/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.rma.type.FilePlanType;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mockito;

public class FilePlanTypeUnitTest
extends BaseUnitTest {
    @InjectMocks
    private FilePlanType filePlanType;
    private NodeRef filePlanContainer;

    @Before
    public void setup() {
        this.filePlanContainer = this.generateNodeRef(TYPE_FILE_PLAN, true);
    }

    @Test(expected=IntegrityException.class)
    public void testAddFileplanToFileplan() {
        ChildAssociationRef childAssoc = this.createFileplanContainerChild(TYPE_FILE_PLAN);
        this.filePlanType.onCreateChildAssociation(childAssoc, true);
    }

    @Test
    public void testAddCategoriesToFileplan() {
        ChildAssociationRef childAssoc1 = this.createFileplanContainerChild(TYPE_RECORD_CATEGORY);
        this.filePlanType.onCreateChildAssociation(childAssoc1, true);
        ChildAssociationRef childAssoc2 = this.createFileplanContainerChild(TYPE_RECORD_CATEGORY);
        this.filePlanType.onCreateChildAssociation(childAssoc2, true);
    }

    @Test
    public void testCreateHoldContainers() {
        ChildAssociationRef childAssoc = this.createFileplanContainerChild(TYPE_HOLD_CONTAINER);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(this.filePlanContainer, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_HOLD_CONTAINER}))).thenReturn(Arrays.asList(childAssoc));
        this.filePlanType.onCreateChildAssociation(childAssoc, true);
    }

    @Test(expected=IntegrityException.class)
    public void testCreateMultipleHoldContainers() {
        ChildAssociationRef existingHoldAssoc = this.createFileplanContainerChild(TYPE_HOLD_CONTAINER);
        ChildAssociationRef childAssoc = this.createFileplanContainerChild(TYPE_HOLD_CONTAINER);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(this.filePlanContainer, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_HOLD_CONTAINER}))).thenReturn(Arrays.asList(existingHoldAssoc, childAssoc));
        this.filePlanType.onCreateChildAssociation(childAssoc, true);
    }

    @Test
    public void testCreateTransferContainers() {
        ChildAssociationRef childAssoc = this.createFileplanContainerChild(TYPE_TRANSFER_CONTAINER);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(this.filePlanContainer, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_TRANSFER_CONTAINER}))).thenReturn(Arrays.asList(childAssoc));
        this.filePlanType.onCreateChildAssociation(childAssoc, true);
    }

    @Test(expected=IntegrityException.class)
    public void testCreateMultipleTransferContainers() {
        ChildAssociationRef existingHoldAssoc = this.createFileplanContainerChild(TYPE_TRANSFER_CONTAINER);
        ChildAssociationRef childAssoc = this.createFileplanContainerChild(TYPE_TRANSFER_CONTAINER);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(this.filePlanContainer, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_TRANSFER_CONTAINER}))).thenReturn(Arrays.asList(existingHoldAssoc, childAssoc));
        this.filePlanType.onCreateChildAssociation(childAssoc, true);
    }

    @Test
    public void testCreateUnfiledRecordsContainers() {
        ChildAssociationRef childAssoc = this.createFileplanContainerChild(TYPE_UNFILED_RECORD_CONTAINER);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(this.filePlanContainer, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_UNFILED_RECORD_CONTAINER}))).thenReturn(Arrays.asList(childAssoc));
        this.filePlanType.onCreateChildAssociation(childAssoc, true);
    }

    @Test(expected=IntegrityException.class)
    public void testCreateMultipleUnfiledRecordsContainers() {
        ChildAssociationRef existingHoldAssoc = this.createFileplanContainerChild(TYPE_UNFILED_RECORD_CONTAINER);
        ChildAssociationRef childAssoc = this.createFileplanContainerChild(TYPE_UNFILED_RECORD_CONTAINER);
        Mockito.when((Object)this.mockedNodeService.getChildAssocs(this.filePlanContainer, (Set)Sets.newHashSet((Object[])new QName[]{TYPE_UNFILED_RECORD_CONTAINER}))).thenReturn(Arrays.asList(existingHoldAssoc, childAssoc));
        this.filePlanType.onCreateChildAssociation(childAssoc, true);
    }

    private ChildAssociationRef createFileplanContainerChild(QName childType) {
        NodeRef child = this.generateNodeRef(childType);
        return new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.filePlanContainer, childType, child);
    }
}

