/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.audit.event;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.audit.event.AuditEvent;
import org.alfresco.module.org_alfresco_module_rm.audit.event.HoldUtils;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

@BehaviourBean
public class CreateHoldAuditEvent
extends AuditEvent
implements NodeServicePolicies.OnCreateNodePolicy {
    private NodeService nodeService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Behaviour(kind=BehaviourKind.CLASS, type="rma:hold", notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onCreateNode(ChildAssociationRef childAssociationRef) {
        NodeRef holdNodeRef = childAssociationRef.getChildRef();
        Map<QName, Serializable> auditProperties = HoldUtils.makePropertiesMap(holdNodeRef, this.nodeService);
        auditProperties.put(PROP_HOLD_REASON, this.nodeService.getProperty(holdNodeRef, PROP_HOLD_REASON));
        this.recordsManagementAuditService.auditEvent(holdNodeRef, this.getName(), null, auditProperties);
    }
}

