/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEvent;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEventService;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEventType;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.ParameterCheck;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.I18NUtil;

public class RecordsManagementEventServiceImpl
implements RecordsManagementEventService {
    private static final StoreRef SPACES_STORE = new StoreRef("workspace", "SpacesStore");
    private static final NodeRef CONFIG_NODE_REF = new NodeRef(SPACES_STORE, "rm_event_config");
    private NodeService nodeService;
    private ContentService contentService;
    private Map<String, RecordsManagementEventType> eventTypes = new HashMap<String, RecordsManagementEventType>(7);
    private Map<String, RecordsManagementEvent> events;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    public void registerEventType(RecordsManagementEventType eventType) {
        this.eventTypes.put(eventType.getName(), eventType);
    }

    @Override
    public List<RecordsManagementEventType> getEventTypes() {
        return new ArrayList<RecordsManagementEventType>(this.eventTypes.values());
    }

    @Override
    public List<RecordsManagementEvent> getEvents() {
        return new ArrayList<RecordsManagementEvent>(this.getEventMap().values());
    }

    @Override
    public RecordsManagementEvent getEvent(String eventName) {
        if (!this.getEventMap().containsKey(eventName)) {
            throw new AlfrescoRuntimeException("The event " + eventName + " does not exist.");
        }
        return this.getEventMap().get(eventName);
    }

    @Override
    public boolean existsEvent(String eventName) {
        return this.getEventMap().containsKey(eventName);
    }

    public boolean existsEventDisplayLabel(String eventDisplayLabel) {
        for (RecordsManagementEvent recordsManagementEvent : this.getEventMap().values()) {
            if (!recordsManagementEvent.getDisplayLabel().equalsIgnoreCase(eventDisplayLabel)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canCreateEvent(String eventDisplayLabel, String eventName) {
        ParameterCheck.mandatoryString((String)"eventDisplayLabel", (String)eventDisplayLabel);
        ParameterCheck.mandatoryString((String)"eventName", (String)eventName);
        boolean canCreateEvent = true;
        if (this.existsEvent(eventName)) {
            canCreateEvent = false;
        }
        if (canCreateEvent) {
            for (RecordsManagementEvent recordsManagementEvent : this.getEventMap().values()) {
                if (!recordsManagementEvent.getDisplayLabel().equalsIgnoreCase(eventDisplayLabel)) continue;
                canCreateEvent = false;
                break;
            }
        }
        return canCreateEvent;
    }

    @Override
    public boolean canEditEvent(String eventDisplayLabel, String eventName, String eventType) {
        ParameterCheck.mandatoryString((String)"eventDisplayLabel", (String)eventDisplayLabel);
        ParameterCheck.mandatoryString((String)"eventName", (String)eventName);
        ParameterCheck.mandatoryString((String)"eventType", (String)eventType);
        boolean canEditEvent = true;
        if (!this.existsEvent(eventName)) {
            throw new AlfrescoRuntimeException("The event '" + eventName + "' does not exist.");
        }
        for (RecordsManagementEvent recordsManagementEvent : this.getEventMap().values()) {
            if (!recordsManagementEvent.getDisplayLabel().equalsIgnoreCase(eventDisplayLabel)) continue;
            if (recordsManagementEvent.getName().equalsIgnoreCase(eventName)) {
                if (!recordsManagementEvent.getType().equalsIgnoreCase(eventType)) {
                    canEditEvent = true;
                    break;
                }
                canEditEvent = false;
                break;
            }
            throw new AlfrescoRuntimeException("Cannot edit event. An event with the display label '" + eventDisplayLabel + "' already exist.");
        }
        return canEditEvent;
    }

    @Override
    public RecordsManagementEvent addEvent(String eventType, String eventName, String eventDisplayLabel) {
        if (!this.eventTypes.containsKey(eventType)) {
            throw new AlfrescoRuntimeException("Can not add event because event " + eventName + " has an undefined eventType. (" + eventType + ")");
        }
        RecordsManagementEvent event = new RecordsManagementEvent(this.eventTypes.get(eventType), eventName, eventDisplayLabel);
        this.getEventMap().put(event.getName(), event);
        this.saveEvents();
        return new RecordsManagementEvent(this.eventTypes.get(eventType), eventName, eventDisplayLabel);
    }

    @Override
    public void removeEvent(String eventName) {
        this.getEventMap().remove(eventName);
        this.saveEvents();
    }

    private Map<String, RecordsManagementEvent> getEventMap() {
        if (this.events == null) {
            this.loadEvents();
        }
        return this.events;
    }

    private void loadEvents() {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                if (!RecordsManagementEventServiceImpl.this.nodeService.exists(CONFIG_NODE_REF)) {
                    throw new AlfrescoRuntimeException("Unable to find records management event configuration node.");
                }
                ContentReader reader = RecordsManagementEventServiceImpl.this.contentService.getReader(CONFIG_NODE_REF, ContentModel.PROP_CONTENT);
                String jsonString = reader.getContentString();
                JSONObject configJSON = new JSONObject(jsonString);
                JSONArray eventsJSON = configJSON.getJSONArray("events");
                RecordsManagementEventServiceImpl.this.events = new HashMap<String, RecordsManagementEvent>(eventsJSON.length());
                for (int i = 0; i < eventsJSON.length(); ++i) {
                    JSONObject eventJSON = eventsJSON.getJSONObject(i);
                    String eventType = eventJSON.getString("eventType");
                    String eventName = eventJSON.getString("eventName");
                    String eventDisplayLabel = eventJSON.getString("eventDisplayLabel");
                    String translated = I18NUtil.getMessage((String)eventDisplayLabel);
                    if (translated != null) {
                        eventDisplayLabel = translated;
                    }
                    if (!RecordsManagementEventServiceImpl.this.eventTypes.containsKey(eventType)) {
                        throw new AlfrescoRuntimeException("Can not load rm event configuration because event " + eventName + " has an undefined eventType. (" + eventType + ")");
                    }
                    RecordsManagementEvent event = new RecordsManagementEvent(RecordsManagementEventServiceImpl.this.eventTypes.get(eventType), eventName, eventDisplayLabel);
                    RecordsManagementEventServiceImpl.this.events.put(event.getName(), event);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private void saveEvents() {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                if (!RecordsManagementEventServiceImpl.this.nodeService.exists(CONFIG_NODE_REF)) {
                    throw new AlfrescoRuntimeException("Unable to find records management event configuration node.");
                }
                JSONObject configJSON = new JSONObject();
                JSONArray eventsJSON = new JSONArray();
                int index = 0;
                for (RecordsManagementEvent event : RecordsManagementEventServiceImpl.this.events.values()) {
                    JSONObject eventJSON = new JSONObject();
                    eventJSON.put("eventType", (Object)event.getType());
                    eventJSON.put("eventName", (Object)event.getName());
                    eventJSON.put("eventDisplayLabel", (Object)event.getDisplayLabel());
                    eventsJSON.put(index, (Object)eventJSON);
                    ++index;
                }
                configJSON.put("events", (Object)eventsJSON);
                ContentWriter contentWriter = RecordsManagementEventServiceImpl.this.contentService.getWriter(CONFIG_NODE_REF, ContentModel.PROP_CONTENT, true);
                contentWriter.putContent(configJSON.toString());
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    public RecordsManagementEventType getEventType(String eventTypeName) {
        return this.eventTypes.get(eventTypeName);
    }
}

