/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.admin;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEvent;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEventService;
import org.alfresco.module.org_alfresco_module_rm.script.admin.RMEventBase;
import org.alfresco.util.GUID;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RmEventsPost
extends RMEventBase {
    private RecordsManagementEventService rmEventService;

    public void setRecordsManagementEventService(RecordsManagementEventService rmEventService) {
        this.rmEventService = rmEventService;
    }

    public Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        ParameterCheck.mandatory((String)"req", (Object)req);
        HashMap<String, Object> model = new HashMap<String, Object>();
        JSONObject json = null;
        try {
            json = new JSONObject(new JSONTokener(req.getContent().getContent()));
            String eventName = this.getEventName(json);
            String eventDisplayLabel = this.getValue(json, "eventDisplayLabel");
            this.doCheck(eventDisplayLabel, "No event display label was provided.");
            this.canCreateEvent(eventDisplayLabel, eventName);
            String eventType = this.getValue(json, "eventType");
            this.doCheck(eventType, "No event type was provided.");
            RecordsManagementEvent event = this.rmEventService.addEvent(eventType, eventName, eventDisplayLabel);
            model.put("event", event);
        }
        catch (IOException iox) {
            throw new WebScriptException(400, "Could not read content from req.", (Throwable)iox);
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from req.", (Throwable)je);
        }
        return model;
    }

    private String getEventName(JSONObject json) throws JSONException {
        String eventName = this.getValue(json, "eventName");
        if (StringUtils.isBlank((CharSequence)eventName)) {
            eventName = GUID.generate();
        }
        return eventName;
    }

    private boolean canCreateEvent(String eventDisplayLabel, String eventName) {
        boolean canCreateEvent = true;
        if (!this.rmEventService.canCreateEvent(eventDisplayLabel, eventName)) {
            throw new WebScriptException(400, "Cannot create event. An event with the display label '" + eventDisplayLabel + "' already exists.");
        }
        return canCreateEvent;
    }
}

