/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.aspect;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.freeze.FreezeService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.model.rma.aspect.FrozenAspect;
import org.alfresco.module.org_alfresco_module_rm.util.NodeTypeUtility;
import org.alfresco.module.org_alfresco_module_rm.util.PropertyModificationAllowedCheck;
import org.alfresco.module.org_alfresco_module_rm.util.TransactionalResourceHelper;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class FrozenAspectUnitTest {
    @Mock
    private NodeService mockNodeService;
    @Mock
    private ChildAssociationRef mockChildAssociationRef;
    @Mock
    private NodeTypeUtility mockedNodeTypeUtility;
    @Mock
    private FreezeService mockFreezeService;
    @Mock
    private TransactionalResourceHelper mockResourceHelper;
    @Mock
    private ChildAssociationRef mockChildRef;
    @Mock
    private ChildAssociationRef mockParentRef;
    @Mock
    private ChildAssociationRef mockOldRef;
    @Mock
    private PropertyModificationAllowedCheck mockPropertyModificationAllowedCheck;
    @InjectMocks
    private FrozenAspect frozenAspect;
    private final List<ChildAssociationRef> children = new ArrayList<ChildAssociationRef>();
    private NodeRef record = new NodeRef("workspace://record/node");
    private NodeRef folder = new NodeRef("workspace://folder/node");
    private NodeRef content = new NodeRef("workspace://content/node");
    private NodeRef child = new NodeRef("workspace://content/child");
    private NodeRef parent = new NodeRef("workspace://content/parent");

    @Before
    public void setUp() {
        Mockito.when((Object)this.mockNodeService.exists(this.record)).thenReturn((Object)true);
        Mockito.when((Object)this.mockNodeService.getType(this.record)).thenReturn((Object)ContentModel.TYPE_CONTENT);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(this.mockNodeService.getType(this.record), ContentModel.TYPE_CONTENT)).thenReturn((Object)true);
        Mockito.when((Object)this.mockNodeService.exists(this.content)).thenReturn((Object)true);
        Mockito.when((Object)this.mockNodeService.hasAspect(this.folder, RecordsManagementModel.ASPECT_HELD_CHILDREN)).thenReturn((Object)true);
        Mockito.when((Object)this.mockNodeService.getProperty(this.folder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT)).thenReturn((Object)1);
        Mockito.when((Object)this.mockFreezeService.isFrozen(this.content)).thenReturn((Object)false);
        this.children.add(this.mockChildRef);
        Mockito.when((Object)this.mockNodeService.getChildAssocs(this.content)).thenReturn(this.children);
        Mockito.when((Object)this.mockChildRef.isPrimary()).thenReturn((Object)true);
        this.frozenAspect.setNodeService(this.mockNodeService);
    }

    @Test
    public void testRemoveAspectForRecords() {
        Mockito.when((Object)this.mockNodeService.getPrimaryParent(this.record)).thenReturn((Object)this.mockChildAssociationRef);
        Mockito.when((Object)this.mockChildAssociationRef.getParentRef()).thenReturn((Object)this.folder);
        this.frozenAspect.onRemoveAspect(this.record, null);
        ((NodeService)Mockito.verify((Object)this.mockNodeService, (VerificationMode)Mockito.times((int)1))).setProperty(this.folder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT, (Serializable)Integer.valueOf(0));
    }

    @Test
    public void testRemoveAspectForContent() {
        Mockito.when((Object)this.mockNodeService.getType(this.content)).thenReturn((Object)ContentModel.TYPE_CONTENT);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(this.mockNodeService.getType(this.content), ContentModel.TYPE_CONTENT)).thenReturn((Object)true);
        Mockito.when((Object)this.mockNodeService.getPrimaryParent(this.content)).thenReturn((Object)this.mockChildAssociationRef);
        Mockito.when((Object)this.mockChildAssociationRef.getParentRef()).thenReturn((Object)this.folder);
        this.frozenAspect.onRemoveAspect(this.content, null);
        ((NodeService)Mockito.verify((Object)this.mockNodeService, (VerificationMode)Mockito.times((int)1))).setProperty(this.folder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT, (Serializable)Integer.valueOf(0));
    }

    @Test
    public void testRemoveAspectForContentDoesntUpdateForOtherTypes() {
        Mockito.when((Object)this.mockNodeService.getType(this.content)).thenReturn((Object)ContentModel.TYPE_FOLDER);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(this.mockNodeService.getType(this.content), ContentModel.TYPE_CONTENT)).thenReturn((Object)false);
        this.frozenAspect.onRemoveAspect(this.content, null);
        ((NodeService)Mockito.verify((Object)this.mockNodeService, (VerificationMode)Mockito.times((int)0))).setProperty(this.folder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT, (Serializable)Integer.valueOf(0));
    }

    @Test(expected=PermissionDeniedException.class)
    public void testBeforeDeleteNodeThrowsExceptionIfNodeFrozen() {
        Mockito.when((Object)this.mockFreezeService.isFrozen(this.content)).thenReturn((Object)true);
        this.frozenAspect.beforeDeleteNode(this.content);
    }

    @Test
    public void testBeforeDeleteForNonFrozenNodes() {
        this.frozenAspect.beforeDeleteNode(this.content);
        ((NodeService)Mockito.verify((Object)this.mockNodeService, (VerificationMode)Mockito.times((int)1))).getChildAssocs(this.content);
        ((ChildAssociationRef)Mockito.verify((Object)this.mockChildRef, (VerificationMode)Mockito.times((int)1))).getChildRef();
    }

    @Test(expected=PermissionDeniedException.class)
    public void testBeforeDeleteThrowsExceptionForFrozenChild() {
        Mockito.when((Object)this.mockChildRef.getChildRef()).thenReturn((Object)this.child);
        Mockito.when((Object)this.mockFreezeService.isFrozen(this.child)).thenReturn((Object)true);
        this.frozenAspect.beforeDeleteNode(this.content);
    }

    @Test
    public void testOnAddAspectForRecord() {
        Mockito.when((Object)this.mockNodeService.getPrimaryParent(this.record)).thenReturn((Object)this.mockParentRef);
        Mockito.when((Object)this.mockParentRef.getParentRef()).thenReturn((Object)this.parent);
        Mockito.when((Object)this.mockNodeService.hasAspect(this.parent, RecordsManagementModel.ASPECT_HELD_CHILDREN)).thenReturn((Object)true);
        Mockito.when((Object)this.mockNodeService.getProperty(this.parent, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT)).thenReturn((Object)0);
        this.frozenAspect.onAddAspect(this.record, null);
        ((NodeService)Mockito.verify((Object)this.mockNodeService, (VerificationMode)Mockito.times((int)1))).setProperty(this.parent, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT, (Serializable)Integer.valueOf(1));
    }

    @Test
    public void testOnAddAspectForContent() {
        Mockito.when((Object)this.mockNodeService.getType(this.content)).thenReturn((Object)ContentModel.TYPE_CONTENT);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(this.mockNodeService.getType(this.content), ContentModel.TYPE_CONTENT)).thenReturn((Object)true);
        Mockito.when((Object)this.mockNodeService.getPrimaryParent(this.content)).thenReturn((Object)this.mockParentRef);
        Mockito.when((Object)this.mockParentRef.getParentRef()).thenReturn((Object)this.parent);
        Mockito.when((Object)this.mockNodeService.hasAspect(this.parent, RecordsManagementModel.ASPECT_HELD_CHILDREN)).thenReturn((Object)false);
        Mockito.when((Object)this.mockNodeService.getType(this.parent)).thenReturn((Object)ContentModel.TYPE_FOLDER);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(this.mockNodeService.getType(this.parent), ContentModel.TYPE_FOLDER)).thenReturn((Object)true);
        this.frozenAspect.onAddAspect(this.content, null);
        ((NodeService)Mockito.verify((Object)this.mockNodeService, (VerificationMode)Mockito.times((int)1))).addAspect((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.any(QName.class), ArgumentMatchers.anyMap());
    }

    @Test(expected=PermissionDeniedException.class)
    public void testBeforeMoveThrowsExceptionForFrozenNode() {
        Mockito.when((Object)this.mockOldRef.getChildRef()).thenReturn((Object)this.child);
        Mockito.when((Object)this.mockNodeService.exists(this.child)).thenReturn((Object)true);
        Mockito.when((Object)this.mockFreezeService.isFrozen(this.child)).thenReturn((Object)true);
        this.frozenAspect.beforeMoveNode(this.mockOldRef, null);
    }

    @Test(expected=PermissionDeniedException.class)
    public void testUpdatePropertiesThrowsExceptionForFrozenNode() {
        Mockito.when((Object)this.mockFreezeService.isFrozen(this.content)).thenReturn((Object)true);
        Mockito.when((Object)this.mockPropertyModificationAllowedCheck.check(null, null)).thenReturn((Object)false);
        this.frozenAspect.onUpdateProperties(this.content, null, null);
    }
}

