/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.audit.extractor;

import java.io.Serializable;
import java.util.Objects;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.audit.extractor.AbstractDataExtractor;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

public final class FilePlanIdentifierDataExtractor
extends AbstractDataExtractor {
    private NodeService nodeService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public boolean isSupported(Serializable data) {
        if (!(data instanceof NodeRef)) {
            return false;
        }
        return this.nodeService.hasAspect((NodeRef)data, RecordsManagementModel.ASPECT_RECORD_COMPONENT_ID);
    }

    public Serializable extractData(Serializable value) {
        NodeRef nodeRef = (NodeRef)value;
        String identifier = (String)((Object)this.nodeService.getProperty(nodeRef, RecordsManagementModel.PROP_IDENTIFIER));
        return identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FilePlanIdentifierDataExtractor that = (FilePlanIdentifierDataExtractor)((Object)o);
        return Objects.equals(this.nodeService, that.nodeService);
    }

    public int hashCode() {
        return Objects.hash(this.nodeService);
    }
}

