/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.record;

import junit.framework.TestCase;
import net.sf.acegisecurity.Authentication;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.download.DownloadService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.GUID;

public class DownloadAsZipRecordTest
extends BaseRMTestCase {
    private DownloadService downloadService;

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected void initServices() {
        super.initServices();
        this.downloadService = (DownloadService)this.applicationContext.getBean("DownloadService");
    }

    public void testDownloadRecordUserNoReadCapability() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AccessDeniedException.class){
            String userDownload;
            Authentication previousAuthentication;

            @Override
            public void given() {
                AuthenticationUtil.runAs(() -> {
                    DownloadAsZipRecordTest.this.recordService.createRecord(DownloadAsZipRecordTest.this.filePlan, DownloadAsZipRecordTest.this.dmDocument);
                    return null;
                }, (String)AuthenticationUtil.getAdminUserName());
                this.userDownload = GUID.generate();
                DownloadAsZipRecordTest.this.createPerson(this.userDownload);
            }

            @Override
            public void when() {
                this.previousAuthentication = AuthenticationUtil.getFullAuthentication();
                AuthenticationUtil.setFullyAuthenticatedUser((String)this.userDownload);
                DownloadAsZipRecordTest.this.downloadService.createDownload(new NodeRef[]{DownloadAsZipRecordTest.this.dmDocument}, true);
            }

            @Override
            public void after() {
                AuthenticationUtil.setFullAuthentication((Authentication)this.previousAuthentication);
                DownloadAsZipRecordTest.this.personService.deletePerson(this.userDownload);
            }
        });
    }

    public void testDownloadRecordUserWithReadCapability() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef downloadStorageNode;

            @Override
            public void given() {
                AuthenticationUtil.runAs(() -> {
                    DownloadAsZipRecordTest.this.recordService.createRecord(DownloadAsZipRecordTest.this.filePlan, DownloadAsZipRecordTest.this.dmDocument);
                    return null;
                }, (String)DownloadAsZipRecordTest.this.dmCollaborator);
            }

            @Override
            public void when() {
                Authentication previousAuthentication = AuthenticationUtil.getFullAuthentication();
                AuthenticationUtil.setFullyAuthenticatedUser((String)DownloadAsZipRecordTest.this.dmCollaborator);
                this.downloadStorageNode = DownloadAsZipRecordTest.this.downloadService.createDownload(new NodeRef[]{DownloadAsZipRecordTest.this.dmDocument}, true);
                AuthenticationUtil.setFullAuthentication((Authentication)previousAuthentication);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)DownloadAsZipRecordTest.this.nodeService.exists(this.downloadStorageNode));
            }
        });
    }
}

