/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.impl;

import java.util.List;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.tools.RecognizedParamsExtractor;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.RMRolesImpl;
import org.alfresco.rm.rest.api.model.CapabilityModel;
import org.alfresco.rm.rest.api.model.RoleModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RMRolesImplUnitTest
extends BaseUnitTest {
    private final RecognizedParamsExtractor queryExtractor = new RecognizedParamsExtractor(){};
    private RMRolesImpl rmRolesImpl;
    private FilePlanRoleService mockedFilePlanRoleService;
    private ApiNodesModelFactory mockedNodesModelFactory;
    private final Capability viewRecordsCapability = (Capability)Mockito.mock(Capability.class);
    private final Capability editMetadataCapability = (Capability)Mockito.mock(Capability.class);
    private final Role role1 = new Role("Role1", "Role 1", Set.of(this.viewRecordsCapability), "Group1");
    private final Role role2 = new Role("Role2", "Role 2", Set.of(this.editMetadataCapability), "Group2");
    private final RoleModel roleModel1 = new RoleModel("Role1", "Role 1", List.of(new CapabilityModel("ViewRecords", "", "", null, 0)), "Group1", null, List.of("User1"), List.of("Group1"));
    private final RoleModel roleModel2 = new RoleModel("Role2", "Role 2", List.of(new CapabilityModel("EditMetadata", "", "", null, 0)), "Group2", null, List.of("User2"), List.of("Group2"));
    private final NodeRef filePlan = new NodeRef("workspace://SpacesStore/testFilePlan");
    private final Parameters parameters = (Parameters)Mockito.mock(Parameters.class);
    private final Paging paging = (Paging)Mockito.mock(Paging.class);

    @Before
    public void setUp() {
        this.mockedFilePlanRoleService = (FilePlanRoleService)Mockito.mock(FilePlanRoleService.class);
        this.mockedNodesModelFactory = (ApiNodesModelFactory)Mockito.mock(ApiNodesModelFactory.class);
        this.rmRolesImpl = new RMRolesImpl();
        this.rmRolesImpl.setFilePlanRoleService(this.mockedFilePlanRoleService);
        this.rmRolesImpl.setNodesModelFactory(this.mockedNodesModelFactory);
        Mockito.when((Object)this.mockedFilePlanRoleService.getRoles(this.filePlan, true)).thenReturn(Set.of(this.role1, this.role2));
        Mockito.when((Object)this.mockedNodesModelFactory.createRoleModel((Role)Mockito.eq((Object)this.role1), (List)Mockito.any(), (List)Mockito.any())).thenReturn((Object)this.roleModel1);
        Mockito.when((Object)this.mockedNodesModelFactory.createRoleModel((Role)Mockito.eq((Object)this.role2), (List)Mockito.any(), (List)Mockito.any())).thenReturn((Object)this.roleModel2);
        Mockito.when((Object)this.viewRecordsCapability.getName()).thenReturn((Object)"ViewRecords");
        Mockito.when((Object)this.editMetadataCapability.getName()).thenReturn((Object)"EditMetadata");
        Mockito.when((Object)this.parameters.getPaging()).thenReturn((Object)this.paging);
        Mockito.when((Object)this.paging.getSkipCount()).thenReturn((Object)0);
        Mockito.when((Object)this.paging.getMaxItems()).thenReturn((Object)10);
    }

    @Test
    public void testGetRoles_NoFilters() {
        CollectionWithPagingInfo result = this.rmRolesImpl.getRoles(this.filePlan, this.parameters);
        List roleModelList = (List)result.getCollection();
        Assert.assertEquals((long)2L, (long)result.getTotalItems().intValue());
        Assert.assertEquals(List.of(this.roleModel1, this.roleModel2), (Object)roleModelList);
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).getRoles(this.filePlan, true);
        ((ApiNodesModelFactory)Mockito.verify((Object)this.mockedNodesModelFactory)).createRoleModel((Role)Mockito.eq((Object)this.role1), (List)Mockito.any(), (List)Mockito.any());
        ((ApiNodesModelFactory)Mockito.verify((Object)this.mockedNodesModelFactory)).createRoleModel((Role)Mockito.eq((Object)this.role2), (List)Mockito.any(), (List)Mockito.any());
    }

    @Test
    public void testGetRoles_WithPersonId() {
        String personId = "testUser";
        Mockito.when((Object)this.mockedFilePlanRoleService.getRolesByUser(this.filePlan, personId, true)).thenReturn(Set.of(this.role1));
        Mockito.when((Object)this.parameters.getQuery()).thenReturn((Object)this.queryExtractor.getWhereClause("(personId='" + personId + "')"));
        CollectionWithPagingInfo result = this.rmRolesImpl.getRoles(this.filePlan, this.parameters);
        Assert.assertEquals((long)1L, (long)result.getTotalItems().intValue());
        Assert.assertEquals(List.of(this.roleModel1), (Object)result.getCollection());
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).getRolesByUser(this.filePlan, personId, true);
        ((ApiNodesModelFactory)Mockito.verify((Object)this.mockedNodesModelFactory)).createRoleModel((Role)Mockito.eq((Object)this.role1), (List)Mockito.any(), (List)Mockito.any());
    }

    @Test
    public void testGetNonSystemRoles() {
        Mockito.when((Object)this.mockedFilePlanRoleService.getRoles(this.filePlan, false)).thenReturn(Set.of(this.role2));
        Mockito.when((Object)this.parameters.getQuery()).thenReturn((Object)this.queryExtractor.getWhereClause("(systemRoles=false)"));
        CollectionWithPagingInfo result = this.rmRolesImpl.getRoles(this.filePlan, this.parameters);
        Assert.assertEquals((long)1L, (long)result.getTotalItems().intValue());
        Assert.assertEquals(List.of(this.roleModel2), (Object)result.getCollection());
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).getRoles(this.filePlan, false);
        ((ApiNodesModelFactory)Mockito.verify((Object)this.mockedNodesModelFactory)).createRoleModel((Role)Mockito.eq((Object)this.role2), (List)Mockito.any(), (List)Mockito.any());
    }

    @Test
    public void testGetRoles_WithCapabilitiesFilter() {
        Mockito.when((Object)this.parameters.getQuery()).thenReturn((Object)this.queryExtractor.getWhereClause("(capabilityName IN ('ViewRecords'))"));
        CollectionWithPagingInfo result = this.rmRolesImpl.getRoles(this.filePlan, this.parameters);
        Assert.assertEquals((long)1L, (long)result.getTotalItems().intValue());
        Assert.assertEquals(List.of(this.roleModel1), (Object)result.getCollection());
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).getRoles(this.filePlan, true);
        ((ApiNodesModelFactory)Mockito.verify((Object)this.mockedNodesModelFactory)).createRoleModel((Role)Mockito.eq((Object)this.role1), (List)Mockito.any(), (List)Mockito.any());
    }

    @Test
    public void testGetRoles_IncludeAssignedUsersAndGroups() {
        Mockito.when((Object)this.mockedFilePlanRoleService.getRoles(this.filePlan, true)).thenReturn(Set.of(this.role1));
        Mockito.when((Object)this.mockedFilePlanRoleService.getAllAssignedToRole(this.filePlan, "Role1")).thenReturn(Set.of("User1"));
        Mockito.when((Object)this.mockedFilePlanRoleService.getGroupsAssignedToRole(this.filePlan, "Role1")).thenReturn(Set.of("Group1"));
        Mockito.when((Object)this.parameters.getInclude()).thenReturn(List.of("assignedUsers", "assignedGroups"));
        CollectionWithPagingInfo result = this.rmRolesImpl.getRoles(this.filePlan, this.parameters);
        List roleModelList = (List)result.getCollection();
        Assert.assertEquals((long)1L, (long)result.getTotalItems().intValue());
        Assert.assertEquals(List.of(this.roleModel1), (Object)roleModelList);
        Assert.assertEquals(List.of("User1"), (Object)((RoleModel)roleModelList.get(0)).assignedUsers());
        Assert.assertEquals(List.of("Group1"), (Object)((RoleModel)roleModelList.get(0)).assignedGroups());
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).getRoles(this.filePlan, true);
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).getAllAssignedToRole(this.filePlan, "Role1");
        ((FilePlanRoleService)Mockito.verify((Object)this.mockedFilePlanRoleService)).getGroupsAssignedToRole(this.filePlan, "Role1");
        ((ApiNodesModelFactory)Mockito.verify((Object)this.mockedNodesModelFactory)).createRoleModel(this.role1, List.of("User1"), List.of("Group1"));
    }
}

