/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.dm;

import java.util.Arrays;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RecordActionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordActionUtils.class);

    private RecordActionUtils() {
    }

    static NodeRef resolvePath(Services services, NodeRef filePlan, String pathParameter, String actionName) {
        NodeRef destinationFolder;
        String[] pathElementsArray;
        if (filePlan == null) {
            filePlan = RecordActionUtils.getDefaultFilePlan(services.getAuthenticationUtil(), services.getFilePlanService(), actionName);
        }
        if ((pathElementsArray = StringUtils.tokenizeToStringArray((String)pathParameter, (String)"/", (boolean)false, (boolean)true)).length > 0) {
            destinationFolder = RecordActionUtils.resolvePath(services.getNodeService(), filePlan, Arrays.asList(pathElementsArray), actionName);
            QName nodeType = services.getNodeService().getType(destinationFolder);
            if (!nodeType.equals((Object)RecordsManagementModel.TYPE_RECORD_FOLDER)) {
                throw new AlfrescoRuntimeException("Unable to execute " + actionName + " action, because the destination path is not a record folder.");
            }
        } else {
            throw new AlfrescoRuntimeException("Unable to execute " + actionName + " action, because the destination path could not be found.");
        }
        return destinationFolder;
    }

    static NodeRef resolvePath(NodeService nodeService, NodeRef parent, List<String> pathElements, String actionName) {
        String childName = pathElements.get(0);
        NodeRef nodeRef = nodeService.getChildByName(parent, ContentModel.ASSOC_CONTAINS, childName);
        if (nodeRef == null) {
            throw new AlfrescoRuntimeException("Unable to execute " + actionName + " action, because the destination path could not be found.");
        }
        QName nodeType = nodeService.getType(nodeRef);
        if (nodeType.equals((Object)RecordsManagementModel.TYPE_HOLD_CONTAINER) || nodeType.equals((Object)RecordsManagementModel.TYPE_TRANSFER_CONTAINER) || nodeType.equals((Object)RecordsManagementModel.TYPE_UNFILED_RECORD_CONTAINER)) {
            throw new AlfrescoRuntimeException("Unable to execute " + actionName + " action, because the destination path is invalid.");
        }
        if (pathElements.size() > 1) {
            nodeRef = RecordActionUtils.resolvePath(nodeService, nodeRef, pathElements.subList(1, pathElements.size()), actionName);
        }
        return nodeRef;
    }

    static NodeRef getDefaultFilePlan(AuthenticationUtil authenticationUtil, FilePlanService filePlanService, String actionName) {
        NodeRef filePlan = (NodeRef)authenticationUtil.runAsSystem(() -> filePlanService.getFilePlanBySiteId("rm"));
        if (filePlan == null) {
            String logMessage = String.format("Unable to execute %s action, because the fileplan path could not be determined. Make sure at least one file plan has been created.", actionName);
            LOGGER.debug(logMessage);
            throw new AlfrescoRuntimeException(logMessage);
        }
        return filePlan;
    }

    static class Services {
        private NodeService nodeService;
        private FilePlanService filePlanService;
        private AuthenticationUtil authenticationUtil;

        Services(NodeService nodeService, FilePlanService filePlanService, AuthenticationUtil authenticationUtil) {
            this.nodeService = nodeService;
            this.filePlanService = filePlanService;
            this.authenticationUtil = authenticationUtil;
        }

        public NodeService getNodeService() {
            return this.nodeService;
        }

        public FilePlanService getFilePlanService() {
            return this.filePlanService;
        }

        public AuthenticationUtil getAuthenticationUtil() {
            return this.authenticationUtil;
        }
    }
}

