/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.aspect;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.model.QuickShareModel;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementPolicies;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.model.behaviour.AbstractDisposableItem;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.security.ExtendedSecurityService;
import org.alfresco.module.org_alfresco_module_rm.util.ContentBinDuplicationUtility;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.quickshare.QuickShareService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.springframework.extensions.surf.util.I18NUtil;

@BehaviourBean(defaultType="rma:record")
public class RecordAspect
extends AbstractDisposableItem
implements NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.BeforeAddAspectPolicy,
RecordsManagementPolicies.OnCreateReference,
RecordsManagementPolicies.OnRemoveReference,
NodeServicePolicies.OnMoveNodePolicy,
CopyServicePolicies.OnCopyCompletePolicy,
ContentServicePolicies.OnContentPropertyUpdatePolicy {
    private NodeRef scriptsFolderNodeRef = new NodeRef("workspace", "SpacesStore", "rm_behavior_scripts");
    protected ExtendedSecurityService extendedSecurityService;
    protected ScriptService scriptService;
    protected RecordService recordService;
    private QuickShareService quickShareService;
    private ContentBinDuplicationUtility contentBinDuplicationUtility;
    private static final String MSG_CANNOT_UPDATE_RECORD_CONTENT = "rm.service.update-record-content";

    public void setExtendedSecurityService(ExtendedSecurityService extendedSecurityService) {
        this.extendedSecurityService = extendedSecurityService;
    }

    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    @Override
    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setQuickShareService(QuickShareService quickShareService) {
        this.quickShareService = quickShareService;
    }

    public void setContentBinDuplicationUtility(ContentBinDuplicationUtility contentBinDuplicationUtility) {
        this.contentBinDuplicationUtility = contentBinDuplicationUtility;
    }

    @Behaviour(kind=BehaviourKind.ASSOCIATION, assocType="rn:rendition", notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onCreateChildAssociation(final ChildAssociationRef childAssocRef, boolean bNew) {
        this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                NodeRef thumbnail = childAssocRef.getChildRef();
                if (RecordAspect.this.nodeService.exists(thumbnail)) {
                    RecordAspect.this.nodeService.addAspect(thumbnail, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT, null);
                    NodeRef parent = childAssocRef.getParentRef();
                    Set<String> readers = RecordAspect.this.extendedSecurityService.getReaders(parent);
                    Set<String> writers = RecordAspect.this.extendedSecurityService.getWriters(parent);
                    if (readers != null && readers.size() != 0) {
                        RecordAspect.this.extendedSecurityService.set(thumbnail, readers, writers);
                    }
                }
                return null;
            }
        });
    }

    @Override
    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onCreateReference(final NodeRef fromNodeRef, NodeRef toNodeRef, QName reference) {
        if (reference.equals((Object)CUSTOM_REF_VERSIONS)) {
            this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    RecordAspect.this.nodeService.addAspect(fromNodeRef, RecordsManagementModel.ASPECT_VERSIONED_RECORD, null);
                    return null;
                }
            });
        }
        this.executeReferenceScript("onCreate", reference, fromNodeRef, toNodeRef);
    }

    @Override
    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onRemoveReference(final NodeRef fromNodeRef, NodeRef toNodeRef, QName reference) {
        if (reference.equals((Object)CUSTOM_REF_VERSIONS)) {
            this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    RecordAspect.this.nodeService.removeAspect(fromNodeRef, RecordsManagementModel.ASPECT_VERSIONED_RECORD);
                    return null;
                }
            });
        }
        this.executeReferenceScript("onRemove", reference, fromNodeRef, toNodeRef);
    }

    @Behaviour(kind=BehaviourKind.CLASS, policy="alf:getCopyCallback")
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return new DefaultCopyBehaviourCallback(this){

            public Map<QName, Serializable> getCopyProperties(QName classRef, CopyDetails copyDetails, Map<QName, Serializable> properties) {
                Map sourceProperties = super.getCopyProperties(classRef, copyDetails, properties);
                if (sourceProperties.containsKey(RecordsManagementModel.PROP_DATE_FILED)) {
                    sourceProperties.remove(RecordsManagementModel.PROP_DATE_FILED);
                }
                return sourceProperties;
            }
        };
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        if (!oldChildAssocRef.getParentRef().equals((Object)newChildAssocRef.getParentRef()) && this.isFilePlanComponent(oldChildAssocRef.getParentRef())) {
            final NodeRef record = newChildAssocRef.getChildRef();
            this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() {
                    if (RecordAspect.this.nodeService.exists(record) && RecordAspect.this.recordService.isFiled(record)) {
                        RecordAspect.this.cleanDisposableItem(RecordAspect.this.nodeService, record);
                        RecordAspect.this.recordService.file(record);
                    }
                    return null;
                }
            });
        }
    }

    private void executeReferenceScript(String policy, QName reference, NodeRef from, NodeRef to) {
        String referenceId = reference.getLocalName();
        String expectedScriptName = policy + "_" + referenceId + ".js";
        NodeRef scriptNodeRef = this.nodeService.getChildByName(this.scriptsFolderNodeRef, ContentModel.ASSOC_CONTAINS, expectedScriptName);
        if (scriptNodeRef != null) {
            HashMap<String, Object> objectModel = new HashMap<String, Object>(1);
            objectModel.put("node", from);
            objectModel.put("toNode", to);
            objectModel.put("policy", policy);
            objectModel.put("reference", referenceId);
            this.scriptService.executeScript(scriptNodeRef, null, objectModel);
        }
    }

    @Behaviour(kind=BehaviourKind.CLASS)
    public void onCopyComplete(QName classRef, NodeRef sourceNodeRef, NodeRef targetNodeRef, boolean copyToNewNode, Map<NodeRef, NodeRef> copyMap) {
        if (this.nodeService.exists(targetNodeRef) && this.nodeService.hasAspect(targetNodeRef, ASPECT_RECORD)) {
            this.extendedSecurityService.remove(targetNodeRef);
            this.contentBinDuplicationUtility.duplicate(targetNodeRef);
        }
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void beforeAddAspect(final NodeRef nodeRef, QName aspectTypeQName) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                String sharedId = (String)((Object)RecordAspect.this.nodeService.getProperty(nodeRef, QuickShareModel.PROP_QSHARE_SHAREDID));
                if (sharedId != null) {
                    RecordAspect.this.quickShareService.unshareContent(sharedId);
                }
                if (!RecordAspect.this.nodeService.getTargetAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_ORIGINAL).isEmpty() || !RecordAspect.this.nodeService.getSourceAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_ORIGINAL).isEmpty()) {
                    RecordAspect.this.contentBinDuplicationUtility.duplicate(nodeRef);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void onContentPropertyUpdate(NodeRef nodeRef, QName propertyQName, ContentData beforeValue, ContentData afterValue) {
        if (beforeValue != null) {
            throw new IntegrityException(I18NUtil.getMessage((String)MSG_CANNOT_UPDATE_RECORD_CONTENT), null);
        }
    }
}

