/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.record;

import java.util.List;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.webscripts.GUID;

public class LinkRecordTest
extends BaseRMTestCase {
    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected void initServices() {
        super.initServices();
    }

    public void testLinkWithCompatibleDispositionSchedules() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef sourceRecordCategory;
            private NodeRef targetRecordCategory;
            private NodeRef sourceRecordFolder;
            private NodeRef targetRecordFolder;
            private NodeRef myRecord;

            @Override
            public void given() throws Exception {
                this.sourceRecordCategory = LinkRecordTest.this.filePlanService.createRecordCategory(LinkRecordTest.this.filePlan, GUID.generate());
                this.sourceRecordFolder = LinkRecordTest.this.recordFolderService.createRecordFolder(this.sourceRecordCategory, GUID.generate());
                this.myRecord = LinkRecordTest.this.utils.createRecord(this.sourceRecordFolder, GUID.generate());
                this.targetRecordCategory = LinkRecordTest.this.filePlanService.createRecordCategory(LinkRecordTest.this.filePlan, GUID.generate());
                this.targetRecordFolder = LinkRecordTest.this.recordFolderService.createRecordFolder(this.targetRecordCategory, GUID.generate());
                LinkRecordTest.this.utils.createBasicDispositionSchedule(this.sourceRecordCategory, "disposition instructions", "disposition authority", false, true);
                LinkRecordTest.this.utils.createBasicDispositionSchedule(this.targetRecordCategory, "disposition instructions", "disposition authority", false, true);
            }

            @Override
            public void when() throws Exception {
                LinkRecordTest.this.recordService.link(this.myRecord, this.targetRecordFolder);
            }

            @Override
            public void then() throws Exception {
                List assocs = LinkRecordTest.this.nodeService.getParentAssocs(this.myRecord);
                TestCase.assertNotNull((Object)assocs);
                TestCase.assertEquals((int)2, (int)assocs.size());
            }
        });
    }

    public void testLinkWithIncompatibleDispositionSchedules() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AlfrescoRuntimeException.class){
            private NodeRef sourceRecordCategory;
            private NodeRef targetRecordCategory;
            private NodeRef sourceRecordFolder;
            private NodeRef targetRecordFolder;
            private NodeRef myRecord;

            @Override
            public void given() throws Exception {
                this.sourceRecordCategory = LinkRecordTest.this.filePlanService.createRecordCategory(LinkRecordTest.this.filePlan, GUID.generate());
                this.sourceRecordFolder = LinkRecordTest.this.recordFolderService.createRecordFolder(this.sourceRecordCategory, GUID.generate());
                this.myRecord = LinkRecordTest.this.utils.createRecord(this.sourceRecordFolder, GUID.generate());
                this.targetRecordCategory = LinkRecordTest.this.filePlanService.createRecordCategory(LinkRecordTest.this.filePlan, GUID.generate());
                this.targetRecordFolder = LinkRecordTest.this.recordFolderService.createRecordFolder(this.targetRecordCategory, GUID.generate());
                LinkRecordTest.this.utils.createBasicDispositionSchedule(this.sourceRecordCategory, "disposition instructions", "disposition authority", false, true);
                LinkRecordTest.this.utils.createBasicDispositionSchedule(this.targetRecordCategory, "disposition instructions", "disposition authority", true, true);
            }

            @Override
            public void when() throws Exception {
                LinkRecordTest.this.recordService.link(this.myRecord, this.targetRecordFolder);
            }
        });
    }
}

