/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.retentionschedule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.UnprocessableContentException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.RetentionSchedule;
import org.alfresco.rm.rest.api.recordcategories.RecordCategoriesEntityResource;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.ParameterCheck;

@RelationshipResource(name="retention-schedules", entityResource=RecordCategoriesEntityResource.class, title="Retention Schedule")
public class RetentionScheduleRelation
implements RelationshipResourceAction.Read<RetentionSchedule>,
RelationshipResourceAction.Create<RetentionSchedule> {
    private FilePlanComponentsApiUtils apiUtils;
    private ApiNodesModelFactory nodesModelFactory;
    private DispositionService dispositionService;
    protected NodeService nodeService;

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @WebApiDescription(title="Create a retention schedule for the particular record category using the 'recordCategoryId'")
    public List<RetentionSchedule> create(String recordCategoryId, List<RetentionSchedule> nodeInfos, Parameters parameters) {
        RMParameterCheck.checkNotBlank("recordCategoryId", recordCategoryId);
        ParameterCheck.mandatory((String)"entity", nodeInfos);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef parentNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, recordCategoryId);
        if (this.checkCategoryHasAssocFolder(parentNodeRef) && nodeInfos.get(0).getIsRecordLevel()) {
            throw new UnprocessableContentException("Record level retention schedule cannot be created for a record category having folder associated.");
        }
        ArrayList<RetentionSchedule> result = new ArrayList<RetentionSchedule>();
        HashMap<QName, Serializable> dsProps = new HashMap<QName, Serializable>();
        dsProps.put(RecordsManagementModel.PROP_DISPOSITION_AUTHORITY, (Serializable)((Object)nodeInfos.get(0).getAuthority()));
        dsProps.put(RecordsManagementModel.PROP_DISPOSITION_INSTRUCTIONS, (Serializable)((Object)nodeInfos.get(0).getInstructions()));
        dsProps.put(RecordsManagementModel.PROP_RECORD_LEVEL_DISPOSITION, Boolean.valueOf(nodeInfos.get(0).getIsRecordLevel()));
        DispositionSchedule dispositionSchedule = this.dispositionService.createDispositionSchedule(parentNodeRef, dsProps);
        RetentionSchedule retentionSchedule = this.nodesModelFactory.mapRetentionScheduleData(dispositionSchedule);
        result.add(retentionSchedule);
        return result;
    }

    private boolean checkCategoryHasAssocFolder(NodeRef nodeRef) {
        List assocs = this.nodeService.getChildAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        return assocs.stream().map(assoc -> this.nodeService.getType(assoc.getChildRef())).anyMatch(nodeType -> nodeType.equals((Object)RecordsManagementModel.TYPE_RECORD_FOLDER));
    }

    @WebApiDescription(title="Return a paged list of retention schedule based on the 'recordCategoryId'")
    public CollectionWithPagingInfo<RetentionSchedule> readAll(String recordCategoryId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("recordCategoryId", recordCategoryId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef parentNodeRef = this.apiUtils.lookupAndValidateNodeType(recordCategoryId, RecordsManagementModel.TYPE_RECORD_CATEGORY);
        DispositionSchedule schedule = this.dispositionService.getDispositionSchedule(parentNodeRef);
        RetentionSchedule retentionSchedule = this.nodesModelFactory.mapRetentionScheduleData(schedule);
        ArrayList<RetentionSchedule> retentionScheduleList = new ArrayList<RetentionSchedule>();
        this.nodesModelFactory.mapRetentionScheduleOptionalInfo(retentionSchedule, schedule, parameters.getInclude());
        retentionScheduleList.add(retentionSchedule);
        return CollectionWithPagingInfo.asPaged((Paging)parameters.getPaging(), retentionScheduleList, (boolean)false, (Integer)retentionScheduleList.size());
    }
}

