/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.slingshot;

import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.script.slingshot.RecordCategoryUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class RecordCategoryUtilUnitTest {
    @Mock
    private NodeService nodeService;
    @Mock
    private Path.ChildAssocElement element;
    @Mock
    private ChildAssociationRef childAssociationRef;
    @InjectMocks
    private RecordCategoryUtil recordCategoryUtil;
    private Path path;
    private NodeRef recordNodeRef;
    private NodeRef recordFolderNodeRef;
    private NodeRef categoryNodeRef;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.recordNodeRef = new NodeRef("test://recordNode/");
        this.recordFolderNodeRef = new NodeRef("test://recordFolderNode/");
        this.categoryNodeRef = new NodeRef("test://categoryNode/");
        this.path = new Path();
        this.path.append((Path.Element)this.element);
        Mockito.when((Object)this.nodeService.getType(this.recordFolderNodeRef)).thenReturn((Object)RecordsManagementModel.TYPE_RECORD_FOLDER);
        Mockito.when((Object)this.nodeService.getType(this.recordNodeRef)).thenReturn((Object)RecordsManagementModel.TYPE_NON_ELECTRONIC_DOCUMENT);
        Mockito.when((Object)this.nodeService.getPath(this.recordNodeRef)).thenReturn((Object)this.path);
        Mockito.when((Object)this.nodeService.getPath(this.recordFolderNodeRef)).thenReturn((Object)this.path);
        Mockito.when((Object)this.element.getRef()).thenReturn((Object)this.childAssociationRef);
        Mockito.when((Object)this.childAssociationRef.getChildRef()).thenReturn((Object)this.categoryNodeRef);
        Mockito.when((Object)this.nodeService.getType(this.categoryNodeRef)).thenReturn((Object)RecordsManagementModel.TYPE_RECORD_CATEGORY);
        Mockito.when((Object)this.nodeService.getProperty(this.categoryNodeRef, RecordsManagementModel.PROP_IDENTIFIER)).thenReturn((Object)"RecordCategoryId");
    }

    @Test
    public void testGetIdFromNodeRef() {
        Assert.assertEquals((Object)"RecordCategoryId", (Object)this.recordCategoryUtil.getCategoryIdFromNodeId(this.recordNodeRef, false));
    }

    @Test
    public void testGetIdFromNodeRefReturnsForNonRecordWhenOptionSelected() {
        Assert.assertEquals((Object)"RecordCategoryId", (Object)this.recordCategoryUtil.getCategoryIdFromNodeId(this.recordFolderNodeRef, true));
    }

    @Test
    public void testGetIdFromNodeRefReturnsNullForNonRecordWhenOptionSelected() {
        Assert.assertNull((Object)this.recordCategoryUtil.getCategoryIdFromNodeId(this.recordFolderNodeRef, false));
    }

    @Test
    public void testGetIdFromNodeRefReturnsNullWithNoCategory() {
        Mockito.when((Object)this.nodeService.getPath(this.recordNodeRef)).thenReturn((Object)new Path());
        Assert.assertNull((Object)this.recordCategoryUtil.getCategoryIdFromNodeId(this.recordNodeRef, false));
    }
}

