/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.bulk_ingester.processor;

import java.util.stream.Stream;
import lombok.Generated;
import org.alfresco.elasticsearch.db.connector.model.AlfrescoNode;
import org.alfresco.hxi_connector.bulk_ingester.event.IngestEventPublisher;
import org.alfresco.hxi_connector.bulk_ingester.processor.BulkIngesterConfig;
import org.alfresco.hxi_connector.bulk_ingester.processor.mapper.AlfrescoNodeMapper;
import org.alfresco.hxi_connector.bulk_ingester.repository.BulkIngesterNodeRepository;
import org.alfresco.hxi_connector.bulk_ingester.repository.IdRange;
import org.alfresco.hxi_connector.bulk_ingester.spring.ApplicationManager;
import org.alfresco.hxi_connector.common.model.ingest.IngestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BulkIngestionProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BulkIngestionProcessor.class);
    private final BulkIngesterNodeRepository bulkIngesterNodeRepository;
    private final BulkIngesterConfig bulkIngesterConfig;
    private final AlfrescoNodeMapper alfrescoNodeMapper;
    private final IngestEventPublisher ingestEventPublisher;
    private final ApplicationManager applicationManager;

    public void process() {
        IdRange idRange = new IdRange(this.bulkIngesterConfig.fromId(), this.bulkIngesterConfig.toId());
        this.bulkIngesterNodeRepository.find(idRange).flatMap(arg_0 -> this.mapToIngestEventStream(arg_0)).forEach(arg_0 -> ((IngestEventPublisher)this.ingestEventPublisher).publish(arg_0));
        this.applicationManager.shutDown();
    }

    private Stream<IngestEvent> mapToIngestEventStream(AlfrescoNode node) {
        try {
            return Stream.of(this.alfrescoNodeMapper.map(node));
        }
        catch (Exception e) {
            log.error("Failed to map node {}", (Object)node.getId(), (Object)e);
            return Stream.empty();
        }
    }

    @Generated
    public BulkIngestionProcessor(BulkIngesterNodeRepository bulkIngesterNodeRepository, BulkIngesterConfig bulkIngesterConfig, AlfrescoNodeMapper alfrescoNodeMapper, IngestEventPublisher ingestEventPublisher, ApplicationManager applicationManager) {
        this.bulkIngesterNodeRepository = bulkIngesterNodeRepository;
        this.bulkIngesterConfig = bulkIngesterConfig;
        this.alfrescoNodeMapper = alfrescoNodeMapper;
        this.ingestEventPublisher = ingestEventPublisher;
        this.applicationManager = applicationManager;
    }
}

