/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.bulk_ingester.processor.mapper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.alfresco.elasticsearch.db.connector.model.AlfrescoNode;
import org.alfresco.elasticsearch.db.connector.model.PropertyValue;
import org.alfresco.elasticsearch.db.connector.model.PropertyValueType;
import org.alfresco.hxi_connector.bulk_ingester.processor.mapper.AlfrescoPropertyMapper;
import org.alfresco.hxi_connector.bulk_ingester.processor.mapper.NamespacePrefixMapper;
import org.alfresco.hxi_connector.common.model.ingest.IngestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlfrescoPropertyMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlfrescoPropertyMapper.class);
    private final NamespacePrefixMapper namespacePrefixMapper;
    private final AlfrescoNode alfrescoNode;
    private final String propertyName;

    public Optional<Map.Entry<String, Serializable>> performMapping() {
        Set propertyValues = this.alfrescoNode.getNodeProperties().stream().filter(nodeProperty -> this.namespacePrefixMapper.toPrefixedName(nodeProperty.getPropertyKey()).equals(this.propertyName)).map(nodeProperty -> this.mapPropertyValue(nodeProperty.getPropertyValue())).flatMap(Optional::stream).collect(Collectors.toSet());
        if (propertyValues.isEmpty()) {
            return Optional.empty();
        }
        if (propertyValues.size() == 1) {
            return Optional.of(Map.entry(this.propertyName, (Serializable)propertyValues.iterator().next()));
        }
        return Optional.of(Map.entry(this.propertyName, (Serializable)((Object)propertyValues)));
    }

    private Optional<Serializable> mapPropertyValue(PropertyValue propertyValue) {
        try {
            return this.getPersistedValue(propertyValue).flatMap(persistedValue -> switch (1.$SwitchMap$org$alfresco$elasticsearch$db$connector$model$PropertyValueType[PropertyValueType.getPropertyValueType((int)propertyValue.getActualType()).ordinal()]) {
                case 8 -> this.getContentValue(persistedValue);
                case 9 -> this.getDateValue(persistedValue);
                case 10 -> this.getNodeRefValue(persistedValue);
                default -> Optional.of(persistedValue);
            });
        }
        catch (Exception e) {
            log.warn("Error occurred while trying to map property {} value {} of node {}", new Object[]{this.propertyName, propertyValue, this.alfrescoNode.getId(), e});
            return Optional.empty();
        }
    }

    private Optional<String> getNodeRefValue(Serializable persistedValue) {
        try {
            String[] nodeRefSplit = ((String)((Object)persistedValue)).split("/");
            String id = nodeRefSplit[nodeRefSplit.length - 1];
            return Optional.of(id);
        }
        catch (Exception e) {
            log.error("Cannot deserialize noderef property {} with value {} for node {}", new Object[]{this.propertyName, persistedValue, this.alfrescoNode.getId(), e});
            return Optional.empty();
        }
    }

    private Optional<IngestEvent.ContentInfo> getContentValue(Serializable propertyValue) {
        if (!this.propertyName.equals("cm:content")) {
            log.info("Found content under property with name {} for node {}. Content different from cm:content won't be ingested.", (Object)this.propertyName, (Object)this.alfrescoNode.getId());
            return Optional.empty();
        }
        return this.alfrescoNode.getContentData().stream().filter(contentMetadata -> Objects.equals(contentMetadata.getId(), propertyValue)).findFirst().map(content -> new IngestEvent.ContentInfo(content.getContentSize(), content.getEncoding(), content.getMimetypeStr())).or(() -> {
            log.error("Content metadata not found for node {}", (Object)this.alfrescoNode.getId());
            return Optional.empty();
        });
    }

    private Optional<Serializable> getDateValue(Serializable propertyValue) {
        try {
            return Optional.of(ZonedDateTime.parse((String)((Object)propertyValue), DateTimeFormatter.ISO_OFFSET_DATE_TIME).format(DateTimeFormatter.ISO_INSTANT));
        }
        catch (Exception e) {
            log.error("Cannot get ISO date value from property {} with value {} for node {}", new Object[]{this.propertyName, propertyValue, this.alfrescoNode.getId()});
            return Optional.empty();
        }
    }

    private Optional<Serializable> getPersistedValue(PropertyValue propertyValue) {
        return switch (1.$SwitchMap$org$alfresco$elasticsearch$db$connector$model$PropertyValueType[PropertyValueType.getPropertyValueType((int)propertyValue.getPersistedType()).ordinal()]) {
            case 1 -> Optional.empty();
            case 2 -> Optional.of(propertyValue.getBooleanValue());
            case 3 -> Optional.of(propertyValue.getLongValue());
            case 4 -> Optional.of(Float.valueOf(propertyValue.getFloatValue()));
            case 5 -> Optional.of(propertyValue.getDoubleValue());
            case 6 -> Optional.of(propertyValue.getStringValue());
            case 7 -> this.deserializeObject(propertyValue);
            default -> {
                log.error("Property {} type not recognized. Cannot extract value {}. Node: {}", new Object[]{this.propertyName, propertyValue, this.alfrescoNode.getId()});
                yield Optional.empty();
            }
        };
    }

    private Optional<Serializable> deserializeObject(PropertyValue propertyValue) {
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(propertyValue.getSerializableValue()));
            return Optional.of((Serializable)in.readObject());
        }
        catch (IOException | ClassNotFoundException e) {
            log.error("Cannot deserialize property {} value {}. Node: {} with reference: {}", new Object[]{this.propertyName, propertyValue, this.alfrescoNode.getId(), this.alfrescoNode.getNodeRef(), e});
            return Optional.empty();
        }
    }

    @Generated
    public AlfrescoPropertyMapper(NamespacePrefixMapper namespacePrefixMapper, AlfrescoNode alfrescoNode, String propertyName) {
        this.namespacePrefixMapper = namespacePrefixMapper;
        this.alfrescoNode = alfrescoNode;
        this.propertyName = propertyName;
    }
}

