/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.bulk_ingester.repository.filter;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.alfresco.elasticsearch.db.connector.AlfrescoMetadataRepository;
import org.alfresco.elasticsearch.db.connector.ChildAssocParams;
import org.alfresco.elasticsearch.db.connector.ParentChildAssociationOrdinality;
import org.alfresco.elasticsearch.db.connector.model.AlfrescoNode;
import org.alfresco.elasticsearch.db.connector.model.ChildAssocMetaData;
import org.alfresco.hxi_connector.bulk_ingester.repository.filter.AlfrescoNodeFilterApplier;
import org.alfresco.hxi_connector.bulk_ingester.repository.filter.NodeFilterConfig;
import org.alfresco.hxi_connector.common.repository.filter.CollectionFilter;
import org.apache.commons.collections4.SetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AncestorFilterApplier
implements AlfrescoNodeFilterApplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AncestorFilterApplier.class);
    private final AlfrescoMetadataRepository metadataRepository;

    @Override
    public boolean applyFilter(AlfrescoNode alfrescoNode, NodeFilterConfig filterConfig) {
        List<String> allowed = filterConfig.path().allow();
        List<String> denied = filterConfig.path().deny();
        if (allowed.isEmpty() && denied.isEmpty()) {
            log.atDebug().log("Ancestor filters will not be applied on Alfresco node of id: {} because there are no filters defined.", (Object)alfrescoNode.getId());
            return true;
        }
        List<String> primaryHierarchy = this.getPrimaryHierarchy(alfrescoNode);
        primaryHierarchy.add(alfrescoNode.getNodeRef());
        log.atDebug().log("Applying primary ancestor filters on Alfresco node of id: {}", (Object)alfrescoNode.getId());
        return CollectionFilter.filter(primaryHierarchy, allowed, denied);
    }

    private List<String> getPrimaryHierarchy(AlfrescoNode alfrescoNode) {
        Set<ParentChildAssociationOrdinality> ordinalities = Set.of(ParentChildAssociationOrdinality.PRIMARY);
        ZonedDateTime nodeTimestamp = ZonedDateTime.ofInstant(Instant.ofEpochMilli(alfrescoNode.getTimestamp()), ZoneId.systemDefault());
        ArrayDeque<String> primaryHierarchy = new ArrayDeque<String>();
        ChildAssocMetaData primaryParentAssociation = alfrescoNode.getPrimaryParentAssociation();
        while (primaryParentAssociation != null) {
            primaryHierarchy.add(primaryParentAssociation.getParentUuid());
            ChildAssocParams childAssocParams = new ChildAssocParams(ordinalities, primaryParentAssociation.getParentId().longValue(), nodeTimestamp);
            Set childAssocMetaData = SetUtils.emptyIfNull((Set)this.metadataRepository.getChildAssocMetaData(childAssocParams));
            primaryParentAssociation = childAssocMetaData.isEmpty() ? null : (ChildAssocMetaData)childAssocMetaData.iterator().next();
        }
        return new ArrayList<String>(primaryHierarchy);
    }

    @Generated
    public AncestorFilterApplier(AlfrescoMetadataRepository metadataRepository) {
        this.metadataRepository = metadataRepository;
    }
}

