/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.bulk_ingester.processor.mapper;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.alfresco.elasticsearch.db.connector.model.AccessControlEntry;
import org.alfresco.elasticsearch.db.connector.model.AccessControlEntryKey;
import org.alfresco.elasticsearch.db.connector.model.AlfrescoNode;
import org.alfresco.hxi_connector.bulk_ingester.processor.mapper.AlfrescoPropertyMapperFactory;
import org.alfresco.hxi_connector.bulk_ingester.processor.mapper.NamespacePrefixMapper;
import org.alfresco.hxi_connector.bulk_ingester.processor.mapper.TimeProvider;
import org.alfresco.hxi_connector.common.model.ingest.IngestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlfrescoNodeMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlfrescoNodeMapper.class);
    private static final Set<String> PREDEFINED_PROPERTIES = Set.of("cm:content");
    private final AlfrescoPropertyMapperFactory propertyMapperFactory;
    private final NamespacePrefixMapper namespacePrefixMapper;
    private final TimeProvider timeProvider;

    public IngestEvent map(AlfrescoNode alfrescoNode) {
        Set denyAccess;
        String nodeId = alfrescoNode.getNodeRef();
        String type = this.namespacePrefixMapper.toPrefixedName(alfrescoNode.getType());
        String creatorId = alfrescoNode.getCreator();
        String modifierId = alfrescoNode.getModifier();
        HashSet aspectNames = alfrescoNode.getAspects().stream().map(arg_0 -> ((NamespacePrefixMapper)this.namespacePrefixMapper).toPrefixedName(arg_0)).collect(Collectors.toCollection(HashSet::new));
        String createdAt = this.getCreatedAt(alfrescoNode);
        String modifiedAt = this.getModifiedAt(alfrescoNode);
        Map allProperties = this.calculateAllProperties(alfrescoNode);
        allProperties.put("type", type);
        allProperties.put("createdBy", creatorId);
        allProperties.put("modifiedBy", modifierId);
        if (!aspectNames.isEmpty()) {
            allProperties.put("aspectsNames", aspectNames);
        }
        allProperties.put("createdAt", createdAt);
        allProperties.put("modifiedAt", modifiedAt);
        Set allowAccess = (Set)((Object)this.getResourceReaderAuthorities(alfrescoNode));
        if (!allowAccess.isEmpty()) {
            allProperties.put("ALLOW_ACCESS", (Serializable)((Object)allowAccess));
        }
        if (!(denyAccess = (Set)((Object)this.getResourceDeniedAuthorities(alfrescoNode))).isEmpty()) {
            allProperties.put("DENY_ACCESS", (Serializable)((Object)denyAccess));
        }
        IngestEvent.ContentInfo content = (IngestEvent.ContentInfo)allProperties.get("cm:content");
        Map properties = this.getProperties(allProperties);
        return new IngestEvent(nodeId, content, properties, this.timeProvider.getCurrentTimestamp());
    }

    private String getCreatedAt(AlfrescoNode alfrescoNode) {
        return this.formatZonedDateTime(alfrescoNode.getCreatedAt());
    }

    private String getModifiedAt(AlfrescoNode alfrescoNode) {
        return this.formatZonedDateTime(alfrescoNode.getModifiedAt());
    }

    private String formatZonedDateTime(ZonedDateTime zonedDateTime) {
        return Optional.ofNullable(zonedDateTime).map(ChronoZonedDateTime::toInstant).map(DateTimeFormatter.ISO_INSTANT::format).orElse(null);
    }

    private Map<String, Serializable> calculateAllProperties(AlfrescoNode alfrescoNode) {
        return alfrescoNode.getNodeProperties().stream().filter(Objects::nonNull).map((? super T property) -> this.namespacePrefixMapper.toPrefixedName(property.getPropertyKey())).distinct().map((? super T propertyName) -> this.propertyMapperFactory.create(alfrescoNode, propertyName).performMapping()).flatMap(Optional::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, Serializable> getProperties(Map<String, Serializable> allProperties) {
        return allProperties.entrySet().stream().filter(property -> Objects.nonNull(property.getValue())).filter(property -> !PREDEFINED_PROPERTIES.contains(property.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Serializable getResourceReaderAuthorities(AlfrescoNode node) {
        return (Serializable)((Object)Optional.ofNullable(node.getAccessControlList()).stream().flatMap(Collection::stream).filter(AccessControlEntry::getAllowed).map(AccessControlEntry::getAccessControlEntryKey).map(AccessControlEntryKey::getAuthority).collect(Collectors.toSet()));
    }

    private Serializable getResourceDeniedAuthorities(AlfrescoNode node) {
        return (Serializable)((Object)Optional.ofNullable(node.getAccessControlList()).stream().flatMap(Collection::stream).filter(Predicate.not(AccessControlEntry::getAllowed)).map(AccessControlEntry::getAccessControlEntryKey).map(AccessControlEntryKey::getAuthority).collect(Collectors.toSet()));
    }

    @Generated
    public AlfrescoNodeMapper(AlfrescoPropertyMapperFactory propertyMapperFactory, NamespacePrefixMapper namespacePrefixMapper, TimeProvider timeProvider) {
        this.propertyMapperFactory = propertyMapperFactory;
        this.namespacePrefixMapper = namespacePrefixMapper;
        this.timeProvider = timeProvider;
    }
}

