/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.bulk_ingester.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.elasticsearch.db.connector.AlfrescoMetadataRepository;
import org.alfresco.elasticsearch.db.connector.ChildAssocParams;
import org.alfresco.elasticsearch.db.connector.NodeParams;
import org.alfresco.elasticsearch.db.connector.model.AlfrescoNode;
import org.alfresco.elasticsearch.db.connector.model.ChildAssocMetaData;
import org.alfresco.elasticsearch.db.connector.model.TagData;

class InMemoryAlfrescoMetadataRepository
implements AlfrescoMetadataRepository {
    private final List<AlfrescoNode> nodes = new ArrayList();

    InMemoryAlfrescoMetadataRepository() {
    }

    public void setNodes(List<AlfrescoNode> nodes) {
        this.nodes.clear();
        this.nodes.addAll(nodes);
    }

    public List<AlfrescoNode> getAlfrescoNodes(NodeParams nodeParams) {
        if (nodeParams.getTimestampRange().isPresent()) {
            throw new UnsupportedOperationException("Not implemented");
        }
        if (nodeParams.getIdRange().isEmpty()) {
            throw new IllegalArgumentException("NodeParams idRange parameter is required");
        }
        if (nodeParams.getPaging().isEmpty()) {
            throw new IllegalArgumentException("NodeParams paging parameter is required");
        }
        NodeParams.Range idRange = (NodeParams.Range)nodeParams.getIdRange().get();
        NodeParams.Paging paging = (NodeParams.Paging)nodeParams.getPaging().get();
        return this.nodes.stream().filter(node -> idRange.getBegin() <= node.getId() && node.getId() < idRange.getEnd()).skip((long)paging.getPageSize() * (long)paging.getPage()).limit(paging.getPageSize()).toList();
    }

    public Set<ChildAssocMetaData> getChildAssocMetaData(ChildAssocParams childAssocParams) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Map<String, TagData> getAllTags() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Long getDBIdFromNodeRef(String s) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

