/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.client;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import org.alfresco.hxi_connector.common.adapters.auth.AuthenticationResult;
import org.alfresco.hxi_connector.common.adapters.auth.DefaultAuthenticationClient;
import org.alfresco.hxi_connector.common.adapters.auth.config.properties.AuthProperties;
import org.alfresco.hxi_connector.common.config.properties.Retry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HxInsightAuthClient
extends DefaultAuthenticationClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HxInsightAuthClient.class);

    public HxInsightAuthClient(AuthProperties authProperties) {
        super(authProperties);
    }

    @Override
    public AuthenticationResult authenticate(String providerId) {
        return HxInsightAuthClient.retryWithBackoff(() -> super.authenticate(providerId), this.authProperties.getRetry());
    }

    private static <T> T retryWithBackoff(Supplier<T> supplier, Retry retryProperties) {
        int attempt = 0;
        int maxAttempts = retryProperties.attempts();
        double delay = retryProperties.initialDelay();
        while (true) {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                if (retryProperties.reasons() != null && retryProperties.reasons().contains(e.getClass())) {
                    if (++attempt >= maxAttempts) {
                        log.atInfo().log("Attempt {} of {} failed", (Object)attempt, (Object)maxAttempts);
                        throw e;
                    }
                    log.atInfo().log("Attempt {} of {} failed, retrying after {}ms", new Object[]{attempt, maxAttempts, Math.round(delay)});
                    try {
                        TimeUnit.MILLISECONDS.sleep(Math.round(delay));
                    }
                    catch (InterruptedException ex) {
                        log.warn("Cannot pause retryable operation due to InterruptedException", (Throwable)e);
                    }
                    delay *= retryProperties.delayMultiplier();
                    continue;
                }
                throw e;
            }
            break;
        }
    }
}

