/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.rest.api.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.util.Set;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.QuestionModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class QuestionModelSerializationTest {
    private final ObjectMapper objectMapper = new ObjectMapper();

    QuestionModelSerializationTest() {
    }

    @Test
    void shouldThrowWhenQuestionIdSpecified() {
        String questionSerialized = "{\n    \"_questionId\": \"86553f9b-e382-4a1b-b07d-52adae3e96e8\",\n    \"question\": \"What is the capital of France?\",\n    \"restrictionQuery\": {\n        \"nodesIds\": [\"node1\", \"node2\"]\n    }\n}\n";
        Assertions.assertThrows(UnrecognizedPropertyException.class, () -> this.objectMapper.readValue(questionSerialized, QuestionModel.class));
    }

    @Test
    void shouldThrowWhenQuestionIdSpecified2() {
        String questionSerialized = "{\n    \"questionId\": \"86553f9b-e382-4a1b-b07d-52adae3e96e8\",\n    \"question\": \"What is the capital of France?\",\n    \"restrictionQuery\": {\n        \"nodesIds\": [\"node1\", \"node2\"]\n    }\n}\n";
        Assertions.assertThrows(UnrecognizedPropertyException.class, () -> this.objectMapper.readValue(questionSerialized, QuestionModel.class));
    }

    @Test
    void shouldDeserializeQuestion() {
        String questionSerialized = "{\n    \"question\": \"What is the capital of France?\",\n    \"restrictionQuery\": {\n        \"nodesIds\": [\"node1\", \"node2\"]\n    }\n}\n";
        QuestionModel question = (QuestionModel)this.objectMapper.readValue(questionSerialized, QuestionModel.class);
        Assertions.assertEquals((Object)"What is the capital of France?", (Object)question.getQuestion());
        Assertions.assertEquals(Set.of("node1", "node2"), (Object)question.getRestrictionQuery().getNodesIds());
    }
}

