/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.service;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.hxi_connector.common.adapters.auth.AuthService;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.ApplicationInfoProvider;
import org.alfresco.hxi_connector.hxi_extension.service.HxInsightClient;
import org.alfresco.hxi_connector.hxi_extension.service.config.HxInsightClientConfig;
import org.alfresco.hxi_connector.hxi_extension.service.model.Agent;
import org.alfresco.hxi_connector.hxi_extension.service.model.AnswerResponse;
import org.alfresco.hxi_connector.hxi_extension.service.model.Feedback;
import org.alfresco.hxi_connector.hxi_extension.service.model.FeedbackType;
import org.alfresco.hxi_connector.hxi_extension.service.model.Question;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.extensions.webscripts.WebScriptException;

class HxInsightClientTest {
    private static final String USER_ID = "user-id";
    private static final String AGENT_ID = "agent-id";
    private static final Set<String> OBJECT_IDS = Set.of("dummy-node-id");
    private static final String USER_AGENT_HEADER = "ACS HXI Connector/1.0.0 ACS/23.2.0 (Windows 10 amd64)";
    private static final String SOURCE_ID = "a1f3e7c0-d193-7023-ce1d-0a63de491876";
    private final HxInsightClientConfig config = new HxInsightClientConfig("http://hxinsight", "http://hxinsight");
    private final AuthService authService = (AuthService)Mockito.mock(AuthService.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final HttpClient httpClient = (HttpClient)Mockito.mock(HttpClient.class);
    private final ApplicationInfoProvider applicationInfoProvider = (ApplicationInfoProvider)Mockito.mock(ApplicationInfoProvider.class);
    private final HxInsightClient hxInsightClient = new HxInsightClient(this.config, this.authService, this.objectMapper, this.httpClient, this.applicationInfoProvider);
    private ArgumentCaptor<HttpRequest> requestCaptor;

    HxInsightClientTest() {
    }

    @BeforeEach
    void setUp() {
        this.objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        BDDMockito.given((Object)this.authService.getHxpAuthHeaders()).willReturn(Map.of("Authorization", "Bearer token"));
        BDDMockito.given((Object)this.applicationInfoProvider.getUserAgentData()).willReturn((Object)USER_AGENT_HEADER);
        BDDMockito.given((Object)this.applicationInfoProvider.getSourceId()).willReturn((Object)SOURCE_ID);
        this.requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
    }

    @Test
    void shouldReturnQuestionId() {
        String expectedQuestionId = "bd4cfeff-f197-40b6-b205-9067cad3fca7";
        String responseBody = "{\n    \"questionId\": \"%s\"\n}\n".formatted(expectedQuestionId);
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        BDDMockito.given((Object)response.statusCode()).willReturn((Object)202);
        BDDMockito.given(response.body()).willReturn((Object)responseBody);
        BDDMockito.given(this.httpClient.send((HttpRequest)ArgumentMatchers.any(), (HttpResponse.BodyHandler)ArgumentMatchers.any())).willReturn((Object)response);
        String actualQuestionId = this.hxInsightClient.askQuestion(AGENT_ID, new Question("Who won last year's Super Bowl?", OBJECT_IDS));
        Assertions.assertEquals((Object)expectedQuestionId, (Object)actualQuestionId);
        ((HttpClient)BDDMockito.then((Object)this.httpClient).should()).send((HttpRequest)this.requestCaptor.capture(), (HttpResponse.BodyHandler)ArgumentMatchers.any());
        Assertions.assertEquals((Object)USER_AGENT_HEADER, (Object)((HttpRequest)this.requestCaptor.getValue()).headers().map().get("User-Agent").get(0));
    }

    @Test
    void shouldPassStatusCodeFromHxi_Question() {
        int expectedStatusCode = 418;
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        BDDMockito.given((Object)response.statusCode()).willReturn((Object)expectedStatusCode);
        BDDMockito.given(this.httpClient.send((HttpRequest)ArgumentMatchers.any(), (HttpResponse.BodyHandler)ArgumentMatchers.any())).willReturn((Object)response);
        WebScriptException exception = (WebScriptException)Assertions.assertThrows(WebScriptException.class, () -> this.hxInsightClient.askQuestion(AGENT_ID, new Question("Who won last year's Super Bowl?", OBJECT_IDS)));
        Assertions.assertEquals((int)expectedStatusCode, (int)exception.getStatus());
        ((HttpClient)BDDMockito.then((Object)this.httpClient).should()).send((HttpRequest)this.requestCaptor.capture(), (HttpResponse.BodyHandler)ArgumentMatchers.any());
        Assertions.assertEquals((Object)USER_AGENT_HEADER, (Object)((HttpRequest)this.requestCaptor.getValue()).headers().map().get("User-Agent").get(0));
    }

    @Test
    void shouldSet503StatusCodeOnCheckedException_Question() {
        BDDMockito.given(this.httpClient.send((HttpRequest)ArgumentMatchers.any(), (HttpResponse.BodyHandler)ArgumentMatchers.any())).willThrow(IOException.class);
        WebScriptException exception = (WebScriptException)Assertions.assertThrows(WebScriptException.class, () -> this.hxInsightClient.askQuestion(AGENT_ID, new Question("Who won last year's Super Bowl?", OBJECT_IDS)));
        Assertions.assertEquals((int)503, (int)exception.getStatus());
    }

    @Test
    void shouldReturnAnswer() {
        String question = "Who won last year's Super Bowl?";
        String answer = "The Kansas City Chiefs won last year's Super Bowl.";
        AnswerResponse expectedAnswerResponse = new AnswerResponse(question, "", "", "", answer, null);
        JSONObject responseBody = new JSONObject((Object)expectedAnswerResponse);
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        BDDMockito.given((Object)response.statusCode()).willReturn((Object)200);
        BDDMockito.given(response.body()).willReturn((Object)responseBody.toString());
        BDDMockito.given(this.httpClient.send((HttpRequest)ArgumentMatchers.any(), (HttpResponse.BodyHandler)ArgumentMatchers.any())).willReturn((Object)response);
        String questionId = "dummy-id-1234";
        AnswerResponse answerResponse = this.hxInsightClient.getAnswer(questionId, USER_ID);
        Assertions.assertEquals((Object)answer, (Object)answerResponse.getAnswer());
        ((HttpClient)BDDMockito.then((Object)this.httpClient).should()).send((HttpRequest)this.requestCaptor.capture(), (HttpResponse.BodyHandler)ArgumentMatchers.any());
        Assertions.assertEquals((Object)USER_AGENT_HEADER, (Object)((HttpRequest)this.requestCaptor.getValue()).headers().map().get("User-Agent").get(0));
    }

    @Test
    void shouldThrowOnNotExpectedStatusCodeWhenGettingAnswer() {
        String questionId = "dummy-id-1234";
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        BDDMockito.given((Object)response.statusCode()).willReturn((Object)400);
        BDDMockito.given(this.httpClient.send((HttpRequest)ArgumentMatchers.any(), (HttpResponse.BodyHandler)ArgumentMatchers.any())).willReturn((Object)response);
        Assertions.assertThrows(WebScriptException.class, () -> this.hxInsightClient.getAnswer(questionId, USER_ID));
        ((HttpClient)BDDMockito.then((Object)this.httpClient).should()).send((HttpRequest)this.requestCaptor.capture(), (HttpResponse.BodyHandler)ArgumentMatchers.any());
        Assertions.assertEquals((Object)USER_AGENT_HEADER, (Object)((HttpRequest)this.requestCaptor.getValue()).headers().map().get("User-Agent").get(0));
    }

    @Test
    void shouldSet503StatusCodeOnIOException_Answer() {
        BDDMockito.given(this.httpClient.send((HttpRequest)ArgumentMatchers.any(), (HttpResponse.BodyHandler)ArgumentMatchers.any())).willThrow(IOException.class);
        WebScriptException exception = (WebScriptException)Assertions.assertThrows(WebScriptException.class, () -> this.hxInsightClient.getAnswer("dummy-id-1234", USER_ID));
        Assertions.assertEquals((int)503, (int)exception.getStatus());
        ((HttpClient)BDDMockito.then((Object)this.httpClient).should()).send((HttpRequest)this.requestCaptor.capture(), (HttpResponse.BodyHandler)ArgumentMatchers.any());
        Assertions.assertEquals((Object)USER_AGENT_HEADER, (Object)((HttpRequest)this.requestCaptor.getValue()).headers().map().get("User-Agent").get(0));
    }

    @Test
    void shouldReturnAgents() {
        String responseBody = "[\n    {\n        \"id\": \"1a3f4b3d-4b3d-4b3d-4b3d-4b3d4b3d4b3d\",\n        \"name\": \"Security Advisor\",\n        \"description\": \"I can help you to secure your systems.\",\n        \"avatarUrl\": \"https://example.com/avatar.png\"\n    },\n    {\n        \"id\": \"1a3f1a3f-1a3f-1a3f-1a3f-1a3f1a3f1a3f\",\n        \"name\": \"Tax Advisor\",\n        \"description\": \"I can help you with your taxes and financial planning.\",\n        \"avatarUrl\": \"https://example.com/avatar.png\"\n    }\n]\n";
        List<Agent> expectedAgents = List.of(new Agent("1a3f4b3d-4b3d-4b3d-4b3d-4b3d4b3d4b3d", "Security Advisor", "I can help you to secure your systems.", "https://example.com/avatar.png"), new Agent("1a3f1a3f-1a3f-1a3f-1a3f-1a3f1a3f1a3f", "Tax Advisor", "I can help you with your taxes and financial planning.", "https://example.com/avatar.png"));
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        BDDMockito.given((Object)response.statusCode()).willReturn((Object)200);
        BDDMockito.given(response.body()).willReturn((Object)responseBody);
        BDDMockito.given(this.httpClient.send((HttpRequest)ArgumentMatchers.argThat(req -> req.uri().toString().equals("http://hxinsight/agents?sourceId=a1f3e7c0-d193-7023-ce1d-0a63de491876")), (HttpResponse.BodyHandler)ArgumentMatchers.any())).willReturn((Object)response);
        List actualAgents = this.hxInsightClient.getAgents();
        Assertions.assertEquals(expectedAgents, (Object)actualAgents);
        ((HttpClient)BDDMockito.then((Object)this.httpClient).should()).send((HttpRequest)this.requestCaptor.capture(), (HttpResponse.BodyHandler)ArgumentMatchers.any());
        Assertions.assertEquals((Object)USER_AGENT_HEADER, (Object)((HttpRequest)this.requestCaptor.getValue()).headers().map().get("User-Agent").get(0));
    }

    @Test
    void shouldPassStatusCodeFromHxi_Agents() {
        int expectedStatusCode = 418;
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        BDDMockito.given((Object)response.statusCode()).willReturn((Object)expectedStatusCode);
        BDDMockito.given(this.httpClient.send((HttpRequest)ArgumentMatchers.any(), (HttpResponse.BodyHandler)ArgumentMatchers.any())).willReturn((Object)response);
        WebScriptException exception = (WebScriptException)Assertions.assertThrows(WebScriptException.class, () -> ((HxInsightClient)this.hxInsightClient).getAgents());
        Assertions.assertEquals((int)expectedStatusCode, (int)exception.getStatus());
        ((HttpClient)BDDMockito.then((Object)this.httpClient).should()).send((HttpRequest)this.requestCaptor.capture(), (HttpResponse.BodyHandler)ArgumentMatchers.any());
        Assertions.assertEquals((Object)USER_AGENT_HEADER, (Object)((HttpRequest)this.requestCaptor.getValue()).headers().map().get("User-Agent").get(0));
    }

    @Test
    void shouldSet503StatusCodeOnCheckedException_Agents() {
        BDDMockito.given(this.httpClient.send((HttpRequest)ArgumentMatchers.any(), (HttpResponse.BodyHandler)ArgumentMatchers.any())).willThrow(IOException.class);
        WebScriptException exception = (WebScriptException)Assertions.assertThrows(WebScriptException.class, () -> ((HxInsightClient)this.hxInsightClient).getAgents());
        Assertions.assertEquals((int)503, (int)exception.getStatus());
        ((HttpClient)BDDMockito.then((Object)this.httpClient).should()).send((HttpRequest)this.requestCaptor.capture(), (HttpResponse.BodyHandler)ArgumentMatchers.any());
        Assertions.assertEquals((Object)USER_AGENT_HEADER, (Object)((HttpRequest)this.requestCaptor.getValue()).headers().map().get("User-Agent").get(0));
    }

    @Test
    void canSubmitFeedbackWithoutException() {
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        BDDMockito.given((Object)response.statusCode()).willReturn((Object)200);
        BDDMockito.given(this.httpClient.send((HttpRequest)ArgumentMatchers.any(), (HttpResponse.BodyHandler)ArgumentMatchers.any())).willReturn((Object)response);
        this.hxInsightClient.submitFeedback("dummy-id-1234", new Feedback(FeedbackType.GOOD, "This answer was amazing"));
        ((HttpClient)BDDMockito.then((Object)this.httpClient).should()).send((HttpRequest)this.requestCaptor.capture(), (HttpResponse.BodyHandler)ArgumentMatchers.any());
        Assertions.assertEquals((Object)"http://hxinsight/questions/dummy-id-1234/answer/feedback", (Object)((HttpRequest)this.requestCaptor.getValue()).uri().toString());
        Assertions.assertEquals((Object)USER_AGENT_HEADER, (Object)((HttpRequest)this.requestCaptor.getValue()).headers().map().get("User-Agent").get(0));
    }

    @Test
    void shouldPassStatusCodeFromHxi_Feedback() {
        int expectedStatusCode = 418;
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        BDDMockito.given((Object)response.statusCode()).willReturn((Object)expectedStatusCode);
        BDDMockito.given(this.httpClient.send((HttpRequest)ArgumentMatchers.any(), (HttpResponse.BodyHandler)ArgumentMatchers.any())).willReturn((Object)response);
        WebScriptException exception = (WebScriptException)Assertions.assertThrows(WebScriptException.class, () -> this.hxInsightClient.submitFeedback("dummy-id-1234", new Feedback(FeedbackType.GOOD, "This answer was amazing")));
        Assertions.assertEquals((int)expectedStatusCode, (int)exception.getStatus());
        ((HttpClient)BDDMockito.then((Object)this.httpClient).should()).send((HttpRequest)this.requestCaptor.capture(), (HttpResponse.BodyHandler)ArgumentMatchers.any());
        Assertions.assertEquals((Object)USER_AGENT_HEADER, (Object)((HttpRequest)this.requestCaptor.getValue()).headers().map().get("User-Agent").get(0));
    }

    @Test
    void shouldSet503StatusCodeOnCheckedException_Feedback() {
        BDDMockito.given(this.httpClient.send((HttpRequest)ArgumentMatchers.any(), (HttpResponse.BodyHandler)ArgumentMatchers.any())).willThrow(IOException.class);
        WebScriptException exception = (WebScriptException)Assertions.assertThrows(WebScriptException.class, () -> this.hxInsightClient.submitFeedback("dummy-id-1234", new Feedback(FeedbackType.GOOD, "This answer was amazing")));
        Assertions.assertEquals((int)503, (int)exception.getStatus());
        ((HttpClient)BDDMockito.then((Object)this.httpClient).should()).send((HttpRequest)this.requestCaptor.capture(), (HttpResponse.BodyHandler)ArgumentMatchers.any());
        Assertions.assertEquals((Object)USER_AGENT_HEADER, (Object)((HttpRequest)this.requestCaptor.getValue()).headers().map().get("User-Agent").get(0));
    }

    @Test
    void canRetryQuestion() {
        String questionId = "dummy-id-1234";
        HttpResponse feedbackResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        BDDMockito.given((Object)feedbackResponse.statusCode()).willReturn((Object)200);
        ArgumentMatcher feedbackMatcher = request -> request != null && request.uri().toString().equals("http://hxinsight/questions/dummy-id-1234/answer/feedback");
        BDDMockito.given(this.httpClient.send((HttpRequest)ArgumentMatchers.argThat((ArgumentMatcher)feedbackMatcher), (HttpResponse.BodyHandler)ArgumentMatchers.any())).willReturn((Object)feedbackResponse);
        HttpResponse questionResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        BDDMockito.given((Object)questionResponse.statusCode()).willReturn((Object)202);
        BDDMockito.given(questionResponse.body()).willReturn((Object)"{\n    \"questionId\": \"dummy-id-5678\"\n}\n");
        ArgumentMatcher questionMatcher = request -> request != null && request.uri().toString().equals("http://hxinsight/agents/agent-id/questions");
        BDDMockito.given(this.httpClient.send((HttpRequest)ArgumentMatchers.argThat((ArgumentMatcher)questionMatcher), (HttpResponse.BodyHandler)ArgumentMatchers.any())).willReturn((Object)questionResponse);
        Question question = new Question("Create a sonnet about the Super Bowl", OBJECT_IDS);
        String newQuestionId = this.hxInsightClient.retryQuestion(AGENT_ID, questionId, "The fourth line was not quite in iambic pentameter", question);
        Assertions.assertEquals((Object)"dummy-id-5678", (Object)newQuestionId);
        ((HttpClient)BDDMockito.then((Object)this.httpClient).should(Mockito.atLeast((int)1))).send((HttpRequest)this.requestCaptor.capture(), (HttpResponse.BodyHandler)ArgumentMatchers.any());
        Assertions.assertEquals((Object)USER_AGENT_HEADER, (Object)((HttpRequest)this.requestCaptor.getValue()).headers().map().get("User-Agent").get(0));
    }
}

