/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.util.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.alfresco.hxi_connector.hxi_extension.rest.api.ConfigEntityResource;
import org.alfresco.rest.api.model.Aspect;

public class TestRepoClient {
    private static final int TIMEOUT_SECONDS = 300000;
    private final HttpClient httpClient = HttpClient.newBuilder().authenticator(new Authenticator(){

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication("admin", "admin".toCharArray());
        }
    }).connectTimeout(Duration.of(300000L, ChronoUnit.SECONDS)).build();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String baseRepoUrl;
    private final String baseRepoHxiExtensionUrl;

    public TestRepoClient(String host, int port) {
        this.baseRepoUrl = "http://%s:%s/alfresco/api/-default-/public/alfresco/versions/1".formatted(host, port);
        this.baseRepoHxiExtensionUrl = "http://%s:%s/alfresco/api/-default-/private/hxi/versions/1".formatted(host, port);
    }

    public ConfigEntityResource.HxIConfig getConfig() {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("%s/config/-default-".formatted(this.baseRepoHxiExtensionUrl))).header("Content-Type", "application/json").GET().build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IllegalStateException("Call to aspects endpoint returned unexpected response %s".formatted(response.statusCode()));
        }
        Map parsedResponse = (Map)this.objectMapper.readValue(response.body(), (TypeReference)new TypeReference<Map<String, Map<String, String>>>(){});
        Map configMap = (Map)parsedResponse.get("entry");
        return new ConfigEntityResource.HxIConfig((String)configMap.get("knowledgeRetrievalUrl"));
    }

    public Aspect getAspectById(String aspectId) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("%s/aspects/%s".formatted(this.baseRepoUrl, aspectId))).header("Content-Type", "application/json").GET().build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IllegalStateException("Call to aspects endpoint returned unexpected response %s".formatted(response.statusCode()));
        }
        Map parsedResponse = (Map)this.objectMapper.readValue(response.body(), (TypeReference)new TypeReference<Map<String, Aspect>>(){});
        return (Aspect)parsedResponse.get("entry");
    }
}

