/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.hx_insight.storage.connector;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.alfresco.hxi_connector.common.exception.EndpointServerErrorException;
import org.alfresco.hxi_connector.common.util.ErrorUtils;
import org.alfresco.hxi_connector.live_ingester.adapters.config.IntegrationProperties;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.hx_insight.storage.connector.FileUploadRequest;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.hx_insight.storage.connector.FileUploader;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.util.LoggingUtils;
import org.alfresco.hxi_connector.live_ingester.domain.exception.LiveIngesterRuntimeException;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class HttpFileUploader
extends RouteBuilder
implements FileUploader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpFileUploader.class);
    private static final String LOCAL_ENDPOINT = "direct:" + HttpFileUploader.class.getSimpleName();
    static final String ROUTE_ID = "rendition-uploader";
    static final String AMZ_SECURITY_TOKEN = "X-Amz-Security-Token=";
    static final String STORAGE_LOCATION_HEADER = "storageLocation";
    private static final int EXPECTED_STATUS_CODE = 200;
    private final CamelContext camelContext;
    private final IntegrationProperties integrationProperties;

    public void configure() {
        String uploadEndpoint = "${headers.storageLocation}&throwExceptionOnFailure=false";
        ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.onException(Exception.class).log(LoggingLevel.ERROR, log, "Storage :: Unexpected response while uploading content - Endpoint: %s".formatted(uploadEndpoint))).process(exchange -> LoggingUtils.logMaskedExchangeState(exchange, log, Level.ERROR))).process(this::wrapErrorIfNecessary)).stop();
        ((ChoiceDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(LOCAL_ENDPOINT).id(ROUTE_ID)).setHeader("CamelHttpMethod", (Expression)this.constant(HttpMethods.PUT))).marshal().mimeMultipart().toD(uploadEndpoint)).choice().when(this.header("CamelHttpResponseCode").isNotEqualTo((Object)String.valueOf(200))).process(this::throwExceptionOnUnexpectedStatusCode)).endChoice().end();
    }

    @Override
    @Retryable(retryFor={EndpointServerErrorException.class}, maxAttemptsExpression="#{@integrationProperties.hylandExperience.storage.upload.retry.attempts}", backoff=@Backoff(delayExpression="#{@integrationProperties.hylandExperience.storage.upload.retry.initialDelay}", multiplierExpression="#{@integrationProperties.hylandExperience.storage.upload.retry.delayMultiplier}"))
    public void upload(FileUploadRequest fileUploadRequest, String nodeId) {
        InputStream fileData = fileUploadRequest.file().data();
        try {
            Map<String, String> headers = Map.of(STORAGE_LOCATION_HEADER, this.wrapRawToken(fileUploadRequest.storageLocation()), "Content-Type", fileUploadRequest.contentType());
            this.camelContext.createFluentProducerTemplate().to(LOCAL_ENDPOINT).withHeaders(headers).withBody((Object)fileData).request();
            log.atInfo().log("Storage :: Rendition of type: {} for node: {} successfully uploaded to pre-signed URL: {}", new Object[]{fileUploadRequest.contentType(), nodeId, fileUploadRequest.storageLocation().getPath()});
        }
        catch (Exception e) {
            try {
                fileData.reset();
                throw e;
            }
            catch (IOException ioe) {
                log.atWarn().log("Storage :: Rendition stream NOT reset properly after node %s content upload fail due to: %s".formatted(nodeId, ioe.getMessage()), (Object)ioe);
                throw e;
            }
        }
    }

    private String wrapRawToken(URL preSignedUrl) {
        String query = preSignedUrl.getQuery();
        if (query != null && query.contains(AMZ_SECURITY_TOKEN)) {
            String token = StringUtils.substringBetween((String)query, (String)AMZ_SECURITY_TOKEN, (String)"&");
            if (StringUtils.isEmpty((CharSequence)token)) {
                token = StringUtils.substringAfter((String)query, (String)AMZ_SECURITY_TOKEN);
            }
            return preSignedUrl.toString().replace(token, "RAW(%s)".formatted(URLDecoder.decode(token, StandardCharsets.UTF_8)));
        }
        return preSignedUrl.toString();
    }

    private void throwExceptionOnUnexpectedStatusCode(Exchange exchange) {
        int actualStatusCode = (Integer)exchange.getMessage().getHeader("CamelHttpResponseCode", Integer.class);
        if (actualStatusCode != 200) {
            log.warn("Unexpected response status code - expecting: %d, received: %d".formatted(200, actualStatusCode));
        }
        ErrorUtils.throwExceptionOnUnexpectedStatusCode((int)actualStatusCode, (int)200);
    }

    private void wrapErrorIfNecessary(Exchange exchange) {
        Exception cause = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
        Set retryReasons = this.integrationProperties.hylandExperience().storage().upload().retry().reasons();
        ErrorUtils.wrapErrorAndThrowIfNecessary((Exception)cause, (Set)retryReasons, LiveIngesterRuntimeException.class);
    }

    @Generated
    public HttpFileUploader(CamelContext camelContext, IntegrationProperties integrationProperties) {
        this.camelContext = camelContext;
        this.integrationProperties = integrationProperties;
    }
}

