/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.prediction_applier.config;

import org.alfresco.hxi_connector.common.config.properties.Retry;
import org.alfresco.hxi_connector.prediction_applier.config.RepositoryApiProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="alfresco.repository")
public record RepositoryApiProperties(String baseUrl, String discoveryEndpoint, Retry retry, HealthProbe healthProbe) {
    private final String baseUrl;
    private final String discoveryEndpoint;
    private final Retry retry;
    private final HealthProbe healthProbe;

    public RepositoryApiProperties(String baseUrl, String discoveryEndpoint, Retry retry, HealthProbe healthProbe) {
        if (StringUtils.isNotBlank((CharSequence)discoveryEndpoint) && StringUtils.isBlank((CharSequence)healthProbe.endpoint())) {
            throw new IllegalStateException("Property %s must be set in the Prediction Applier configuration when property %s is set.".formatted("alfresco.repository.health-probe.endpoint", "alfresco.repository.discovery-endpoint"));
        }
        this.baseUrl = baseUrl;
        this.discoveryEndpoint = discoveryEndpoint;
        this.retry = retry;
        this.healthProbe = healthProbe;
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public String discoveryEndpoint() {
        return this.discoveryEndpoint;
    }

    public Retry retry() {
        return this.retry;
    }

    public HealthProbe healthProbe() {
        return this.healthProbe;
    }
}

