/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.file.TBIO;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.socket.OutputSocket;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TFileOutputStream
extends DecoratingOutputStream {
    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public TFileOutputStream(String path) throws FileNotFoundException {
        super(TFileOutputStream.newOutputStream(new TFile(path), false));
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public TFileOutputStream(String path, boolean append) throws FileNotFoundException {
        super(TFileOutputStream.newOutputStream(new TFile(path), append));
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public TFileOutputStream(File file) throws FileNotFoundException {
        super(TFileOutputStream.newOutputStream(file, false));
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public TFileOutputStream(File file, boolean append) throws FileNotFoundException {
        super(TFileOutputStream.newOutputStream(file, append));
    }

    @CreatesObligation
    private static OutputStream newOutputStream(File dst, boolean append) throws FileNotFoundException {
        OutputSocket<?> output = TBIO.getOutputSocket(dst, TConfig.get().getOutputPreferences().set(FsOutputOption.APPEND, append), null);
        try {
            return output.newOutputStream();
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw (FileNotFoundException)new FileNotFoundException(dst.toString()).initCause(ex);
        }
    }
}

