/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.Date;
import java.util.List;
import org.alfresco.rest.AbstractSingleNetworkSiteTest;
import org.alfresco.rest.api.discovery.DiscoveryApiWebscript;
import org.alfresco.rest.api.model.DiscoveryDetails;
import org.alfresco.rest.api.model.RepositoryInfo;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.license.LicenseDescriptor;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;

public class DiscoveryApiTest
extends AbstractSingleNetworkSiteTest {
    private static final DateTime NOW = DateTime.now();
    @Mock
    private DescriptorService descriptorServiceMock;
    @Mock
    private Descriptor serverDescriptor;
    @Mock
    private Descriptor currentRepositoryDescriptor;
    @Mock
    private LicenseDescriptor licenseDescriptorMock;
    private DiscoveryApiWebscript discoveryApiWebscript;
    private Date licenseIssuedAt;
    private Date licenseExpiresAt;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.licenseIssuedAt = NOW.toDate();
        this.licenseExpiresAt = NOW.plusDays(5).toDate();
        this.descriptorServiceMock = (DescriptorService)Mockito.mock(DescriptorService.class);
        this.serverDescriptor = (Descriptor)Mockito.mock(Descriptor.class);
        this.licenseDescriptorMock = (LicenseDescriptor)Mockito.mock(LicenseDescriptor.class);
        Mockito.when((Object)this.descriptorServiceMock.getServerDescriptor()).thenReturn((Object)this.serverDescriptor);
        Mockito.when((Object)this.descriptorServiceMock.getCurrentRepositoryDescriptor()).thenReturn((Object)this.currentRepositoryDescriptor);
        Mockito.when((Object)this.currentRepositoryDescriptor.getId()).thenReturn((Object)"repoId");
        Mockito.when((Object)this.serverDescriptor.getEdition()).thenReturn((Object)"Enterprise");
        Mockito.when((Object)this.serverDescriptor.getVersionMajor()).thenReturn((Object)"5");
        Mockito.when((Object)this.serverDescriptor.getVersionMinor()).thenReturn((Object)"2");
        Mockito.when((Object)this.serverDescriptor.getVersionRevision()).thenReturn((Object)"1");
        Mockito.when((Object)this.serverDescriptor.getVersionLabel()).thenReturn((Object)".3");
        Mockito.when((Object)this.serverDescriptor.getVersionBuild()).thenReturn((Object)"r123456-b0");
        Mockito.when((Object)this.serverDescriptor.getSchema()).thenReturn((Object)10051);
        Mockito.when((Object)this.descriptorServiceMock.getLicenseDescriptor()).thenReturn((Object)this.licenseDescriptorMock);
        Mockito.when((Object)this.licenseDescriptorMock.getIssued()).thenReturn((Object)this.licenseIssuedAt);
        Mockito.when((Object)this.licenseDescriptorMock.getValidUntil()).thenReturn((Object)this.licenseExpiresAt);
        Mockito.when((Object)this.licenseDescriptorMock.getRemainingDays()).thenReturn((Object)5);
        Mockito.when((Object)this.licenseDescriptorMock.getLicenseMode()).thenReturn((Object)RepoUsage.LicenseMode.ENTERPRISE);
        Mockito.when((Object)this.licenseDescriptorMock.getHolderOrganisation()).thenReturn((Object)"Alfresco Dev Test");
        Mockito.when((Object)this.licenseDescriptorMock.getMaxUsers()).thenReturn((Object)20L);
        Mockito.when((Object)this.licenseDescriptorMock.getMaxDocs()).thenReturn((Object)1000L);
        Mockito.when((Object)this.licenseDescriptorMock.isClusterEnabled()).thenReturn((Object)true);
        this.discoveryApiWebscript = (DiscoveryApiWebscript)this.applicationContext.getBean("webscript.org.alfresco.api.DiscoveryApiWebscript.get", DiscoveryApiWebscript.class);
        this.discoveryApiWebscript.setDescriptorService(this.descriptorServiceMock);
        this.discoveryApiWebscript.setEnabled(true);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testGetDiscovery() throws Exception {
        this.setRequestContext(null, user1, "wrongPassword");
        this.get("discovery", null, 401);
        this.setRequestContext(null, user1, null);
        HttpResponse response = this.get("discovery", null, 200);
        DiscoveryDetails discoveryDetails = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), DiscoveryDetails.class);
        Assert.assertNotNull((Object)discoveryDetails);
        RepositoryInfo repositoryInfo = discoveryDetails.getRepository();
        Assert.assertNotNull((Object)repositoryInfo);
        Assert.assertEquals((Object)"repoId", (Object)repositoryInfo.getId());
        Assert.assertEquals((Object)"Enterprise", (Object)repositoryInfo.getEdition());
        RepositoryInfo.VersionInfo versionInfo = repositoryInfo.getVersion();
        Assert.assertNotNull((Object)versionInfo);
        Assert.assertEquals((Object)"5", (Object)versionInfo.getMajor());
        Assert.assertEquals((Object)"2", (Object)versionInfo.getMinor());
        Assert.assertEquals((Object)"1", (Object)versionInfo.getPatch());
        Assert.assertEquals((Object)"3", (Object)versionInfo.getHotfix());
        Assert.assertEquals((Object)"r123456-b0", (Object)versionInfo.getLabel());
        Assert.assertEquals((long)10051L, (long)versionInfo.getSchema());
        Assert.assertEquals((Object)"5.2.1.3 (r123456-b0) schema 10051", (Object)versionInfo.getDisplay());
        RepositoryInfo.LicenseInfo licenseInfo = repositoryInfo.getLicense();
        Assert.assertNotNull((Object)licenseInfo);
        Assert.assertEquals((Object)RepoUsage.LicenseMode.ENTERPRISE.name(), (Object)licenseInfo.getMode());
        Assert.assertEquals((Object)this.licenseIssuedAt.toString(), (Object)licenseInfo.getIssuedAt().toString());
        Assert.assertEquals((Object)this.licenseExpiresAt.toString(), (Object)licenseInfo.getExpiresAt().toString());
        Assert.assertEquals((Object)5, (Object)licenseInfo.getRemainingDays());
        Assert.assertEquals((Object)"Alfresco Dev Test", (Object)licenseInfo.getHolder());
        RepositoryInfo.LicenseEntitlement entitlements = licenseInfo.getEntitlements();
        Assert.assertNotNull((Object)entitlements);
        Assert.assertNotNull((Object)entitlements.getMaxUsers());
        Assert.assertEquals((long)20L, (long)entitlements.getMaxUsers());
        Assert.assertNotNull((Object)entitlements.getMaxDocs());
        Assert.assertEquals((long)1000L, (long)entitlements.getMaxDocs());
        Assert.assertTrue((boolean)entitlements.getIsClusterEnabled());
        Assert.assertFalse((boolean)entitlements.getIsCryptodocEnabled());
        RepositoryInfo.StatusInfo statusInfo = repositoryInfo.getStatus();
        Assert.assertNotNull((Object)statusInfo);
        Assert.assertFalse((boolean)statusInfo.getIsReadOnly());
        Assert.assertTrue((boolean)statusInfo.getIsAuditEnabled());
        Assert.assertTrue((boolean)statusInfo.getIsQuickShareEnabled());
        Assert.assertTrue((boolean)statusInfo.getIsThumbnailGenerationEnabled());
        Assert.assertFalse((boolean)statusInfo.getIsDirectAccessUrlEnabled());
        List modulePackageList = repositoryInfo.getModules();
        Assert.assertNotNull((Object)modulePackageList);
    }

    @Test
    public void testGetDiscovery_hotfixValue() throws Exception {
        Mockito.when((Object)this.serverDescriptor.getVersionLabel()).thenReturn((Object)"4");
        this.setRequestContext(null, user1, null);
        HttpResponse response = this.get("discovery", null, 200);
        DiscoveryDetails discoveryDetails = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), DiscoveryDetails.class);
        Assert.assertNotNull((Object)discoveryDetails);
        RepositoryInfo repositoryInfo = discoveryDetails.getRepository();
        Assert.assertNotNull((Object)repositoryInfo);
        Assert.assertEquals((Object)"Enterprise", (Object)repositoryInfo.getEdition());
        RepositoryInfo.VersionInfo versionInfo = repositoryInfo.getVersion();
        Assert.assertNotNull((Object)versionInfo);
        Assert.assertEquals((Object)"5", (Object)versionInfo.getMajor());
        Assert.assertEquals((Object)"2", (Object)versionInfo.getMinor());
        Assert.assertEquals((Object)"1", (Object)versionInfo.getPatch());
        Assert.assertEquals((Object)"4", (Object)versionInfo.getHotfix());
        Assert.assertEquals((Object)"r123456-b0", (Object)versionInfo.getLabel());
        Assert.assertEquals((long)10051L, (long)versionInfo.getSchema());
        Assert.assertEquals((Object)"5.2.1.4 (r123456-b0) schema 10051", (Object)versionInfo.getDisplay());
        Mockito.when((Object)this.serverDescriptor.getVersionLabel()).thenReturn((Object)"d");
        response = this.get("discovery", null, 200);
        discoveryDetails = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), DiscoveryDetails.class);
        Assert.assertNotNull((Object)discoveryDetails);
        repositoryInfo = discoveryDetails.getRepository();
        Assert.assertNotNull((Object)repositoryInfo);
        versionInfo = repositoryInfo.getVersion();
        Assert.assertNotNull((Object)versionInfo);
        Assert.assertEquals((Object)"5", (Object)versionInfo.getMajor());
        Assert.assertEquals((Object)"2", (Object)versionInfo.getMinor());
        Assert.assertEquals((Object)"1", (Object)versionInfo.getPatch());
        Assert.assertEquals((Object)"0", (Object)versionInfo.getHotfix());
        Assert.assertEquals((Object)"r123456-b0", (Object)versionInfo.getLabel());
        Assert.assertEquals((long)10051L, (long)versionInfo.getSchema());
        Assert.assertEquals((Object)"5.2.1.0 (r123456-b0) schema 10051", (Object)versionInfo.getDisplay());
        Mockito.when((Object)this.serverDescriptor.getVersionLabel()).thenReturn((Object)"39.4");
        response = this.get("discovery", null, 200);
        discoveryDetails = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), DiscoveryDetails.class);
        Assert.assertNotNull((Object)discoveryDetails);
        repositoryInfo = discoveryDetails.getRepository();
        Assert.assertNotNull((Object)repositoryInfo);
        versionInfo = repositoryInfo.getVersion();
        Assert.assertNotNull((Object)versionInfo);
        Assert.assertEquals((Object)"5", (Object)versionInfo.getMajor());
        Assert.assertEquals((Object)"2", (Object)versionInfo.getMinor());
        Assert.assertEquals((Object)"1", (Object)versionInfo.getPatch());
        Assert.assertEquals((Object)"0", (Object)versionInfo.getHotfix());
        Assert.assertEquals((Object)"r123456-b0", (Object)versionInfo.getLabel());
        Assert.assertEquals((long)10051L, (long)versionInfo.getSchema());
        Assert.assertEquals((Object)"5.2.1.0 (r123456-b0) schema 10051", (Object)versionInfo.getDisplay());
    }

    @Test
    public void testGetDiscovery_licenseEntitlement() throws Exception {
        Mockito.when((Object)this.licenseDescriptorMock.getMaxUsers()).thenReturn(null);
        this.setRequestContext(null, user1, null);
        HttpResponse response = this.get("discovery", null, 200);
        DiscoveryDetails discoveryDetails = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), DiscoveryDetails.class);
        Assert.assertNotNull((Object)discoveryDetails);
        RepositoryInfo repositoryInfo = discoveryDetails.getRepository();
        Assert.assertNotNull((Object)repositoryInfo);
        Assert.assertEquals((Object)"Enterprise", (Object)repositoryInfo.getEdition());
        RepositoryInfo.LicenseInfo licenseInfo = repositoryInfo.getLicense();
        Assert.assertNotNull((Object)licenseInfo);
        Assert.assertEquals((Object)RepoUsage.LicenseMode.ENTERPRISE.name(), (Object)licenseInfo.getMode());
        Assert.assertEquals((Object)this.licenseIssuedAt.toString(), (Object)licenseInfo.getIssuedAt().toString());
        Assert.assertEquals((Object)this.licenseExpiresAt.toString(), (Object)licenseInfo.getExpiresAt().toString());
        Assert.assertEquals((Object)5, (Object)licenseInfo.getRemainingDays());
        Assert.assertEquals((Object)"Alfresco Dev Test", (Object)licenseInfo.getHolder());
        RepositoryInfo.LicenseEntitlement entitlements = licenseInfo.getEntitlements();
        Assert.assertNotNull((Object)entitlements);
        Assert.assertNull((Object)entitlements.getMaxUsers());
        Assert.assertEquals((long)1000L, (long)entitlements.getMaxDocs());
        Assert.assertTrue((boolean)entitlements.getIsClusterEnabled());
        Assert.assertFalse((boolean)entitlements.getIsCryptodocEnabled());
        Mockito.when((Object)this.licenseDescriptorMock.getMaxDocs()).thenReturn(null);
        Mockito.when((Object)this.licenseDescriptorMock.isClusterEnabled()).thenReturn((Object)false);
        Mockito.when((Object)this.licenseDescriptorMock.isCryptodocEnabled()).thenReturn((Object)true);
        response = this.get("discovery", null, 200);
        discoveryDetails = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), DiscoveryDetails.class);
        Assert.assertNotNull((Object)discoveryDetails);
        repositoryInfo = discoveryDetails.getRepository();
        Assert.assertNotNull((Object)repositoryInfo);
        licenseInfo = repositoryInfo.getLicense();
        Assert.assertNotNull((Object)licenseInfo);
        entitlements = licenseInfo.getEntitlements();
        Assert.assertNotNull((Object)entitlements);
        Assert.assertNull((Object)entitlements.getMaxUsers());
        Assert.assertNull((Object)entitlements.getMaxDocs());
        Assert.assertFalse((boolean)entitlements.getIsClusterEnabled());
        Assert.assertTrue((boolean)entitlements.getIsCryptodocEnabled());
    }

    @Test
    public void testDiscoveryDisabled() throws Exception {
        try {
            this.discoveryApiWebscript.setEnabled(false);
            this.setRequestContext(null, user1, null);
            this.get("discovery", null, 501);
        }
        finally {
            this.discoveryApiWebscript.setEnabled(true);
        }
    }
}

