/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search.impl;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.alfresco.repo.search.SearchEngineResultSet;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.GenericBucket;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.GenericFacetResponse;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.Metric;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.RangeResultMapper;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.SimpleMetric;
import org.alfresco.repo.security.permissions.impl.acegi.FilteringResultSet;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.rest.api.DeletedNodes;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.lookups.PropertyLookupRegistry;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.api.nodes.NodeVersionsRelation;
import org.alfresco.rest.api.search.context.FacetFieldContext;
import org.alfresco.rest.api.search.context.FacetQueryContext;
import org.alfresco.rest.api.search.context.SearchContext;
import org.alfresco.rest.api.search.context.SearchRequestContext;
import org.alfresco.rest.api.search.context.SpellCheckContext;
import org.alfresco.rest.api.search.impl.StoreMapper;
import org.alfresco.rest.api.search.model.FacetField;
import org.alfresco.rest.api.search.model.FacetQuery;
import org.alfresco.rest.api.search.model.HighlightEntry;
import org.alfresco.rest.api.search.model.SearchEntry;
import org.alfresco.rest.api.search.model.SearchQuery;
import org.alfresco.rest.api.search.model.SearchSQLQuery;
import org.alfresco.rest.api.search.model.TupleEntry;
import org.alfresco.rest.api.search.model.TupleList;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.FacetFormat;
import org.alfresco.service.cmr.search.Interval;
import org.alfresco.service.cmr.search.IntervalSet;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SpellCheckResult;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ResultMapper {
    private ServiceRegistry serviceRegistry;
    private Nodes nodes;
    private NodeVersionsRelation nodeVersions;
    private PropertyLookupRegistry propertyLookup;
    private StoreMapper storeMapper;
    private DeletedNodes deletedNodes;
    private static Log logger = LogFactory.getLog(ResultMapper.class);

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setNodeVersions(NodeVersionsRelation nodeVersions) {
        this.nodeVersions = nodeVersions;
    }

    public void setDeletedNodes(DeletedNodes deletedNodes) {
        this.deletedNodes = deletedNodes;
    }

    public void setStoreMapper(StoreMapper storeMapper) {
        this.storeMapper = storeMapper;
    }

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setPropertyLookup(PropertyLookupRegistry propertyLookup) {
        this.propertyLookup = propertyLookup;
    }

    public CollectionWithPagingInfo<Node> toCollectionWithPagingInfo(Params params, SearchRequestContext searchRequestContext, SearchQuery searchQuery, ResultSet results) {
        ArrayList<Node> noderesults = new ArrayList<Node>();
        HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>(10);
        Map highLighting = Collections.emptyMap();
        if (results != null) {
            highLighting = results.getHighlighting();
        }
        AtomicInteger unknownNodeRefsCount = new AtomicInteger();
        if (results != null && results.getNumberFound() > 0L) {
            List<Node> nodes = this.getNodes(results, params, mapUserInfo);
            for (ResultSetRow row : results) {
                Node aNode = nodes.stream().filter(n -> n.getNodeRef().equals((Object)row.getNodeRef())).findFirst().orElse(null);
                if (aNode == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Unknown noderef returned from search results " + String.valueOf(row.getNodeRef())));
                    }
                    unknownNodeRefsCount.incrementAndGet();
                    continue;
                }
                float f = row.getScore();
                if (!highLighting.isEmpty()) {
                    ArrayList<HighlightEntry> highlightEntries = null;
                    List high = (List)highLighting.get(row.getNodeRef());
                    if (high != null && !high.isEmpty()) {
                        highlightEntries = new ArrayList<HighlightEntry>(high.size());
                        for (Pair highlight : high) {
                            highlightEntries.add(new HighlightEntry((String)highlight.getFirst(), (List)highlight.getSecond()));
                        }
                    }
                    aNode.setSearch(new SearchEntry(Float.valueOf(f), highlightEntries));
                }
                noderesults.add(aNode);
            }
        }
        if (unknownNodeRefsCount.get() > 0) {
            logger.warn((Object)("Search results contained " + unknownNodeRefsCount.get() + " unknown noderefs which were skipped."));
        }
        SearchContext context = this.toSearchEngineResultSet(results).map(resultSet -> this.toSearchContext((SearchEngineResultSet)resultSet, searchRequestContext, searchQuery)).orElse(null);
        return CollectionWithPagingInfo.asPaged(params.getPaging(), noderesults, results.hasMore(), this.setTotal(results), null, context);
    }

    public Node getNode(ResultSetRow aRow, Params params, Map<String, UserInfo> mapUserInfo, boolean isHistory) {
        String nodeStore = isHistory ? "history" : this.storeMapper.getStore(aRow.getNodeRef());
        Node aNode = null;
        try {
            switch (nodeStore) {
                case "nodes": {
                    aNode = this.nodes.getFolderOrDocument(aRow.getNodeRef(), null, null, params.getInclude(), mapUserInfo);
                    break;
                }
                case "history": {
                    aNode = this.nodes.getFolderOrDocument(aRow.getNodeRef(), null, null, params.getInclude(), mapUserInfo);
                    break;
                }
                case "versions": {
                    Map properties = this.serviceRegistry.getNodeService().getProperties(aRow.getNodeRef());
                    NodeRef frozenNodeRef = (NodeRef)properties.get(Version2Model.PROP_QNAME_FROZEN_NODE_REF);
                    String versionLabelId = (String)properties.get(Version2Model.PROP_QNAME_VERSION_LABEL);
                    Version version = null;
                    try {
                        if (frozenNodeRef != null && versionLabelId != null) {
                            version = this.nodeVersions.findVersion(frozenNodeRef.getId(), versionLabelId);
                            aNode = this.nodes.getFolderOrDocument(version.getFrozenStateNodeRef(), null, null, params.getInclude(), mapUserInfo);
                        }
                    }
                    catch (EntityNotFoundException | InvalidNodeRefException e) {
                        logger.debug((Object)("Failed to find a versioned node with id of " + String.valueOf(frozenNodeRef) + " this is probably because the original node has been deleted."));
                    }
                    if (version == null || aNode == null) break;
                    this.nodeVersions.mapVersionInfo(version, aNode, aRow.getNodeRef());
                    aNode.setNodeId(frozenNodeRef.getId());
                    aNode.setVersionLabel(versionLabelId);
                    break;
                }
                case "deleted-nodes": {
                    try {
                        aNode = this.deletedNodes.getDeletedNode(aRow.getNodeRef().getId(), params, false, mapUserInfo);
                        break;
                    }
                    catch (EntityNotFoundException enfe) {
                        logger.debug((Object)("Failed to find a deleted node with id of " + aRow.getNodeRef().getId()));
                    }
                }
            }
        }
        catch (PermissionDeniedException e) {
            logger.debug((Object)("Unable to access node: " + aRow.toString()));
            return null;
        }
        if (aNode != null) {
            aNode.setLocation(nodeStore);
        }
        return aNode;
    }

    /*
     * Unable to fully structure code
     */
    public List<Node> getNodes(ResultSet resultSet, Params params, Map<String, UserInfo> mapUserInfo) {
        block20: {
            results = new ArrayList<Node>(resultSet.length());
            if (resultSet.length() <= 0) break block20;
            nodeStore = this.storeMapper.getStore(resultSet.getNodeRef(0));
            try {
                var6_6 = nodeStore;
                var7_8 = -1;
                switch (var6_6.hashCode()) {
                    case 104993457: {
                        if (!var6_6.equals("nodes")) break;
                        var7_8 = 0;
                        break;
                    }
                    case -1985053029: {
                        if (!var6_6.equals("versions")) break;
                        var7_8 = 1;
                        break;
                    }
                    case -1920065539: {
                        if (!var6_6.equals("deleted-nodes")) break;
                        var7_8 = 2;
                    }
                }
                switch (var7_8) {
                    case 0: {
                        results.addAll(this.nodes.getFoldersOrDocuments(resultSet.getNodeRefs(), params.getInclude(), mapUserInfo));
                        break;
                    }
                    case 1: {
                        properties = this.serviceRegistry.getNodeService().getPropertiesForNodeRefs(resultSet.getNodeRefs());
                        frozenNodeRefs = new HashMap<NodeRef, Pair>();
                        for (Map.Entry<K, V> entry : properties.entrySet()) {
                            frozenNodeRef = (NodeRef)((Map)entry.getValue()).get(Version2Model.PROP_QNAME_FROZEN_NODE_REF);
                            versionLabelId = (String)((Map)entry.getValue()).get(Version2Model.PROP_QNAME_VERSION_LABEL);
                            if (frozenNodeRef == null || versionLabelId == null) continue;
                            frozenNodeRefs.put((NodeRef)entry.getKey(), new Pair((Object)frozenNodeRef, (Object)versionLabelId));
                        }
                        for (Map.Entry<K, V> entry : frozenNodeRefs.entrySet()) {
                            frozenNodeRef = (NodeRef)((Pair)entry.getValue()).getFirst();
                            versionLabelId = (String)((Pair)entry.getValue()).getSecond();
                            version = null;
                            aNode = null;
                            try {
                                version = this.nodeVersions.findVersion(frozenNodeRef.getId(), versionLabelId);
                                aNode = this.nodes.getFolderOrDocument(version.getFrozenStateNodeRef(), null, null, params.getInclude(), mapUserInfo);
                            }
                            catch (EntityNotFoundException | InvalidNodeRefException e) {
                                if (!ResultMapper.logger.isDebugEnabled()) ** GOTO lbl46
                                ResultMapper.logger.debug((Object)("Failed to find a versioned node with id of " + String.valueOf(frozenNodeRef) + " this is probably because the original node has been deleted."));
                            }
lbl46:
                            // 3 sources

                            if (version == null || aNode == null) continue;
                            this.nodeVersions.mapVersionInfo(version, aNode, (NodeRef)entry.getKey());
                            aNode.setNodeId(frozenNodeRef.getId());
                            aNode.setVersionLabel(versionLabelId);
                            results.add(aNode);
                        }
                        break;
                    }
                    case 2: {
                        nodeIds = resultSet.getNodeRefs().stream().map((Function<NodeRef, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getId(), (Lorg/alfresco/service/cmr/repository/NodeRef;)Ljava/lang/String;)()).collect(Collectors.toList());
                        try {
                            results = this.deletedNodes.getDeletedNodes(nodeIds, params, false, mapUserInfo);
                            break;
                        }
                        catch (EntityNotFoundException enfe) {
                            if (!ResultMapper.logger.isDebugEnabled()) break;
                            ResultMapper.logger.debug((Object)("Failed to find a deleted nodes with ids of " + nodeIds.toString()));
                        }
                    }
                }
            }
            catch (PermissionDeniedException e) {
                return null;
            }
            if (!results.isEmpty()) {
                results.forEach((Consumer<Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getNodes$2(java.lang.String org.alfresco.rest.api.model.Node ), (Lorg/alfresco/rest/api/model/Node;)V)((String)nodeStore));
            }
        }
        return results;
    }

    public Integer setTotal(ResultSet results) {
        Long totalItems = results.getNumberFound();
        Integer total = totalItems.intValue();
        return total;
    }

    public SearchContext toSearchContext(SearchEngineResultSet resultSet, SearchRequestContext searchRequestContext, SearchQuery searchQuery) {
        SearchContext context = null;
        Map facetQueries = resultSet.getFacetQueries();
        ArrayList<GenericFacetResponse> facets = new ArrayList<GenericFacetResponse>();
        ArrayList<FacetQueryContext> facetResults = null;
        SpellCheckContext spellCheckContext = null;
        ArrayList<FacetFieldContext> ffcs = new ArrayList<FacetFieldContext>();
        if (searchQuery == null) {
            throw new IllegalArgumentException("searchQuery can't be null");
        }
        if (facetQueries != null && !facetQueries.isEmpty()) {
            List<GenericFacetResponse> facetQueryForFields = this.getFacetBucketsFromFacetQueries(facetQueries, searchQuery);
            if (ResultMapper.hasGroup(searchQuery) || FacetFormat.V2 == searchQuery.getFacetFormat()) {
                facets.addAll(facetQueryForFields);
            } else {
                facetResults = new ArrayList<FacetQueryContext>(facetQueries.size());
                for (Map.Entry fq : facetQueries.entrySet()) {
                    String filterQuery = null;
                    if (searchQuery.getFacetQueries() != null) {
                        Optional<FacetQuery> found = searchQuery.getFacetQueries().stream().filter(facetQuery -> ((String)fq.getKey()).equals(facetQuery.getLabel())).findFirst();
                        filterQuery = found.isPresent() ? found.get().getQuery() : (String)fq.getKey();
                    }
                    facetResults.add(new FacetQueryContext((String)fq.getKey(), filterQuery, (Integer)fq.getValue()));
                }
            }
        }
        Map facetFields = resultSet.getFieldFacets();
        if (FacetFormat.V2 == searchQuery.getFacetFormat()) {
            facets.addAll(this.getFacetBucketsForFacetFieldsAsFacets(facetFields, searchQuery));
        } else {
            ffcs.addAll(this.getFacetBucketsForFacetFields(facetFields, searchQuery));
        }
        Map facetInterval = resultSet.getFacetIntervals();
        facets.addAll(ResultMapper.getGenericFacetsForIntervals(facetInterval, searchQuery));
        Map facetRanges = resultSet.getFacetRanges();
        facets.addAll(RangeResultMapper.getGenericFacetsForRanges((Map)facetRanges, searchQuery.getFacetRanges()));
        List<GenericFacetResponse> stats = this.getFieldStats(searchRequestContext, resultSet.getStats());
        List<GenericFacetResponse> pimped = this.getPivots(searchRequestContext, resultSet.getPivotFacets(), stats);
        facets.addAll(pimped);
        facets.addAll(stats);
        SpellCheckResult spell = resultSet.getSpellCheckResult();
        if (spell != null && spell.getResultName() != null && !spell.getResults().isEmpty()) {
            spellCheckContext = new SpellCheckContext(spell.getResultName(), spell.getResults());
        }
        context = new SearchContext(resultSet.getLastIndexedTxId(), facets, facetResults, ffcs, spellCheckContext, searchRequestContext.includeRequest() ? searchQuery : null);
        return this.isNullContext(context) ? null : context;
    }

    public static boolean hasGroup(SearchQuery searchQuery) {
        if (searchQuery != null && searchQuery.getFacetQueries() != null) {
            return searchQuery.getFacetQueries().stream().anyMatch(facetQ -> facetQ.getGroup() != null);
        }
        return false;
    }

    protected List<GenericFacetResponse> getFacetBucketsFromFacetQueries(Map<String, Integer> facetQueries, SearchQuery searchQuery) {
        ArrayList<GenericFacetResponse> facetResults = new ArrayList<GenericFacetResponse>();
        HashMap<String, List> groups = new HashMap<String, List>();
        for (Map.Entry<String, Integer> fq : facetQueries.entrySet()) {
            String group = null;
            String filterQuery = null;
            if (searchQuery != null && searchQuery.getFacetQueries() != null) {
                Optional<FacetQuery> found = searchQuery.getFacetQueries().stream().filter(facetQuery -> ((String)fq.getKey()).equals(facetQuery.getLabel())).findFirst();
                String string = filterQuery = found.isPresent() ? found.get().getQuery() : fq.getKey();
                if (found.isPresent() && found.get().getGroup() != null) {
                    group = found.get().getGroup();
                }
            }
            if (groups.containsKey(group)) {
                HashSet<SimpleMetric> metrics = new HashSet<SimpleMetric>(1);
                metrics.add(new SimpleMetric(Metric.METRIC_TYPE.count, (Object)fq.getValue()));
                ((List)groups.get(group)).add(new GenericBucket(fq.getKey(), filterQuery, null, metrics, null));
                continue;
            }
            ArrayList<GenericBucket> l = new ArrayList<GenericBucket>();
            HashSet<SimpleMetric> metrics = new HashSet<SimpleMetric>(1);
            metrics.add(new SimpleMetric(Metric.METRIC_TYPE.count, (Object)fq.getValue()));
            l.add(new GenericBucket(fq.getKey(), filterQuery, null, metrics, null));
            groups.put(group, l);
        }
        if (!groups.isEmpty()) {
            groups.forEach((a, v) -> facetResults.add(new GenericFacetResponse(GenericFacetResponse.FACET_TYPE.query, a, v)));
        }
        return facetResults;
    }

    protected List<GenericFacetResponse> getFieldStats(SearchRequestContext searchRequestContext, Map<String, Set<Metric>> stats) {
        if (stats != null && !stats.isEmpty()) {
            return stats.entrySet().stream().map(statsFieldEntry -> new GenericFacetResponse(GenericFacetResponse.FACET_TYPE.stats, (String)statsFieldEntry.getKey(), Arrays.asList(new GenericBucket(null, null, null, (Set)statsFieldEntry.getValue(), null)))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected List<GenericFacetResponse> getPivots(SearchRequestContext searchRequest, List<GenericFacetResponse> pivots, List<GenericFacetResponse> stats) {
        if (pivots != null && !pivots.isEmpty()) {
            Map<String, String> pivotKeys = searchRequest.getPivotKeys();
            return pivots.stream().map(aFacet -> {
                String pivotLabel = pivotKeys.containsKey(aFacet.getLabel()) ? (String)pivotKeys.get(aFacet.getLabel()) : aFacet.getLabel();
                ArrayList<GenericBucket> bucks = new ArrayList<GenericBucket>();
                Optional<GenericFacetResponse> foundStat = stats.stream().filter(aStat -> aStat.getLabel().equals(pivotLabel)).findFirst();
                if (foundStat.isPresent()) {
                    bucks.add((GenericBucket)foundStat.get().getBuckets().get(0));
                    stats.remove(foundStat.get());
                }
                bucks.addAll(aFacet.getBuckets().stream().map(genericBucket -> {
                    Object display = this.propertyLookup.lookup(aFacet.getLabel(), genericBucket.getLabel());
                    return new GenericBucket(genericBucket.getLabel(), genericBucket.getFilterQuery(), display, genericBucket.getMetrics(), this.getPivots(searchRequest, genericBucket.getFacets(), stats));
                }).collect(Collectors.toList()));
                return new GenericFacetResponse(aFacet.getType(), pivotLabel, bucks);
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected List<GenericFacetResponse> getFacetBucketsForFacetFieldsAsFacets(Map<String, List<Pair<String, Integer>>> facetFields, SearchQuery searchQuery) {
        if (facetFields != null && !facetFields.isEmpty()) {
            ArrayList<GenericFacetResponse> ffcs = new ArrayList<GenericFacetResponse>(facetFields.size());
            for (Map.Entry<String, List<Pair<String, Integer>>> facet : facetFields.entrySet()) {
                if (facet.getValue() == null || facet.getValue().isEmpty()) continue;
                ArrayList<GenericBucket> buckets = new ArrayList<GenericBucket>(facet.getValue().size());
                for (Pair<String, Integer> buck : facet.getValue()) {
                    Optional<FacetField> found;
                    Object display = null;
                    String filterQuery = null;
                    if (searchQuery != null && searchQuery.getFacetFields() != null && searchQuery.getFacetFields().getFacets() != null && !searchQuery.getFacetFields().getFacets().isEmpty() && (found = searchQuery.getFacetFields().getFacets().stream().filter(queryable -> ((String)facet.getKey()).equals(queryable.getLabel() != null ? queryable.getLabel() : queryable.getField())).findFirst()).isPresent()) {
                        display = this.propertyLookup.lookup(found.get().getField(), (String)buck.getFirst());
                        String fq = found.get().toFilterQuery((String)buck.getFirst());
                        if (fq != null) {
                            filterQuery = fq;
                        }
                    }
                    GenericBucket bucket = new GenericBucket((String)buck.getFirst(), filterQuery, display, new HashSet<SimpleMetric>(Arrays.asList(new SimpleMetric(Metric.METRIC_TYPE.count, (Object)String.valueOf(buck.getSecond())))), null, null);
                    buckets.add(bucket);
                }
                ffcs.add(new GenericFacetResponse(GenericFacetResponse.FACET_TYPE.field, facet.getKey(), buckets));
            }
            return ffcs;
        }
        return Collections.emptyList();
    }

    protected List<FacetFieldContext> getFacetBucketsForFacetFields(Map<String, List<Pair<String, Integer>>> facetFields, SearchQuery searchQuery) {
        if (facetFields != null && !facetFields.isEmpty()) {
            ArrayList<FacetFieldContext> ffcs = new ArrayList<FacetFieldContext>(facetFields.size());
            for (Map.Entry<String, List<Pair<String, Integer>>> facet : facetFields.entrySet()) {
                if (facet.getValue() == null || facet.getValue().isEmpty()) continue;
                ArrayList<FacetFieldContext.Bucket> buckets = new ArrayList<FacetFieldContext.Bucket>(facet.getValue().size());
                for (Pair<String, Integer> buck : facet.getValue()) {
                    Optional<FacetField> found;
                    Object display = null;
                    String filterQuery = null;
                    if (searchQuery != null && searchQuery.getFacetFields() != null && searchQuery.getFacetFields().getFacets() != null && !searchQuery.getFacetFields().getFacets().isEmpty() && (found = searchQuery.getFacetFields().getFacets().stream().filter(queryable -> ((String)facet.getKey()).equals(queryable.getLabel() != null ? queryable.getLabel() : queryable.getField())).findFirst()).isPresent()) {
                        display = this.propertyLookup.lookup(found.get().getField(), (String)buck.getFirst());
                        String fq = found.get().toFilterQuery((String)buck.getFirst());
                        if (fq != null) {
                            filterQuery = fq;
                        }
                    }
                    buckets.add(new FacetFieldContext.Bucket((String)buck.getFirst(), filterQuery, (Integer)buck.getSecond(), display));
                }
                ffcs.add(new FacetFieldContext(facet.getKey(), buckets));
            }
            return ffcs;
        }
        return Collections.emptyList();
    }

    protected static List<GenericFacetResponse> getGenericFacetsForIntervals(Map<String, List<Pair<String, Integer>>> facetFields, SearchQuery searchQuery) {
        if (facetFields != null && !facetFields.isEmpty()) {
            ArrayList<GenericFacetResponse> ffcs = new ArrayList<GenericFacetResponse>(facetFields.size());
            for (Map.Entry<String, List<Pair<String, Integer>>> facet : facetFields.entrySet()) {
                if (facet.getValue() == null || facet.getValue().isEmpty()) continue;
                ArrayList<GenericBucket> buckets = new ArrayList<GenericBucket>(facet.getValue().size());
                for (Pair<String, Integer> buck : facet.getValue()) {
                    Optional<IntervalSet> foundSet;
                    Optional<Interval> found;
                    String filterQuery = null;
                    HashMap<String, String> bucketInfo = new HashMap<String, String>();
                    if (searchQuery != null && searchQuery.getFacetIntervals() != null && searchQuery.getFacetIntervals().getIntervals() != null && !searchQuery.getFacetIntervals().getIntervals().isEmpty() && (found = searchQuery.getFacetIntervals().getIntervals().stream().filter(interval -> ((String)facet.getKey()).equals(interval.getLabel() != null ? interval.getLabel() : interval.getField())).findFirst()).isPresent() && found.get().getSets() != null && (foundSet = found.get().getSets().stream().filter(aSet -> ((String)buck.getFirst()).equals(aSet.getLabel())).findFirst()).isPresent()) {
                        filterQuery = found.get().getField() + ":" + foundSet.get().toAFTSQuery();
                        bucketInfo.put("start", foundSet.get().getStart());
                        bucketInfo.put("end", foundSet.get().getEnd());
                        bucketInfo.put("startInclusive", String.valueOf(foundSet.get().isStartInclusive()));
                        bucketInfo.put("endInclusive", String.valueOf(foundSet.get().isEndInclusive()));
                    }
                    GenericBucket bucket = new GenericBucket((String)buck.getFirst(), filterQuery, null, new HashSet<SimpleMetric>(Arrays.asList(new SimpleMetric(Metric.METRIC_TYPE.count, (Object)String.valueOf(buck.getSecond())))), null, bucketInfo);
                    buckets.add(bucket);
                }
                ffcs.add(new GenericFacetResponse(GenericFacetResponse.FACET_TYPE.interval, facet.getKey(), buckets));
            }
            return ffcs;
        }
        return Collections.emptyList();
    }

    public boolean isNullContext(SearchContext context) {
        return context.getFacetQueries() == null && context.getConsistency() == null && context.getSpellCheck() == null && context.getFacetsFields() == null && context.getFacets() == null;
    }

    protected Optional<SearchEngineResultSet> toSearchEngineResultSet(ResultSet results) {
        if (results instanceof FilteringResultSet && (results = ((FilteringResultSet)results).getUnFilteredResultSet()) instanceof FilteringResultSet) {
            results = ((FilteringResultSet)results).getUnFilteredResultSet();
        }
        return results instanceof SearchEngineResultSet ? Optional.of(results).map(SearchEngineResultSet.class::cast) : Optional.empty();
    }

    public CollectionWithPagingInfo<TupleList> toCollectionWithPagingInfo(JSONArray docs, SearchSQLQuery searchQuery) throws JSONException {
        if (docs == null) {
            throw new RuntimeException("Solr response is required instead of JSONArray docs was null");
        }
        if (searchQuery == null) {
            throw new RuntimeException("SearchSQLQuery is required");
        }
        ArrayList<TupleList> entries = new ArrayList<TupleList>();
        for (int i = 0; i < docs.length() - 1; ++i) {
            ArrayList<TupleEntry> row = new ArrayList<TupleEntry>();
            JSONObject docObj = (JSONObject)docs.get(i);
            docObj.keys().forEachRemaining(action -> {
                try {
                    String value = docObj.get(action.toString()).toString();
                    row.add(new TupleEntry(action.toString(), value));
                }
                catch (JSONException e) {
                    throw new RuntimeException("Unable to parse SQL response. " + String.valueOf((Object)e));
                }
            });
            entries.add(new TupleList(row));
        }
        Paging paging = Paging.valueOf(0, searchQuery.getItemLimit());
        return CollectionWithPagingInfo.asPaged(paging, entries);
    }

    private static /* synthetic */ void lambda$getNodes$2(String nodeStore, Node aNode) {
        aNode.setLocation(nodeStore);
    }
}

