/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.resource.parameters;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.alfresco.rest.api.search.context.SearchContext;
import org.alfresco.rest.framework.resource.SerializablePagedCollection;
import org.alfresco.rest.framework.resource.parameters.Paging;

public class CollectionWithPagingInfo<T>
implements SerializablePagedCollection {
    private final Collection<T> collection;
    private final boolean hasMoreItems;
    private final Integer totalItems;
    private final Paging paging;
    private final Object sourceEntity;
    private final SearchContext context;

    protected CollectionWithPagingInfo(Collection<T> collection, Paging paging, boolean hasMoreItems, Integer totalItems, Object sourceEntity, SearchContext context) {
        this.hasMoreItems = hasMoreItems;
        this.paging = paging;
        if (collection == null) {
            this.collection = Collections.emptyList();
            this.totalItems = 0;
        } else {
            this.collection = collection;
            this.totalItems = totalItems;
        }
        this.sourceEntity = sourceEntity;
        this.context = context;
    }

    public static <T> CollectionWithPagingInfo<T> asPaged(Paging paging, Collection<T> aCollection) {
        int collectionSize = aCollection == null ? 0 : aCollection.size();
        return new CollectionWithPagingInfo<T>(aCollection, paging, false, collectionSize, null, null);
    }

    public static <T> CollectionWithPagingInfo<T> asPagedCollection(T ... entity) {
        List<T> aNewCollection = Arrays.asList(entity);
        return new CollectionWithPagingInfo<T>(aNewCollection, Paging.DEFAULT, false, aNewCollection.size(), null, null);
    }

    public static <T> CollectionWithPagingInfo<T> asPaged(Paging paging, Collection<T> aCollection, boolean hasMoreItems, Integer totalItems) {
        return new CollectionWithPagingInfo<T>(aCollection, paging, hasMoreItems, totalItems, null, null);
    }

    public static <T> CollectionWithPagingInfo<T> asPaged(Paging paging, Collection<T> aCollection, boolean hasMoreItems, Integer totalItems, Object sourceEntity) {
        return new CollectionWithPagingInfo<T>(aCollection, paging, hasMoreItems, totalItems, sourceEntity, null);
    }

    public static <T> CollectionWithPagingInfo<T> asPaged(Paging paging, Collection<T> aCollection, boolean hasMoreItems, Integer totalItems, Object sourceEntity, SearchContext context) {
        return new CollectionWithPagingInfo<T>(aCollection, paging, hasMoreItems, totalItems, sourceEntity, context);
    }

    @Override
    public Collection<T> getCollection() {
        return this.collection;
    }

    @Override
    public boolean hasMoreItems() {
        return this.hasMoreItems;
    }

    @Override
    public Integer getTotalItems() {
        return this.totalItems;
    }

    @Override
    public Object getSourceEntity() {
        return this.sourceEntity;
    }

    @Override
    public Paging getPaging() {
        return this.paging;
    }

    @Override
    public SearchContext getContext() {
        return this.context;
    }
}

