/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.servlet;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.management.subsystems.DefaultChildApplicationContextManager;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.external.DefaultRemoteUserMapper;
import org.alfresco.repo.security.authentication.external.RemoteUserMapper;
import org.alfresco.repo.web.scripts.servlet.BlockingRemoteUserMapper;
import org.alfresco.repo.web.scripts.servlet.RemoteUserAuthenticatorFactory;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.testing.category.IntermittentlyFailingTests;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@ContextConfiguration(value={"classpath:alfresco/application-context.xml", "classpath:alfresco/web-scripts-application-context.xml", "classpath:alfresco/web-scripts-application-context-test.xml"})
public class RemoteAuthenticatorFactoryAdminConsoleAccessTest
extends BaseSpringTest {
    private String proxyHeader = "X-Alfresco-Remote-User";
    public static int setStatusCode;
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private RemoteUserAuthenticatorFactory remoteUserAuthenticatorFactory;
    private BlockingRemoteUserMapper blockingRemoteUserMapper;
    private PersonService personService;
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private AuthorityService authorityService;

    @Before
    public void before() throws Exception {
        this.blockingRemoteUserMapper = new BlockingRemoteUserMapper();
        DefaultChildApplicationContextManager childApplicationContextManager = (DefaultChildApplicationContextManager)this.applicationContext.getBean("Authentication");
        this.remoteUserAuthenticatorFactory = (RemoteUserAuthenticatorFactory)this.applicationContext.getBean("webscripts.authenticator.remoteuser");
        this.remoteUserAuthenticatorFactory.setRemoteUserMapper((RemoteUserMapper)this.blockingRemoteUserMapper);
        this.remoteUserAuthenticatorFactory.setGetRemoteUserTimeoutMilliseconds(500L);
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("AuthenticationService", MutableAuthenticationService.class);
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("AuthenticationComponent", AuthenticationComponent.class);
        this.authorityService = (AuthorityService)this.applicationContext.getBean("AuthorityService", AuthorityService.class);
        childApplicationContextManager.stop();
        childApplicationContextManager.setProperty("chain", "external1:external,alfrescoNtlm1:alfrescoNtlm");
        ChildApplicationContextFactory childApplicationContextFactory = childApplicationContextManager.getChildApplicationContextFactory("external1");
        childApplicationContextFactory.stop();
        childApplicationContextFactory.setProperty("external.authentication.proxyUserName", "");
    }

    @Test
    public void testAdminGuestAccess() {
        Description.RequiredAuthentication required = Description.RequiredAuthentication.admin;
        boolean isGuest = true;
        boolean authenticated = this.authenticateWithGuestParameters(required, isGuest);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertFalse((String)"This should not authenticate. Admin access and guest is not a valid combination.", (boolean)authenticated);
        this.checkTimeOutFeaturesWasNotUsed();
    }

    @Test
    public void testUserGuestAccess() {
        Description.RequiredAuthentication required = Description.RequiredAuthentication.user;
        boolean isGuest = true;
        boolean authenticated = this.authenticateWithGuestParameters(required, isGuest);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertFalse((String)"This should not authenticate", (boolean)authenticated);
        this.checkTimeOutFeaturesWasNotUsed();
    }

    @Test
    public void testGuestGuestAccess() {
        Description.RequiredAuthentication required = Description.RequiredAuthentication.guest;
        boolean isGuest = true;
        boolean authenticated = this.authenticateWithGuestParameters(required, isGuest);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertTrue((String)"This should authenticate", (boolean)authenticated);
        this.checkTimeOutFeaturesWasNotUsed();
    }

    @Test
    public void testNoneGuestAccess() {
        Description.RequiredAuthentication required = Description.RequiredAuthentication.none;
        boolean isGuest = true;
        boolean authenticated = this.authenticateWithGuestParameters(required, isGuest);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertFalse((String)"This should not authenticate.", (boolean)authenticated);
        this.checkTimeOutFeaturesWasNotUsed();
    }

    @Test
    public void testNoneNotGuestAccess() {
        Description.RequiredAuthentication required = Description.RequiredAuthentication.none;
        boolean isGuest = false;
        boolean authenticated = this.authenticateWithGuestParameters(Description.RequiredAuthentication.none, false);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertFalse((String)"This should not authenticate.", (boolean)authenticated);
        this.checkTimeOutFeaturesWasNotUsed();
    }

    @Test
    public void testExternalAuthForAdminPage() {
        Description.RequiredAuthentication required = Description.RequiredAuthentication.admin;
        HashSet<String> families = new HashSet<String>();
        families.add("AdminConsole");
        this.checkExtAuthStillWorks(required, families);
    }

    @Test
    public void testExternalAuthForAdminResource() {
        Description.RequiredAuthentication required = Description.RequiredAuthentication.admin;
        Set<String> families = Collections.emptySet();
        this.checkExtAuthStillWorks(required, families);
    }

    @Test
    public void testExternalAuthForUserResource() {
        Description.RequiredAuthentication required = Description.RequiredAuthentication.user;
        Set<String> families = Collections.emptySet();
        this.checkExtAuthStillWorks(required, families);
    }

    @Test
    public void testAdminCanAccessAdminConsoleScript() {
        HashSet<String> families = new HashSet<String>();
        families.add("AdminConsole");
        this.complexCheckOfScriptCases(families);
    }

    @Category(value={IntermittentlyFailingTests.class})
    @Test
    public void testAdminCanAccessAdminConsoleHelperScript() {
        HashSet<String> families = new HashSet<String>();
        families.add("AdminConsoleHelper");
        this.complexCheckOfScriptCases(families);
    }

    @Test
    public void testUserCanAccessAdminConsoleScript() {
        HashSet<String> families = new HashSet<String>();
        families.add("AdminConsole");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        String username = RandomStringUtils.randomAlphabetic((int)10);
        String password = RandomStringUtils.randomAlphabetic((int)10);
        this.createUser(username, password);
        this.authorityService.addAuthority("GROUP_ALFRESCO_ADMINISTRATORS", username);
        this.authenticationComponent.clearCurrentSecurityContext();
        String headerToAdd = this.getBasicAuthHeader(username, password);
        this.checkAdminConsoleFamilyWithBasicAuthHeaderPresentUser(families, headerToAdd);
    }

    private void complexCheckOfScriptCases(Set<String> families) {
        String headerToAdd = "Basic YWRtaW46YWRtaW4=";
        this.checkGenericResourceAccess();
        this.checkAdminConsoleFamilyPage(families);
        this.checkAdminConsoleFamilyPageWithRemoteUserMapperDisabled(families);
        this.checkAdminConsoleFamilyWithBasicAuthHeaderPresent(families, "Basic YWRtaW46YWRtaW4=");
        this.checkAdminConsoleFamilyWithBasicAuthHeaderButWrongPassword(families);
    }

    private void checkAdminConsoleFamilyWithBasicAuthHeaderButWrongPassword(Set<String> families) {
        this.blockingRemoteUserMapper.reset();
        String headerToAddWithWrongPassword = "Basic YWRtaW46YmliaQ==";
        boolean authenticated = this.authenticate(families, headerToAddWithWrongPassword);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertFalse((String)"It is an AdminConsole webscript now and Admin basic auth header was present BUT with wrong password. Should fail.", (boolean)authenticated);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertEquals((String)"Status should be 401", (int)401, (int)setStatusCode);
        String message = "The code from blockingRemoteUserMapper shouldn't have been called";
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertFalse((String)"The code from blockingRemoteUserMapper shouldn't have been called", (boolean)this.blockingRemoteUserMapper.isWasInterrupted());
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertEquals((String)"The code from blockingRemoteUserMapper shouldn't have been called", (int)this.blockingRemoteUserMapper.getTimePassed(), (int)0);
    }

    private void checkAdminConsoleFamilyPage(Set<String> families) {
        this.blockingRemoteUserMapper.reset();
        boolean authenticated = this.authenticate(families, null);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertFalse((String)"It is an AdminConsole webscript now, but Admin basic auth header was not present. It should return 401", (boolean)authenticated);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertEquals((String)"Status should be 401", (int)401, (int)setStatusCode);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertTrue((String)"Because it is an AdminConsole webscript, the interrupt should have been called.", (boolean)this.blockingRemoteUserMapper.isWasInterrupted());
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertTrue((String)"The interrupt should have been called.", (this.blockingRemoteUserMapper.getTimePassed() < 1000 ? 1 : 0) != 0);
    }

    private void checkAdminConsoleFamilyWithBasicAuthHeaderPresent(Set<String> families, String headerToAdd) {
        this.blockingRemoteUserMapper.reset();
        boolean authenticated = this.authenticate(families, headerToAdd);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertTrue((String)"It is an AdminConsole webscript now and Admin basic auth header was present. It should succeed.", (boolean)authenticated);
        String message = "The code from blockingRemoteUserMapper shouldn't have been called";
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertFalse((String)"The code from blockingRemoteUserMapper shouldn't have been called", (boolean)this.blockingRemoteUserMapper.isWasInterrupted());
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertEquals((String)"The code from blockingRemoteUserMapper shouldn't have been called", (int)this.blockingRemoteUserMapper.getTimePassed(), (int)0);
    }

    private void checkAdminConsoleFamilyWithBasicAuthHeaderPresentUser(Set<String> families, String headerToAdd) {
        this.blockingRemoteUserMapper.reset();
        boolean authenticated = false;
        try {
            authenticated = this.authenticate(families, headerToAdd);
        }
        catch (Exception e) {
            this.logger.error((Object)String.format("The authentication should not require secure context to be set. %s", e.getMessage()), (Throwable)e);
        }
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertTrue((String)"It is an AdminConsole webscript and a User with Admin access and basic auth header was present. It should succeed.", (boolean)authenticated);
        String message = "The code from blockingRemoteUserMapper shouldn't have been called";
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertFalse((String)"The code from blockingRemoteUserMapper shouldn't have been called", (boolean)this.blockingRemoteUserMapper.isWasInterrupted());
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertEquals((String)"The code from blockingRemoteUserMapper shouldn't have been called", (int)this.blockingRemoteUserMapper.getTimePassed(), (int)0);
    }

    private void checkAdminConsoleFamilyPageWithRemoteUserMapperDisabled(Set<String> families) {
        this.blockingRemoteUserMapper.reset();
        this.blockingRemoteUserMapper.setEnabled(false);
        boolean authenticated = this.authenticate(families, null);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertFalse((String)"It is an AdminConsole webscript now, but Admin basic auth header was not present. It should return 401", (boolean)authenticated);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertEquals((String)"Status should be 401", (int)401, (int)setStatusCode);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertFalse((String)"The interrupt should have not been called because the RemoteUserMapper is not enabled.", (boolean)this.blockingRemoteUserMapper.isWasInterrupted());
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertEquals((String)"RemoteUserMapper not called", (int)this.blockingRemoteUserMapper.getTimePassed(), (int)0);
    }

    private void checkGenericResourceAccess() {
        this.blockingRemoteUserMapper.reset();
        boolean authenticated = this.authenticate(Collections.emptySet(), null);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertFalse((String)"This should not be authenticated as it is not an Admin Console requested. And no credentials have been provided", (boolean)authenticated);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertFalse((String)"Because it is not an Admin Console, the timeout feature from BasicHttpAuthenticator should not be requested. Therefore the interrupt should not have been called. ", (boolean)this.blockingRemoteUserMapper.isWasInterrupted());
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertTrue((String)"No interrupt should have been called.", (this.blockingRemoteUserMapper.getTimePassed() > 999 ? 1 : 0) != 0);
    }

    private void checkTimeOutFeaturesWasNotUsed() {
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertFalse((String)"The timeout feature from BasicHttpAuthenticator should not be requested. Therefore the interrupt should not have been called. ", (boolean)this.blockingRemoteUserMapper.isWasInterrupted());
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertTrue((String)"No interrupt should have been called.", (this.blockingRemoteUserMapper.getTimePassed() > 999 ? 1 : 0) != 0);
    }

    private boolean authenticate(Set<String> families, String headerToAdd) {
        WebScriptServletRequest mockRequest = this.prepareMockRequest(families, headerToAdd);
        WebScriptServletResponse mockResponse = this.prepareMockResponse();
        Authenticator authenticator = this.remoteUserAuthenticatorFactory.create(mockRequest, mockResponse);
        return authenticator.authenticate(Description.RequiredAuthentication.admin, false);
    }

    private boolean authenticateWithGuestParameters(Description.RequiredAuthentication required, boolean isGuest) {
        this.blockingRemoteUserMapper.reset();
        WebScriptServletRequest mockRequest = this.prepareMockRequest(Collections.emptySet(), null);
        WebScriptServletResponse mockResponse = this.prepareMockResponse();
        Authenticator authenticator = this.remoteUserAuthenticatorFactory.create(mockRequest, mockResponse);
        return authenticator.authenticate(required, isGuest);
    }

    private WebScriptServletRequest prepareMockRequest(Set<String> families, String headerToAdd) {
        HttpServletRequest mockHttpRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockHttpRequest.getScheme()).thenReturn((Object)"http");
        if (headerToAdd != null) {
            Mockito.when((Object)mockHttpRequest.getHeader("Authorization")).thenReturn((Object)headerToAdd);
        }
        WebScriptServletRequest mockRequest = (WebScriptServletRequest)Mockito.mock(WebScriptServletRequest.class);
        Mockito.when((Object)mockRequest.getHttpServletRequest()).thenReturn((Object)mockHttpRequest);
        WebScript mockWebScript = (WebScript)Mockito.mock(WebScript.class);
        Match mockMatch = new Match("fake", Collections.EMPTY_MAP, "whatever", mockWebScript);
        Mockito.when((Object)mockRequest.getServiceMatch()).thenReturn((Object)mockMatch);
        Description mockDescription = (Description)Mockito.mock(Description.class);
        Mockito.when((Object)mockWebScript.getDescription()).thenReturn((Object)mockDescription);
        Mockito.when((Object)mockDescription.getFamilys()).thenReturn(families);
        return mockRequest;
    }

    private void checkExtAuthStillWorks(Description.RequiredAuthentication required, Set<String> families) {
        this.blockingRemoteUserMapper.reset();
        DefaultRemoteUserMapper defaultRemoteUserMapper = new DefaultRemoteUserMapper();
        defaultRemoteUserMapper.setActive(true);
        defaultRemoteUserMapper.setProxyUserName(null);
        defaultRemoteUserMapper.setPersonService(this.personService);
        this.remoteUserAuthenticatorFactory.setRemoteUserMapper((RemoteUserMapper)defaultRemoteUserMapper);
        HttpServletRequest mockHttpRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockHttpRequest.getScheme()).thenReturn((Object)"http");
        String userName = "RAFACAT_usr_" + (int)(Math.random() * 1000.0);
        Mockito.when((Object)mockHttpRequest.getHeader(this.proxyHeader)).thenReturn((Object)userName);
        WebScriptServletRequest mockRequest = (WebScriptServletRequest)Mockito.mock(WebScriptServletRequest.class);
        Mockito.when((Object)mockRequest.getHttpServletRequest()).thenReturn((Object)mockHttpRequest);
        WebScript mockWebScript = (WebScript)Mockito.mock(WebScript.class);
        Match mockMatch = new Match("fake", Collections.EMPTY_MAP, "whatever", mockWebScript);
        Mockito.when((Object)mockRequest.getServiceMatch()).thenReturn((Object)mockMatch);
        Description mockDescription = (Description)Mockito.mock(Description.class);
        Mockito.when((Object)mockWebScript.getDescription()).thenReturn((Object)mockDescription);
        Mockito.when((Object)mockDescription.getFamilys()).thenReturn(families);
        WebScriptServletResponse mockResponse = this.prepareMockResponse();
        Authenticator authenticator = this.remoteUserAuthenticatorFactory.create(mockRequest, mockResponse);
        boolean authenticated = authenticator.authenticate(required, false);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertTrue((String)"This should be authenticating with external auth", (boolean)authenticated);
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertFalse((String)"We have been using the DefaultRemoteUserMapper, so our BlockingRemoteUserMapper shouldn't have been called", (boolean)this.blockingRemoteUserMapper.isWasInterrupted());
        RemoteAuthenticatorFactoryAdminConsoleAccessTest.assertEquals((String)"BlockingRemoteUserMapper shouldn't have been called", (int)this.blockingRemoteUserMapper.getTimePassed(), (int)0);
    }

    private WebScriptServletResponse prepareMockResponse() {
        HttpServletResponse mockHttpResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        WebScriptServletResponse mockResponse = (WebScriptServletResponse)Mockito.mock(WebScriptServletResponse.class);
        Mockito.when((Object)mockResponse.getHttpServletResponse()).thenReturn((Object)mockHttpResponse);
        ((HttpServletResponse)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                if (args != null && args.length == 1) {
                    setStatusCode = -1;
                    try {
                        setStatusCode = (Integer)args[0];
                    }
                    catch (Exception e) {
                        RemoteAuthenticatorFactoryAdminConsoleAccessTest.this.logger.error((Object)("Could not get the status code: " + e.getMessage()), (Throwable)e);
                    }
                }
                return null;
            }
        }).when((Object)mockHttpResponse)).setStatus(Matchers.anyInt());
        return mockResponse;
    }

    private void createUser(String userName, String password) {
        if (!this.personService.personExists(userName)) {
            this.authenticationService.createAuthentication(userName, password.toCharArray());
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"myFirstName");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"myLastName");
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"myFirstName.myLastName@email.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"myJobTitle");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"myOrganisation");
            this.personService.createPerson((Map)personProps);
        }
    }

    private String getBasicAuthHeader(String userName, String password) {
        return String.format("Basic %s", Base64.encodeBase64String((byte[])String.format("%s:%s", userName, password).getBytes()));
    }
}

