/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search.impl;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.impl.lucene.LuceneQueryLanguageSPI;
import org.alfresco.rest.api.search.context.SearchRequestContext;
import org.alfresco.rest.api.search.impl.StoreMapper;
import org.alfresco.rest.api.search.model.Default;
import org.alfresco.rest.api.search.model.FacetField;
import org.alfresco.rest.api.search.model.FacetFields;
import org.alfresco.rest.api.search.model.FacetQuery;
import org.alfresco.rest.api.search.model.FilterQuery;
import org.alfresco.rest.api.search.model.Limits;
import org.alfresco.rest.api.search.model.Localization;
import org.alfresco.rest.api.search.model.Pivot;
import org.alfresco.rest.api.search.model.Query;
import org.alfresco.rest.api.search.model.Scope;
import org.alfresco.rest.api.search.model.SearchQuery;
import org.alfresco.rest.api.search.model.SortDef;
import org.alfresco.rest.api.search.model.Spelling;
import org.alfresco.rest.api.search.model.Template;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.GeneralHighlightParameters;
import org.alfresco.service.cmr.search.Interval;
import org.alfresco.service.cmr.search.IntervalParameters;
import org.alfresco.service.cmr.search.IntervalSet;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.RangeParameters;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.StatsRequestParameters;
import org.alfresco.util.ParameterCheck;

public class SearchMapper {
    public static final List<String> PERMITTED_INCLUDES = Arrays.asList("allowableOperations", "aspectNames", "isLink", "path", "properties", "association", "isLocked", "permissions");
    public static final String CMIS = "cmis";
    public static final String LUCENE = "lucene";
    public static final String AFTS = "afts";
    private StoreMapper storeMapper;

    public SearchParameters toSearchParameters(Params params, SearchQuery searchQuery, SearchRequestContext searchRequestContext) {
        ParameterCheck.mandatory((String)"query", (Object)searchQuery.getQuery());
        SearchParameters sp = new SearchParameters();
        this.setDefaults(sp);
        this.fromLocalization(sp, searchQuery.getLocalization());
        this.fromQuery(sp, searchQuery.getQuery());
        this.fromPaging(sp, params.getPaging());
        this.fromSort(sp, searchQuery.getSort());
        this.fromTemplate(sp, searchQuery.getTemplates());
        this.validateInclude(searchQuery.getInclude());
        this.fromDefault(sp, searchQuery.getDefaults());
        this.fromFilterQuery(sp, searchQuery.getFilterQueries());
        this.fromFacetQuery(sp, searchQuery.getFacetQueries());
        this.fromPivot(sp, searchQuery.getStats(), searchQuery.getFacetFields(), searchQuery.getFacetRanges(), searchQuery.getPivots(), searchRequestContext);
        this.fromStats(sp, searchQuery.getStats());
        this.fromFacetFields(sp, searchQuery.getFacetFields());
        this.fromSpellCheck(sp, searchQuery.getSpellcheck());
        this.fromHighlight(sp, searchQuery.getHighlight());
        this.fromFacetIntervals(sp, searchQuery.getFacetIntervals());
        this.fromRange(sp, searchQuery.getFacetRanges());
        this.fromScope(sp, searchQuery.getScope(), searchRequestContext);
        this.fromLimits(sp, searchQuery.getLimits());
        return sp;
    }

    public void setDefaults(SearchParameters sp) {
        sp.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
    }

    public void fromQuery(SearchParameters sp, Query q) {
        ParameterCheck.mandatoryString((String)"query", (String)q.getQuery());
        String lang = q.getLanguage() == null ? AFTS : q.getLanguage();
        switch (lang.toLowerCase()) {
            case "afts": {
                sp.setLanguage("fts-alfresco");
                break;
            }
            case "lucene": {
                sp.setLanguage(LUCENE);
                break;
            }
            case "cmis": {
                sp.setLanguage("cmis-alfresco");
                break;
            }
            default: {
                throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{": language allowed values: afts,lucene,cmis"});
            }
        }
        sp.setQuery(q.getQuery());
        sp.setSearchTerm(q.getUserQuery());
    }

    public void fromPaging(SearchParameters sp, Paging paging) {
        if (paging != null) {
            sp.setLimitBy(LimitBy.FINAL_SIZE);
            sp.setLimit(paging.getMaxItems());
            sp.setSkipCount(paging.getSkipCount());
        }
    }

    public void fromSort(SearchParameters sp, List<SortDef> sort) {
        if (sort != null && !sort.isEmpty()) {
            if ("cmis-alfresco".equals(sp.getLanguage())) {
                throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{": sort {} not allowed with cmis language"});
            }
            for (SortDef sortDef : sort) {
                try {
                    SearchParameters.SortDefinition.SortType sortType = SearchParameters.SortDefinition.SortType.valueOf((String)sortDef.getType());
                    String field = sortDef.getField();
                    sp.addSort(new SearchParameters.SortDefinition(sortType, field, sortDef.isAscending()));
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{sortDef.getType()});
                }
            }
        }
    }

    public void fromTemplate(SearchParameters sp, List<Template> templates) {
        if (templates != null && !templates.isEmpty()) {
            for (Template aTemplate : templates) {
                ParameterCheck.mandatoryString((String)"template name", (String)aTemplate.getName());
                ParameterCheck.mandatoryString((String)"template template", (String)aTemplate.getTemplate());
                sp.addQueryTemplate(aTemplate.getName(), aTemplate.getTemplate());
            }
        }
    }

    public void fromDefault(SearchParameters sp, Default defaults) {
        if (defaults != null) {
            List<String> txtAttribs = defaults.getTextAttributes();
            if (txtAttribs != null && !txtAttribs.isEmpty()) {
                for (String attrib : txtAttribs) {
                    sp.addTextAttribute(attrib);
                }
            }
            if (defaults.getDefaultFTSOperator() != null) {
                sp.setDefaultFTSOperator(SearchParameters.Operator.valueOf((String)defaults.getDefaultFTSOperator().toUpperCase()));
            }
            if (defaults.getDefaultFTSFieldOperator() != null) {
                sp.setDefaultFTSFieldConnective(SearchParameters.Operator.valueOf((String)defaults.getDefaultFTSFieldOperator().toUpperCase()));
            }
            sp.setNamespace(defaults.getNamespace());
            sp.setDefaultFieldName(defaults.getDefaultFieldName());
        }
    }

    public void validateInclude(List<String> includes) {
        if (includes != null && !includes.isEmpty()) {
            for (String inc : includes) {
                if (PERMITTED_INCLUDES.contains(inc)) continue;
                throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{inc});
            }
        }
    }

    public void fromFilterQuery(SearchParameters sp, List<FilterQuery> filterQueries) {
        if (filterQueries != null && !filterQueries.isEmpty()) {
            if ("cmis-alfresco".equals(sp.getLanguage())) {
                throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{": filterQueries {} not allowed with cmis language"});
            }
            for (FilterQuery fq : filterQueries) {
                Object query = null;
                if (fq.getQuery() != null && !fq.getQuery().isEmpty()) {
                    query = fq.getQuery().trim();
                }
                if (fq.getQueries() != null && !fq.getQueries().isEmpty() && query == null) {
                    query = String.join((CharSequence)" OR ", fq.getQueries());
                }
                ParameterCheck.mandatoryString((String)"filterQueries query", query);
                if (fq.getTags() == null || fq.getTags().isEmpty() || ((String)query).contains("afts tag")) {
                    sp.addFilterQuery((String)query);
                    continue;
                }
                String tags = "tag=" + String.join((CharSequence)",", fq.getTags());
                Matcher matcher = LuceneQueryLanguageSPI.AFTS_QUERY.matcher((CharSequence)query);
                query = matcher.find() ? "{!afts " + tags + " " + matcher.group(1).trim() + "}" + matcher.group(2) : "{!afts " + tags + " }" + (String)query;
                sp.addFilterQuery((String)query);
            }
        }
    }

    public void fromFacetQuery(SearchParameters sp, List<FacetQuery> facetQueries) {
        if (facetQueries != null && !facetQueries.isEmpty()) {
            for (FacetQuery fq : facetQueries) {
                String label;
                ParameterCheck.mandatoryString((String)"facetQuery query", (String)fq.getQuery());
                Object query = fq.getQuery();
                String string = label = fq.getLabel() != null ? fq.getLabel() : query;
                if (((String)query).startsWith("{!afts")) {
                    throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{": Facet queries should not start with !afts"});
                }
                query = "{!afts key='" + label + "'}" + (String)query;
                sp.addFacetQuery((String)query);
            }
        }
    }

    public void fromFacetFields(SearchParameters sp, FacetFields facetFields) {
        if (facetFields != null) {
            ParameterCheck.mandatory((String)"facetFields facets", facetFields.getFacets());
            if (facetFields.getFacets() != null && !facetFields.getFacets().isEmpty()) {
                for (FacetField facet : facetFields.getFacets()) {
                    ParameterCheck.mandatoryString((String)"facetFields facet field", (String)facet.getField());
                    String field = facet.getField();
                    SearchParameters.FieldFacet ff = new SearchParameters.FieldFacet(field);
                    if (facet.getSort() != null && !facet.getSort().isEmpty()) {
                        try {
                            ff.setSort(SearchParameters.FieldFacetSort.valueOf((String)facet.getSort()));
                        }
                        catch (IllegalArgumentException e) {
                            throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{facet.getSort()});
                        }
                    }
                    if (facet.getMethod() != null && !facet.getMethod().isEmpty()) {
                        try {
                            ff.setMethod(SearchParameters.FieldFacetMethod.valueOf((String)facet.getMethod()));
                        }
                        catch (IllegalArgumentException e) {
                            throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{facet.getMethod()});
                        }
                    }
                    ff.setPrefix(facet.getPrefix());
                    ff.setLabel(facet.getLabel());
                    ff.setExcludeFilters(facet.getExcludeFilters());
                    ff.setCountDocsMissingFacetField(facet.getMissing().booleanValue());
                    ff.setLimitOrNull(facet.getLimit());
                    ff.setOffset(facet.getOffset().intValue());
                    ff.setMinCount(facet.getMincount().intValue());
                    ff.setEnumMethodCacheMinDF(facet.getFacetEnumCacheMinDf().intValue());
                    sp.addFieldFacet(ff);
                }
            }
        }
    }

    public void fromSpellCheck(SearchParameters sp, Spelling spelling) {
        if (spelling != null) {
            if (spelling.getQuery() != null && !spelling.getQuery().isEmpty()) {
                sp.setSearchTerm(spelling.getQuery());
            } else if (sp.getSearchTerm() == null || sp.getSearchTerm().isEmpty()) {
                throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{": userQuery or spelling.query required."});
            }
            sp.setSpellCheck(true);
        }
    }

    public void fromScope(SearchParameters sp, Scope scope, SearchRequestContext searchRequestContext) {
        List<String> stores;
        if (scope != null && (stores = scope.getLocations()) != null && !stores.isEmpty()) {
            sp.getStores().clear();
            searchRequestContext.getStores().addAll(stores);
            for (String aStore : stores) {
                try {
                    sp.addStore(this.storeMapper.getStoreRef(aStore));
                }
                catch (AlfrescoRuntimeException are) {
                    throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{aStore});
                }
            }
            if (stores.contains("history") && stores.size() > 1) {
                throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{": scope 'history' can only be used on its own"});
            }
        }
    }

    public void fromFacetIntervals(SearchParameters sp, IntervalParameters facetIntervals) {
        if (facetIntervals != null) {
            ParameterCheck.mandatory((String)"facetIntervals intervals", (Object)facetIntervals.getIntervals());
            Set globalSets = facetIntervals.getSets();
            this.validateSets(globalSets, "facetIntervals");
            if (facetIntervals.getIntervals() != null && !facetIntervals.getIntervals().isEmpty()) {
                ArrayList<String> intervalLabels = new ArrayList<String>(facetIntervals.getIntervals().size());
                for (Interval interval : facetIntervals.getIntervals()) {
                    ParameterCheck.mandatory((String)"facetIntervals intervals field", (Object)interval.getField());
                    this.validateSets(interval.getSets(), "facetIntervals intervals " + interval.getField());
                    if (interval.getSets() != null && globalSets != null) {
                        interval.getSets().addAll(globalSets);
                    }
                    ParameterCheck.mandatoryCollection((String)"facetIntervals intervals sets", (Collection)interval.getSets());
                    List duplicateSetLabels = interval.getSets().stream().collect(Collectors.groupingBy(IntervalSet::getLabel, Collectors.counting())).entrySet().stream().filter(e -> ((Long)e.getValue()).intValue() > 1).collect(Collectors.toList());
                    if (!duplicateSetLabels.isEmpty()) {
                        throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{": duplicate set interval label " + duplicateSetLabels.toString()});
                    }
                    if (interval.getLabel() == null) continue;
                    intervalLabels.add(interval.getLabel());
                }
                List duplicateIntervalLabels = intervalLabels.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(e -> ((Long)e.getValue()).intValue() > 1).collect(Collectors.toList());
                if (!duplicateIntervalLabels.isEmpty()) {
                    throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{": duplicate interval label " + duplicateIntervalLabels.toString()});
                }
            }
            if (facetIntervals.getSets() != null) {
                facetIntervals.getSets().clear();
            }
        }
        sp.setInterval(facetIntervals);
    }

    public void fromRange(SearchParameters sp, List<RangeParameters> ranges) {
        if (ranges != null && !ranges.isEmpty()) {
            for (RangeParameters rangeParams : ranges) {
                ParameterCheck.mandatory((String)"ranges", (Object)rangeParams);
                ParameterCheck.mandatory((String)"field", (Object)rangeParams.getField());
                ParameterCheck.mandatory((String)"start", (Object)rangeParams.getStart());
                ParameterCheck.mandatory((String)"end", (Object)rangeParams.getEnd());
                ParameterCheck.mandatory((String)"gap", (Object)rangeParams.getGap());
            }
            sp.setRanges(ranges);
        }
    }

    public void fromPivot(SearchParameters sp, List<StatsRequestParameters> stats, FacetFields facetFields, List<RangeParameters> ranges, List<Pivot> multiplePivots, SearchRequestContext searchRequestContext) {
        if (multiplePivots != null && !multiplePivots.isEmpty()) {
            multiplePivots.forEach(aPivot -> {
                ArrayList<String> pivotKeys = new ArrayList<String>();
                this.buildPivotKeys((List<String>)pivotKeys, (Pivot)aPivot, stats, facetFields, ranges, searchRequestContext);
                sp.addPivots(pivotKeys);
            });
        }
    }

    protected void buildPivotKeys(List<String> pivotKeys, Pivot aPivot, List<StatsRequestParameters> stats, FacetFields facetFields, List<RangeParameters> ranges, SearchRequestContext searchRequestContext) {
        Optional<FacetField> found;
        if (aPivot == null) {
            return;
        }
        String pivotKey = null;
        ParameterCheck.mandatoryString((String)"pivot key", (String)aPivot.getKey());
        if (facetFields.getFacets() != null && !facetFields.getFacets().isEmpty() && (found = facetFields.getFacets().stream().filter(queryable -> aPivot.getKey().equals(queryable.getLabel() != null ? queryable.getLabel() : queryable.getField())).findFirst()).isPresent()) {
            pivotKey = aPivot.getKey();
            if (searchRequestContext.getPivotKeys().containsValue(pivotKey)) {
                throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{": Duplicate pivot parameter " + aPivot.getKey()});
            }
            pivotKeys.add(found.get().getField());
            facetFields.getFacets().remove(found.get());
            searchRequestContext.getPivotKeys().put(found.get().getField(), pivotKey);
        }
        if (pivotKey == null && (aPivot.getPivots() == null || aPivot.getPivots().isEmpty())) {
            Object foundStat;
            if (stats != null && !stats.isEmpty() && ((Optional)(foundStat = stats.stream().filter(stas -> aPivot.getKey().equals(stas.getLabel() != null ? stas.getLabel() : stas.getField())).findFirst())).isPresent()) {
                pivotKey = aPivot.getKey();
                if (pivotKeys.isEmpty()) {
                    throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{": Stats key " + pivotKey + " cannot be used here"});
                }
                pivotKeys.add(pivotKey);
                searchRequestContext.getPivotKeys().put(pivotKey, pivotKey);
            }
            if (ranges != null && !ranges.isEmpty()) {
                for (RangeParameters aRange : ranges) {
                    if (!aPivot.getKey().equals(aRange.getLabel())) continue;
                    pivotKey = aPivot.getKey();
                    if (pivotKeys.isEmpty()) {
                        throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{": Range key " + pivotKey + " cannot be used here"});
                    }
                    pivotKeys.add(pivotKey);
                    searchRequestContext.getPivotKeys().put(pivotKey, pivotKey);
                }
            }
        }
        if (pivotKey == null) {
            String invalidMessage = searchRequestContext.getPivotKeys().values().contains(aPivot.getKey()) ? " cannot be used more than once." : " does not reference a facet Field, range or stats.";
            throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{": Pivot parameter " + aPivot.getKey() + invalidMessage});
        }
        if (aPivot.getPivots() != null && !aPivot.getPivots().isEmpty() && aPivot.getPivots().size() > 1) {
            throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{": Currently only 1 nested pivot is supported, you have " + aPivot.getPivots().size()});
        }
        aPivot.getPivots().forEach(subPivot -> this.buildPivotKeys(pivotKeys, (Pivot)subPivot, stats, facetFields, ranges, searchRequestContext));
    }

    public void fromStats(SearchParameters sp, List<StatsRequestParameters> stats) {
        if (stats != null && !stats.isEmpty()) {
            for (StatsRequestParameters aStat : stats) {
                ParameterCheck.mandatory((String)"stats field", (Object)aStat.getField());
                List perc = aStat.getPercentiles();
                if (perc != null && !perc.isEmpty()) {
                    for (Float percentile : perc) {
                        if (percentile != null && !(percentile.floatValue() < 0.0f) && !(percentile.floatValue() > 100.0f)) continue;
                        throw new IllegalArgumentException("Invalid percentile " + percentile);
                    }
                }
                if (!aStat.getCardinality().booleanValue() || !(aStat.getCardinalityAccuracy().floatValue() < 0.0f) && !(aStat.getCardinalityAccuracy().floatValue() > 1.0f)) continue;
                throw new IllegalArgumentException("Invalid cardinality accuracy " + aStat.getCardinalityAccuracy() + " It must be between 0 and 1.");
            }
            sp.setStats(stats);
        }
    }

    protected void validateSets(Set<IntervalSet> intervalSets, String prefix) {
        if (intervalSets != null && !intervalSets.isEmpty()) {
            for (IntervalSet aSet : intervalSets) {
                ParameterCheck.mandatory((String)(prefix + " sets start"), (Object)aSet.getStart());
                ParameterCheck.mandatory((String)(prefix + " sets end"), (Object)aSet.getEnd());
                if (aSet.getLabel() != null) continue;
                aSet.setLabel(aSet.toRange());
            }
        }
    }

    public void fromHighlight(SearchParameters sp, GeneralHighlightParameters highlight) {
        sp.setHighlight(highlight);
    }

    public void fromLocalization(SearchParameters sp, Localization localization) {
        if (localization != null) {
            String timezoneId;
            if (!localization.getLocales().isEmpty()) {
                try {
                    localization.getLocales().forEach(localeStr -> {
                        if (localeStr != null) {
                            localeStr = localeStr.replace('_', '-');
                        }
                        sp.addLocale(Locale.forLanguageTag(localeStr));
                    });
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid locale " + String.valueOf(localization.getLocales()));
                }
            }
            if ((timezoneId = localization.getTimezone()) != null && !timezoneId.isEmpty()) {
                ZoneId validZoneId = null;
                TimeZone timeZone = null;
                try {
                    validZoneId = ZoneId.of(timezoneId);
                    timeZone = TimeZone.getTimeZone(timezoneId);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid timezoneId " + timezoneId);
                }
                if (validZoneId.getId().equals(timeZone.getID())) {
                    sp.setTimezone(validZoneId.getId());
                } else {
                    throw new IllegalArgumentException("Incompatible timezoneId " + timezoneId);
                }
            }
        }
    }

    public void fromLimits(SearchParameters sp, Limits limits) {
        if (limits != null) {
            if (limits.getPermissionEvaluationCount() != null) {
                sp.setLimit(-1);
                sp.setLimitBy(LimitBy.NUMBER_OF_PERMISSION_EVALUATIONS);
                sp.setMaxPermissionChecks(limits.getPermissionEvaluationCount().intValue());
            }
            if (limits.getPermissionEvaluationTime() != null) {
                sp.setLimit(-1);
                sp.setLimitBy(LimitBy.NUMBER_OF_PERMISSION_EVALUATIONS);
                sp.setMaxPermissionCheckTimeMillis((long)limits.getPermissionEvaluationTime().intValue());
            }
        }
    }

    public void setStoreMapper(StoreMapper storeMapper) {
        this.storeMapper = storeMapper;
    }
}

