/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tests.core;

import com.fasterxml.jackson.databind.Module;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.rest.api.tests.util.MultiPartBuilder;
import org.alfresco.rest.framework.core.ResourceInspector;
import org.alfresco.rest.framework.core.ResourceLocator;
import org.alfresco.rest.framework.core.ResourceLookupDictionary;
import org.alfresco.rest.framework.core.ResourceMetadata;
import org.alfresco.rest.framework.core.ResourceOperation;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.core.exceptions.UnsupportedResourceOperationException;
import org.alfresco.rest.framework.jacksonextensions.BeanPropertiesFilter;
import org.alfresco.rest.framework.jacksonextensions.JacksonHelper;
import org.alfresco.rest.framework.jacksonextensions.RestJsonModule;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.tests.api.mocks.Farmer;
import org.alfresco.rest.framework.tests.api.mocks.GrassEntityResource;
import org.alfresco.rest.framework.tools.ApiAssistant;
import org.alfresco.rest.framework.webscripts.ParamsExtractor;
import org.alfresco.rest.framework.webscripts.ResourceWebScriptDelete;
import org.alfresco.rest.framework.webscripts.ResourceWebScriptGet;
import org.alfresco.rest.framework.webscripts.ResourceWebScriptPost;
import org.alfresco.rest.framework.webscripts.ResourceWebScriptPut;
import org.alfresco.util.TempFileProvider;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.servlet.FormData;
import org.springframework.http.HttpMethod;
import org.springframework.mock.web.MockHttpServletRequest;

public class ParamsExtractorTests {
    static JacksonHelper jsonHelper = null;
    static ApiAssistant assistant = null;
    static ResourceLocator locator;

    @BeforeClass
    public static void setupTests() throws Exception {
        jsonHelper = new JacksonHelper();
        RestJsonModule module = new RestJsonModule();
        jsonHelper.setModule((Module)module);
        jsonHelper.afterPropertiesSet();
        assistant = new ApiAssistant();
        assistant.setJsonHelper(jsonHelper);
        locator = new ResourceLookupDictionary();
    }

    @Test
    public void testGetExtractor() {
        ResourceWebScriptGet extractor = new ResourceWebScriptGet();
        extractor.setLocator(locator);
        HashMap<String, String> templateVars = new HashMap<String, String>();
        WebScriptRequest request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getServiceMatch()).thenReturn((Object)new Match(null, templateVars, null));
        Params params = extractor.extractParams(ParamsExtractorTests.mockEntity(), request);
        Assert.assertNull((String)"For getting a Collection there should be no entity params.", (Object)params.getEntityId());
        Assert.assertNull((String)"For getting a Collection there should be no passed params.", (Object)params.getPassedIn());
        Assert.assertNull((String)"For getting a Collection there should be no relationshipId params.", (Object)params.getRelationshipId());
        Assert.assertEquals((long)0L, (long)params.getPaging().getSkipCount());
        Assert.assertEquals((long)100L, (long)params.getPaging().getMaxItems());
        Assert.assertNotNull((Object)params.getFilter());
        Assert.assertTrue((String)"Default filter is BeanPropertiesFilter.AllProperties", (boolean)BeanPropertiesFilter.AllProperties.class.equals(params.getFilter().getClass()));
        templateVars.put("entityId", "1234");
        params = extractor.extractParams(ParamsExtractorTests.mockEntity(), request);
        Assert.assertNotNull((Object)params);
        Assert.assertNotNull((Object)params.getRelationsFilter());
        Assert.assertFalse((boolean)params.includeSource());
        templateVars.put("relationResource", "codfish");
        params = extractor.extractParams(ParamsExtractorTests.mockRelationship(), request);
        Assert.assertNotNull((Object)params);
        Assert.assertNull((String)"For getting a Collection there should be no relationshipId params.", (Object)params.getRelationshipId());
        templateVars.put("relationshipId", "45678");
        params = extractor.extractParams(ParamsExtractorTests.mockRelationship(), request);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)"1234", (Object)params.getEntityId());
        Assert.assertEquals((Object)"45678", (Object)params.getRelationshipId());
        Assert.assertFalse((boolean)params.includeSource());
        this.testExtractAddressedParams(templateVars, request, (ParamsExtractor)extractor);
    }

    private Params testExtractAddressedParams(Map<String, String> templateVars, WebScriptRequest request, ParamsExtractor extractor) {
        templateVars.clear();
        templateVars.put("entityId", "1234");
        templateVars.put("relationResource", "codfish");
        Params params = extractor.extractParams(ParamsExtractorTests.mockProperty(), request);
        Assert.assertNotNull((Object)params);
        Assert.assertTrue((boolean)params.hasBinaryProperty("codfish"));
        Assert.assertFalse((boolean)params.hasBinaryProperty("something"));
        Assert.assertEquals((Object)"codfish", (Object)params.getBinaryProperty());
        templateVars.put("relationshipId", "9865");
        templateVars.put("property", "monkFish");
        params = extractor.extractParams(ParamsExtractorTests.mockProperty(), request);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)"1234", (Object)params.getEntityId());
        Assert.assertEquals((Object)"9865", (Object)params.getRelationshipId());
        Assert.assertTrue((boolean)params.hasBinaryProperty("monkFish"));
        return params;
    }

    @Test
    public void testPostExtractor() throws IOException {
        ResourceWebScriptPost extractor = new ResourceWebScriptPost();
        extractor.setAssistant(assistant);
        extractor.setLocator(locator);
        HashMap<String, String> templateVars = new HashMap<String, String>();
        Content content = (Content)Mockito.mock(Content.class);
        Mockito.when((Object)content.getReader()).thenReturn((Object)new StringReader("{\"name\":\"Giles\",\"created\":\"2012-03-23T15:56:18.552+0000\",\"age\":54,\"id\":\"1234A3\",\"farm\":\"LARGE\"}"));
        WebScriptRequest request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getServiceMatch()).thenReturn((Object)new Match(null, templateVars, null));
        Mockito.when((Object)request.getContent()).thenReturn((Object)content);
        Params params = extractor.extractParams(ParamsExtractorTests.mockEntity(), request);
        Assert.assertNotNull((Object)params);
        Assert.assertNotNull((Object)params.getFilter());
        Assert.assertTrue((String)"Default filter is BeanPropertiesFilter.AllProperties", (boolean)BeanPropertiesFilter.AllProperties.class.equals(params.getFilter().getClass()));
        Object passed = params.getPassedIn();
        Assert.assertNotNull((Object)passed);
        Assert.assertTrue((boolean)List.class.isAssignableFrom(passed.getClass()));
        List passedObjs = (List)passed;
        Assert.assertTrue((passedObjs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"A Farmer was passed in.", (boolean)Farmer.class.equals(passedObjs.get(0).getClass()));
        templateVars.put("entityId", "1234");
        try {
            params = extractor.extractParams(ParamsExtractorTests.mockEntity(), request);
            Assert.fail((String)"Should not get here. No entity id for POST");
        }
        catch (UnsupportedResourceOperationException uoe) {
            Assert.assertNotNull((Object)((Object)uoe));
        }
        Mockito.when((Object)content.getReader()).thenReturn((Object)new StringReader("{\"name\":\"Giles\",\"created\":\"2012-03-23T15:56:18.552+0000\",\"age\":54,\"id\":\"1234A3\",\"farm\":\"LARGE\"}"));
        params = extractor.extractParams(ParamsExtractorTests.mockRelationship(), request);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)"1234", (Object)params.getEntityId());
        passed = params.getPassedIn();
        Assert.assertNotNull((Object)passed);
        passedObjs = (List)passed;
        Assert.assertTrue((passedObjs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"A Farmer was passed in.", (boolean)Farmer.class.equals(passedObjs.get(0).getClass()));
        try {
            Mockito.when((Object)content.getReader()).thenReturn((Object)new StringReader("{\"name\":\"Giles\",\"created\":\"2012-03-23T15:56:18.552+0000\",\"age\":54,\"id\":\"1234A3\",\"farm\":\"LARGE\"}"));
            templateVars.put("relationshipId", "45678");
            params = extractor.extractParams(ParamsExtractorTests.mockRelationship(), request);
            Assert.fail((String)"Should not get here.");
        }
        catch (UnsupportedResourceOperationException iae) {
            Assert.assertNotNull((String)"POSTING to a relationship collection by id is not correct.", (Object)((Object)iae));
        }
        templateVars.clear();
        Mockito.when((Object)content.getReader()).thenReturn((Object)new StringReader("{\"name\":\"Giles\",\"created\":\"2012-03-23T15:56:18.552+0000\",\"age\":54,\"id\":\"1234A3\",\"farm\":\"LARGE\"}"));
        templateVars.put("entityId", "1234");
        templateVars.put("relationshipId", "codfish");
        try {
            params = extractor.extractParams(ParamsExtractorTests.mockEntity(), request);
            Assert.fail((String)"Should not get here.");
        }
        catch (UnsupportedResourceOperationException uoe) {
            Assert.assertNotNull((Object)((Object)uoe));
        }
        this.testExtractOperationParams(templateVars, request, (ParamsExtractor)extractor);
        templateVars.clear();
        Method aMethod = ResourceInspector.findMethod(EntityResourceAction.Create.class, GrassEntityResource.class);
        ResourceOperation op = ResourceInspector.inspectOperation(GrassEntityResource.class, (Method)aMethod, (HttpMethod)HttpMethod.POST);
        List metainfo = ResourceInspector.inspect(GrassEntityResource.class);
        Assert.assertNotNull((Object)op);
        Assert.assertTrue((String)"Create method should have two params", (op.getParameters().size() == 2 ? 1 : 0) != 0);
        ResourceParameter singleParam = (ResourceParameter)op.getParameters().get(0);
        Assert.assertTrue((boolean)ResourceParameter.KIND.HTTP_BODY_OBJECT.equals((Object)singleParam.getParamType()));
        Assert.assertFalse((String)"Create grass does not support multiple grass creations", (boolean)singleParam.isAllowMultiple());
        Assert.assertFalse((boolean)singleParam.isRequired());
        Mockito.when((Object)request.getHeader("content-length")).thenReturn((Object)"0");
        params = extractor.extractParams((ResourceMetadata)metainfo.get(0), request);
        Assert.assertNotNull((Object)params);
        Mockito.when((Object)content.getReader()).thenReturn((Object)new StringReader("{\"id\":\"grass\",\"color\":\"green\"}"));
        params = extractor.extractParams((ResourceMetadata)metainfo.get(0), request);
        Assert.assertNotNull((Object)params);
    }

    private Params testExtractOperationParams(Map<String, String> templateVars, WebScriptRequest request, ParamsExtractor extractor) {
        templateVars.clear();
        templateVars.put("entityId", "1234");
        templateVars.put("relationResource", "codfish");
        Params params = extractor.extractParams(ParamsExtractorTests.mockOperation(), request);
        Assert.assertNotNull((Object)params);
        Assert.assertNull((String)"For a Collection there should be no relationshipId params.", (Object)params.getRelationshipId());
        templateVars.put("relationshipId", "9865");
        templateVars.put("property", "monkFish");
        params = extractor.extractParams(ParamsExtractorTests.mockOperation(), request);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)"1234", (Object)params.getEntityId());
        Assert.assertEquals((Object)"9865", (Object)params.getRelationshipId());
        return params;
    }

    @Test
    public void testMultiPartPostExtractor() throws Exception {
        ResourceWebScriptPost extractor = new ResourceWebScriptPost();
        extractor.setAssistant(assistant);
        extractor.setLocator(locator);
        HashMap<String, String> templateVars = new HashMap<String, String>();
        WebScriptRequest request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getServiceMatch()).thenReturn((Object)new Match(null, templateVars, null));
        File file = TempFileProvider.createTempFile((String)"ParamsExtractorTests-", (String)".txt");
        PrintWriter writer = new PrintWriter(file);
        writer.println("Multipart Mock test.");
        writer.close();
        MultiPartBuilder.MultiPartRequest reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(file.getName(), file, "text/plain")).build();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest("POST", "");
        mockRequest.setContent(reqBody.getBody());
        mockRequest.setContentType(reqBody.getContentType());
        Mockito.when((Object)request.getContentType()).thenReturn((Object)"multipart/form-data");
        Mockito.when((Object)request.parseContent()).thenReturn((Object)new FormData((HttpServletRequest)mockRequest));
        Params params = extractor.extractParams(ParamsExtractorTests.mockEntity(), request);
        Assert.assertNotNull((Object)params);
        Object passed = params.getPassedIn();
        Assert.assertNotNull((Object)passed);
        Assert.assertTrue((boolean)FormData.class.isAssignableFrom(passed.getClass()));
        FormData formData = (FormData)passed;
        Assert.assertTrue((boolean)formData.getIsMultiPart());
        templateVars.put("entityId", "1234");
        try {
            params = extractor.extractParams(ParamsExtractorTests.mockEntity(), request);
            Assert.fail((String)"Should not get here. No entity id for POST");
        }
        catch (UnsupportedResourceOperationException uoe) {
            Assert.assertNotNull((Object)((Object)uoe));
        }
        params = extractor.extractParams(ParamsExtractorTests.mockRelationship(), request);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)"1234", (Object)params.getEntityId());
        passed = params.getPassedIn();
        Assert.assertNotNull((Object)passed);
        Assert.assertTrue((boolean)FormData.class.isAssignableFrom(passed.getClass()));
        formData = (FormData)passed;
        Assert.assertTrue((boolean)formData.getIsMultiPart());
    }

    @Test
    public void testPutExtractor() throws IOException {
        ResourceWebScriptPut extractor = new ResourceWebScriptPut();
        extractor.setAssistant(assistant);
        extractor.setLocator(locator);
        HashMap<String, String> templateVars = new HashMap<String, String>();
        Content content = (Content)Mockito.mock(Content.class);
        Mockito.when((Object)content.getReader()).thenReturn((Object)new StringReader("{\"name\":\"Giles\",\"created\":\"2012-03-23T15:56:18.552+0000\",\"age\":54,\"id\":\"1234A3\",\"farm\":\"LARGE\"}"));
        WebScriptRequest request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getServiceMatch()).thenReturn((Object)new Match(null, templateVars, null));
        Mockito.when((Object)request.getContent()).thenReturn((Object)content);
        Mockito.when((Object)request.getContentType()).thenReturn((Object)"application/pdf; charset=UTF-16BE");
        Params params = null;
        try {
            params = extractor.extractParams(ParamsExtractorTests.mockEntity(), request);
            Assert.fail((String)"Should not get here. PUT is executed against the instance URL");
        }
        catch (UnsupportedResourceOperationException uoe) {
            Assert.assertNotNull((Object)((Object)uoe));
        }
        templateVars.put("entityId", "1234");
        try {
            params = extractor.extractParams(ParamsExtractorTests.mockRelationship(), request);
            Assert.fail((String)"Should not get here. PUT is executed against the instance URL");
        }
        catch (UnsupportedResourceOperationException uoe) {
            Assert.assertNotNull((Object)((Object)uoe));
        }
        templateVars.put("entityId", "1234");
        params = extractor.extractParams(ParamsExtractorTests.mockEntity(), request);
        Assert.assertNotNull((Object)params);
        Object passed = params.getPassedIn();
        Assert.assertNotNull((Object)passed);
        Assert.assertTrue((String)"A Farmer was passed in.", (boolean)Farmer.class.equals(passed.getClass()));
        Assert.assertNotNull((Object)params.getFilter());
        Assert.assertTrue((String)"Default filter is BeanPropertiesFilter.AllProperties", (boolean)BeanPropertiesFilter.AllProperties.class.equals(params.getFilter().getClass()));
        Mockito.when((Object)content.getReader()).thenReturn((Object)new StringReader("{\"name\":\"Giles\",\"created\":\"2012-03-23T15:56:18.552+0000\",\"age\":54,\"id\":\"1234A3\",\"farm\":\"LARGE\"}"));
        params = extractor.extractParams(ParamsExtractorTests.mockEntity(), request);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)"1234", (Object)params.getEntityId());
        passed = params.getPassedIn();
        Assert.assertNotNull((Object)passed);
        Mockito.when((Object)content.getReader()).thenReturn((Object)new StringReader("{\"name\":\"Giles\",\"created\":\"2012-03-23T15:56:18.552+0000\",\"age\":54,\"id\":\"1234A3\",\"farm\":\"LARGE\"}"));
        templateVars.put("relationshipId", "67890");
        params = extractor.extractParams(ParamsExtractorTests.mockRelationship(), request);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)"1234", (Object)params.getEntityId());
        passed = params.getPassedIn();
        Assert.assertNotNull((Object)passed);
        Assert.assertTrue((String)"A Farmer was passed in.", (boolean)Farmer.class.equals(passed.getClass()));
        Farmer aFarmer = (Farmer)passed;
        Assert.assertEquals((String)"Relationship id should be automatically set on the object passed in.", (Object)aFarmer.getId(), (Object)"67890");
        Mockito.when((Object)content.getReader()).thenReturn((Object)new StringReader("{\"name\":\"Giles\",\"created\":\"2012-03-23T15:56:18.552+0000\",\"age\":54,\"id\":\"1234A3\",\"farm\":\"LARGE\"}"));
        params = this.testExtractAddressedParams(templateVars, request, (ParamsExtractor)extractor);
        Assert.assertEquals((Object)"UTF-16BE", (Object)params.getContentInfo().getEncoding());
        Assert.assertEquals((Object)"application/pdf", (Object)params.getContentInfo().getMimeType());
    }

    @Test
    public void testDeleteExtractor() throws IOException {
        ResourceWebScriptDelete extractor = new ResourceWebScriptDelete();
        extractor.setLocator(locator);
        HashMap<String, String> templateVars = new HashMap<String, String>();
        WebScriptRequest request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getServiceMatch()).thenReturn((Object)new Match(null, templateVars, null));
        Params params = null;
        params = extractor.extractParams(ParamsExtractorTests.mockEntity(), request);
        Assert.assertNotNull((Object)params);
        Assert.assertNull((Object)params.getEntityId());
        Assert.assertNull((Object)params.getRelationshipId());
        Assert.assertNotNull((Object)params.getFilter());
        Assert.assertTrue((String)"Default filter is BeanPropertiesFilter.AllProperties", (boolean)BeanPropertiesFilter.AllProperties.class.equals(params.getFilter().getClass()));
        templateVars.put("entityId", "1234");
        params = extractor.extractParams(ParamsExtractorTests.mockRelationship(), request);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)"1234", (Object)params.getEntityId());
        Assert.assertNull((Object)params.getRelationshipId());
        Assert.assertNotNull((Object)params.getFilter());
        Assert.assertTrue((String)"Default filter is BeanPropertiesFilter.AllProperties", (boolean)BeanPropertiesFilter.AllProperties.class.equals(params.getFilter().getClass()));
        templateVars.put("relationshipId", "45678");
        params = extractor.extractParams(ParamsExtractorTests.mockRelationship(), request);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)"1234", (Object)params.getEntityId());
        Assert.assertEquals((Object)"45678", (Object)params.getRelationshipId());
        Assert.assertNotNull((Object)params.getFilter());
        Assert.assertTrue((String)"Default filter is BeanPropertiesFilter.AllProperties", (boolean)BeanPropertiesFilter.AllProperties.class.equals(params.getFilter().getClass()));
        this.testExtractAddressedParams(templateVars, request, (ParamsExtractor)extractor);
    }

    @Test
    public void testHeaderParsing() throws IOException {
    }

    @Test
    public void testSpecialChars() throws IOException {
        String specialChars = new String(new char[]{'\u9999'}) + " \u9999\u8549";
        ResourceWebScriptPost extractor = new ResourceWebScriptPost();
        extractor.setAssistant(assistant);
        extractor.setLocator(locator);
        HashMap templateVars = new HashMap();
        String mockMe = "{\"name\":\"" + specialChars + "\",\"created\":\"2012-03-23T15:56:18.552+0000\",\"age\":54,\"id\":\"1234A3\",\"farm\":\"LARGE\"}";
        Content content = (Content)Mockito.mock(Content.class);
        Mockito.when((Object)content.getReader()).thenReturn((Object)new StringReader(mockMe));
        WebScriptRequest request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getServiceMatch()).thenReturn((Object)new Match(null, templateVars, null));
        Mockito.when((Object)request.getContent()).thenReturn((Object)content);
        Params params = extractor.extractParams(ParamsExtractorTests.mockEntity(), request);
        Assert.assertNotNull((Object)params);
        Object passed = params.getPassedIn();
        Assert.assertTrue((boolean)List.class.isAssignableFrom(passed.getClass()));
        List passedObjs = (List)passed;
        Assert.assertTrue((passedObjs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"A Farmer was passed in.", (boolean)Farmer.class.equals(passedObjs.get(0).getClass()));
        Farmer f = (Farmer)passedObjs.get(0);
        Assert.assertTrue((boolean)f.getName().equals("\u9999 \u9999\u8549"));
        ResourceWebScriptGet getExtractor = new ResourceWebScriptGet();
        getExtractor.setAssistant(assistant);
        getExtractor.setLocator(locator);
        HashMap getTemplateVars = new HashMap();
        WebScriptRequest getRequest = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)getRequest.getServiceMatch()).thenReturn((Object)new Match(null, getTemplateVars, null));
        Mockito.when((Object)getRequest.getParameterNames()).thenReturn((Object)new String[]{"aParam"});
        Mockito.when((Object)getRequest.getParameterValues("aParam")).thenReturn((Object)new String[]{specialChars});
        Params pGet = getExtractor.extractParams(ParamsExtractorTests.mockEntity(), getRequest);
        Assert.assertNotNull((Object)pGet);
        String pVal = pGet.getParameter("aParam");
        Assert.assertTrue((boolean)pVal.equals("\u9999 \u9999\u8549"));
    }

    private static ResourceMetadata mockEntity() {
        ResourceMetadata resourceMock = (ResourceMetadata)Mockito.mock(ResourceMetadata.class);
        ResourceOperation resourceOperation = (ResourceOperation)Mockito.mock(ResourceOperation.class);
        Mockito.when((Object)resourceMock.getType()).thenReturn((Object)ResourceMetadata.RESOURCE_TYPE.ENTITY);
        Mockito.when((Object)resourceMock.getOperation((HttpMethod)Matchers.notNull(HttpMethod.class))).thenReturn((Object)resourceOperation);
        Mockito.when((Object)resourceMock.getObjectType((ResourceOperation)Matchers.notNull(ResourceOperation.class))).thenReturn(Farmer.class);
        return resourceMock;
    }

    private static ResourceMetadata mockProperty() {
        ResourceMetadata resourceMock = (ResourceMetadata)Mockito.mock(ResourceMetadata.class);
        Mockito.when((Object)resourceMock.getType()).thenReturn((Object)ResourceMetadata.RESOURCE_TYPE.PROPERTY);
        return resourceMock;
    }

    private static ResourceMetadata mockOperation() {
        ResourceMetadata resourceMock = (ResourceMetadata)Mockito.mock(ResourceMetadata.class);
        Mockito.when((Object)resourceMock.getType()).thenReturn((Object)ResourceMetadata.RESOURCE_TYPE.OPERATION);
        return resourceMock;
    }

    private static ResourceMetadata mockRelationship() {
        ResourceMetadata resourceMock = (ResourceMetadata)Mockito.mock(ResourceMetadata.class);
        ResourceOperation resourceOperation = (ResourceOperation)Mockito.mock(ResourceOperation.class);
        Mockito.when((Object)resourceMock.getOperation((HttpMethod)Matchers.notNull(HttpMethod.class))).thenReturn((Object)resourceOperation);
        Mockito.when((Object)resourceMock.getType()).thenReturn((Object)ResourceMetadata.RESOURCE_TYPE.RELATIONSHIP);
        Mockito.when((Object)resourceMock.getObjectType((ResourceOperation)Matchers.notNull(ResourceOperation.class))).thenReturn(Farmer.class);
        return resourceMock;
    }
}

