/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav.auth;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.external.RemoteUserMapper;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.auth.AuthenticationListener;
import org.alfresco.repo.webdav.auth.WebDAVUser;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseAuthenticationFilter {
    protected static final String NO_AUTH_REQUIRED = "alfNoAuthRequired";
    public static final String AUTHENTICATION_USER = "_alfDAVAuthTicket";
    private static final String LOGIN_EXTERNAL_AUTH = "_alfExternalAuth";
    protected static final String ARG_TICKET = "ticket";
    protected AuthenticationService authenticationService;
    protected PersonService personService;
    protected NodeService nodeService;
    protected TransactionService transactionService;
    protected AuthenticationComponent authenticationComponent;
    protected RemoteUserMapper remoteUserMapper;
    protected AuthenticationListener authenticationListener;
    private String userAttributeName = "_alfDAVAuthTicket";

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public void setAuthenticationListener(AuthenticationListener authenticationListener) {
        this.authenticationListener = authenticationListener;
    }

    public void setRemoteUserMapper(RemoteUserMapper remoteUserMapper) {
        this.remoteUserMapper = remoteUserMapper;
    }

    protected SessionUser createUserObject(String userName, String ticket, NodeRef personNode, NodeRef homeSpaceRef) {
        return new WebDAVUser(userName, ticket, homeSpaceRef);
    }

    protected SessionUser getSessionUser(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean externalAuth) {
        SessionUser sessionUser;
        block15: {
            String userId = null;
            if (this.remoteUserMapper != null && (!(this.remoteUserMapper instanceof ActivateableBean) || ((ActivateableBean)this.remoteUserMapper).isActive())) {
                userId = this.remoteUserMapper.getRemoteUser(httpServletRequest);
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace((Object)("Found a remote user: " + AuthenticationUtil.maskUsername((String)userId)));
                }
            }
            String sessionAttrib = this.getUserAttributeName();
            HttpSession session = httpServletRequest.getSession();
            sessionUser = (SessionUser)session.getAttribute(sessionAttrib);
            if (sessionUser != null) {
                try {
                    if (this.getLogger().isTraceEnabled()) {
                        this.getLogger().trace((Object)("Found a session user: " + AuthenticationUtil.maskUsername((String)sessionUser.getUserName())));
                    }
                    this.authenticationService.validate(sessionUser.getTicket());
                    this.setExternalAuth(session, externalAuth);
                }
                catch (AuthenticationException e) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"The ticket may have expired or the person could have been removed, invalidating session.", (Throwable)e);
                    }
                    this.invalidateSession(httpServletRequest);
                    sessionUser = null;
                }
            }
            if (userId != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"We have a previously-cached user with the wrong identity - replace them.");
                }
                if (sessionUser != null && !sessionUser.getUserName().equals(userId)) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"Removing the session user, invalidating session.");
                    }
                    session.removeAttribute(sessionAttrib);
                    session.invalidate();
                    sessionUser = null;
                }
                if (sessionUser == null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("Propagating through the user identity: " + AuthenticationUtil.maskUsername((String)userId)));
                    }
                    this.authenticationComponent.setCurrentUser(userId);
                    session = httpServletRequest.getSession();
                    try {
                        sessionUser = this.createUserEnvironment(session, this.authenticationService.getCurrentUserName(), this.authenticationService.getCurrentTicket(), true);
                    }
                    catch (Throwable e) {
                        if (!this.getLogger().isDebugEnabled()) break block15;
                        this.getLogger().debug((Object)("Error during ticket validation and user creation: " + e.getMessage()), e);
                    }
                }
            }
        }
        return sessionUser;
    }

    protected void invalidateSession(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (session != null) {
            this.setExternalAuth(session, false);
            session.removeAttribute(this.getUserAttributeName());
            session.invalidate();
        }
    }

    protected <T> T doInSystemTransaction(final RetryingTransactionHelper.RetryingTransactionCallback<T> callback) {
        return (T)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<T>(){

            public T doWork() throws Exception {
                return BaseAuthenticationFilter.this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, BaseAuthenticationFilter.this.transactionService.isReadOnly());
            }
        }, (String)"System");
    }

    protected final String getUserAttributeName() {
        return this.userAttributeName;
    }

    protected final void setUserAttributeName(String userAttr) {
        this.userAttributeName = userAttr;
    }

    protected SessionUser createUserEnvironment(HttpSession session, final String userName, final String ticket, boolean externalAuth) throws IOException, ServletException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("Create the User environment for: " + AuthenticationUtil.maskUsername((String)userName)));
        }
        SessionUser user = this.doInSystemTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<SessionUser>(){

            public SessionUser execute() throws Throwable {
                NodeRef personNodeRef = BaseAuthenticationFilter.this.personService.getPerson(userName);
                String name = (String)((Object)BaseAuthenticationFilter.this.nodeService.getProperty(personNodeRef, ContentModel.PROP_USERNAME));
                NodeRef homeSpaceRef = (NodeRef)BaseAuthenticationFilter.this.nodeService.getProperty(personNodeRef, ContentModel.PROP_HOMEFOLDER);
                return BaseAuthenticationFilter.this.createUserObject(name, ticket, personNodeRef, homeSpaceRef);
            }
        });
        session.setAttribute(this.getUserAttributeName(), (Object)user);
        this.setExternalAuth(session, externalAuth);
        return user;
    }

    private void setExternalAuth(HttpSession session, boolean externalAuth) {
        if (externalAuth) {
            session.setAttribute(LOGIN_EXTERNAL_AUTH, (Object)Boolean.TRUE);
        } else {
            session.removeAttribute(LOGIN_EXTERNAL_AUTH);
        }
    }

    protected SessionUser createUserEnvironment(final HttpSession session, final String userName) throws IOException, ServletException {
        return (SessionUser)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<SessionUser>(){

            public SessionUser execute() throws Throwable {
                BaseAuthenticationFilter.this.authenticationComponent.setCurrentUser(userName);
                return BaseAuthenticationFilter.this.createUserEnvironment(session, userName, BaseAuthenticationFilter.this.authenticationService.getCurrentTicket(), true);
            }
        }, this.transactionService.isReadOnly());
    }

    protected abstract Log getLogger();

    protected boolean handleLoginForm(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        int charsRead;
        HttpSession session;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Handling the login form.");
        }
        if ((session = req.getSession(false)) != null) {
            session.invalidate();
        }
        StringBuilder out = new StringBuilder(1024);
        BufferedReader in = req.getReader();
        char[] buff = new char[1024];
        while ((charsRead = in.read(buff)) != -1) {
            out.append(buff, 0, charsRead);
        }
        ((Reader)in).close();
        try {
            JSONObject json = new JSONObject(out.toString());
            String username = json.getString("username");
            String password = json.getString("password");
            if (username == null || username.length() == 0) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"Username not specified in the login form.");
                }
                res.sendError(400, "Username not specified");
                return false;
            }
            if (password == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"Password not specified in the login form.");
                }
                res.sendError(400, "Password not specified");
                return false;
            }
            this.authenticationService.authenticate(username, password.toCharArray());
            session = req.getSession();
            this.createUserEnvironment(session, username, this.authenticationService.getCurrentTicket(), false);
            res.setStatus(204);
            return true;
        }
        catch (AuthenticationException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Login failed", (Throwable)e);
            }
            res.sendError(403, "Login failed");
        }
        catch (JSONException jErr) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Unable to parse JSON POST body", (Throwable)jErr);
            }
            res.sendError(400, "Unable to parse JSON POST body: " + jErr.getMessage());
        }
        return false;
    }
}

