/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import javax.servlet.http.HttpServletRequest;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.Authorization;
import org.alfresco.repo.security.authentication.TicketComponent;
import org.alfresco.repo.security.authentication.external.RemoteUserMapper;
import org.alfresco.repo.web.scripts.BufferedRequest;
import org.alfresco.rest.api.Authentications;
import org.alfresco.rest.api.PublicApiTenantWebScriptServletRequest;
import org.alfresco.rest.api.model.LoginTicket;
import org.alfresco.rest.api.model.LoginTicketResponse;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.surf.util.Base64;

public class AuthenticationsImpl
implements Authentications {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String PARAM_ALF_TICKET = "alf_ticket";
    private AuthenticationService authenticationService;
    private TicketComponent ticketComponent;
    private RemoteUserMapper remoteUserMapper;

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setTicketComponent(TicketComponent ticketComponent) {
        this.ticketComponent = ticketComponent;
    }

    public void setRemoteUserMapper(RemoteUserMapper remoteUserMapper) {
        this.remoteUserMapper = remoteUserMapper;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"authenticationService", (Object)this.authenticationService);
        PropertyCheck.mandatory((Object)this, (String)"ticketComponent", (Object)this.ticketComponent);
    }

    @Override
    public LoginTicketResponse createTicket(LoginTicket loginRequest, Parameters parameters) {
        this.validateLoginRequest(loginRequest);
        try {
            this.authenticationService.authenticate(loginRequest.getUserId(), loginRequest.getPassword().toCharArray());
            LoginTicketResponse response = new LoginTicketResponse();
            response.setUserId(loginRequest.getUserId());
            response.setId(this.authenticationService.getCurrentTicket());
            LoginTicketResponse loginTicketResponse = response;
            return loginTicketResponse;
        }
        catch (AuthenticationException e) {
            throw new PermissionDeniedException("Login failed");
        }
        finally {
            AuthenticationUtil.clearCurrentSecurityContext();
        }
    }

    @Override
    public LoginTicketResponse validateTicket(String me, Parameters parameters, WithResponse withResponse) {
        if (!"-me-".equals(me)) {
            throw new InvalidArgumentException("Invalid parameter: " + me);
        }
        String ticket = this.getTicket(parameters);
        try {
            String ticketUser = this.ticketComponent.validateTicket(ticket);
            String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
            if (currentUser == null || !currentUser.equals(ticketUser)) {
                throw new NotFoundException(NotFoundException.DEFAULT_MESSAGE_ID, new String[]{ticket});
            }
        }
        catch (AuthenticationException e) {
            throw new NotFoundException(NotFoundException.DEFAULT_MESSAGE_ID, new String[]{ticket});
        }
        LoginTicketResponse response = new LoginTicketResponse();
        response.setId(ticket);
        return response;
    }

    @Override
    public void deleteTicket(String me, Parameters parameters, WithResponse withResponse) {
        if (!"-me-".equals(me)) {
            throw new InvalidArgumentException("Invalid parameter: " + me);
        }
        String ticket = this.getTicket(parameters);
        try {
            String ticketUser = this.ticketComponent.validateTicket(ticket);
            String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
            if (currentUser == null || !currentUser.equals(ticketUser)) {
                throw new NotFoundException(NotFoundException.DEFAULT_MESSAGE_ID, new String[]{ticket});
            }
            this.authenticationService.invalidateTicket(ticket);
        }
        catch (AuthenticationException e) {
            throw new NotFoundException(NotFoundException.DEFAULT_MESSAGE_ID, new String[]{ticket});
        }
    }

    protected void validateLoginRequest(LoginTicket loginTicket) {
        if (loginTicket == null || loginTicket.getUserId() == null || loginTicket.getPassword() == null) {
            throw new InvalidArgumentException("Invalid login details.");
        }
    }

    protected String getTicket(Parameters parameters) {
        String alfTicket = parameters.getParameter(PARAM_ALF_TICKET);
        if (StringUtils.isNotEmpty((CharSequence)alfTicket)) {
            return alfTicket;
        }
        String authorization = parameters.getRequest().getHeader(AUTHORIZATION_HEADER);
        if (StringUtils.isEmpty((CharSequence)authorization)) {
            throw new InvalidArgumentException("Authorization header is required.");
        }
        String[] authorizationParts = authorization.split(" ");
        if (authorizationParts[0].equalsIgnoreCase("basic")) {
            String decodedAuthorisation = new String(Base64.decode((String)authorizationParts[1]));
            Authorization authObj = new Authorization(decodedAuthorisation);
            if (!authObj.isTicket()) {
                throw new InvalidArgumentException("Ticket base authentication required.");
            }
            return authObj.getTicket();
        }
        if (authorizationParts[0].equalsIgnoreCase("bearer")) {
            return this.getTicketFromRemoteUserMapperUserId(parameters);
        }
        throw new InvalidArgumentException("Authorization '" + authorizationParts[0] + "' not supported.");
    }

    private String getTicketFromRemoteUserMapperUserId(Parameters parameters) {
        String remoteUser;
        HttpServletRequest httpServletRequest = this.extractHttpServletRequestFromParameters(parameters);
        if (httpServletRequest != null && this.isRemoteUserMapperActive() && (remoteUser = this.remoteUserMapper.getRemoteUser(httpServletRequest)) != null) {
            return this.ticketComponent.getCurrentTicket(remoteUser, false);
        }
        throw new InvalidArgumentException("Can't use Alfresco Identity Services to validate the user in the bearer access token");
    }

    private HttpServletRequest extractHttpServletRequestFromParameters(Parameters parameters) {
        if (parameters.getRequest() instanceof BufferedRequest && ((BufferedRequest)parameters.getRequest()).getNext() instanceof PublicApiTenantWebScriptServletRequest) {
            return ((PublicApiTenantWebScriptServletRequest)((BufferedRequest)parameters.getRequest()).getNext()).getHttpServletRequest();
        }
        return null;
    }

    private boolean isRemoteUserMapperActive() {
        return this.remoteUserMapper instanceof ActivateableBean && ((ActivateableBean)this.remoteUserMapper).isActive();
    }
}

