/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.search.context.SearchRequestContext;
import org.alfresco.rest.api.search.impl.ResultMapper;
import org.alfresco.rest.api.search.impl.SearchMapper;
import org.alfresco.rest.api.search.model.SearchQuery;
import org.alfresco.rest.framework.jacksonextensions.BeanPropertiesFilter;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.tools.ApiAssistant;
import org.alfresco.rest.framework.tools.RecognizedParamsExtractor;
import org.alfresco.rest.framework.tools.RequestReader;
import org.alfresco.rest.framework.tools.ResponseWriter;
import org.alfresco.rest.framework.webscripts.ResourceWebScriptHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class SearchApiWebscript
extends AbstractWebScript
implements RecognizedParamsExtractor,
RequestReader,
ResponseWriter,
InitializingBean {
    private ServiceRegistry serviceRegistry;
    private SearchService searchService;
    private SearchMapper searchMapper;
    private ResultMapper resultMapper;
    protected ApiAssistant assistant;
    protected ResourceWebScriptHelper helper;

    public void afterPropertiesSet() {
        PropertyCheck.mandatory((Object)this, (String)"serviceRegistry", (Object)this.serviceRegistry);
        this.searchService = this.serviceRegistry.getSearchService();
        ParameterCheck.mandatory((String)"assistant", (Object)this.assistant);
        ParameterCheck.mandatory((String)"searchMapper", (Object)this.searchMapper);
        ParameterCheck.mandatory((String)"resultMapper", (Object)this.resultMapper);
    }

    public void execute(WebScriptRequest webScriptRequest, WebScriptResponse webScriptResponse) throws IOException {
        try {
            SearchQuery searchQuery = (SearchQuery)this.extractJsonContent(webScriptRequest, this.assistant.getJsonHelper(), SearchQuery.class);
            Params params = this.getParams(webScriptRequest, searchQuery.getFields(), searchQuery.getInclude(), searchQuery.getPaging());
            SearchRequestContext searchRequestContext = SearchRequestContext.from(searchQuery);
            SearchParameters searchParams = this.searchMapper.toSearchParameters(params, searchQuery, searchRequestContext);
            ResultSet results = this.searchService.query(searchParams);
            CollectionWithPagingInfo<Node> resultJson = this.resultMapper.toCollectionWithPagingInfo(params, searchRequestContext, searchQuery, results);
            Object toRender = this.helper.processAdditionsToTheResponse(null, null, null, params, resultJson);
            this.setResponse(webScriptResponse, DEFAULT_SUCCESS);
            this.renderJsonResponse(webScriptResponse, toRender, this.assistant.getJsonHelper());
        }
        catch (Exception exception) {
            this.renderException(exception, webScriptResponse, this.assistant);
        }
    }

    protected Params getParams(WebScriptRequest webScriptRequest, List<String> fields, List<String> include, Paging paging) {
        if (paging == null) {
            paging = Paging.DEFAULT;
        }
        BeanPropertiesFilter filter = null;
        if (fields != null && !fields.isEmpty()) {
            ArrayList<String> selectList = new ArrayList<String>(fields.size());
            selectList.addAll(fields);
            if (include != null && !include.isEmpty()) {
                selectList.addAll(include);
            }
            filter = this.getFilter("", selectList);
        }
        Params.RecognizedParams recognizedParams = new Params.RecognizedParams(null, paging, filter, null, include, null, null, null, false);
        return Params.valueOf(null, recognizedParams, null, webScriptRequest);
    }

    public void setSearchMapper(SearchMapper searchMapper) {
        this.searchMapper = searchMapper;
    }

    public void setResultMapper(ResultMapper resultMapper) {
        this.resultMapper = resultMapper;
    }

    public void setAssistant(ApiAssistant assistant) {
        this.assistant = assistant;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setHelper(ResourceWebScriptHelper helper) {
        this.helper = helper;
    }
}

