/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.admin;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.Facetable;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.repo.web.scripts.admin.NodeBrowserPost;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.cmr.admin.RepoUsageStatus;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.license.LicenseDescriptor;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.PropertyMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.TestWebScriptServer;

@Category(value={OwnJVMTestsCategory.class})
public class AdminWebScriptTest
extends BaseWebScriptTest {
    private RepoAdminService repoAdminService;
    private DescriptorService descriptorService;
    private PersonService personService;
    private MutableAuthenticationService authenticationService;
    private String admin;
    private String guest;
    private String user1_sysAdmin;
    private String user2;

    protected void setUp() throws Exception {
        super.setUp();
        ApplicationContext ctx = this.getServer().getApplicationContext();
        this.repoAdminService = (RepoAdminService)ctx.getBean("RepoAdminService", RepoAdminService.class);
        this.descriptorService = (DescriptorService)ctx.getBean("DescriptorService", DescriptorService.class);
        this.personService = (PersonService)ctx.getBean("PersonService", PersonService.class);
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("AuthenticationService", MutableAuthenticationService.class);
        AuthorityService authorityService = (AuthorityService)ctx.getBean("AuthorityService", AuthorityService.class);
        this.admin = AuthenticationUtil.getAdminUserName();
        this.guest = AuthenticationUtil.getGuestUserName();
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.admin);
        this.user1_sysAdmin = RandomStringUtils.randomAlphabetic((int)10);
        String user1_password = RandomStringUtils.randomAlphabetic((int)10);
        this.createUser(this.user1_sysAdmin, user1_password);
        authorityService.addAuthority("GROUP_ALFRESCO_SYSTEM_ADMINISTRATORS", this.user1_sysAdmin);
        this.user2 = RandomStringUtils.randomAlphabetic((int)10);
        String user2_password = RandomStringUtils.randomAlphabetic((int)10);
        this.createUser(this.user2, user2_password);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void testGetRestrictions() throws Exception {
        RepoUsage restrictions = this.repoAdminService.getRestrictions();
        String url = "/api/admin/restrictions";
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest(url);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.guest);
        JSONObject json = new JSONObject(response.getContentAsString());
        Long maxUsers = json.isNull("users") ? null : Long.valueOf(json.getLong("users"));
        AdminWebScriptTest.assertEquals((String)"Mismatched max users", (Object)restrictions.getUsers(), (Object)maxUsers);
        Long maxDocuments = json.isNull("documents") ? null : Long.valueOf(json.getLong("documents"));
        AdminWebScriptTest.assertEquals((String)"Mismatched max documents", (Object)restrictions.getDocuments(), (Object)maxDocuments);
    }

    public void testGetUsage() throws Exception {
        RepoUsageStatus usageStatus = this.repoAdminService.getUsageStatus();
        RepoUsage usage = usageStatus.getUsage();
        LicenseDescriptor licenseDescriptor = this.descriptorService.getLicenseDescriptor();
        Date validUntil = licenseDescriptor == null ? null : licenseDescriptor.getValidUntil();
        Integer checkLevel = new Integer(usageStatus.getLevel().ordinal());
        String url = "/api/admin/usage";
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest(url);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.guest);
        System.out.println(response.getContentAsString());
        JSONObject json = new JSONObject(response.getContentAsString());
        Long users = json.isNull("users") ? null : Long.valueOf(json.getLong("users"));
        AdminWebScriptTest.assertEquals((String)"Mismatched users", (Object)usage.getUsers(), (Object)users);
        Long documents = json.isNull("documents") ? null : Long.valueOf(json.getLong("documents"));
        AdminWebScriptTest.assertEquals((String)"Mismatched documents", (Object)usage.getDocuments(), (Object)documents);
        String licenseMode = json.isNull("licenseMode") ? null : json.getString("licenseMode");
        AdminWebScriptTest.assertEquals((String)"Mismatched licenseMode", (String)usage.getLicenseMode().toString(), (String)licenseMode);
        boolean readOnly = json.getBoolean("readOnly");
        AdminWebScriptTest.assertEquals((String)"Mismatched readOnly", (boolean)usage.isReadOnly(), (boolean)readOnly);
        boolean updated = json.getBoolean("updated");
        AdminWebScriptTest.assertEquals((String)"Mismatched updated", (boolean)false, (boolean)updated);
        Long licenseValidUntil = json.isNull("licenseValidUntil") ? null : Long.valueOf(json.getLong("licenseValidUntil"));
        AdminWebScriptTest.assertEquals((String)"Mismatched licenseValidUntil", (Object)(validUntil == null ? null : Long.valueOf(validUntil.getTime())), (Object)licenseValidUntil);
        Integer level = json.isNull("level") ? null : Integer.valueOf(json.getInt("level"));
        AdminWebScriptTest.assertEquals((String)"Mismatched level", (Object)checkLevel, (Object)level);
        json.getJSONArray("warnings");
        json.getJSONArray("errors");
    }

    public void testUpdateUsageWithoutPermissions() throws Exception {
        String url = "/api/admin/usage";
        TestWebScriptServer.PostRequest req = new TestWebScriptServer.PostRequest(url, "", "application/json");
        this.sendRequest((TestWebScriptServer.Request)req, 401, AuthenticationUtil.getGuestRoleName());
    }

    public void testUpdateUsage() throws Exception {
        this.repoAdminService.updateUsage(RepoUsage.UsageType.USAGE_ALL);
        RepoUsage usage = this.repoAdminService.getUsage();
        String url = "/api/admin/usage";
        TestWebScriptServer.PostRequest req = new TestWebScriptServer.PostRequest(url, "", "application/json");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        System.out.println(response.getContentAsString());
        JSONObject json = new JSONObject(response.getContentAsString());
        Long users = json.isNull("users") ? null : Long.valueOf(json.getLong("users"));
        AdminWebScriptTest.assertEquals((String)"Mismatched users", (Object)usage.getUsers(), (Object)users);
        Long documents = json.isNull("documents") ? null : Long.valueOf(json.getLong("documents"));
        AdminWebScriptTest.assertEquals((String)"Mismatched documents", (Object)usage.getDocuments(), (Object)documents);
        String licenseMode = json.isNull("licenseMode") ? null : json.getString("licenseMode");
        AdminWebScriptTest.assertEquals((String)"Mismatched licenseMode", (String)usage.getLicenseMode().toString(), (String)licenseMode);
        boolean readOnly = json.getBoolean("readOnly");
        AdminWebScriptTest.assertEquals((String)"Mismatched readOnly", (boolean)usage.isReadOnly(), (boolean)readOnly);
        boolean updated = json.getBoolean("updated");
        AdminWebScriptTest.assertEquals((String)"Mismatched updated", (boolean)true, (boolean)updated);
    }

    @Test
    public void testResidualProperties() throws Exception {
        NodeBrowserPost nodeBrowserPost = new NodeBrowserPost();
        DictionaryService dictionaryService = (DictionaryService)Mockito.mock(DictionaryService.class);
        NodeService nodeService = (NodeService)Mockito.mock(NodeService.class);
        nodeBrowserPost.setDictionaryService(dictionaryService);
        nodeBrowserPost.setNodeService(nodeService);
        ClassDefinition classDefinition = (ClassDefinition)Mockito.mock(ClassDefinition.class);
        Mockito.when((Object)dictionaryService.getClass((QName)ArgumentMatchers.any())).thenReturn((Object)classDefinition);
        QName qnameResidualFalse1 = QName.createQName((String)"testResidualProperties", (String)"residualFalse1");
        QName qnameResidualFalse2 = QName.createQName((String)"testResidualProperties", (String)"residualFalse2");
        QName qnameResidualTrue1 = QName.createQName((String)"testResidualProperties", (String)"residualTrue1");
        QName qnameResidualTrue2 = QName.createQName((String)"testResidualProperties", (String)"residualTrue2");
        HashMap<QName, SimplePropertyDefinition> properties = new HashMap<QName, SimplePropertyDefinition>();
        properties.put(qnameResidualFalse1, new SimplePropertyDefinition(false));
        properties.put(qnameResidualFalse2, new SimplePropertyDefinition(true));
        Mockito.when((Object)classDefinition.getProperties()).thenReturn(properties);
        Mockito.when((Object)dictionaryService.getProperty((QName)ArgumentMatchers.eq((Object)qnameResidualFalse1))).thenReturn((Object)new SimplePropertyDefinition(false));
        Mockito.when((Object)dictionaryService.getProperty((QName)ArgumentMatchers.eq((Object)qnameResidualFalse2))).thenReturn((Object)new SimplePropertyDefinition(true));
        Mockito.when((Object)dictionaryService.getProperty((QName)ArgumentMatchers.eq((Object)qnameResidualTrue1))).thenReturn((Object)new SimplePropertyDefinition(true));
        Mockito.when((Object)dictionaryService.getProperty((QName)ArgumentMatchers.eq((Object)qnameResidualTrue2))).thenReturn((Object)new SimplePropertyDefinition(false));
        String value = "abc";
        NodeBrowserPost nodeBrowserPost2 = nodeBrowserPost;
        Objects.requireNonNull(nodeBrowserPost2);
        NodeBrowserPost.Property property = new NodeBrowserPost.Property(nodeBrowserPost2, qnameResidualFalse1, (Serializable)((Object)value), null);
        AdminWebScriptTest.assertFalse((boolean)property.getResidual());
        NodeBrowserPost nodeBrowserPost3 = nodeBrowserPost;
        Objects.requireNonNull(nodeBrowserPost3);
        property = new NodeBrowserPost.Property(nodeBrowserPost3, qnameResidualFalse2, (Serializable)((Object)value), null);
        AdminWebScriptTest.assertFalse((boolean)property.getResidual());
        NodeBrowserPost nodeBrowserPost4 = nodeBrowserPost;
        Objects.requireNonNull(nodeBrowserPost4);
        property = new NodeBrowserPost.Property(nodeBrowserPost4, qnameResidualTrue1, (Serializable)((Object)value), null);
        AdminWebScriptTest.assertFalse((boolean)property.getResidual());
        NodeBrowserPost nodeBrowserPost5 = nodeBrowserPost;
        Objects.requireNonNull(nodeBrowserPost5);
        property = new NodeBrowserPost.Property(nodeBrowserPost5, qnameResidualTrue2, (Serializable)((Object)value), null);
        AdminWebScriptTest.assertTrue((boolean)property.getResidual());
    }

    public void testSysAdminAccess() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
        String url = "/admin/admin-communitysummary";
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest(url);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.user1_sysAdmin);
        Document doc = Jsoup.parse((String)response.getContentAsString());
        AdminWebScriptTest.assertNotNull((Object)doc.title());
        AdminWebScriptTest.assertTrue((boolean)doc.title().contains("System Summary"));
        response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        doc = Jsoup.parse((String)response.getContentAsString());
        AdminWebScriptTest.assertNotNull((Object)doc.title());
        AdminWebScriptTest.assertTrue((boolean)doc.title().contains("System Summary"));
    }

    public void testSysAdminAccess_nodeBrowser() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
        String nodeBrowserUrl = "/admin/admin-nodebrowser";
        TestWebScriptServer.GetRequest getReq = new TestWebScriptServer.GetRequest(nodeBrowserUrl);
        this.sendRequest((TestWebScriptServer.Request)getReq, 401, this.user1_sysAdmin);
        TestWebScriptServer.PostRequest postReq = new TestWebScriptServer.PostRequest(nodeBrowserUrl, "", "multipart/form-data; boundary=----WebKitFormBoundaryjacWCXfJ3KjtRenA");
        this.sendRequest((TestWebScriptServer.Request)postReq, 401, this.user1_sysAdmin);
        this.sendRequest((TestWebScriptServer.Request)getReq, 401, this.user2);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)getReq, 200, this.admin);
        Document doc = Jsoup.parse((String)response.getContentAsString());
        AdminWebScriptTest.assertNotNull((Object)doc.title());
        AdminWebScriptTest.assertTrue((boolean)doc.title().contains("Node Browser"));
    }

    public void testSysAdminAccess_repoConsole() throws Exception {
        String repoConsoleUrl = "/admin/admin-repoconsole";
        TestWebScriptServer.GetRequest getReq = new TestWebScriptServer.GetRequest(repoConsoleUrl);
        this.sendRequest((TestWebScriptServer.Request)getReq, 401, this.user1_sysAdmin);
        TestWebScriptServer.PostRequest postReq = new TestWebScriptServer.PostRequest(repoConsoleUrl, "", "multipart/form-data; boundary=----WebKitFormBoundaryjacWCXfJ3KjtRenA");
        this.sendRequest((TestWebScriptServer.Request)postReq, 401, this.user1_sysAdmin);
        this.sendRequest((TestWebScriptServer.Request)getReq, 401, this.user2);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)getReq, 200, this.admin);
        Document doc = Jsoup.parse((String)response.getContentAsString());
        AdminWebScriptTest.assertNotNull((Object)doc.title());
        AdminWebScriptTest.assertTrue((boolean)doc.title().contains("Model and Messages Console"));
    }

    public void testSysAdminAccess_tenantConsole() throws Exception {
        String tenantConsoleUrl = "/admin/admin-tenantconsole";
        TestWebScriptServer.GetRequest getReq = new TestWebScriptServer.GetRequest(tenantConsoleUrl);
        this.sendRequest((TestWebScriptServer.Request)getReq, 401, this.user1_sysAdmin);
        TestWebScriptServer.PostRequest postReq = new TestWebScriptServer.PostRequest(tenantConsoleUrl, "", "multipart/form-data; boundary=----WebKitFormBoundaryjacWCXfJ3KjtRenA");
        this.sendRequest((TestWebScriptServer.Request)postReq, 401, this.user1_sysAdmin);
        this.sendRequest((TestWebScriptServer.Request)getReq, 401, this.user2);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)getReq, 200, this.admin);
        Document doc = Jsoup.parse((String)response.getContentAsString());
        AdminWebScriptTest.assertNotNull((Object)doc.title());
        AdminWebScriptTest.assertTrue((boolean)doc.title().contains("Tenant Admin Console"));
    }

    public void testSysAdminAccess_workflowConsole() throws Exception {
        String workflowConsoleUrl = "/admin/admin-workflowconsole";
        TestWebScriptServer.GetRequest getReq = new TestWebScriptServer.GetRequest(workflowConsoleUrl);
        this.sendRequest((TestWebScriptServer.Request)getReq, 401, this.user1_sysAdmin);
        TestWebScriptServer.PostRequest postReq = new TestWebScriptServer.PostRequest(workflowConsoleUrl, "", "multipart/form-data; boundary=----WebKitFormBoundaryjacWCXfJ3KjtRenA");
        this.sendRequest((TestWebScriptServer.Request)postReq, 401, this.user1_sysAdmin);
        this.sendRequest((TestWebScriptServer.Request)getReq, 401, this.user2);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)getReq, 200, this.admin);
        Document doc = Jsoup.parse((String)response.getContentAsString());
        AdminWebScriptTest.assertNotNull((Object)doc.title());
        AdminWebScriptTest.assertTrue((boolean)doc.title().contains("Workflow Admin Console"));
    }

    public void testNonSysAdminAccess() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
        String url = "/admin/admin-communitysummary";
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest(url);
        this.sendRequest((TestWebScriptServer.Request)req, 401, this.user2);
    }

    private void createUser(String username, String password) {
        if (!this.personService.personExists(username)) {
            this.authenticationService.createAuthentication(username, password.toCharArray());
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)username);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"testFirstName");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"testLastName");
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)(username + "@email.com"));
            this.personService.createPerson((Map)personProps);
        }
    }

    private class SimplePropertyDefinition
    implements PropertyDefinition {
        private boolean isAspect;

        public SimplePropertyDefinition(boolean isAspect) {
            this.isAspect = isAspect;
        }

        public ModelDefinition getModel() {
            return null;
        }

        public QName getName() {
            return null;
        }

        public String getTitle() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public String getTitle(MessageLookup messageLookup) {
            return null;
        }

        public String getTitle(MessageLookup messageLookup, Locale locale) {
            return null;
        }

        public String getDescription(MessageLookup messageLookup) {
            return null;
        }

        public String getDescription(MessageLookup messageLookup, Locale locale) {
            return null;
        }

        public String getDefaultValue() {
            return null;
        }

        public DataTypeDefinition getDataType() {
            DataTypeDefinition dataTypeDefinition = (DataTypeDefinition)Mockito.mock(DataTypeDefinition.class);
            Mockito.when((Object)dataTypeDefinition.getName()).thenReturn((Object)QName.createQName((String)"notImportant"));
            return dataTypeDefinition;
        }

        public ClassDefinition getContainerClass() {
            ClassDefinition classDefinition = (ClassDefinition)Mockito.mock(ClassDefinition.class);
            Mockito.when((Object)classDefinition.isAspect()).thenReturn((Object)this.isAspect);
            return classDefinition;
        }

        public boolean isOverride() {
            return false;
        }

        public boolean isMultiValued() {
            return false;
        }

        public boolean isMandatory() {
            return false;
        }

        public boolean isMandatoryEnforced() {
            return false;
        }

        public boolean isProtected() {
            return false;
        }

        public boolean isIndexed() {
            return false;
        }

        public boolean isStoredInIndex() {
            return false;
        }

        public IndexTokenisationMode getIndexTokenisationMode() {
            return null;
        }

        public Facetable getFacetable() {
            return null;
        }

        public boolean isIndexedAtomically() {
            return false;
        }

        public List<ConstraintDefinition> getConstraints() {
            return null;
        }
    }
}

