/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.links;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.activities.feed.FeedGenerator;
import org.alfresco.repo.activities.post.lookup.PostLookup;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.alfresco.util.ISO8601DateFormat;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class LinksRestApiTest
extends BaseWebScriptTest {
    private static Log logger = LogFactory.getLog(LinksRestApiTest.class);
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private TransactionService transactionService;
    private BehaviourFilter policyBehaviourFilter;
    private PersonService personService;
    private NodeService nodeService;
    private NodeService internalNodeService;
    private SiteService siteService;
    private NodeArchiveService nodeArchiveService;
    private ActivityService activityService;
    private FeedGenerator feedGenerator;
    private PostLookup postLookup;
    private static final String USER_ONE = "UserOneSecondToo";
    private static final String USER_TWO = "UserTwoSecondToo";
    private static final String USERDETAILS_FIRSTNAME = "FirstName123";
    private static final String USERDETAILS_LASTNAME = "LastName123";
    private static final String SITE_SHORT_NAME_LINKS = "LinkSiteShortNameTest";
    private static final String LINK_TITLE_ONE = "TestLinkOne";
    private static final String LINK_TITLE_TWO = "TestLinkTwo";
    private static final String LINK_TITLE_THREE = "StillTestLinkThree";
    private static final String LINK_URL_ONE = "http://google.com/";
    private static final String LINK_URL_TWO = "http://alfresco.com/";
    private static final String LINK_URL_THREE = "http://share.alfresco.com/";
    private static final String URL_LINKS_BASE = "/api/links/site/LinkSiteShortNameTest/links";
    private static final String URL_LINKS_LIST = "/api/links/site/LinkSiteShortNameTest/links";
    private static final String URL_LINKS_CREATE = "/api/links/site/LinkSiteShortNameTest/links/posts";
    private static final String URL_LINKS_UPDATE = "/api/links/site/LinkSiteShortNameTest/links/";
    private static final String URL_LINKS_DELETE = "/api/links/delete/site/LinkSiteShortNameTest/links";
    private static final String URL_LINKS_FETCH = "/api/links/link/site/LinkSiteShortNameTest/links/";
    private static final String URL_DELETE_COMMENT = "api/comment/node/{0}/{1}/{2}?site={3}&itemtitle={4}&page={5}";

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.policyBehaviourFilter = (BehaviourFilter)this.getServer().getApplicationContext().getBean("policyBehaviourFilter");
        this.transactionService = (TransactionService)this.getServer().getApplicationContext().getBean("transactionService");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.siteService = (SiteService)this.getServer().getApplicationContext().getBean("SiteService");
        this.internalNodeService = (NodeService)this.getServer().getApplicationContext().getBean("nodeService");
        this.nodeArchiveService = (NodeArchiveService)this.getServer().getApplicationContext().getBean("nodeArchiveService");
        this.activityService = (ActivityService)this.getServer().getApplicationContext().getBean("activityService");
        ChildApplicationContextFactory activitiesFeed = (ChildApplicationContextFactory)this.getServer().getApplicationContext().getBean("ActivitiesFeed");
        ApplicationContext activitiesFeedCtx = activitiesFeed.getApplicationContext();
        this.feedGenerator = (FeedGenerator)activitiesFeedCtx.getBean("feedGenerator");
        this.postLookup = (PostLookup)activitiesFeedCtx.getBean("postLookup");
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        SiteInfo siteInfo = this.siteService.getSite(SITE_SHORT_NAME_LINKS);
        if (siteInfo == null) {
            this.siteService.createSite("CalendarSitePreset", SITE_SHORT_NAME_LINKS, "LinksSiteTitle", "TestDescription", SiteVisibility.PUBLIC);
        }
        if (!this.siteService.hasContainer(SITE_SHORT_NAME_LINKS, "links")) {
            this.siteService.createContainer(SITE_SHORT_NAME_LINKS, "links", null, null);
        }
        this.createUser(USER_ONE, "SiteCollaborator", SITE_SHORT_NAME_LINKS);
        this.createUser(USER_TWO, "SiteCollaborator", SITE_SHORT_NAME_LINKS);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        SiteInfo siteInfo = this.siteService.getSite(SITE_SHORT_NAME_LINKS);
        if (siteInfo != null) {
            this.siteService.deleteSite(SITE_SHORT_NAME_LINKS);
            this.nodeArchiveService.purgeArchivedNode(this.nodeArchiveService.getArchivedNode(siteInfo.getNodeRef()));
        }
        this.personService.deletePerson(USER_ONE);
        if (this.authenticationService.authenticationExists(USER_ONE)) {
            this.authenticationService.deleteAuthentication(USER_ONE);
        }
        this.personService.deletePerson(USER_TWO);
        if (this.authenticationService.authenticationExists(USER_TWO)) {
            this.authenticationService.deleteAuthentication(USER_TWO);
        }
    }

    private void createUser(String userName, String role, String siteName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)USERDETAILS_FIRSTNAME);
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)USERDETAILS_LASTNAME);
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"FirstName123.LastName123@email.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"JobTitle123");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"Organisation123");
            this.personService.createPerson((Map)personProps);
        }
        this.siteService.setMembership(siteName, userName, role);
    }

    private JSONObject getLinks(String filter, String username) throws Exception {
        String origUser = this.authenticationComponent.getCurrentUserName();
        if (username != null) {
            this.authenticationComponent.setCurrentUser(username);
            filter = "user";
        }
        Object url = "/api/links/site/LinkSiteShortNameTest/links";
        if (filter == null) {
            filter = "all";
        }
        url = (String)url + "?filter=" + filter;
        url = (String)url + "&startIndex=0&page=1&pageSize=4";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest((String)url), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        if (username != null) {
            this.authenticationComponent.setCurrentUser(origUser);
        }
        return result;
    }

    private JSONObject getLink(String name, int expectedStatus) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_LINKS_FETCH + name), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = new JSONObject(response.getContentAsString());
            if (result.has("item")) {
                return result.getJSONObject("item");
            }
            return result;
        }
        return null;
    }

    private JSONObject createLink(String title, String description, String url, boolean internal, int expectedStatus) throws Exception {
        JSONObject json = new JSONObject();
        json.put("site", (Object)SITE_SHORT_NAME_LINKS);
        json.put("title", (Object)title);
        json.put("description", (Object)description);
        json.put("url", (Object)url);
        json.put("tags", (Object)"");
        if (internal) {
            json.put("internal", (Object)"true");
        }
        json.put("page", (Object)"links-view");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_LINKS_CREATE, json.toString(), "application/json"), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = new JSONObject(response.getContentAsString());
            if (result.has("link")) {
                return result.getJSONObject("link");
            }
            return result;
        }
        return null;
    }

    private JSONObject updateLink(String name, String title, String description, String url, boolean internal, int expectedStatus) throws Exception {
        JSONObject json = new JSONObject();
        json.put("site", (Object)SITE_SHORT_NAME_LINKS);
        json.put("title", (Object)title);
        json.put("description", (Object)description);
        json.put("url", (Object)url);
        json.put("tags", (Object)"");
        json.put("internal", (Object)Boolean.toString(internal).toLowerCase());
        json.put("page", (Object)"links-view");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(URL_LINKS_UPDATE + name, json.toString(), "application/json"), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = new JSONObject(response.getContentAsString());
            if (result.has("links")) {
                return result.getJSONObject("links");
            }
            return result;
        }
        return null;
    }

    private JSONObject deleteLink(String name, int expectedStatus) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(URL_LINKS_FETCH + name), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = new JSONObject(response.getContentAsString());
            return result;
        }
        return null;
    }

    private JSONObject deleteLinks(List<String> names, int expectedStatus) throws Exception {
        JSONArray items = new JSONArray();
        for (String name : names) {
            items.put((Object)name);
        }
        JSONObject json = new JSONObject();
        json.put("items", (Object)items);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_LINKS_DELETE, json.toString(), "application/json"), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = new JSONObject(response.getContentAsString());
            return result;
        }
        return null;
    }

    private void pushLinkCreatedDateBack(String name, int daysAgo) throws Exception {
        NodeRef container = this.siteService.getContainer(SITE_SHORT_NAME_LINKS, "links");
        NodeRef node = this.nodeService.getChildByName(container, ContentModel.ASSOC_CONTAINS, name);
        Date created = (Date)this.nodeService.getProperty(node, ContentModel.PROP_CREATED);
        Date newCreated = new Date(created.getTime() - (long)(daysAgo * 24 * 60 * 60 * 1000));
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
        this.internalNodeService.setProperty(node, ContentModel.PROP_CREATED, (Serializable)newCreated);
        this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
        txn.commit();
        this.nodeService.setProperty(node, ContentModel.PROP_CREATED, (Serializable)newCreated);
        this.nodeService.setProperty(node, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"Forced change"));
    }

    private String getNameFromLink(JSONObject link) throws Exception {
        if (!link.has("name")) {
            throw new IllegalArgumentException("No name in " + link.toString());
        }
        return link.getString("name");
    }

    public void testCreateEditDeleteEntry() throws Exception {
        JSONObject link = this.getLinks(null, null);
        LinksRestApiTest.assertEquals((String)("Incorrect JSON: " + link.toString()), (boolean)true, (boolean)link.has("total"));
        LinksRestApiTest.assertEquals((int)0, (int)link.getInt("total"));
        link = this.getLink(LINK_TITLE_ONE, 404);
        link = this.createLink(LINK_TITLE_ONE, "Thing 1", LINK_URL_ONE, false, 200);
        LinksRestApiTest.assertEquals((String)("Incorrect JSON: " + link.toString()), (boolean)true, (boolean)link.has("name"));
        String name = this.getNameFromLink(link);
        LinksRestApiTest.assertEquals((String)name, (String)link.getString("name"));
        LinksRestApiTest.assertEquals((String)name, (String)link.getString("message"));
        link = this.getLink(name, 200);
        LinksRestApiTest.assertEquals((String)("Error found " + link.toString()), (boolean)false, (boolean)link.has("error"));
        LinksRestApiTest.assertEquals((String)LINK_TITLE_ONE, (String)link.getString("title"));
        LinksRestApiTest.assertEquals((String)"Thing 1", (String)link.getString("description"));
        LinksRestApiTest.assertEquals((String)LINK_URL_ONE, (String)link.getString("url"));
        LinksRestApiTest.assertEquals((boolean)false, (boolean)link.getBoolean("internal"));
        LinksRestApiTest.assertEquals((int)0, (int)link.getJSONArray("tags").length());
        LinksRestApiTest.assertEquals((boolean)true, (boolean)link.has("author"));
        JSONObject author = link.getJSONObject("author");
        LinksRestApiTest.assertEquals((String)USER_ONE, (String)author.getString("username"));
        LinksRestApiTest.assertEquals((String)USERDETAILS_FIRSTNAME, (String)author.getString("firstName"));
        LinksRestApiTest.assertEquals((String)USERDETAILS_LASTNAME, (String)author.getString("lastName"));
        LinksRestApiTest.assertEquals((boolean)true, (boolean)link.has("permissions"));
        JSONObject permissions = link.getJSONObject("permissions");
        LinksRestApiTest.assertEquals((boolean)true, (boolean)permissions.getBoolean("edit"));
        LinksRestApiTest.assertEquals((boolean)true, (boolean)permissions.getBoolean("delete"));
        NodeRef nodeRef = new NodeRef(link.getString("nodeRef"));
        LinksRestApiTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(nodeRef));
        LinksRestApiTest.assertEquals((Object)name, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
        LinksRestApiTest.assertEquals((String)("/node/workspace/" + nodeRef.getStoreRef().getIdentifier() + "/" + nodeRef.getId() + "/comments"), (String)link.getString("commentsUrl"));
        LinksRestApiTest.assertEquals((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CREATED), (Object)ISO8601DateFormat.parse((String)link.getJSONObject("createdOnDate").getString("iso8601")));
        link = this.updateLink(name, LINK_TITLE_ONE, "More Thing 1", LINK_URL_ONE, true, 200);
        LinksRestApiTest.assertEquals((String)("Incorrect JSON: " + link.toString()), (boolean)true, (boolean)link.has("message"));
        LinksRestApiTest.assertEquals((String)("Incorrect JSON: " + link.toString()), (boolean)true, (boolean)link.getString("message").contains("updated"));
        link = this.getLink(name, 200);
        LinksRestApiTest.assertEquals((String)("Error found " + link.toString()), (boolean)false, (boolean)link.has("error"));
        LinksRestApiTest.assertEquals((String)LINK_TITLE_ONE, (String)link.getString("title"));
        LinksRestApiTest.assertEquals((String)"More Thing 1", (String)link.getString("description"));
        LinksRestApiTest.assertEquals((String)LINK_URL_ONE, (String)link.getString("url"));
        LinksRestApiTest.assertEquals((boolean)true, (boolean)link.getBoolean("internal"));
        LinksRestApiTest.assertEquals((int)0, (int)link.getJSONArray("tags").length());
        LinksRestApiTest.assertEquals((boolean)true, (boolean)link.has("author"));
        author = link.getJSONObject("author");
        LinksRestApiTest.assertEquals((String)USER_ONE, (String)author.getString("username"));
        LinksRestApiTest.assertEquals((String)USERDETAILS_FIRSTNAME, (String)author.getString("firstName"));
        LinksRestApiTest.assertEquals((String)USERDETAILS_LASTNAME, (String)author.getString("lastName"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        link = this.getLink(name, 200);
        LinksRestApiTest.assertEquals((String)LINK_TITLE_ONE, (String)link.getString("title"));
        LinksRestApiTest.assertEquals((String)"More Thing 1", (String)link.getString("description"));
        LinksRestApiTest.assertEquals((String)LINK_URL_ONE, (String)link.getString("url"));
        LinksRestApiTest.assertEquals((boolean)true, (boolean)link.getBoolean("internal"));
        LinksRestApiTest.assertEquals((int)0, (int)link.getJSONArray("tags").length());
        LinksRestApiTest.assertEquals((boolean)true, (boolean)link.has("permissions"));
        permissions = link.getJSONObject("permissions");
        LinksRestApiTest.assertEquals((boolean)true, (boolean)permissions.getBoolean("edit"));
        LinksRestApiTest.assertEquals((boolean)false, (boolean)permissions.getBoolean("delete"));
        this.authenticationComponent.setCurrentUser(USER_ONE);
        link = this.deleteLinks(Arrays.asList(name), 200);
        LinksRestApiTest.assertEquals((String)("Incorrect JSON: " + link.toString()), (boolean)true, (boolean)link.has("message"));
        LinksRestApiTest.assertEquals((String)("Incorrect JSON: " + link.toString()), (boolean)true, (boolean)link.getString("message").contains("deleted"));
        link = this.getLink(name, 404);
        this.deleteLinks(Arrays.asList(name), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(URL_LINKS_UPDATE + name, "{}", "application/json"), 404);
        link = this.createLink(LINK_TITLE_ONE, "Thing 1", LINK_URL_ONE, false, 200);
        name = this.getNameFromLink(link);
        this.getLink(name, 200);
        this.deleteLink(name, 204);
        this.getLink(name, 404);
        this.deleteLink(name, 404);
    }

    public void testXssLinks() throws Exception {
        String LINK_TITLE = "lnk" + System.currentTimeMillis();
        String LINK_URL = "http://alfresco.com";
        HashMap<String, Integer> mapForCheck = new HashMap<String, Integer>();
        mapForCheck.put("http:javasc\\ript:alert('mail.ru')", 400);
        mapForCheck.put("javas\\0cr\\ip\\00t:alert('dd')", 400);
        mapForCheck.put("alfresco.my", 200);
        mapForCheck.put("javascript:alert('http://somedata.html')", 400);
        mapForCheck.put("http://alfresco.org", 200);
        mapForCheck.put("localhost:8080", 200);
        mapForCheck.put("localhost:8080/share", 200);
        mapForCheck.put("localhost:80A80/share", 400);
        mapForCheck.put("http:java\\00script:alert('XSS')", 400);
        mapForCheck.put("http:javas\\0cript:alert('XSS')", 400);
        mapForCheck.put("http: &#14;  javascript:alert('XSS')", 400);
        mapForCheck.put("<SCRIPT/XSS SRC='http://ha.ckers.org/xss.js'></SCRIPT>", 400);
        mapForCheck.put("<iframe src=http://ha.ckers.org/scriptlet.html <", 400);
        mapForCheck.put("html:vbscript:msgbox(\"XSS\")", 400);
        mapForCheck.put("<STYLE>@im\\port'\\ja\\vasc\\ript:alert(\"XSS\")';</STYLE>", 400);
        mapForCheck.put("<IMG SRC= onmouseover=\"alert('xxs')\">", 400);
        mapForCheck.put("BODY onload!#$%&()*~+-_.,:;?@[/|\\]^`=alert(\"XSS\")>", 400);
        mapForCheck.put("onload54(dd)fg`=df", 400);
        JSONObject link = this.createLink(LINK_TITLE, "Link desc", LINK_URL, false, 200);
        String name = this.getNameFromLink(link);
        for (String url : mapForCheck.keySet()) {
            int expStatus = (Integer)mapForCheck.get(url);
            this.updateLink(name, LINK_TITLE, "Link desc", url, false, expStatus);
        }
    }

    public void testOverallListing() throws Exception {
        JSONObject links = this.getLinks(null, null);
        LinksRestApiTest.assertEquals((String)("Incorrect JSON: " + links.toString()), (boolean)true, (boolean)links.has("total"));
        LinksRestApiTest.assertEquals((int)0, (int)links.getInt("total"));
        LinksRestApiTest.assertEquals((int)0, (int)links.getInt("itemCount"));
        this.createLink(LINK_TITLE_ONE, "Thing 1", LINK_URL_ONE, false, 200);
        this.createLink(LINK_TITLE_TWO, "Thing 2", LINK_URL_TWO, false, 200);
        links = this.getLinks(null, null);
        LinksRestApiTest.assertEquals((String)("Incorrect JSON: " + links.toString()), (boolean)true, (boolean)links.has("total"));
        LinksRestApiTest.assertEquals((int)2, (int)links.getInt("total"));
        LinksRestApiTest.assertEquals((int)2, (int)links.getInt("itemCount"));
        JSONArray entries = links.getJSONArray("items");
        LinksRestApiTest.assertEquals((int)2, (int)entries.length());
        LinksRestApiTest.assertEquals((String)LINK_TITLE_TWO, (String)entries.getJSONObject(0).getString("title"));
        LinksRestApiTest.assertEquals((String)LINK_TITLE_ONE, (String)entries.getJSONObject(1).getString("title"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        JSONObject link3 = this.createLink(LINK_TITLE_THREE, "Thing 3", LINK_URL_THREE, true, 200);
        String name3 = this.getNameFromLink(link3);
        this.updateLink(name3, LINK_TITLE_THREE, "More Where 3", LINK_URL_THREE, false, 200);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        links = this.getLinks(null, null);
        LinksRestApiTest.assertEquals((int)3, (int)links.getInt("total"));
        LinksRestApiTest.assertEquals((int)3, (int)links.getInt("itemCount"));
        entries = links.getJSONArray("items");
        LinksRestApiTest.assertEquals((int)3, (int)entries.length());
        LinksRestApiTest.assertEquals((String)LINK_TITLE_THREE, (String)entries.getJSONObject(0).getString("title"));
        LinksRestApiTest.assertEquals((String)LINK_TITLE_TWO, (String)entries.getJSONObject(1).getString("title"));
        LinksRestApiTest.assertEquals((String)LINK_TITLE_ONE, (String)entries.getJSONObject(2).getString("title"));
        links = this.getLinks(null, USER_ONE);
        LinksRestApiTest.assertEquals((int)2, (int)links.getInt("total"));
        LinksRestApiTest.assertEquals((int)2, (int)links.getInt("itemCount"));
        entries = links.getJSONArray("items");
        LinksRestApiTest.assertEquals((int)2, (int)entries.length());
        LinksRestApiTest.assertEquals((String)LINK_TITLE_TWO, (String)entries.getJSONObject(0).getString("title"));
        LinksRestApiTest.assertEquals((String)LINK_TITLE_ONE, (String)entries.getJSONObject(1).getString("title"));
        links = this.getLinks(null, USER_TWO);
        LinksRestApiTest.assertEquals((int)1, (int)links.getInt("total"));
        LinksRestApiTest.assertEquals((int)1, (int)links.getInt("itemCount"));
        entries = links.getJSONArray("items");
        LinksRestApiTest.assertEquals((int)1, (int)entries.length());
        LinksRestApiTest.assertEquals((String)LINK_TITLE_THREE, (String)entries.getJSONObject(0).getString("title"));
        links = this.getLinks("recent", null);
        LinksRestApiTest.assertEquals((int)3, (int)links.getInt("total"));
        LinksRestApiTest.assertEquals((int)3, (int)links.getInt("itemCount"));
        entries = links.getJSONArray("items");
        LinksRestApiTest.assertEquals((int)3, (int)entries.length());
        LinksRestApiTest.assertEquals((String)LINK_TITLE_THREE, (String)entries.getJSONObject(0).getString("title"));
        LinksRestApiTest.assertEquals((String)LINK_TITLE_TWO, (String)entries.getJSONObject(1).getString("title"));
        LinksRestApiTest.assertEquals((String)LINK_TITLE_ONE, (String)entries.getJSONObject(2).getString("title"));
        this.pushLinkCreatedDateBack(name3, 10);
        links = this.getLinks("recent", null);
        LinksRestApiTest.assertEquals((int)2, (int)links.getInt("total"));
        LinksRestApiTest.assertEquals((int)2, (int)links.getInt("itemCount"));
        entries = links.getJSONArray("items");
        LinksRestApiTest.assertEquals((int)2, (int)entries.length());
        LinksRestApiTest.assertEquals((String)LINK_TITLE_TWO, (String)entries.getJSONObject(0).getString("title"));
        LinksRestApiTest.assertEquals((String)LINK_TITLE_ONE, (String)entries.getJSONObject(1).getString("title"));
        this.createLink("StillTestLinkThreea", "Thing 4", LINK_URL_THREE, true, 200);
        this.createLink("StillTestLinkThreez", "Thing 5", LINK_URL_THREE, true, 200);
        links = this.getLinks(null, null);
        LinksRestApiTest.assertEquals((int)5, (int)links.getInt("total"));
        LinksRestApiTest.assertEquals((int)4, (int)links.getInt("itemCount"));
        entries = links.getJSONArray("items");
        LinksRestApiTest.assertEquals((int)4, (int)entries.length());
        LinksRestApiTest.assertEquals((String)"StillTestLinkThreez", (String)entries.getJSONObject(0).getString("title"));
        LinksRestApiTest.assertEquals((String)"StillTestLinkThreea", (String)entries.getJSONObject(1).getString("title"));
        LinksRestApiTest.assertEquals((String)LINK_TITLE_TWO, (String)entries.getJSONObject(2).getString("title"));
        LinksRestApiTest.assertEquals((String)LINK_TITLE_ONE, (String)entries.getJSONObject(3).getString("title"));
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        SiteInfo site = this.siteService.getSite(SITE_SHORT_NAME_LINKS);
        site.setVisibility(SiteVisibility.PRIVATE);
        this.siteService.updateSite(site);
        this.siteService.removeMembership(SITE_SHORT_NAME_LINKS, USER_ONE);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/links/site/LinkSiteShortNameTest/links"), 404);
    }

    public void testCreateLinkPermission() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String siteName = SITE_SHORT_NAME_LINKS + GUID.generate();
        this.siteService.createSite("LinkSitePreset", siteName, "SiteTitle", "SiteDescription", SiteVisibility.PUBLIC);
        String userName = USER_ONE + GUID.generate();
        this.createUser(userName, "SiteCollaborator", siteName);
        this.checkLinkPermissions(siteName);
        this.authenticationComponent.setCurrentUser(userName);
        this.checkLinkPermissions(siteName);
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.siteService.deleteSite(siteName);
        this.authenticationComponent.setCurrentUser(userName);
        siteName = SITE_SHORT_NAME_LINKS + GUID.generate();
        this.siteService.createSite("LinkSitePreset", siteName, "SiteTitle", "SiteDescription", SiteVisibility.PUBLIC);
        this.checkLinkPermissions(siteName);
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.checkLinkPermissions(siteName);
        this.siteService.deleteSite(siteName);
        this.personService.deletePerson(userName);
    }

    private void checkLinkPermissions(String siteName) throws Exception {
        String url = "/api/links/site/" + siteName + "/links";
        url = url + "?filter=all";
        url = url + "&startIndex=0&page=1&pageSize=4";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        LinksRestApiTest.assertTrue((String)"The user sould have permission to create a new link.", (boolean)result.getJSONObject("metadata").getJSONObject("linkPermissions").getBoolean("create"));
    }

    public void testCommentLink() throws Exception {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        JSONObject link = this.createLink(LINK_TITLE_ONE, "commented link", LINK_URL_ONE, false, 200);
        this.postLookup.execute();
        this.feedGenerator.execute();
        int activityNumStart = this.activityService.getSiteFeedEntries(SITE_SHORT_NAME_LINKS).size();
        String name = this.getNameFromLink(link);
        link = this.getLink(name, 200);
        String nodeRef = link.getString("nodeRef");
        JSONObject commentOne = this.createComment(nodeRef, "comment", "content", 200);
        this.postLookup.execute();
        this.feedGenerator.execute();
        int activityNumNext = this.activityService.getSiteFeedEntries(SITE_SHORT_NAME_LINKS).size();
        LinksRestApiTest.assertEquals((String)"The activity feeds were not generated after adding a comment", (int)(activityNumStart + 1), (int)activityNumNext);
        activityNumStart = activityNumNext;
        NodeRef commentNodeRef = new NodeRef(commentOne.getString("nodeRef"));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(this.getDeleteCommentUrl(commentNodeRef)), 200);
        this.postLookup.execute();
        this.feedGenerator.execute();
        activityNumNext = this.activityService.getSiteFeedEntries(SITE_SHORT_NAME_LINKS).size();
        LinksRestApiTest.assertEquals((String)"The activity feeds were not generated after deleting a comment", (int)(activityNumStart + 1), (int)activityNumNext);
    }

    private JSONObject createComment(String nodeRef, String title, String content, int expectedStatus) throws Exception {
        JSONObject comment = new JSONObject();
        comment.put("title", (Object)title);
        comment.put("content", (Object)content);
        comment.put("site", (Object)SITE_SHORT_NAME_LINKS);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.getCommentsUrl(nodeRef), comment.toString(), "application/json"), expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        return result.getJSONObject("item");
    }

    private String getCommentsUrl(String nodeRef) {
        return "/api/node/" + nodeRef.replace("://", "/") + "/comments";
    }

    private String getCommentUrl(String nodeRef) {
        return "/api/comment/node/" + nodeRef.replace("://", "/");
    }

    private String getDeleteCommentUrl(NodeRef commentNodeRef) {
        String itemTitle = "Test Title";
        String page = "document-details";
        String URL2 = MessageFormat.format(URL_DELETE_COMMENT, commentNodeRef.getStoreRef().getProtocol(), commentNodeRef.getStoreRef().getIdentifier(), commentNodeRef.getId(), SITE_SHORT_NAME_LINKS, itemTitle, page);
        return URL2;
    }
}

