/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.io.File;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.repo.quickshare.QuickShareLinkExpiryActionImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.service.ServiceDescriptorRegistry;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.impl.QuickShareLinksImpl;
import org.alfresco.rest.api.model.LockInfo;
import org.alfresco.rest.api.model.NodePermissions;
import org.alfresco.rest.api.model.PathInfo;
import org.alfresco.rest.api.model.QuickShareLink;
import org.alfresco.rest.api.model.Site;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.api.quicksharelinks.QuickShareLinkEntityResource;
import org.alfresco.rest.api.tests.AbstractBaseApiTest;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.Document;
import org.alfresco.rest.api.tests.client.data.Favourite;
import org.alfresco.rest.api.tests.client.data.FavouriteDocument;
import org.alfresco.rest.api.tests.client.data.FavouritesTarget;
import org.alfresco.rest.api.tests.client.data.FileFavouriteTarget;
import org.alfresco.rest.api.tests.client.data.Folder;
import org.alfresco.rest.api.tests.client.data.Node;
import org.alfresco.rest.api.tests.client.data.QuickShareLinkEmailRequest;
import org.alfresco.rest.api.tests.client.data.Rendition;
import org.alfresco.rest.api.tests.client.data.UserInfo;
import org.alfresco.rest.api.tests.util.MultiPartBuilder;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedActionService;
import org.alfresco.service.cmr.quickshare.QuickShareLinkExpiryAction;
import org.alfresco.service.cmr.quickshare.QuickShareLinkExpiryActionPersister;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@Category(value={LuceneTests.class})
public class SharedLinkApiTest
extends AbstractBaseApiTest {
    private static final String URL_SHARED_LINKS = "shared-links";
    private QuickShareLinkExpiryActionPersister quickShareLinkExpiryActionPersister;
    private ScheduledPersistedActionService scheduledPersistedActionService;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.quickShareLinkExpiryActionPersister = (QuickShareLinkExpiryActionPersister)this.applicationContext.getBean("quickShareLinkExpiryActionPersister", QuickShareLinkExpiryActionPersister.class);
        this.scheduledPersistedActionService = (ScheduledPersistedActionService)this.applicationContext.getBean("scheduledPersistedActionService", ScheduledPersistedActionService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedLinkCreateGetDelete() throws Exception {
        this.setRequestContext(user1);
        String sharedFolderNodeId = this.getSharedNodeId();
        String fileName1 = "quick" + this.RUNID + "_1.pdf";
        File file1 = this.getResourceFile("quick.pdf");
        byte[] file1_originalBytes = Files.readAllBytes(Paths.get(file1.getAbsolutePath(), new String[0]));
        String file1_MimeType = "application/pdf";
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName1, file1, file1_MimeType));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        HttpResponse response = this.post(this.getNodeChildrenUrl(sharedFolderNodeId), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document doc1 = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String d1Id = doc1.getId();
        String myFolderNodeId = this.getMyNodeId();
        String content2Text = "The quick brown fox jumps over the lazy dog 2.";
        String fileName2 = "content" + this.RUNID + "_2.txt";
        Document doc2 = this.createTextFile(myFolderNodeId, fileName2, content2Text);
        String d2Id = doc2.getId();
        String file2_MimeType = "text/plain";
        this.setRequestContext(user2);
        response = this.getSingle(NodesEntityResource.class, d1Id, null, 200);
        Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Date docModifiedAt = nodeResp.getModifiedAt();
        String docModifiedBy = nodeResp.getModifiedByUser().getId();
        Assert.assertEquals((Object)user1, (Object)docModifiedBy);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("nodeId", d1Id);
        Thread.sleep(3000L);
        response = this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 201);
        QuickShareLink resp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        String shared1Id = resp.getId();
        Assert.assertNotNull((Object)shared1Id);
        Assert.assertEquals((Object)d1Id, (Object)resp.getNodeId());
        Assert.assertEquals((Object)fileName1, (Object)resp.getName());
        Assert.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)resp.getTitle());
        Assert.assertEquals((Object)"Pangram, fox, dog, Gym class featuring a brown fox and lazy dog", (Object)resp.getDescription());
        Assert.assertEquals((Object)file1_MimeType, (Object)resp.getContent().getMimeType());
        Assert.assertEquals((Object)"Adobe PDF Document", (Object)resp.getContent().getMimeTypeName());
        Assert.assertEquals((Object)new Long(file1_originalBytes.length), (Object)resp.getContent().getSizeInBytes());
        Assert.assertEquals((Object)"UTF-8", (Object)resp.getContent().getEncoding());
        Assert.assertEquals((Object)docModifiedBy, (Object)resp.getModifiedByUser().getId());
        Assert.assertEquals((Object)UserInfo.getTestDisplayName(docModifiedBy), (Object)resp.getModifiedByUser().getDisplayName());
        Assert.assertEquals((Object)user2, (Object)resp.getSharedByUser().getId());
        Assert.assertEquals((Object)UserInfo.getTestDisplayName(user2), (Object)resp.getSharedByUser().getDisplayName());
        this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 409);
        this.setRequestContext(user1);
        body = new HashMap();
        body.put("nodeId", d2Id);
        response = this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 201);
        resp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        String shared2Id = resp.getId();
        Map<String, String> params = Collections.singletonMap("include", "allowableOperations");
        response = this.getSingle(QuickShareLinkEntityResource.class, shared1Id, params, 200);
        resp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((Object)shared1Id, (Object)resp.getId());
        Assert.assertEquals((Object)fileName1, (Object)resp.getName());
        Assert.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)resp.getTitle());
        Assert.assertEquals((Object)"Pangram, fox, dog, Gym class featuring a brown fox and lazy dog", (Object)resp.getDescription());
        Assert.assertEquals((Object)d1Id, (Object)resp.getNodeId());
        Assert.assertNull((Object)resp.getAllowableOperations());
        Assert.assertNull((Object)resp.getAllowableOperationsOnTarget());
        Assert.assertNull((Object)resp.getModifiedByUser().getId());
        Assert.assertEquals((Object)UserInfo.getTestDisplayName(user1), (Object)resp.getModifiedByUser().getDisplayName());
        Assert.assertNull((Object)resp.getSharedByUser().getId());
        Assert.assertEquals((Object)UserInfo.getTestDisplayName(user2), (Object)resp.getSharedByUser().getDisplayName());
        params = Collections.singletonMap("include", "allowableOperations");
        response = this.getSingle(QuickShareLinkEntityResource.class, shared1Id, params, 200);
        resp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((Object)shared1Id, (Object)resp.getId());
        Assert.assertEquals((Object)fileName1, (Object)resp.getName());
        Assert.assertEquals((Object)d1Id, (Object)resp.getNodeId());
        Assert.assertNull((Object)resp.getAllowableOperations());
        Assert.assertNull((Object)resp.getAllowableOperationsOnTarget());
        Assert.assertNull((Object)resp.getModifiedByUser().getId());
        Assert.assertEquals((Object)UserInfo.getTestDisplayName(user1), (Object)resp.getModifiedByUser().getDisplayName());
        Assert.assertNull((Object)resp.getSharedByUser().getId());
        Assert.assertEquals((Object)UserInfo.getTestDisplayName(user2), (Object)resp.getSharedByUser().getDisplayName());
        response = this.getSingle(QuickShareLinkEntityResource.class, shared1Id, null, 200);
        resp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertNull((Object)resp.getAllowableOperations());
        Assert.assertNull((Object)resp.getAllowableOperationsOnTarget());
        this.setRequestContext(null);
        params = Collections.singletonMap("include", "allowableOperations");
        response = this.getSingle(QuickShareLinkEntityResource.class, shared1Id, params, 200);
        resp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((Object)shared1Id, (Object)resp.getId());
        Assert.assertEquals((Object)fileName1, (Object)resp.getName());
        Assert.assertEquals((Object)d1Id, (Object)resp.getNodeId());
        Assert.assertNull((Object)resp.getAllowableOperations());
        Assert.assertNull((Object)resp.getAllowableOperationsOnTarget());
        Assert.assertNull((Object)resp.getModifiedByUser().getId());
        Assert.assertEquals((Object)UserInfo.getTestDisplayName(user1), (Object)resp.getModifiedByUser().getDisplayName());
        Assert.assertNull((Object)resp.getSharedByUser().getId());
        Assert.assertEquals((Object)UserInfo.getTestDisplayName(user2), (Object)resp.getSharedByUser().getDisplayName());
        response = this.getSingle(QuickShareLinkEntityResource.class, shared1Id + "/content", null, 200);
        Assert.assertArrayEquals((byte[])file1_originalBytes, (byte[])response.getResponseAsBytes());
        Map<String, String> responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        Assert.assertEquals((Object)(file1_MimeType + ";charset=utf-8"), (Object)responseHeaders.get("Content-Type"));
        Assert.assertNotNull((Object)responseHeaders.get("Expires"));
        Assert.assertEquals((Object)("attachment; filename=\"" + fileName1 + "\"; filename*=UTF-8''" + fileName1), (Object)responseHeaders.get("Content-Disposition"));
        String lastModifiedHeader = responseHeaders.get("Last-Modified");
        Assert.assertNotNull((Object)lastModifiedHeader);
        Map<String, String> headers = Collections.singletonMap("If-Modified-Since", lastModifiedHeader);
        this.getSingle(URL_SHARED_LINKS, shared1Id + "/content", null, headers, 304);
        params = new HashMap<String, String>();
        params.put("attachment", "false");
        response = this.getSingle(QuickShareLinkEntityResource.class, shared1Id + "/content", params, 200);
        Assert.assertArrayEquals((byte[])file1_originalBytes, (byte[])response.getResponseAsBytes());
        responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        Assert.assertEquals((Object)(file1_MimeType + ";charset=utf-8"), (Object)responseHeaders.get("Content-Type"));
        Assert.assertNotNull((Object)responseHeaders.get("Last-Modified"));
        Assert.assertNotNull((Object)responseHeaders.get("Expires"));
        Assert.assertNull((Object)responseHeaders.get("Content-Disposition"));
        response = this.getSingle(QuickShareLinkEntityResource.class, shared2Id + "/content", null, 200);
        Assert.assertArrayEquals((byte[])content2Text.getBytes(), (byte[])response.getResponseAsBytes());
        responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        Assert.assertEquals((Object)(file2_MimeType + ";charset=iso-8859-1"), (Object)responseHeaders.get("Content-Type"));
        Assert.assertNotNull((Object)responseHeaders.get("Expires"));
        Assert.assertNotNull((Object)responseHeaders.get("Last-Modified"));
        Assert.assertEquals((Object)("attachment; filename=\"" + fileName2 + "\"; filename*=UTF-8''" + fileName2), (Object)responseHeaders.get("Content-Disposition"));
        params = new HashMap<String, String>();
        params.put("attachment", "false");
        response = this.getSingle(QuickShareLinkEntityResource.class, shared2Id + "/content", params, 200);
        Assert.assertEquals((Object)("attachment; filename=\"" + fileName2 + "\"; filename*=UTF-8''" + fileName2), (Object)response.getHeaders().get("Content-Disposition"));
        this.getSingle(QuickShareLinkEntityResource.class, shared1Id + "/renditions/doclib/content", null, 404);
        this.getSingle(QuickShareLinkEntityResource.class, shared1Id + "/renditions/dummy/content", null, 404);
        this.getSingle(QuickShareLinkEntityResource.class, shared1Id + "/renditions/doclib", null, 404);
        this.getSingle(QuickShareLinkEntityResource.class, shared1Id + "/renditions/dummy", null, 404);
        response = this.getAll("shared-links/" + shared1Id + "/renditions", null, 200);
        List<Rendition> renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertEquals((long)0L, (long)renditions.size());
        this.setRequestContext(user2);
        Rendition rendition = this.createAndGetRendition(d1Id, "doclib");
        Assert.assertNotNull((Object)rendition);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.CREATED), (Object)((Object)rendition.getStatus()));
        this.setRequestContext(null);
        response = this.getAll("shared-links/" + shared1Id + "/renditions", null, 200);
        renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertEquals((long)1L, (long)renditions.size());
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.CREATED), (Object)((Object)renditions.get(0).getStatus()));
        Assert.assertEquals((Object)"doclib", (Object)renditions.get(0).getId());
        this.getSingle(QuickShareLinkEntityResource.class, shared1Id + "/renditions/doclib", null, 200);
        response = this.getSingle(QuickShareLinkEntityResource.class, shared1Id + "/renditions/doclib/content", null, 200);
        Assert.assertTrue((response.getResponseAsBytes().length > 0 ? 1 : 0) != 0);
        responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        Assert.assertEquals((Object)"image/png;charset=utf-8", (Object)responseHeaders.get("Content-Type"));
        Assert.assertNotNull((Object)responseHeaders.get("Last-Modified"));
        Assert.assertNotNull((Object)responseHeaders.get("Expires"));
        String docName = "doclib";
        Assert.assertEquals((Object)("attachment; filename=\"" + docName + "\"; filename*=UTF-8''" + docName), (Object)responseHeaders.get("Content-Disposition"));
        params = new HashMap<String, String>();
        params.put("attachment", "false");
        response = this.getSingle(QuickShareLinkEntityResource.class, shared1Id + "/renditions/doclib/content", params, 200);
        Assert.assertTrue((response.getResponseAsBytes().length > 0 ? 1 : 0) != 0);
        responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        Assert.assertEquals((Object)"image/png;charset=utf-8", (Object)responseHeaders.get("Content-Type"));
        Assert.assertNotNull((Object)responseHeaders.get("Expires"));
        Assert.assertNull((Object)responseHeaders.get("Content-Disposition"));
        lastModifiedHeader = responseHeaders.get("Last-Modified");
        Assert.assertNotNull((Object)lastModifiedHeader);
        headers = Collections.singletonMap("If-Modified-Since", lastModifiedHeader);
        this.getSingle(URL_SHARED_LINKS, shared1Id + "/renditions/doclib/content", null, headers, 304);
        this.setRequestContext(null);
        this.deleteSharedLink(shared1Id, 401);
        this.setRequestContext(user1);
        this.deleteSharedLink(shared1Id, 403);
        this.deleteSharedLink("dummy", 404);
        body = new HashMap();
        body.put("nodeId", d1Id);
        this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 409);
        body = new HashMap();
        this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 400);
        body = new HashMap();
        body.put("nodeId", "dummy");
        this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 404);
        String f1Id = this.createFolder(myFolderNodeId, "f1 " + this.RUNID).getId();
        body = new HashMap();
        body.put("nodeId", f1Id);
        this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 400);
        this.setRequestContext(user2);
        body = new HashMap();
        body.put("nodeId", d2Id);
        this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 403);
        this.setRequestContext(null);
        body = new HashMap();
        body.put("nodeId", d1Id);
        this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 401);
        this.setRequestContext(user2);
        this.deleteSharedLink(shared1Id);
        this.setRequestContext(user1);
        this.deleteSharedLink(shared1Id, 404);
        this.setRequestContext(user2);
        response = this.getSingle(NodesEntityResource.class, d1Id, null, 200);
        nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertEquals((Object)docModifiedBy, (Object)nodeResp.getModifiedByUser().getId());
        this.getSingle(QuickShareLinkEntityResource.class, shared1Id, null, 404);
        this.getSingle(QuickShareLinkEntityResource.class, shared1Id + "/content", null, 404);
        this.getSingle(QuickShareLinkEntityResource.class, "dummy", null, 404);
        this.getSingle(QuickShareLinkEntityResource.class, "dummy/content", null, 404);
        QuickShareLinksImpl quickShareLinks = (QuickShareLinksImpl)this.applicationContext.getBean("quickShareLinks", QuickShareLinksImpl.class);
        try {
            quickShareLinks.setEnabled(false);
            this.setRequestContext(user1);
            body.put("nodeId", "dummy");
            this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 501);
            this.setRequestContext(null);
            this.getSingle(QuickShareLinkEntityResource.class, "dummy", null, 501);
            this.getSingle(QuickShareLinkEntityResource.class, "dummy/content", null, 501);
            this.setRequestContext(user1);
            this.deleteSharedLink("dummy", 501);
        }
        finally {
            quickShareLinks.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Category(value={LuceneTests.class, RedundantTests.class})
    public void testSharedLinkFind() throws Exception {
        this.setRequestContext(user1);
        PublicApiClient.Paging paging = this.getPaging(0, 100);
        HttpResponse response = this.getAll(URL_SHARED_LINKS, paging, 200);
        List<QuickShareLink> sharedLinks = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((long)0L, (long)sharedLinks.size());
        String myFolderNodeId = this.getMyNodeId();
        String content1Text = "The quick brown fox jumps over the lazy dog 1.";
        String docName1 = "content" + this.RUNID + "_1.txt";
        Document doc1 = this.createTextFile(myFolderNodeId, docName1, content1Text);
        String d1Id = doc1.getId();
        String sharedFolderNodeId = this.getSharedNodeId();
        String docName2 = "content" + this.RUNID + "_2.txt";
        Document doc2 = this.createTextFile(sharedFolderNodeId, docName2, content1Text);
        String d2Id = doc2.getId();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("nodeId", d1Id);
        response = this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 201);
        QuickShareLink resp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        String shared1Id = resp.getId();
        this.setRequestContext(user2);
        body = new HashMap();
        body.put("nodeId", d2Id);
        response = this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 201);
        resp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        String shared2Id = resp.getId();
        this.setRequestContext(user1);
        response = this.getAll(URL_SHARED_LINKS, paging, 200);
        sharedLinks = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((long)2L, (long)sharedLinks.size());
        Assert.assertEquals((Object)shared2Id, (Object)sharedLinks.get(0).getId());
        Assert.assertEquals((Object)d2Id, (Object)sharedLinks.get(0).getNodeId());
        Assert.assertEquals((Object)shared1Id, (Object)sharedLinks.get(1).getId());
        Assert.assertEquals((Object)d1Id, (Object)sharedLinks.get(1).getNodeId());
        this.setRequestContext(user2);
        response = this.getAll(URL_SHARED_LINKS, paging, 200);
        sharedLinks = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((long)1L, (long)sharedLinks.size());
        Assert.assertEquals((Object)shared2Id, (Object)sharedLinks.get(0).getId());
        Assert.assertEquals((Object)d2Id, (Object)sharedLinks.get(0).getNodeId());
        this.setRequestContext(user1);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("where", "(sharedByUser='-me-')");
        response = this.getAll(URL_SHARED_LINKS, paging, params, 200);
        sharedLinks = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((long)1L, (long)sharedLinks.size());
        Assert.assertEquals((Object)shared1Id, (Object)sharedLinks.get(0).getId());
        Assert.assertEquals((Object)d1Id, (Object)sharedLinks.get(0).getNodeId());
        params = new HashMap();
        params.put("where", "(sharedByUser='" + user2 + "')");
        response = this.getAll(URL_SHARED_LINKS, paging, params, 200);
        sharedLinks = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((long)1L, (long)sharedLinks.size());
        Assert.assertEquals((Object)shared2Id, (Object)sharedLinks.get(0).getId());
        Assert.assertEquals((Object)d2Id, (Object)sharedLinks.get(0).getNodeId());
        this.setRequestContext(null);
        this.getAll(URL_SHARED_LINKS, paging, params, 401);
        this.setRequestContext(user1);
        this.deleteSharedLink(shared1Id);
        this.setRequestContext(user2);
        this.deleteSharedLink(shared2Id);
        this.setRequestContext(user1);
        QuickShareLinksImpl quickShareLinks = (QuickShareLinksImpl)this.applicationContext.getBean("quickShareLinks", QuickShareLinksImpl.class);
        try {
            quickShareLinks.setEnabled(false);
            this.getAll(URL_SHARED_LINKS, paging, 501);
        }
        finally {
            quickShareLinks.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmailSharedLink() throws Exception {
        this.setRequestContext(user1);
        String myFolderNodeId = this.getMyNodeId();
        String contentText = "The quick brown fox jumps over the lazy dog.";
        String fileName = "file-" + this.RUNID + ".txt";
        Document doc = this.createTextFile(myFolderNodeId, fileName, contentText);
        String docId = doc.getId();
        Map<String, String> body = Collections.singletonMap("nodeId", docId);
        HttpResponse response = this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 201);
        QuickShareLink resp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        String sharedId = resp.getId();
        Assert.assertNotNull((Object)sharedId);
        Assert.assertEquals((Object)fileName, (Object)resp.getName());
        QuickShareLinkEmailRequest request = new QuickShareLinkEmailRequest();
        request.setClient("share");
        List<Object> recipients = new ArrayList<String>(2);
        recipients.add(user2 + "@acme.test");
        recipients.add(user2 + "@ping.test");
        request.setRecipientEmails(recipients);
        this.post(this.getEmailSharedLinkUrl(sharedId), RestApiUtil.toJsonAsString(request), 202);
        request = new QuickShareLinkEmailRequest();
        request.setClient("share");
        request.setMessage("My custom message!");
        request.setLocale(Locale.UK.toString());
        recipients = Collections.singletonList(user2 + "@acme.test");
        request.setRecipientEmails(recipients);
        this.post(this.getEmailSharedLinkUrl(sharedId), RestApiUtil.toJsonAsString(request), 202);
        this.post(this.getEmailSharedLinkUrl(sharedId + System.currentTimeMillis()), RestApiUtil.toJsonAsString(request), 404);
        request = new QuickShareLinkEmailRequest();
        request.setClient("VeryCoolClient" + System.currentTimeMillis());
        List<CallSite> user2Email = Collections.singletonList(user2 + "@acme.test");
        request.setRecipientEmails(user2Email);
        this.post(this.getEmailSharedLinkUrl(sharedId), RestApiUtil.toJsonAsString(request), 404);
        request.setClient(null);
        this.post(this.getEmailSharedLinkUrl(sharedId), RestApiUtil.toJsonAsString(request), 400);
        request.setClient("share");
        request.setRecipientEmails(null);
        this.post(this.getEmailSharedLinkUrl(sharedId), RestApiUtil.toJsonAsString(request), 400);
        QuickShareLinksImpl quickShareLinks = (QuickShareLinksImpl)this.applicationContext.getBean("quickShareLinks", QuickShareLinksImpl.class);
        try {
            quickShareLinks.setEnabled(false);
            request = new QuickShareLinkEmailRequest();
            request.setClient("share");
            request.setRecipientEmails(user2Email);
            this.post(this.getEmailSharedLinkUrl(sharedId), RestApiUtil.toJsonAsString(request), 501);
        }
        finally {
            quickShareLinks.setEnabled(true);
        }
    }

    @Test
    public void testSharedLinkWithExpiryDate() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
        int numOfSchedules = this.getSchedules();
        this.setRequestContext(user1);
        String myFolderNodeId = this.getMyNodeId();
        String contentText = "The quick brown fox jumps over the lazy dog.";
        String fileName = "file-" + this.RUNID + ".txt";
        String docId = this.createTextFile(myFolderNodeId, fileName, contentText).getId();
        QuickShareLink body = new QuickShareLink();
        body.setNodeId(docId);
        body.setExpiresAt(DateTime.now().minusSeconds(20).toDate());
        this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsString(body), 400);
        body.setExpiresAt(DateTime.now().plusMinutes(5).toDate());
        this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsString(body), 400);
        Date time = DateTime.now().plusDays(2).toDate();
        body.setExpiresAt(time);
        HttpResponse response = this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsString(body), 201);
        QuickShareLink resp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertNotNull((Object)resp.getId());
        Assert.assertEquals((Object)fileName, (Object)resp.getName());
        Assert.assertEquals((Object)time, (Object)resp.getExpiresAt());
        Assert.assertEquals((long)(numOfSchedules + 1), (long)this.getSchedules());
        this.deleteSharedLink(resp.getId());
        this.getSingle(QuickShareLinkEntityResource.class, resp.getId(), null, 404);
        Assert.assertEquals((long)numOfSchedules, (long)this.getSchedules());
        time = DateTime.now().plusDays(1).toDate();
        body.setExpiresAt(time);
        response = this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsString(body), 201);
        resp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertNotNull((Object)resp.getId());
        Assert.assertEquals((long)(numOfSchedules + 1), (long)this.getSchedules());
        response = this.getSingle(QuickShareLinkEntityResource.class, resp.getId(), null, 200);
        resp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((Object)fileName, (Object)resp.getName());
        Assert.assertEquals((Object)time, (Object)resp.getExpiresAt());
        this.forceNewExpiryTime(resp.getId(), DateTime.now().plusSeconds(6).toDate());
        Thread.sleep(10000L);
        this.getSingle(QuickShareLinkEntityResource.class, resp.getId(), null, 404);
        Assert.assertEquals((long)numOfSchedules, (long)this.getSchedules());
        body.setExpiresAt(null);
        response = this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsString(body), 201);
        resp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertNotNull((Object)resp.getId());
        Assert.assertNull((String)"The 'expiryDate' property should have benn null.", (Object)resp.getExpiresAt());
        Assert.assertEquals((long)numOfSchedules, (long)this.getSchedules());
        this.deleteSharedLink(resp.getId());
    }

    @Override
    public String getScope() {
        return "public";
    }

    @Test
    @Category(value={LuceneTests.class, RedundantTests.class})
    public void testGetSharedLinksIncludePath() throws Exception {
        String contentText = "includePathTest" + this.RUNID;
        PublicApiClient.Paging paging = this.getPaging(0, 100);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("include", "path");
        this.setRequestContext(user1);
        HttpResponse response = this.getAll(URL_SHARED_LINKS, paging, 200);
        List<QuickShareLink> sharedLinks = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        response = this.getAll(URL_SHARED_LINKS, paging, queryParams, 200);
        List<QuickShareLink> sharedLinksWithPath = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((String)"get /shared-links/ API returns same no of shared-links with or without include=path, when there are no shared-links", sharedLinks, sharedLinksWithPath);
        Document myFile = this.createTextFile(this.getMyNodeId(), "MyFile" + this.RUNID + ".txt", contentText);
        Document sharedFile = this.createTextFile(this.getSharedNodeId(), "SharedFile" + this.RUNID + ".txt", contentText);
        Site publicSite = this.createSite("TestSite-Public-" + this.RUNID, SiteVisibility.PUBLIC);
        Site modSite = this.createSite("TestSite-Moderate-" + this.RUNID, SiteVisibility.MODERATED);
        Site privateSite = this.createSite("TestSite-Private-" + this.RUNID, SiteVisibility.PRIVATE);
        String docLibPub = this.getSiteContainerNodeId(publicSite.getId(), "documentLibrary");
        Document filePublic = this.createTextFile(docLibPub, "filePublic.txt", contentText);
        String docLibMod = this.getSiteContainerNodeId(modSite.getId(), "documentLibrary");
        Folder folder1 = this.createFolder(docLibMod, "1");
        Folder folder2 = this.createFolder(docLibMod, "2");
        Document fileMod = this.createTextFile(folder1.getId(), "fileMod.txt", contentText);
        Document fileMod2 = this.createTextFile(folder2.getId(), "fileMod2.txt", contentText);
        String docLibPvt = this.getSiteContainerNodeId(privateSite.getId(), "documentLibrary");
        Document filePrivate = this.createTextFile(docLibPvt, "filePrivate.txt", contentText);
        String myFileLinkId = this.postSharedLink(myFile);
        String sharedLinkId = this.postSharedLink(sharedFile);
        String filePublicLinkId = this.postSharedLink(filePublic);
        String fileModLinkId = this.postSharedLink(fileMod);
        String fileMod2LinkId = this.postSharedLink(fileMod2);
        String filePrivateLinkId = this.postSharedLink(filePrivate);
        ArrayList<NodePermissions.NodePermission> locallySetPermissions = new ArrayList<NodePermissions.NodePermission>();
        locallySetPermissions.add(new NodePermissions.NodePermission(user2, "Consumer", AccessStatus.ALLOWED.toString()));
        NodePermissions nodePermissions = new NodePermissions();
        nodePermissions.setIsInheritanceEnabled(false);
        nodePermissions.setLocallySet(locallySetPermissions);
        Document docPermissions = new Document();
        docPermissions.setPermissions(nodePermissions);
        this.put("nodes", fileMod.getId(), RestApiUtil.toJsonAsStringNonNull(docPermissions), null, 200);
        this.put("nodes", fileMod2.getId(), RestApiUtil.toJsonAsStringNonNull(docPermissions), null, 200);
        Folder folderPermissions = new Folder();
        folderPermissions.setPermissions(nodePermissions);
        this.put("nodes", folder2.getId(), RestApiUtil.toJsonAsStringNonNull(folderPermissions), null, 200);
        this.setRequestContext(user1);
        response = this.getSingle(QuickShareLinkEntityResource.class, myFileLinkId, null, 200);
        QuickShareLink link = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertNull((String)"get /shared-links/<id> API does not return Path info by default", (Object)link.getPath());
        response = this.getSingle(QuickShareLinkEntityResource.class, myFileLinkId, queryParams, 200);
        link = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertNull((String)"get /shared-links/<id> API ignores Path info when requested as it is a noAuth API.", (Object)link.getPath());
        response = this.getAll(URL_SHARED_LINKS, paging, 200);
        sharedLinks = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((String)"API returns correct shared-links as expected: without path info", (long)6L, (long)sharedLinks.size());
        sharedLinks.forEach(sharedLink -> Assert.assertNull((String)"API does not return Path info for any shared-links by default", (Object)sharedLink.getPath()));
        response = this.getAll(URL_SHARED_LINKS, paging, queryParams, 200);
        sharedLinks = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((String)"API returns correct shared-links as expected: with path info", (long)6L, (long)sharedLinks.size());
        sharedLinks.forEach(sharedLink -> Assert.assertTrue((String)"API returns Complete Path info for each link when requested by content owner", (boolean)sharedLink.getPath().getIsComplete()));
        this.setRequestContext(user2);
        response = this.getAll(URL_SHARED_LINKS, paging, 200);
        sharedLinks = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((String)"API returns correct shared-links as expected for user2: without path info", (long)4L, (long)sharedLinks.size());
        sharedLinks.forEach(sharedLink -> Assert.assertNull((String)"get /shared-links/ API does not return Path info for any shared-links by default", (Object)sharedLink.getPath()));
        response = this.getAll(URL_SHARED_LINKS, paging, queryParams, 200);
        sharedLinks = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((String)"API returns correct shared-links as expected for user2: with path info", (long)4L, (long)sharedLinks.size());
        sharedLinks.forEach(sharedLink -> Assert.assertNotNull((String)"API returns Path info for each link when requested by user2", (Object)sharedLink.getPath()));
        QuickShareLink sharedLink2 = sharedLinks.get(0);
        Assert.assertEquals((String)("Incorrect sort order or SharedLink ID for fileMod2: " + String.valueOf(sharedLink2)), (Object)fileMod2LinkId, (Object)sharedLink2.getId());
        PathInfo path = sharedLink2.getPath();
        Assert.assertEquals((String)("Complete Path is returned even when user2 does not have appropriate permissions. SharedLink Path: " + String.valueOf(path)), (Object)false, (Object)path.getIsComplete());
        Assert.assertEquals((String)("Path omits immediate Parent folder Name when user has access to it. SharedLink Path: " + String.valueOf(path)), (Object)("/" + folder2.getName()), (Object)path.getName());
        Assert.assertEquals((String)("Path omits immediate Parent folder ID when user has access to it. SharedLink Path: " + String.valueOf(path)), (Object)folder2.getId(), (Object)((PathInfo.ElementInfo)path.getElements().get(0)).getId());
        sharedLink2 = sharedLinks.get(1);
        Assert.assertEquals((String)("Incorrect sort order or SharedLink ID for fileMod: " + String.valueOf(sharedLink2)), (Object)fileModLinkId, (Object)sharedLink2.getId());
        path = sharedLink2.getPath();
        Assert.assertNotNull((String)("Path info is not included in the response when user does not have right permissions. SharedLink Path: " + String.valueOf(path)), (Object)path);
        Assert.assertNull((String)("Path Name is returned when user does not have right permissions. SharedLink Path: " + String.valueOf(path)), (Object)path.getName());
        Assert.assertNull((String)("Path info is returned when user does not have right permissions. SharedLink Path: " + String.valueOf(path)), (Object)path.getIsComplete());
        Assert.assertNull((String)("Path Elements are returned when user does not have right permissions. SharedLink Path: " + String.valueOf(path)), (Object)path.getElements());
        sharedLink2 = sharedLinks.get(2);
        Assert.assertEquals((String)("Incorrect sort order or SharedLink ID for filePublic: " + String.valueOf(sharedLink2)), (Object)filePublicLinkId, (Object)sharedLink2.getId());
        path = sharedLink2.getPath();
        Assert.assertEquals((String)("Complete Path is not returned for user2 for public files. SharedLink Path: " + String.valueOf(path)), (Object)true, (Object)path.getIsComplete());
        Assert.assertEquals((String)("Incorrect Path Name for Public Site Files. SharedLink Path: " + String.valueOf(path)), (Object)("/Company Home/Sites/" + publicSite.getId() + "/documentLibrary"), (Object)path.getName());
        Assert.assertEquals((String)("Incorrect Path Elements for Public Site Files. SharedLink Path: " + String.valueOf(path)), (long)4L, (long)path.getElements().size());
        Assert.assertEquals((String)("Incorrect ID in the Path for Company Home. SharedLink Path: " + String.valueOf(path)), (Object)this.getRootNodeId(), (Object)((PathInfo.ElementInfo)path.getElements().get(0)).getId());
        Assert.assertEquals((String)("Incorrect ID in the Path for Public Site. SharedLink Path: " + String.valueOf(path)), (Object)publicSite.getGuid(), (Object)((PathInfo.ElementInfo)path.getElements().get(2)).getId());
        Assert.assertEquals((String)("Incorrect ID in the Path for Public Site DocLib. SharedLink Path: " + String.valueOf(path)), (Object)docLibPub, (Object)((PathInfo.ElementInfo)path.getElements().get(3)).getId());
        sharedLink2 = sharedLinks.get(3);
        Assert.assertEquals((String)("Incorrect sort order or SharedLink ID for sharedFiles: " + String.valueOf(sharedLink2)), (Object)sharedLinkId, (Object)sharedLink2.getId());
        path = sharedLink2.getPath();
        Assert.assertEquals((String)("Complete Path is not returned for user2 for shared files. SharedLink Path: " + String.valueOf(path)), (Object)true, (Object)path.getIsComplete());
        Assert.assertEquals((String)("Incorrect Path Name for Shared Files. SharedLink Path: " + String.valueOf(path)), (Object)"/Company Home/Shared", (Object)path.getName());
        Assert.assertEquals((String)("Incorrect Path Elements for Shared Files. SharedLink Path: " + String.valueOf(path)), (long)2L, (long)path.getElements().size());
        Assert.assertEquals((String)("Incorrect ID in the Path for Company Home. SharedLink Path: " + String.valueOf(path)), (Object)this.getRootNodeId(), (Object)((PathInfo.ElementInfo)path.getElements().get(0)).getId());
        Assert.assertEquals((String)("Incorrect ID in the path for Shared Files. SharedLink Path: " + String.valueOf(path)), (Object)this.getSharedNodeId(), (Object)((PathInfo.ElementInfo)path.getElements().get(1)).getId());
        this.setRequestContext(null, "UserNotKnown", "admin");
        queryParams = new HashMap();
        this.getAll(URL_SHARED_LINKS, paging, queryParams, 401);
        this.setRequestContext(user2, null, null);
        this.getAll(URL_SHARED_LINKS, paging, queryParams, 401);
        this.setRequestContext(user1);
        this.deleteSharedLink(myFileLinkId);
        this.deleteSharedLink(sharedLinkId);
        this.deleteSharedLink(filePublicLinkId);
        this.deleteSharedLink(fileModLinkId);
        this.deleteSharedLink(fileMod2LinkId);
        this.deleteSharedLink(filePrivateLinkId);
    }

    @Test
    @Category(value={LuceneTests.class, RedundantTests.class})
    public void testCreateSharedLinkWithIncludeParam() throws Exception {
        String content = "The quick brown fox jumps over the lazy dog.";
        String fileName1 = "fileOne_" + this.RUNID + ".txt";
        String fileName2 = "fileTwo_" + this.RUNID + ".txt";
        String fileName3 = "fileThree_" + this.RUNID + ".txt";
        this.setRequestContext(user1);
        String doc1Id = this.createTextFile(this.getMyNodeId(), fileName1, content).getId();
        String doc2Id = this.createTextFile(this.getMyNodeId(), fileName2, content).getId();
        String doc3Id = this.createTextFile(this.getMyNodeId(), fileName3, content).getId();
        QuickShareLink body = new QuickShareLink();
        body.setNodeId(doc1Id);
        HttpResponse response = this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsString(body), "?include=path", 201);
        QuickShareLink quickShareLinkResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        PathInfo pathInfo = quickShareLinkResponse.getPath();
        Assert.assertNotNull((String)"API returns Path info when requested upon creation.", (Object)pathInfo);
        Assert.assertTrue((String)"IsComplete should have been true for user1.", (boolean)pathInfo.getIsComplete());
        Assert.assertEquals((String)"Incorrect number of path elements.", (long)3L, (long)pathInfo.getElements().size());
        Assert.assertEquals((String)"Incorrect path name.", (Object)("/Company Home/User Homes/" + user1), (Object)pathInfo.getName());
        Assert.assertEquals((String)"Incorrect path element.", (Object)this.getRootNodeId(), (Object)((PathInfo.ElementInfo)pathInfo.getElements().get(0)).getId());
        Assert.assertEquals((String)"Incorrect path element.", (Object)"Company Home", (Object)((PathInfo.ElementInfo)pathInfo.getElements().get(0)).getName());
        Assert.assertEquals((String)"Incorrect path element", (Object)"User Homes", (Object)((PathInfo.ElementInfo)pathInfo.getElements().get(1)).getName());
        Assert.assertEquals((String)"Incorrect path element.", (Object)this.getMyNodeId(), (Object)((PathInfo.ElementInfo)pathInfo.getElements().get(2)).getId());
        Assert.assertEquals((String)"Incorrect path element.", (Object)user1, (Object)((PathInfo.ElementInfo)pathInfo.getElements().get(2)).getName());
        body.setNodeId(doc2Id);
        response = this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsString(body), "?include=allowableOperations", 201);
        quickShareLinkResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        List allowableOperations = quickShareLinkResponse.getAllowableOperations();
        Assert.assertNotNull((String)"'allowableOperations' should have been returned.", (Object)allowableOperations);
        Assert.assertEquals((String)"allowableOperations should only have 'Delete' as allowable operation.", (long)1L, (long)allowableOperations.size());
        Assert.assertEquals((String)"Incorrect allowable operation.", (Object)"delete", allowableOperations.get(0));
        body.setNodeId(doc3Id);
        response = this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsString(body), "?include=path,allowableOperations", 201);
        quickShareLinkResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        pathInfo = quickShareLinkResponse.getPath();
        Assert.assertNotNull((String)"'path' should have been returned.", (Object)pathInfo);
        Assert.assertTrue((String)"IsComplete should have been true for user1.", (boolean)pathInfo.getIsComplete());
        Assert.assertEquals((String)"Incorrect number of path elements.", (long)3L, (long)pathInfo.getElements().size());
        Assert.assertEquals((String)"Incorrect path name.", (Object)("/Company Home/User Homes/" + user1), (Object)pathInfo.getName());
        allowableOperations = quickShareLinkResponse.getAllowableOperations();
        Assert.assertNotNull((String)"'allowableOperations' should have been returned.", (Object)allowableOperations);
        Assert.assertEquals((String)"allowableOperations should only have 'Delete' as allowable operation.", (long)1L, (long)allowableOperations.size());
        Assert.assertEquals((String)"Incorrect allowable operation.", (Object)"delete", allowableOperations.get(0));
        allowableOperations = quickShareLinkResponse.getAllowableOperationsOnTarget();
        Assert.assertNotNull((String)"'allowableOperationsOnTarget' should have been returned.", (Object)allowableOperations);
        List<String> expectedOps = Arrays.asList("delete", "update", "updatePermissions");
        Assert.assertTrue((boolean)allowableOperations.containsAll(expectedOps));
        Assert.assertEquals((long)expectedOps.size(), (long)allowableOperations.size());
        Assert.assertEquals((String)"Incorrect allowable operation.", (Object)"delete", allowableOperations.get(0));
        PublicApiClient.Paging paging = this.getPaging(0, 100);
        response = this.getAll(URL_SHARED_LINKS, paging, Collections.singletonMap("include", "path,allowableOperations"), 200);
        List<QuickShareLink> sharedLinks = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((String)"Incorrect number of shared-links returned.", (long)3L, (long)sharedLinks.size());
        sharedLinks.forEach(sharedLink -> {
            PathInfo path = sharedLink.getPath();
            Assert.assertNotNull((String)"'path' should have been returned.", (Object)path);
            Assert.assertTrue((String)"IsComplete should have been true for user1.", (boolean)path.getIsComplete());
            Assert.assertEquals((String)"Incorrect number of path elements.", (long)3L, (long)path.getElements().size());
            Assert.assertEquals((String)"Incorrect path name.", (Object)("/Company Home/User Homes/" + user1), (Object)path.getName());
            List operations = sharedLink.getAllowableOperations();
            Assert.assertNotNull((String)"'allowableOperations' should have been returned.", (Object)operations);
            Assert.assertEquals((String)"allowableOperations should only have 'Delete' as allowable operation.", (long)1L, (long)operations.size());
            Assert.assertEquals((String)"Incorrect allowable operation.", (Object)"delete", operations.get(0));
            operations = sharedLink.getAllowableOperationsOnTarget();
            Assert.assertNotNull((String)"'allowableOperationsOnTarget' should have been returned.", (Object)operations);
            Assert.assertTrue((boolean)operations.containsAll(expectedOps));
            Assert.assertEquals((long)expectedOps.size(), (long)operations.size());
            Assert.assertEquals((String)"Incorrect allowable operation.", (Object)"delete", operations.get(0));
            Assert.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)sharedLink.getTitle());
            Assert.assertEquals((Object)"Pangram, fox, dog, Gym class featuring a brown fox and lazy dog", (Object)sharedLink.getDescription());
        });
    }

    @Test
    public void testSharedLinkFindIncludeNodeProperties() throws Exception {
        QuickShareLinksImpl quickShareLinks = (QuickShareLinksImpl)this.applicationContext.getBean("quickShareLinks", QuickShareLinksImpl.class);
        ServiceDescriptorRegistry serviceRegistry = (ServiceDescriptorRegistry)this.applicationContext.getBean("ServiceRegistry", ServiceDescriptorRegistry.class);
        SearchService mockSearchService = (SearchService)Mockito.mock(SearchService.class);
        serviceRegistry.setMockSearchService(mockSearchService);
        this.setRequestContext(user1);
        PublicApiClient.Paging paging = this.getPaging(0, 100);
        String content = "The quick brown fox jumps over the lazy dog.";
        String fileName1 = "fileOne_" + this.RUNID + ".txt";
        String fileName2 = "fileTwo_" + this.RUNID + ".txt";
        this.setRequestContext(user1);
        HashMap<String, String> file1Props = new HashMap<String, String>();
        file1Props.put("cm:title", "File one title");
        file1Props.put("cm:lastThumbnailModification", "doclib:1549351708998");
        String file1Id = this.createTextFile(this.getMyNodeId(), fileName1, content, "UTF-8", file1Props).getId();
        String file2Id = this.createTextFile(this.getMyNodeId(), fileName2, content).getId();
        QuickShareLink body = new QuickShareLink();
        body.setNodeId(file1Id);
        HttpResponse response = this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 201);
        QuickShareLink resp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
        String shared1Id = resp.getId();
        body = new QuickShareLink();
        body.setNodeId(file2Id);
        this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 201);
        LockInfo lockInfo = new LockInfo();
        lockInfo.setTimeToExpire(Integer.valueOf(60));
        lockInfo.setType("FULL");
        lockInfo.setLifetime("PERSISTENT");
        this.post(this.getNodeOperationUrl(file1Id, "lock"), RestApiUtil.toJsonAsStringNonNull(lockInfo), null, 200);
        ResultSet mockResultSet = SharedLinkApiTest.mockResultSet(Arrays.asList(file1Id, file2Id));
        Mockito.when((Object)mockSearchService.query((SearchParameters)ArgumentMatchers.any())).thenReturn((Object)mockResultSet);
        quickShareLinks.afterPropertiesSet();
        response = this.getAll(URL_SHARED_LINKS, paging, null, 200);
        List<QuickShareLink> sharedLinks = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((long)2L, (long)sharedLinks.size());
        QuickShareLink resQuickShareLink1 = sharedLinks.get(0);
        QuickShareLink resQuickShareLink2 = sharedLinks.get(1);
        Assert.assertNull((String)"Properties were not requested therefore they should not be included", (Object)resQuickShareLink1.getProperties());
        Assert.assertNull((String)"Properties were not requested therefore they should not be included", (Object)resQuickShareLink2.getProperties());
        mockResultSet = SharedLinkApiTest.mockResultSet(Arrays.asList(file1Id, file2Id));
        Mockito.when((Object)mockSearchService.query((SearchParameters)ArgumentMatchers.any())).thenReturn((Object)mockResultSet);
        quickShareLinks.afterPropertiesSet();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("include", "properties,allowableOperations");
        response = this.getAll(URL_SHARED_LINKS, paging, params, 200);
        sharedLinks = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((long)2L, (long)sharedLinks.size());
        resQuickShareLink1 = sharedLinks.get(0);
        Assert.assertEquals((Object)shared1Id, (Object)resQuickShareLink1.getId());
        Assert.assertEquals((Object)file1Id, (Object)resQuickShareLink1.getNodeId());
        Map resQuickShareLink1Props = resQuickShareLink1.getProperties();
        Assert.assertNotNull((String)"Properties were requested to be included but are null.", (Object)resQuickShareLink1Props);
        Assert.assertNotNull((String)"Properties should include cm:lockType", resQuickShareLink1Props.get("cm:lockType"));
        Assert.assertNotNull((String)"Properties should include cm:lockOwner", resQuickShareLink1Props.get("cm:lockOwner"));
        Assert.assertNotNull((String)"Properties should include cm:lockLifetime", resQuickShareLink1Props.get("cm:lockLifetime"));
        Assert.assertNotNull((String)"Properties should include cm:title", resQuickShareLink1Props.get("cm:title"));
        Assert.assertNotNull((String)"Properties should include cm:versionType", resQuickShareLink1Props.get("cm:versionType"));
        Assert.assertNotNull((String)"Properties should include cm:versionLabel", resQuickShareLink1Props.get("cm:versionLabel"));
        Assert.assertNotNull((String)"Properties should include cm:lastThumbnailModification", resQuickShareLink1Props.get("cm:lastThumbnailModification"));
        Assert.assertNull((String)"Properties should NOT include cm:name", resQuickShareLink1Props.get("cm:name"));
        Assert.assertNull((String)"Properties should NOT include qshare:sharedBy", resQuickShareLink1Props.get("qshare:sharedBy"));
        Assert.assertNull((String)"Properties should NOT include qshare:sharedId", resQuickShareLink1Props.get("qshare:sharedId"));
        Assert.assertNull((String)"Properties should NOT include cm:content", resQuickShareLink1Props.get("cm:content"));
        Assert.assertNull((String)"Properties should NOT include cm:created", resQuickShareLink1Props.get("cm:created"));
        Assert.assertNull((String)"Properties should NOT include cm:creator", resQuickShareLink1Props.get("cm:creator"));
        Assert.assertNull((String)"Properties should NOT include cm:modifier", resQuickShareLink1Props.get("cm:modifier"));
        Assert.assertNull((String)"Properties should NOT include cm:modified", resQuickShareLink1Props.get("cm:modified"));
        Assert.assertNull((String)"Properties should NOT include cm:autoVersion", resQuickShareLink1Props.get("cm:autoVersion"));
        Assert.assertNull((String)"Properties should NOT include cm:initialVersion", resQuickShareLink1Props.get("cm:initialVersion"));
        Assert.assertNull((String)"Properties should NOT include cm:autoVersionOnUpdateProps", resQuickShareLink1Props.get("cm:autoVersionOnUpdateProps"));
        boolean foundSysProp = resQuickShareLink1Props.keySet().stream().anyMatch(s -> s.startsWith("sys:"));
        Assert.assertFalse((String)"System properties should be excluded", (boolean)foundSysProp);
        serviceRegistry.setMockSearchService(null);
        quickShareLinks.afterPropertiesSet();
    }

    @Test
    public void testSharedLinkFindIncludeIsFavorite() throws Exception {
        PublicApiClient.Favourites favouritesProxy = this.publicApiClient.favourites();
        QuickShareLinksImpl quickShareLinks = (QuickShareLinksImpl)this.applicationContext.getBean("quickShareLinks", QuickShareLinksImpl.class);
        ServiceDescriptorRegistry serviceRegistry = (ServiceDescriptorRegistry)this.applicationContext.getBean("ServiceRegistry", ServiceDescriptorRegistry.class);
        SearchService mockSearchService = (SearchService)Mockito.mock(SearchService.class);
        serviceRegistry.setMockSearchService(mockSearchService);
        this.setRequestContext(user1);
        PublicApiClient.Paging paging = this.getPaging(0, 100);
        String content = "The quick brown fox jumps over the lazy dog.";
        String fileName1 = "fileOne_" + this.RUNID + ".txt";
        String fileName2 = "fileTwo_" + this.RUNID + ".txt";
        this.setRequestContext(user1);
        String file1Id = this.createTextFile(this.getMyNodeId(), fileName1, content).getId();
        String file2Id = this.createTextFile(this.getMyNodeId(), fileName2, content).getId();
        QuickShareLink body = new QuickShareLink();
        body.setNodeId(file1Id);
        this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 201);
        body = new QuickShareLink();
        body.setNodeId(file2Id);
        this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 201);
        Favourite file1Favourite = SharedLinkApiTest.makeFileFavourite(file1Id);
        favouritesProxy.createFavourite(user1, file1Favourite, null);
        ResultSet mockResultSet = SharedLinkApiTest.mockResultSet(Arrays.asList(file1Id, file2Id));
        Mockito.when((Object)mockSearchService.query((SearchParameters)ArgumentMatchers.any())).thenReturn((Object)mockResultSet);
        quickShareLinks.afterPropertiesSet();
        HttpResponse response = this.getAll(URL_SHARED_LINKS, paging, null, 200);
        List<QuickShareLink> sharedLinks = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((long)2L, (long)sharedLinks.size());
        QuickShareLink resQuickShareLink1 = sharedLinks.get(0);
        QuickShareLink resQuickShareLink2 = sharedLinks.get(1);
        Assert.assertNull((String)"isFavorite was not requested therefore it should not be included", (Object)resQuickShareLink1.getIsFavorite());
        Assert.assertNull((String)"isFavorite was not requested therefore it should not be included", (Object)resQuickShareLink2.getIsFavorite());
        mockResultSet = SharedLinkApiTest.mockResultSet(Arrays.asList(file1Id, file2Id));
        Mockito.when((Object)mockSearchService.query((SearchParameters)ArgumentMatchers.any())).thenReturn((Object)mockResultSet);
        quickShareLinks.afterPropertiesSet();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("include", "isFavorite");
        response = this.getAll(URL_SHARED_LINKS, paging, params, 200);
        sharedLinks = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((long)2L, (long)sharedLinks.size());
        resQuickShareLink1 = sharedLinks.get(0);
        resQuickShareLink2 = sharedLinks.get(1);
        Assert.assertTrue((String)"Document should be marked as favorite.", (boolean)resQuickShareLink1.getIsFavorite());
        Assert.assertFalse((String)"Document should not be marked as favorite.", (boolean)resQuickShareLink2.getIsFavorite());
        serviceRegistry.setMockSearchService(null);
        quickShareLinks.afterPropertiesSet();
    }

    @Test
    public void testSharedLinkFindIncludeAspects() throws Exception {
        PublicApiClient.Favourites favouritesProxy = this.publicApiClient.favourites();
        QuickShareLinksImpl quickShareLinks = (QuickShareLinksImpl)this.applicationContext.getBean("quickShareLinks", QuickShareLinksImpl.class);
        ServiceDescriptorRegistry serviceRegistry = (ServiceDescriptorRegistry)this.applicationContext.getBean("ServiceRegistry", ServiceDescriptorRegistry.class);
        SearchService mockSearchService = (SearchService)Mockito.mock(SearchService.class);
        serviceRegistry.setMockSearchService(mockSearchService);
        this.setRequestContext(user1);
        PublicApiClient.Paging paging = this.getPaging(0, 100);
        String content = "The quick brown fox jumps over the lazy dog.";
        String fileName1 = "fileOne_" + this.RUNID + ".txt";
        String fileName2 = "fileTwo_" + this.RUNID + ".txt";
        this.setRequestContext(user1);
        String file1Id = this.createTextFile(this.getMyNodeId(), fileName1, content).getId();
        String file2Id = this.createTextFile(this.getMyNodeId(), fileName2, content).getId();
        QuickShareLink body = new QuickShareLink();
        body.setNodeId(file1Id);
        this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 201);
        body = new QuickShareLink();
        body.setNodeId(file2Id);
        this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 201);
        Favourite file1Favourite = SharedLinkApiTest.makeFileFavourite(file1Id);
        favouritesProxy.createFavourite(user1, file1Favourite, null);
        ResultSet mockResultSet = SharedLinkApiTest.mockResultSet(Arrays.asList(file1Id, file2Id));
        Mockito.when((Object)mockSearchService.query((SearchParameters)ArgumentMatchers.any())).thenReturn((Object)mockResultSet);
        quickShareLinks.afterPropertiesSet();
        HttpResponse response = this.getAll(URL_SHARED_LINKS, paging, null, 200);
        List<QuickShareLink> sharedLinks = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((long)2L, (long)sharedLinks.size());
        QuickShareLink resQuickShareLink1 = sharedLinks.get(0);
        QuickShareLink resQuickShareLink2 = sharedLinks.get(1);
        Assert.assertNull((String)"aspectNames was not requested therefore it should not be included", (Object)resQuickShareLink1.getAspectNames());
        Assert.assertNull((String)"aspectNames was not requested therefore it should not be included", (Object)resQuickShareLink2.getAspectNames());
        mockResultSet = SharedLinkApiTest.mockResultSet(Arrays.asList(file1Id, file2Id));
        Mockito.when((Object)mockSearchService.query((SearchParameters)ArgumentMatchers.any())).thenReturn((Object)mockResultSet);
        quickShareLinks.afterPropertiesSet();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("include", "aspectNames");
        response = this.getAll(URL_SHARED_LINKS, paging, params, 200);
        sharedLinks = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), QuickShareLink.class);
        Assert.assertEquals((long)2L, (long)sharedLinks.size());
        resQuickShareLink1 = sharedLinks.get(0);
        resQuickShareLink2 = sharedLinks.get(1);
        Assert.assertNotNull((String)"aspectNames was not requested therefore it should not be included", (Object)resQuickShareLink1.getAspectNames());
        Assert.assertNotNull((String)"aspectNames was not requested therefore it should not be included", (Object)resQuickShareLink2.getAspectNames());
        serviceRegistry.setMockSearchService(null);
        quickShareLinks.afterPropertiesSet();
    }

    private static ResultSet mockResultSet(List<String> nodeIds) {
        LinkedList<ResultSetRow> resultSetRows = new LinkedList<ResultSetRow>();
        for (String nodeId : nodeIds) {
            ResultSetRow mockResultSetRow1 = (ResultSetRow)Mockito.mock(ResultSetRow.class);
            Mockito.when((Object)mockResultSetRow1.getNodeRef()).thenReturn((Object)new NodeRef("workspace", "SpacesStore", nodeId));
            resultSetRows.add(mockResultSetRow1);
        }
        ResultSet mockSearchServiceQueryResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)mockSearchServiceQueryResultSet.hasMore()).thenReturn((Object)false);
        Mockito.when((Object)mockSearchServiceQueryResultSet.getNumberFound()).thenReturn((Object)nodeIds.size());
        Mockito.when((Object)mockSearchServiceQueryResultSet.length()).thenReturn((Object)nodeIds.size());
        Mockito.when((Object)mockSearchServiceQueryResultSet.iterator()).thenReturn(resultSetRows.iterator());
        return mockSearchServiceQueryResultSet;
    }

    private static Favourite makeFileFavourite(String targetGuid) throws ParseException {
        FavouriteDocument document = new FavouriteDocument(targetGuid);
        FileFavouriteTarget target = new FileFavouriteTarget(document);
        Date creationData = new Date();
        Favourite favourite = new Favourite(creationData, null, (FavouritesTarget)target, null);
        return favourite;
    }

    private String getEmailSharedLinkUrl(String sharedId) {
        return "shared-links/" + sharedId + "/email";
    }

    private String postSharedLink(Document file) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("nodeId", file.getId());
        try {
            HttpResponse response = this.post(URL_SHARED_LINKS, RestApiUtil.toJsonAsStringNonNull(body), 201);
            QuickShareLink resp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), QuickShareLink.class);
            return resp.getId();
        }
        catch (Exception e) {
            throw new RuntimeException("Error sharing link for File: " + file.getId(), e);
        }
    }

    private void deleteSharedLink(String sharedId) throws Exception {
        this.deleteSharedLink(sharedId, 204);
    }

    private void deleteSharedLink(String sharedId, int expectedStatus) throws Exception {
        this.delete(URL_SHARED_LINKS, sharedId, expectedStatus);
    }

    private void forceNewExpiryTime(String sharedId, Date date) {
        TenantUtil.runAsSystemTenant(() -> {
            QuickShareLinkExpiryAction linkExpiryAction = this.quickShareLinkExpiryActionPersister.loadQuickShareLinkExpiryAction(QuickShareLinkExpiryActionImpl.createQName((String)sharedId));
            linkExpiryAction.setSchedule(this.scheduledPersistedActionService.getSchedule((Action)linkExpiryAction));
            linkExpiryAction.setScheduleStart(date);
            this.transactionHelper.doInTransaction(() -> {
                this.quickShareLinkExpiryActionPersister.saveQuickShareLinkExpiryAction(linkExpiryAction);
                this.scheduledPersistedActionService.saveSchedule(linkExpiryAction.getSchedule());
                return null;
            });
            return null;
        }, (String)TenantUtil.getCurrentDomain());
    }

    private int getSchedules() {
        return (Integer)TenantUtil.runAsSystemTenant(() -> this.scheduledPersistedActionService.listSchedules().size(), (String)TenantUtil.getCurrentDomain());
    }
}

