/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.solr;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.search.SearchTrackingComponent;
import org.alfresco.repo.solr.MetaDataResultsFilter;
import org.alfresco.repo.solr.NodeMetaData;
import org.alfresco.repo.solr.NodeMetaDataParameters;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.web.scripts.solr.PropertyValue;
import org.alfresco.repo.web.scripts.solr.SOLRSerializer;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class NodesMetaDataGet
extends DeclarativeWebScript {
    protected static final Log logger = LogFactory.getLog(NodesMetaDataGet.class);
    private static final int INITIAL_DEFAULT_SIZE = 100;
    private static final int BATCH_SIZE = 50;
    private SearchTrackingComponent searchTrackingComponent;
    private SOLRSerializer solrSerializer;

    public void setSearchTrackingComponent(SearchTrackingComponent searchTrackingComponent) {
        this.searchTrackingComponent = searchTrackingComponent;
    }

    public void setSolrSerializer(SOLRSerializer solrSerializer) {
        this.solrSerializer = solrSerializer;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        try {
            Content content = req.getContent();
            if (content == null) {
                throw new WebScriptException("Failed to convert request to String");
            }
            JSONObject o = new JSONObject(content.getContent());
            ArrayList<Long> nodeIds = null;
            if (o.has("nodeIds")) {
                JSONArray jsonNodeIds = o.getJSONArray("nodeIds");
                nodeIds = new ArrayList<Long>(jsonNodeIds.length());
                for (int i = 0; i < jsonNodeIds.length(); ++i) {
                    Long nodeId = jsonNodeIds.getLong(i);
                    nodeIds.add(nodeId);
                }
            }
            Long fromNodeId = o.has("fromNodeId") ? Long.valueOf(o.getLong("fromNodeId")) : null;
            Long toNodeId = o.has("toNodeId") ? Long.valueOf(o.getLong("toNodeId")) : null;
            int maxResults = o.has("maxResults") ? o.getInt("maxResults") : 0;
            int size = 0;
            if (maxResults != 0 && maxResults != Integer.MAX_VALUE) {
                size = maxResults;
            } else if (nodeIds != null) {
                size = nodeIds.size();
            } else if (fromNodeId != null && toNodeId != null) {
                if (toNodeId - fromNodeId > Integer.MAX_VALUE) {
                    throw new WebScriptException("Too many nodes expected, try changing the criteria");
                }
                size = (int)(toNodeId - fromNodeId);
            }
            final boolean noSizeCalculated = size == 0;
            MetaDataResultsFilter filter = new MetaDataResultsFilter();
            if (o.has("includeAclId")) {
                filter.setIncludeAclId(o.getBoolean("includeAclId"));
            }
            if (o.has("includeAspects")) {
                filter.setIncludeAspects(o.getBoolean("includeAspects"));
            }
            if (o.has("includeNodeRef")) {
                filter.setIncludeNodeRef(o.getBoolean("includeNodeRef"));
            }
            if (o.has("includeOwner")) {
                filter.setIncludeOwner(o.getBoolean("includeOwner"));
            }
            if (o.has("includeProperties")) {
                filter.setIncludeProperties(o.getBoolean("includeProperties"));
            }
            if (o.has("includePaths")) {
                filter.setIncludePaths(o.getBoolean("includePaths"));
            }
            if (o.has("includeType")) {
                filter.setIncludeType(o.getBoolean("includeType"));
            }
            if (o.has("includeParentAssociations")) {
                filter.setIncludeParentAssociations(o.getBoolean("includeParentAssociations"));
            }
            if (o.has("includeChildIds")) {
                filter.setIncludeChildIds(o.getBoolean("includeChildIds"));
            }
            if (o.has("includeTxnId")) {
                filter.setIncludeTxnId(o.getBoolean("includeTxnId"));
            }
            final ArrayList nodesMetaData = new ArrayList(size > 0 ? size : 100);
            NodeMetaDataParameters params = new NodeMetaDataParameters();
            params.setNodeIds(nodeIds);
            params.setFromNodeId(fromNodeId);
            params.setToNodeId(toNodeId);
            params.setMaxResults(maxResults);
            this.searchTrackingComponent.getNodesMetadata(params, filter, new SearchTrackingComponent.NodeMetaDataQueryCallback(){
                private int counter = 50;
                private int numBatches = 0;

                public boolean handleNodeMetaData(NodeMetaData nodeMetaData) {
                    try {
                        FreemarkerNodeMetaData fNodeMetaData = new FreemarkerNodeMetaData(NodesMetaDataGet.this.solrSerializer, nodeMetaData);
                        nodesMetaData.add(fNodeMetaData);
                    }
                    catch (Exception e) {
                        throw new AlfrescoRuntimeException("Problem converting to Freemarker using node " + nodeMetaData.getNodeRef().toString(), (Throwable)e);
                    }
                    if (noSizeCalculated && --this.counter == 0) {
                        this.counter = 50;
                        nodesMetaData.ensureCapacity(++this.numBatches * 50);
                    }
                    return true;
                }
            });
            HashMap<String, Object> model = new HashMap<String, Object>(1, 1.0f);
            model.put("nodes", nodesMetaData);
            model.put("filter", filter);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Result: \n\tRequest: " + String.valueOf(req) + "\n\tModel: " + String.valueOf(model)));
            }
            return model;
        }
        catch (IOException e) {
            throw new WebScriptException("IO exception parsing request", (Throwable)e);
        }
        catch (JSONException e) {
            throw new WebScriptException("Invalid JSON", (Throwable)e);
        }
    }

    public static class FreemarkerNodeMetaData {
        private final Long nodeId;
        private final NodeRef nodeRef;
        private final QName nodeType;
        private final Long aclId;
        private final Map<String, PropertyValue> properties;
        private final Set<QName> aspects;
        private final List<String> paths;
        private final List<String> namePaths;
        private final List<String> childAssocs;
        private final List<String> parentAssocs;
        private final Long parentAssocsCrc;
        private final List<Long> childIds;
        private final String owner;
        private final Long txnId;
        private final Set<String> ancestors;
        private final String tenantDomain;

        public FreemarkerNodeMetaData(final SOLRSerializer solrSerializer, NodeMetaData nodeMetaData) throws IOException, JSONException {
            Map props;
            JSONObject o;
            this.nodeId = nodeMetaData.getNodeId();
            this.tenantDomain = nodeMetaData.getTenantDomain();
            this.aclId = nodeMetaData.getAclId();
            this.nodeRef = nodeMetaData.getNodeRef();
            this.nodeType = nodeMetaData.getNodeType();
            this.txnId = nodeMetaData.getTxnId();
            this.parentAssocs = new ArrayList<String>();
            this.childAssocs = new ArrayList<String>();
            ArrayList<String> paths = new ArrayList<String>();
            ArrayList ancestorPaths = new ArrayList();
            HashSet<String> ancestors = new HashSet<String>();
            if (nodeMetaData.getPaths() != null) {
                for (Object pair : nodeMetaData.getPaths()) {
                    StringBuilder ancestorPath = new StringBuilder();
                    o = new JSONObject();
                    o.put("path", (Object)solrSerializer.serializeValue(String.class, pair.getFirst()));
                    o.put("qname", (Object)solrSerializer.serializeValue(String.class, pair.getSecond()));
                    for (NodeRef ancestor : this.getAncestors((Path)pair.getFirst())) {
                        ancestors.add(ancestor.toString());
                        ancestorPath.insert(0, ancestor.getId()).insert(0, "/");
                    }
                    o.put("apath", (Object)ancestorPath);
                    paths.add(o.toString(3));
                }
            }
            this.ancestors = ancestors;
            this.paths = paths;
            ArrayList<String> namePaths = new ArrayList<String>();
            if (nodeMetaData.getNamePaths() != null) {
                for (Collection namePath : nodeMetaData.getNamePaths()) {
                    o = new JSONObject();
                    JSONArray array = new JSONArray();
                    for (String element : namePath) {
                        array.put((Object)solrSerializer.serializeValue(String.class, element));
                    }
                    o.put("namePath", (Object)array);
                    namePaths.add(o.toString(3));
                }
            }
            this.namePaths = namePaths;
            this.owner = nodeMetaData.getOwner();
            this.childIds = nodeMetaData.getChildIds();
            this.parentAssocsCrc = nodeMetaData.getParentAssocsCrc();
            this.aspects = nodeMetaData.getAspects();
            if (nodeMetaData.getParentAssocs() != null) {
                for (ChildAssociationRef assRef : nodeMetaData.getParentAssocs()) {
                    this.parentAssocs.add("\"" + solrSerializer.serializeToJSONString((Serializable)assRef) + "\"");
                }
            }
            if (nodeMetaData.getChildAssocs() != null) {
                for (ChildAssociationRef assRef : nodeMetaData.getChildAssocs()) {
                    this.childAssocs.add("\"" + solrSerializer.serializeToJSONString((Serializable)assRef) + "\"");
                }
            }
            if ((props = nodeMetaData.getProperties()) != null) {
                final HashMap<String, PropertyValue> properties = new HashMap<String, PropertyValue>(props.size());
                for (final QName propName : props.keySet()) {
                    TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                        public Void doWork() throws Exception {
                            Serializable value = (Serializable)props.get(propName);
                            properties.put(solrSerializer.serializeValue(String.class, propName), solrSerializer.serialize(propName, value));
                            return null;
                        }
                    }, (String)this.tenantDomain);
                }
                this.properties = properties;
            } else {
                this.properties = null;
            }
        }

        public NodeRef getNodeRef() {
            return this.nodeRef;
        }

        public List<String> getPaths() {
            return this.paths;
        }

        public List<String> getNamePaths() {
            return this.namePaths;
        }

        public QName getNodeType() {
            return this.nodeType;
        }

        public Long getNodeId() {
            return this.nodeId;
        }

        public Long getAclId() {
            return this.aclId;
        }

        public Map<String, PropertyValue> getProperties() {
            return this.properties;
        }

        public Set<QName> getAspects() {
            return this.aspects;
        }

        public List<String> getChildAssocs() {
            return this.childAssocs;
        }

        public List<String> getParentAssocs() {
            return this.parentAssocs;
        }

        public Long getParentAssocsCrc() {
            return this.parentAssocsCrc;
        }

        public Set<String> getAncestors() {
            return this.ancestors;
        }

        public List<Long> getChildIds() {
            return this.childIds;
        }

        public String getOwner() {
            return this.owner;
        }

        public Long getTxnId() {
            return this.txnId;
        }

        public String getTenantDomain() {
            return this.tenantDomain;
        }

        private ArrayList<NodeRef> getAncestors(Path path) {
            ArrayList<NodeRef> ancestors = new ArrayList<NodeRef>(8);
            for (Path.Element element : path) {
                if (!(element instanceof Path.ChildAssocElement)) {
                    throw new IndexerException("Confused path: " + String.valueOf(path));
                }
                Path.ChildAssocElement cae = (Path.ChildAssocElement)element;
                NodeRef parentRef = cae.getRef().getParentRef();
                if (parentRef == null) continue;
                ancestors.add(0, parentRef);
            }
            return ancestors;
        }
    }
}

