/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.alfresco.model.ContentModel;
import org.alfresco.rest.api.Categories;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.model.Category;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.InvalidNodeTypeException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.Pair;
import org.alfresco.util.TypeConstraint;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

@Experimental
public class CategoriesImpl
implements Categories {
    static final String INCLUDE_COUNT_PARAM = "count";
    static final String NOT_A_VALID_CATEGORY = "Node id does not refer to a valid category";
    static final String NO_PERMISSION_TO_MANAGE_A_CATEGORY = "Current user does not have permission to manage a category";
    static final String NO_PERMISSION_TO_READ_CONTENT = "Current user does not have read permission to content";
    static final String NO_PERMISSION_TO_CHANGE_CONTENT = "Current user does not have change permission to content";
    static final String NOT_NULL_OR_EMPTY = "Category name must not be null or empty";
    static final String INVALID_NODE_TYPE = "Cannot categorize this type of node";
    private final AuthorityService authorityService;
    private final CategoryService categoryService;
    private final Nodes nodes;
    private final NodeService nodeService;
    private final PermissionService permissionService;
    private final TypeConstraint typeConstraint;

    public CategoriesImpl(AuthorityService authorityService, CategoryService categoryService, Nodes nodes, NodeService nodeService, PermissionService permissionService, TypeConstraint typeConstraint) {
        this.authorityService = authorityService;
        this.categoryService = categoryService;
        this.nodes = nodes;
        this.nodeService = nodeService;
        this.permissionService = permissionService;
        this.typeConstraint = typeConstraint;
    }

    @Override
    public Category getCategoryById(StoreRef storeRef, String id, Parameters parameters) {
        NodeRef nodeRef = this.getCategoryNodeRef(storeRef, id);
        if (this.isRootCategory(nodeRef)) {
            throw new InvalidArgumentException(NOT_A_VALID_CATEGORY, new String[]{id});
        }
        Category category = this.mapToCategory(nodeRef);
        if (parameters.getInclude().contains(INCLUDE_COUNT_PARAM)) {
            Map<String, Integer> categoriesCount = this.getCategoriesCount(storeRef);
            category.setCount(categoriesCount.getOrDefault(category.getId(), 0));
        }
        if (parameters.getInclude().contains("path")) {
            category.setPath(this.getCategoryPath(category));
        }
        return category;
    }

    @Override
    public List<Category> createSubcategories(StoreRef storeRef, String parentCategoryId, List<Category> categories, Parameters parameters) {
        this.verifyAdminAuthority();
        NodeRef parentNodeRef = this.getCategoryNodeRef(storeRef, parentCategoryId);
        return categories.stream().map(c -> this.createCategoryNodeRef(parentNodeRef, (Category)c)).map(this::mapToCategory).peek(category -> {
            if (parameters.getInclude().contains(INCLUDE_COUNT_PARAM)) {
                category.setCount(0);
            }
            if (parameters.getInclude().contains("path")) {
                category.setPath(this.getCategoryPath((Category)category));
            }
        }).collect(Collectors.toList());
    }

    @Override
    public List<Category> getCategoryChildren(StoreRef storeRef, String parentCategoryId, Parameters parameters) {
        NodeRef parentNodeRef = this.getCategoryNodeRef(storeRef, parentCategoryId);
        List<Category> categories = this.nodeService.getChildAssocs(parentNodeRef).stream().filter(ca -> ContentModel.ASSOC_SUBCATEGORIES.equals((Object)ca.getTypeQName())).map(ChildAssociationRef::getChildRef).map(this::mapToCategory).peek(category -> {
            if (parameters.getInclude().contains("path")) {
                category.setPath(this.getCategoryPath((Category)category));
            }
        }).collect(Collectors.toList());
        if (parameters.getInclude().contains(INCLUDE_COUNT_PARAM)) {
            Map<String, Integer> categoriesCount = this.getCategoriesCount(storeRef);
            categories.forEach(category -> category.setCount(categoriesCount.getOrDefault(category.getId(), 0)));
        }
        return categories;
    }

    @Override
    public Category updateCategoryById(StoreRef storeRef, String id, Category fixedCategoryModel, Parameters parameters) {
        this.verifyAdminAuthority();
        NodeRef categoryNodeRef = this.getCategoryNodeRef(storeRef, id);
        if (this.isRootCategory(categoryNodeRef)) {
            throw new InvalidArgumentException(NOT_A_VALID_CATEGORY, new String[]{id});
        }
        this.validateCategoryFields(fixedCategoryModel);
        Category category = this.mapToCategory(this.changeCategoryName(categoryNodeRef, fixedCategoryModel.getName()));
        if (parameters.getInclude().contains(INCLUDE_COUNT_PARAM)) {
            Map<String, Integer> categoriesCount = this.getCategoriesCount(storeRef);
            category.setCount(categoriesCount.getOrDefault(category.getId(), 0));
        }
        if (parameters.getInclude().contains("path")) {
            category.setPath(this.getCategoryPath(category));
        }
        return category;
    }

    @Override
    public void deleteCategoryById(StoreRef storeRef, String id, Parameters parameters) {
        this.verifyAdminAuthority();
        NodeRef nodeRef = this.getCategoryNodeRef(storeRef, id);
        if (this.isRootCategory(nodeRef)) {
            throw new InvalidArgumentException(NOT_A_VALID_CATEGORY, new String[]{id});
        }
        this.nodeService.deleteNode(nodeRef);
    }

    @Override
    public List<Category> listCategoriesForNode(String nodeId, Parameters parameters) {
        NodeRef contentNodeRef = this.nodes.validateOrLookupNode(nodeId);
        this.verifyReadPermission(contentNodeRef);
        this.verifyNodeType(contentNodeRef);
        Serializable currentCategories = this.nodeService.getProperty(contentNodeRef, ContentModel.PROP_CATEGORIES);
        if (currentCategories == null) {
            return Collections.emptyList();
        }
        Collection actualCategories = DefaultTypeConverter.INSTANCE.getCollection(NodeRef.class, (Object)currentCategories);
        return actualCategories.stream().map(this::mapToCategory).peek(category -> {
            if (parameters.getInclude().contains("path")) {
                category.setPath(this.getCategoryPath((Category)category));
            }
        }).collect(Collectors.toList());
    }

    @Override
    public List<Category> linkNodeToCategories(StoreRef storeRef, String nodeId, List<Category> categoryLinks, Parameters parameters) {
        if (CollectionUtils.isEmpty(categoryLinks)) {
            throw new InvalidArgumentException(NOT_A_VALID_CATEGORY);
        }
        NodeRef contentNodeRef = this.nodes.validateOrLookupNode(nodeId);
        this.verifyChangePermission(contentNodeRef);
        this.verifyNodeType(contentNodeRef);
        Collection categoryNodeRefs = categoryLinks.stream().filter(Objects::nonNull).map(Category::getId).filter(StringUtils::isNotEmpty).distinct().map(id -> this.getCategoryNodeRef(storeRef, (String)id)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)categoryNodeRefs) || this.isRootCategoryPresent(categoryNodeRefs)) {
            throw new InvalidArgumentException(NOT_A_VALID_CATEGORY);
        }
        this.linkNodeToCategories(contentNodeRef, categoryNodeRefs);
        return categoryNodeRefs.stream().map(this::mapToCategory).peek(category -> {
            if (parameters.getInclude().contains("path")) {
                category.setPath(this.getCategoryPath((Category)category));
            }
        }).collect(Collectors.toList());
    }

    @Override
    public void unlinkNodeFromCategory(StoreRef storeRef, String nodeId, String categoryId, Parameters parameters) {
        NodeRef categoryNodeRef = this.getCategoryNodeRef(storeRef, categoryId);
        NodeRef contentNodeRef = this.nodes.validateOrLookupNode(nodeId);
        this.verifyChangePermission(contentNodeRef);
        this.verifyNodeType(contentNodeRef);
        if (this.isCategoryAspectMissing(contentNodeRef)) {
            throw new InvalidArgumentException("Node with id: " + nodeId + " does not belong to a category");
        }
        if (this.isRootCategory(categoryNodeRef)) {
            throw new InvalidArgumentException(NOT_A_VALID_CATEGORY, new String[]{categoryId});
        }
        Collection<NodeRef> allCategories = this.removeCategory(contentNodeRef, categoryNodeRef);
        if (allCategories.size() == 0) {
            this.nodeService.removeAspect(contentNodeRef, ContentModel.ASPECT_GEN_CLASSIFIABLE);
            this.nodeService.removeProperty(contentNodeRef, ContentModel.PROP_CATEGORIES);
            return;
        }
        this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_CATEGORIES, (Serializable)((Object)allCategories));
    }

    private void verifyAdminAuthority() {
        if (!this.authorityService.hasAdminAuthority()) {
            throw new PermissionDeniedException(NO_PERMISSION_TO_MANAGE_A_CATEGORY);
        }
    }

    private void verifyReadPermission(NodeRef nodeRef) {
        if (this.permissionService.hasReadPermission(nodeRef) != AccessStatus.ALLOWED) {
            throw new PermissionDeniedException(NO_PERMISSION_TO_READ_CONTENT);
        }
    }

    private void verifyChangePermission(NodeRef nodeRef) {
        if (this.permissionService.hasPermission(nodeRef, "ChangePermissions") != AccessStatus.ALLOWED) {
            throw new PermissionDeniedException(NO_PERMISSION_TO_CHANGE_CONTENT);
        }
    }

    private void verifyNodeType(NodeRef nodeRef) {
        if (!this.typeConstraint.matches(nodeRef)) {
            throw new InvalidNodeTypeException(INVALID_NODE_TYPE);
        }
    }

    private NodeRef getCategoryNodeRef(StoreRef storeRef, String nodeId) {
        return "-root-".equals(nodeId) ? (NodeRef)this.categoryService.getRootCategoryNodeRef(storeRef).orElseThrow(() -> new EntityNotFoundException(nodeId)) : this.validateCategoryNode(nodeId);
    }

    private NodeRef validateCategoryNode(String nodeId) {
        NodeRef nodeRef = this.nodes.validateNode(nodeId);
        if (this.isNotACategory(nodeRef)) {
            throw new InvalidArgumentException(NOT_A_VALID_CATEGORY, new String[]{nodeId});
        }
        return nodeRef;
    }

    private NodeRef createCategoryNodeRef(NodeRef parentNodeRef, Category c) {
        this.validateCategoryFields(c);
        return this.categoryService.createCategory(parentNodeRef, c.getName());
    }

    private Category mapToCategory(NodeRef nodeRef) {
        Node categoryNode = this.nodes.getNode(nodeRef.getId());
        boolean hasChildren = CollectionUtils.isNotEmpty((Collection)this.nodeService.getChildAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false));
        return Category.builder().id(nodeRef.getId()).name(categoryNode.getName()).parentId(this.getParentId(nodeRef)).hasChildren(hasChildren).create();
    }

    private boolean isNotACategory(NodeRef nodeRef) {
        return !this.nodes.isSubClass(nodeRef, ContentModel.TYPE_CATEGORY, false);
    }

    private boolean isRootCategory(NodeRef nodeRef) {
        List parentAssocs = this.nodeService.getParentAssocs(nodeRef);
        return parentAssocs.stream().anyMatch(pa -> ContentModel.ASPECT_GEN_CLASSIFIABLE.equals((Object)pa.getQName()));
    }

    private String getParentId(NodeRef nodeRef) {
        NodeRef parentRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
        return this.isRootCategory(parentRef) ? "-root-" : parentRef.getId();
    }

    private NodeRef changeCategoryName(NodeRef categoryNodeRef, String newName) {
        ChildAssociationRef parentAssociation = this.nodeService.getPrimaryParent(categoryNodeRef);
        if (parentAssociation == null) {
            throw new InvalidArgumentException(NOT_A_VALID_CATEGORY, new String[]{categoryNodeRef.getId()});
        }
        this.nodeService.setProperty(categoryNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)newName));
        QName newQName = QName.createQName((String)parentAssociation.getQName().getNamespaceURI(), (String)QName.createValidLocalName((String)newName));
        return this.nodeService.moveNode(parentAssociation.getChildRef(), parentAssociation.getParentRef(), parentAssociation.getTypeQName(), newQName).getChildRef();
    }

    private void validateCategoryFields(Category fixedCategoryModel) {
        if (StringUtils.isEmpty((CharSequence)fixedCategoryModel.getName())) {
            throw new InvalidArgumentException(NOT_NULL_OR_EMPTY);
        }
    }

    private boolean isRootCategoryPresent(Collection<NodeRef> categoryNodeRefs) {
        return categoryNodeRefs.stream().anyMatch(this::isRootCategory);
    }

    private boolean isCategoryAspectMissing(NodeRef nodeRef) {
        return !this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_GEN_CLASSIFIABLE);
    }

    private Collection<NodeRef> mergeCategories(Serializable currentCategories, Collection<NodeRef> newCategories) {
        if (currentCategories == null) {
            return newCategories;
        }
        Collection actualCategories = DefaultTypeConverter.INSTANCE.getCollection(NodeRef.class, (Object)currentCategories);
        HashSet<NodeRef> allCategories = new HashSet<NodeRef>(actualCategories);
        allCategories.addAll(newCategories);
        return allCategories;
    }

    private Collection<NodeRef> removeCategory(NodeRef contentNodeRef, NodeRef categoryToRemove) {
        Serializable currentCategories = this.nodeService.getProperty(contentNodeRef, ContentModel.PROP_CATEGORIES);
        Collection actualCategories = DefaultTypeConverter.INSTANCE.getCollection(NodeRef.class, (Object)currentCategories);
        HashSet<NodeRef> updatedCategories = new HashSet<NodeRef>(actualCategories);
        updatedCategories.remove(categoryToRemove);
        return updatedCategories;
    }

    private void linkNodeToCategories(NodeRef nodeRef, Collection<NodeRef> categoryNodeRefs) {
        if (this.isCategoryAspectMissing(nodeRef)) {
            Map<QName, Serializable> properties = Map.of(ContentModel.PROP_CATEGORIES, (Serializable)((Object)categoryNodeRefs));
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_GEN_CLASSIFIABLE, properties);
        } else {
            Serializable currentCategories = this.nodeService.getProperty(nodeRef, ContentModel.PROP_CATEGORIES);
            Collection<NodeRef> allCategories = this.mergeCategories(currentCategories, categoryNodeRefs);
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_CATEGORIES, (Serializable)((Object)allCategories));
        }
    }

    private Map<String, Integer> getCategoriesCount(StoreRef storeRef) {
        String idPrefix = String.valueOf(storeRef) + "/";
        return this.categoryService.getTopCategories(storeRef, ContentModel.ASPECT_GEN_CLASSIFIABLE, Integer.MAX_VALUE).stream().collect(Collectors.toMap(pair -> ((NodeRef)pair.getFirst()).toString().replace(idPrefix, ""), Pair::getSecond));
    }

    private String getCategoryPath(Category category) {
        NodeRef categoryNodeRef = this.nodes.getNode(category.getId()).getNodeRef();
        return this.nodeService.getPath(categoryNodeRef).toDisplayPath(this.nodeService, this.permissionService);
    }
}

