/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tags;

import java.util.List;
import org.alfresco.rest.api.Tags;
import org.alfresco.rest.api.model.Tag;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="tags", title="Tags")
public class TagsEntityResource
implements EntityResourceAction.Read<Tag>,
EntityResourceAction.ReadById<Tag>,
EntityResourceAction.Update<Tag>,
EntityResourceAction.Create<Tag>,
EntityResourceAction.Delete,
InitializingBean {
    private Tags tags;

    public void setTags(Tags tags) {
        this.tags = tags;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"tags", (Object)this.tags);
    }

    @Override
    @WebApiDescription(title="A paged list of all tags in the network.")
    public CollectionWithPagingInfo<Tag> readAll(Parameters parameters) {
        return this.tags.getTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, parameters);
    }

    @Override
    @WebApiDescription(title="Updates a tag by unique Id")
    public Tag update(String id, Tag entity, Parameters parameters) {
        return this.tags.changeTag(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, id, entity, parameters);
    }

    @Override
    public Tag readById(String id, Parameters parameters) throws EntityNotFoundException {
        return this.tags.getTag(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, id, parameters);
    }

    @Override
    @WebApiDescription(title="Create an orphan tag", description="Creates a tag, which is not associated with any node", successStatus=201)
    @Experimental
    public List<Tag> create(List<Tag> tags, Parameters parameters) {
        return this.tags.createTags(tags, parameters);
    }

    @Override
    public void delete(String id, Parameters parameters) {
        this.tags.deleteTagById(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, id);
    }
}

