/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.model.QuickShareModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.content.ContentLimitViolationException;
import org.alfresco.repo.domain.node.AuditablePropertiesEntity;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.repo.node.getchildren.FilterPropBoolean;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.RenditionDefinitionRegistry2;
import org.alfresco.repo.rendition2.RenditionService2;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.repo.virtual.store.VirtualStore;
import org.alfresco.rest.api.Activities;
import org.alfresco.rest.api.ClassDefinitionMapper;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.QuickShareLinks;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.AssocChild;
import org.alfresco.rest.api.model.AssocTarget;
import org.alfresco.rest.api.model.ClassDefinition;
import org.alfresco.rest.api.model.Document;
import org.alfresco.rest.api.model.Folder;
import org.alfresco.rest.api.model.LockInfo;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.NodePermissions;
import org.alfresco.rest.api.model.PathInfo;
import org.alfresco.rest.api.model.QuickShareLink;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.rest.framework.core.exceptions.DisabledServiceException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InsufficientStorageException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.core.exceptions.RequestEntityTooLargeException;
import org.alfresco.rest.framework.core.exceptions.UnsupportedMediaTypeException;
import org.alfresco.rest.framework.resource.content.BasicContentInfo;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.content.ContentInfoImpl;
import org.alfresco.rest.framework.resource.content.NodeBinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.SortColumn;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalker;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.activities.ActivitiesTransactionListener;
import org.alfresco.service.cmr.activities.ActivityInfo;
import org.alfresco.service.cmr.activities.ActivityPoster;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.repository.AssociationExistsException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.cmr.usage.ContentQuotaException;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.servlet.FormData;

public class NodesImpl
implements Nodes {
    private static final Log logger = LogFactory.getLog(NodesImpl.class);
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private FileFolderService fileFolderService;
    private NamespaceService namespaceService;
    private PermissionService permissionService;
    private MimetypeService mimetypeService;
    private ContentService contentService;
    private ActionService actionService;
    private VersionService versionService;
    private PersonService personService;
    private OwnableService ownableService;
    private AuthorityService authorityService;
    private ThumbnailService thumbnailService;
    private RenditionService2 renditionService2;
    private SiteService siteService;
    private ActivityPoster poster;
    private RetryingTransactionHelper retryingTransactionHelper;
    private LockService lockService;
    private VirtualStore smartStore;
    private ClassDefinitionMapper classDefinitionMapper;
    private RuleService ruleService;
    private BehaviourFilter behaviourFilter;
    private QuickShareLinks quickShareLinks;
    private Repository repositoryHelper;
    private ServiceRegistry sr;
    private Set<String> defaultIgnoreTypesAndAspects;
    private Set<String> defaultPersonLookupProperties;
    private Set<QName> ignoreQNames;
    private Set<QName> personLookupProperties = new HashSet<QName>();
    private ConcurrentHashMap<String, NodeRef> ddCache = new ConcurrentHashMap();
    private Set<String> nonAttachContentTypes = Collections.emptySet();
    private static final List<String> EXCLUDED_NS = Arrays.asList("http://www.alfresco.org/model/system/1.0");
    private static final List<QName> EXCLUDED_ASPECTS = Arrays.asList(new QName[0]);
    private static final List<QName> EXCLUDED_PROPS = Arrays.asList(ContentModel.PROP_NAME, ContentModel.PROP_MODIFIER, ContentModel.PROP_MODIFIED, ContentModel.PROP_CREATOR, ContentModel.PROP_CREATED, ContentModel.PROP_CONTENT, ContentModel.PROP_INITIAL_VERSION, ContentModel.PROP_AUTO_VERSION_PROPS, ContentModel.PROP_AUTO_VERSION);
    public static final Map<String, QName> PARAM_SYNONYMS_QNAME;
    private static final Set<String> LIST_FOLDER_CHILDREN_EQUALS_QUERY_PROPERTIES;

    public void setNonAttachContentTypes(String nonAttachAllowListStr) {
        if (nonAttachAllowListStr != null && !nonAttachAllowListStr.isEmpty()) {
            this.nonAttachContentTypes = Set.of(nonAttachAllowListStr.trim().split("\\s*,\\s*"));
        }
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"serviceRegistry", (Object)this.sr);
        PropertyCheck.mandatory((Object)this, (String)"behaviourFilter", (Object)this.behaviourFilter);
        PropertyCheck.mandatory((Object)this, (String)"repositoryHelper", (Object)this.repositoryHelper);
        PropertyCheck.mandatory((Object)this, (String)"quickShareLinks", (Object)this.quickShareLinks);
        PropertyCheck.mandatory((Object)this, (String)"poster", (Object)this.poster);
        this.namespaceService = this.sr.getNamespaceService();
        this.fileFolderService = this.sr.getFileFolderService();
        this.nodeService = this.sr.getNodeService();
        this.permissionService = this.sr.getPermissionService();
        this.dictionaryService = this.sr.getDictionaryService();
        this.mimetypeService = this.sr.getMimetypeService();
        this.contentService = this.sr.getContentService();
        this.actionService = this.sr.getActionService();
        this.versionService = this.sr.getVersionService();
        this.personService = this.sr.getPersonService();
        this.ownableService = this.sr.getOwnableService();
        this.authorityService = this.sr.getAuthorityService();
        this.thumbnailService = this.sr.getThumbnailService();
        this.renditionService2 = this.sr.getRenditionService2();
        this.siteService = this.sr.getSiteService();
        this.retryingTransactionHelper = this.sr.getRetryingTransactionHelper();
        this.lockService = this.sr.getLockService();
        if (this.defaultIgnoreTypesAndAspects != null) {
            this.ignoreQNames = new HashSet<QName>(this.defaultIgnoreTypesAndAspects.size());
            for (String type : this.defaultIgnoreTypesAndAspects) {
                this.ignoreQNames.add(this.createQName(type));
            }
        }
        if (this.defaultPersonLookupProperties != null) {
            for (String property : this.defaultPersonLookupProperties) {
                this.personLookupProperties.add(this.createQName(property));
            }
        }
    }

    public void setServiceRegistry(ServiceRegistry sr) {
        this.sr = sr;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setRepositoryHelper(Repository repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    public void setQuickShareLinks(QuickShareLinks quickShareLinks) {
        this.quickShareLinks = quickShareLinks;
    }

    public void setIgnoreTypes(Set<String> ignoreTypesAndAspects) {
        this.defaultIgnoreTypesAndAspects = ignoreTypesAndAspects;
    }

    public void setPersonLookupProperties(Set<String> personLookupProperties) {
        this.defaultPersonLookupProperties = personLookupProperties;
    }

    public void setPoster(ActivityPoster poster) {
        this.poster = poster;
    }

    public void setSmartStore(VirtualStore smartStore) {
        this.smartStore = smartStore;
    }

    public void setClassDefinitionMapper(ClassDefinitionMapper classDefinitionMapper) {
        this.classDefinitionMapper = classDefinitionMapper;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    @Override
    public NodeRef validateNode(String nodeId) {
        if (nodeId == null) {
            throw new InvalidArgumentException("Missing nodeId");
        }
        return this.validateNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
    }

    @Override
    public NodeRef validateNode(StoreRef storeRef, String nodeId) {
        int idx = nodeId.indexOf(";");
        if (idx != -1) {
            String versionLabel = nodeId.substring(idx + 1);
            nodeId = nodeId.substring(0, idx);
            if (versionLabel.equals("pwc")) {
                throw new EntityNotFoundException(nodeId);
            }
        }
        NodeRef nodeRef = new NodeRef(storeRef, nodeId);
        return this.validateNode(nodeRef);
    }

    @Override
    public NodeRef validateNode(NodeRef nodeRef) {
        if (!this.nodeService.exists(nodeRef)) {
            throw new EntityNotFoundException(nodeRef.getId());
        }
        return nodeRef;
    }

    @Override
    public boolean nodeMatches(NodeRef nodeRef, Set<QName> expectedTypes, Set<QName> excludedTypes) {
        return this.nodeMatches(nodeRef, expectedTypes, excludedTypes, true);
    }

    @Override
    public boolean isSubClass(NodeRef nodeRef, QName ofClassQName, boolean validateNodeRef) {
        if (validateNodeRef) {
            nodeRef = this.validateNode(nodeRef);
        }
        return this.isSubClass(this.getNodeType(nodeRef), ofClassQName);
    }

    private boolean nodeMatches(NodeRef nodeRef, Set<QName> expectedTypes, Set<QName> excludedTypes, boolean existsCheck) {
        if (existsCheck && !this.nodeService.exists(nodeRef)) {
            throw new EntityNotFoundException(nodeRef.getId());
        }
        return this.typeMatches(this.getNodeType(nodeRef), expectedTypes, excludedTypes);
    }

    private QName getNodeType(NodeRef nodeRef) {
        return this.nodeService.getType(nodeRef);
    }

    private boolean isSubClass(QName className, QName ofClassQName) {
        return this.dictionaryService.isSubClass(className, ofClassQName);
    }

    protected boolean typeMatches(QName type, Set<QName> expectedTypes, Set<QName> excludedTypes) {
        if (expectedTypes != null && expectedTypes.size() == 1 && (excludedTypes == null || excludedTypes.size() == 0)) {
            return this.isSubClass(type, expectedTypes.iterator().next());
        }
        HashSet allExpectedTypes = new HashSet();
        if (expectedTypes != null) {
            for (QName expectedType : expectedTypes) {
                allExpectedTypes.addAll(this.dictionaryService.getSubTypes(expectedType, true));
            }
        }
        HashSet allExcludedTypes = new HashSet();
        if (excludedTypes != null) {
            for (QName excludedType : excludedTypes) {
                allExcludedTypes.addAll(this.dictionaryService.getSubTypes(excludedType, true));
            }
        }
        boolean inExpected = allExpectedTypes.contains(type);
        boolean excluded = allExcludedTypes.contains(type);
        return inExpected && !excluded;
    }

    @Override
    public Node getNode(String nodeId) {
        NodeRef nodeRef = this.validateNode(nodeId);
        return new Node(nodeRef, null, this.nodeService.getProperties(nodeRef), null, this.sr);
    }

    public Node getNode(NodeRef nodeRef) {
        return new Node(nodeRef, null, this.nodeService.getProperties(nodeRef), null, this.sr);
    }

    private Type getType(NodeRef nodeRef) {
        return this.getType(this.getNodeType(nodeRef), nodeRef);
    }

    private Type getType(QName typeQName, NodeRef nodeRef) {
        if (typeQName.equals((Object)ContentModel.TYPE_FOLDER) || typeQName.equals((Object)ApplicationModel.TYPE_FOLDERLINK)) {
            return Type.FOLDER;
        }
        if (typeQName.equals((Object)ContentModel.TYPE_CONTENT) || typeQName.equals((Object)ApplicationModel.TYPE_FILELINK)) {
            return Type.DOCUMENT;
        }
        if (this.isSubClass(typeQName, ContentModel.TYPE_LINK)) {
            if (this.isSubClass(typeQName, ApplicationModel.TYPE_FOLDERLINK)) {
                return Type.FOLDER;
            }
            if (this.isSubClass(typeQName, ApplicationModel.TYPE_FILELINK)) {
                return Type.DOCUMENT;
            }
            NodeRef linkNodeRef = (NodeRef)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LINK_DESTINATION);
            if (linkNodeRef != null) {
                try {
                    typeQName = this.getNodeType(linkNodeRef);
                }
                catch (InvalidNodeRefException invalidNodeRefException) {
                    // empty catch block
                }
            }
        }
        if (this.isSubClass(typeQName, ContentModel.TYPE_FOLDER)) {
            if (!this.isSubClass(typeQName, ContentModel.TYPE_SYSTEM_FOLDER)) {
                return Type.FOLDER;
            }
            return null;
        }
        if (this.isSubClass(typeQName, ContentModel.TYPE_CONTENT)) {
            return Type.DOCUMENT;
        }
        return null;
    }

    @Override
    public Document getDocument(NodeRef nodeRef) {
        Type type = this.getType(nodeRef);
        if (type != null && type.equals((Object)Type.DOCUMENT)) {
            Map properties = this.nodeService.getProperties(nodeRef);
            Document doc = new Document(nodeRef, this.getParentNodeRef(nodeRef), properties, null, this.sr);
            doc.setVersionLabel((String)properties.get(ContentModel.PROP_VERSION_LABEL));
            ContentData cd = (ContentData)properties.get(ContentModel.PROP_CONTENT);
            if (cd != null) {
                doc.setSizeInBytes(BigInteger.valueOf(cd.getSize()));
                doc.setMimeType(cd.getMimetype());
            }
            this.setCommonProps(doc, nodeRef, properties);
            return doc;
        }
        throw new InvalidArgumentException("Node is not a file: " + nodeRef.getId());
    }

    private void setCommonProps(Node node, NodeRef nodeRef, Map<QName, Serializable> properties) {
        node.setGuid(nodeRef);
        node.setTitle((String)((Object)properties.get(ContentModel.PROP_TITLE)));
        node.setDescription((String)((Object)properties.get(ContentModel.PROP_DESCRIPTION)));
        node.setModifiedBy((String)((Object)properties.get(ContentModel.PROP_MODIFIER)));
        node.setCreatedBy((String)((Object)properties.get(ContentModel.PROP_CREATOR)));
    }

    @Override
    public Folder getFolder(NodeRef nodeRef) {
        Type type = this.getType(nodeRef);
        if (type != null && type.equals((Object)Type.FOLDER)) {
            Map properties = this.nodeService.getProperties(nodeRef);
            Folder folder = new Folder(nodeRef, this.getParentNodeRef(nodeRef), properties, null, this.sr);
            this.setCommonProps(folder, nodeRef, properties);
            return folder;
        }
        throw new InvalidArgumentException("Node is not a folder: " + nodeRef.getId());
    }

    private NodeRef getParentNodeRef(NodeRef nodeRef) {
        if (this.repositoryHelper.getCompanyHome().equals((Object)nodeRef)) {
            return null;
        }
        return this.nodeService.getPrimaryParent(nodeRef).getParentRef();
    }

    @Override
    public NodeRef validateOrLookupNode(String nodeId, String path) {
        NodeRef parentNodeRef;
        if (nodeId == null || nodeId.isEmpty()) {
            throw new InvalidArgumentException("Missing nodeId");
        }
        if (nodeId.equals("-root-")) {
            parentNodeRef = this.repositoryHelper.getCompanyHome();
        } else if (nodeId.equals("-shared-")) {
            parentNodeRef = this.repositoryHelper.getSharedHome();
        } else if (nodeId.equals("-my-")) {
            NodeRef person = this.repositoryHelper.getPerson();
            if (person == null) {
                throw new InvalidArgumentException("Unexpected - cannot use: -my-");
            }
            parentNodeRef = this.repositoryHelper.getUserHome(person);
            if (parentNodeRef == null) {
                throw new EntityNotFoundException(nodeId);
            }
        } else {
            parentNodeRef = this.validateNode(nodeId);
        }
        if (path != null) {
            if (!this.nodeMatches(parentNodeRef, Collections.singleton(ContentModel.TYPE_FOLDER), null, false)) {
                throw new InvalidArgumentException("NodeId of folder is expected: " + parentNodeRef.getId());
            }
            parentNodeRef = this.resolveNodeByPath(parentNodeRef, path, true);
        }
        return parentNodeRef;
    }

    protected NodeRef resolveNodeByPath(NodeRef parentNodeRef, String path, boolean checkForCompanyHome) {
        List<String> pathElements = this.getPathElements(path);
        if (pathElements.isEmpty() || checkForCompanyHome) {
            // empty if block
        }
        FileInfo fileInfo = null;
        try {
            if (!pathElements.isEmpty()) {
                fileInfo = this.fileFolderService.resolveNamePath(parentNodeRef, pathElements);
            } else {
                fileInfo = this.fileFolderService.getFileInfo(parentNodeRef);
                if (fileInfo == null) {
                    throw new EntityNotFoundException(parentNodeRef.getId());
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new NotFoundException("The entity with relativePath: " + path + " was not found.");
        }
        catch (AccessDeniedException ade) {
            throw new NotFoundException("The entity with relativePath: " + path + " was not found.");
        }
        return fileInfo.getNodeRef();
    }

    private List<String> getPathElements(String path) {
        ArrayList<String> pathElements = new ArrayList<String>();
        if (path != null && path.trim().length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(path, "/");
            while (tokenizer.hasMoreTokens()) {
                pathElements.add(tokenizer.nextToken().trim());
            }
        }
        return pathElements;
    }

    private NodeRef makeFolders(NodeRef parentNodeRef, List<String> pathElements) {
        NodeRef currentParentRef = parentNodeRef;
        Iterator<String> iterator = pathElements.iterator();
        while (iterator.hasNext()) {
            final NodeRef contextNodeRef = currentParentRef;
            final String element = iterator.next();
            NodeRef nodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    return NodesImpl.this.nodeService.getChildByName(contextNodeRef, ContentModel.ASSOC_CONTAINS, element);
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            if (nodeRef == null) {
                try {
                    FileInfo createdFileInfo = this.fileFolderService.create(currentParentRef, element, ContentModel.TYPE_FOLDER);
                    currentParentRef = createdFileInfo.getNodeRef();
                    continue;
                }
                catch (AccessDeniedException ade) {
                    throw new PermissionDeniedException(ade.getMessage());
                }
                catch (FileExistsException fex) {
                    throw new ConcurrencyFailureException(fex.getMessage());
                }
            }
            if (!this.isSubClass(nodeRef, ContentModel.TYPE_FOLDER, false)) {
                String parentName = (String)((Object)this.nodeService.getProperty(contextNodeRef, ContentModel.PROP_NAME));
                throw new ConstraintViolatedException("Name [" + element + "] already exists in the target parent: " + parentName);
            }
            currentParentRef = nodeRef;
        }
        return currentParentRef;
    }

    @Override
    public Node getFolderOrDocument(String nodeId, Parameters parameters) {
        String path = parameters.getParameter("relativePath");
        NodeRef nodeRef = this.validateOrLookupNode(nodeId, path);
        Node node = this.getFolderOrDocumentFullInfo(nodeRef, null, null, parameters);
        return node;
    }

    private Node getFolderOrDocumentFullInfo(NodeRef nodeRef, NodeRef parentNodeRef, QName nodeTypeQName, Parameters parameters) {
        return this.getFolderOrDocumentFullInfo(nodeRef, parentNodeRef, nodeTypeQName, parameters, null);
    }

    @Override
    public Node getFolderOrDocumentFullInfo(NodeRef nodeRef, NodeRef parentNodeRef, QName nodeTypeQName, Parameters parameters, Map<String, UserInfo> mapUserInfo) {
        ArrayList<String> includeParam = new ArrayList<String>();
        if (parameters != null) {
            includeParam.addAll(parameters.getInclude());
        }
        includeParam.add("aspectNames");
        includeParam.add("properties");
        return this.getFolderOrDocument(nodeRef, parentNodeRef, nodeTypeQName, includeParam, mapUserInfo);
    }

    @Override
    public Node getFolderOrDocument(NodeRef nodeRef, NodeRef parentNodeRef, QName nodeTypeQName, List<String> includeParam, Map<String, UserInfo> mapUserInfo) {
        Node node;
        Type type;
        if (mapUserInfo == null) {
            mapUserInfo = new HashMap<String, UserInfo>(2);
        }
        if (includeParam == null) {
            includeParam = Collections.emptyList();
        }
        Map properties = this.nodeService.getProperties(nodeRef);
        PathInfo pathInfo = null;
        if (includeParam.contains("path")) {
            ChildAssociationRef archivedParentAssoc = (ChildAssociationRef)properties.get(ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC);
            pathInfo = this.lookupPathInfo(nodeRef, archivedParentAssoc);
        }
        if (nodeTypeQName == null) {
            nodeTypeQName = this.getNodeType(nodeRef);
        }
        if (parentNodeRef == null) {
            parentNodeRef = this.getParentNodeRef(nodeRef);
        }
        if ((type = this.getType(nodeTypeQName, nodeRef)) == null) {
            node = new Node(nodeRef, parentNodeRef, properties, mapUserInfo, this.sr);
            node.setIsFolder(false);
            node.setIsFile(false);
        } else if (type.equals((Object)Type.DOCUMENT)) {
            node = new Document(nodeRef, parentNodeRef, properties, mapUserInfo, this.sr);
        } else if (type.equals((Object)Type.FOLDER)) {
            node = new Folder(nodeRef, parentNodeRef, properties, mapUserInfo, this.sr);
        } else {
            throw new RuntimeException("Unexpected - should not reach here: " + String.valueOf((Object)type));
        }
        if (includeParam.size() > 0) {
            node.setProperties(this.mapFromNodeProperties(properties, includeParam, mapUserInfo, EXCLUDED_NS, EXCLUDED_PROPS));
        }
        Set aspects = null;
        if (includeParam.contains("aspectNames")) {
            aspects = this.nodeService.getAspects(nodeRef);
            node.setAspectNames(this.mapFromNodeAspects(aspects, EXCLUDED_NS, EXCLUDED_ASPECTS));
        }
        if (includeParam.contains("isLink")) {
            boolean isLink = this.isSubClass(nodeTypeQName, ContentModel.TYPE_LINK);
            node.setIsLink(isLink);
        }
        if (includeParam.contains("isLocked")) {
            boolean isLocked = this.isLocked(nodeRef, aspects);
            node.setIsLocked(isLocked);
        }
        if (includeParam.contains("isFavorite")) {
            boolean isFavorite = this.isFavorite(nodeRef);
            node.setIsFavorite(isFavorite);
        }
        if (includeParam.contains("allowableOperations")) {
            HashMap<String, String> mapPermsToOps = new HashMap<String, String>(3);
            mapPermsToOps.put("Delete", "delete");
            mapPermsToOps.put("AddChildren", "create");
            mapPermsToOps.put("Write", "update");
            mapPermsToOps.put("ChangePermissions", "updatePermissions");
            ArrayList<String> allowableOperations = new ArrayList<String>(3);
            for (Map.Entry kv : mapPermsToOps.entrySet()) {
                String perm = (String)kv.getKey();
                String op = (String)kv.getValue();
                if (perm.equals("AddChildren") && Type.DOCUMENT.equals((Object)type) || perm.equals("Delete") && this.isSpecialNode(nodeRef, nodeTypeQName) || this.permissionService.hasPermission(nodeRef, perm) != AccessStatus.ALLOWED) continue;
                allowableOperations.add(op);
            }
            node.setAllowableOperations(allowableOperations.size() > 0 ? allowableOperations : null);
        }
        if (includeParam.contains("permissions")) {
            Boolean inherit = this.permissionService.getInheritParentPermissions(nodeRef);
            ArrayList<NodePermissions.NodePermission> inheritedPerms = new ArrayList<NodePermissions.NodePermission>(5);
            ArrayList setDirectlyPerms = new ArrayList(5);
            Set settablePerms = null;
            boolean allowRetrievePermission = true;
            try {
                for (AccessPermission accessPerm : this.permissionService.getAllSetPermissions(nodeRef)) {
                    NodePermissions.NodePermission nodePerm = new NodePermissions.NodePermission(accessPerm.getAuthority(), accessPerm.getPermission(), accessPerm.getAccessStatus().toString());
                    if (accessPerm.isSetDirectly()) {
                        setDirectlyPerms.add(nodePerm);
                        continue;
                    }
                    inheritedPerms.add(nodePerm);
                }
                settablePerms = this.permissionService.getSettablePermissions(nodeRef);
            }
            catch (AccessDeniedException ade) {
                allowRetrievePermission = false;
            }
            if (allowRetrievePermission) {
                NodePermissions nodePerms = new NodePermissions(inherit, inheritedPerms, setDirectlyPerms, settablePerms);
                node.setPermissions(nodePerms);
            }
        }
        if (includeParam.contains("association")) {
            QName assocTypeQName;
            ChildAssociationRef parentAssocRef = this.nodeService.getPrimaryParent(nodeRef);
            if (parentAssocRef == null || parentAssocRef.getParentRef() == null || !parentAssocRef.getParentRef().equals((Object)parentNodeRef)) {
                List parentAssocRefs = this.nodeService.getParentAssocs(nodeRef);
                for (ChildAssociationRef pAssocRef : parentAssocRefs) {
                    if (!pAssocRef.getParentRef().equals((Object)parentNodeRef)) continue;
                    parentAssocRef = pAssocRef;
                    break;
                }
            }
            if (parentAssocRef != null && (assocTypeQName = parentAssocRef.getTypeQName()) != null && !EXCLUDED_NS.contains(assocTypeQName.getNamespaceURI())) {
                AssocChild childAssoc = new AssocChild(assocTypeQName.toPrefixString((NamespacePrefixResolver)this.namespaceService), parentAssocRef.isPrimary());
                node.setAssociation(childAssoc);
            }
        }
        if (includeParam.contains("definition")) {
            ClassDefinition classDefinition = this.classDefinitionMapper.fromDictionaryClassDefinition((org.alfresco.service.cmr.dictionary.ClassDefinition)this.getTypeDefinition(nodeRef), (MessageLookup)this.dictionaryService);
            node.setDefinition(classDefinition);
        }
        node.setNodeType(nodeTypeQName.toPrefixString((NamespacePrefixResolver)this.namespaceService));
        node.setPath(pathInfo);
        return node;
    }

    private TypeDefinition getTypeDefinition(NodeRef nodeRef) {
        QName type = this.nodeService.getType(nodeRef);
        Set aspectNames = this.nodeService.getAspects(nodeRef);
        TypeDefinition typeDefinition = this.dictionaryService.getAnonymousType(type, (Collection)aspectNames);
        return typeDefinition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PathInfo lookupPathInfo(NodeRef nodeRefIn, ChildAssociationRef archivedParentAssoc) {
        Path nodePath;
        ArrayList<PathInfo.ElementInfo> pathElements = new ArrayList<PathInfo.ElementInfo>();
        Boolean isComplete = Boolean.TRUE;
        if (archivedParentAssoc != null) {
            if (!this.permissionService.hasPermission(archivedParentAssoc.getParentRef(), "Read").equals((Object)AccessStatus.ALLOWED) || !this.nodeService.exists(archivedParentAssoc.getParentRef())) return null;
            nodePath = this.nodeService.getPath(archivedParentAssoc.getParentRef());
            pathIndex = 1;
        } else {
            nodePath = this.nodeService.getPath(nodeRefIn);
            pathIndex = 2;
        }
        for (int i = nodePath.size() - pathIndex; i >= 0; --i) {
            ChildAssociationRef elementRef;
            Path.Element element = nodePath.get(i);
            if (!(element instanceof Path.ChildAssocElement) || (elementRef = ((Path.ChildAssocElement)element).getRef()).getParentRef() == null) continue;
            NodeRef childNodeRef = elementRef.getChildRef();
            if (this.permissionService.hasPermission(childNodeRef, "Read") == AccessStatus.ALLOWED) {
                Serializable nameProp = this.nodeService.getProperty(childNodeRef, ContentModel.PROP_NAME);
                String type = this.getNodeType(childNodeRef).toPrefixString((NamespacePrefixResolver)this.namespaceService);
                Set aspects = this.nodeService.getAspects(childNodeRef);
                List<String> aspectNames = this.mapFromNodeAspects(aspects, EXCLUDED_NS, EXCLUDED_ASPECTS);
                pathElements.add(0, new PathInfo.ElementInfo(childNodeRef.getId(), nameProp.toString(), type, aspectNames));
                continue;
            }
            isComplete = Boolean.FALSE;
            break;
        }
        String pathStr = null;
        if (pathElements.size() > 0) {
            StringBuilder sb = new StringBuilder(120);
            for (PathInfo.ElementInfo e : pathElements) {
                sb.append("/").append(e.getName());
            }
            pathStr = sb.toString();
            return new PathInfo(pathStr, isComplete, pathElements);
        } else {
            isComplete = null;
        }
        return new PathInfo(pathStr, isComplete, pathElements);
    }

    @Override
    public Set<QName> mapToNodeAspects(List<String> aspectNames) {
        HashSet<QName> nodeAspects = new HashSet<QName>(aspectNames.size());
        for (String aspectName : aspectNames) {
            QName aspectQName = this.createQName(aspectName);
            AspectDefinition ad = this.dictionaryService.getAspect(aspectQName);
            if (ad != null) {
                nodeAspects.add(aspectQName);
                continue;
            }
            throw new InvalidArgumentException("Unknown aspect: " + aspectName);
        }
        return nodeAspects;
    }

    @Override
    public Map<QName, Serializable> mapToNodeProperties(Map<String, Object> props) {
        HashMap<QName, Serializable> nodeProps = new HashMap<QName, Serializable>(props.size());
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String propName = entry.getKey();
            QName propQName = this.createQName(propName);
            PropertyDefinition pd = this.dictionaryService.getProperty(propQName);
            if (pd != null) {
                Serializable value = null;
                if (entry.getValue() != null) {
                    String nodeRefString;
                    value = pd.getDataType().getName().equals((Object)DataTypeDefinition.NODE_REF) ? (!NodeRef.isNodeRef((String)(nodeRefString = (String)entry.getValue())) ? new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeRefString) : new NodeRef(nodeRefString)) : (Serializable)entry.getValue();
                }
                nodeProps.put(propQName, value);
                continue;
            }
            throw new InvalidArgumentException("Unknown property: " + propName);
        }
        return nodeProps;
    }

    @Override
    public Map<String, Object> mapFromNodeProperties(Map<QName, Serializable> nodeProps, List<String> selectParam, Map<String, UserInfo> mapUserInfo, List<String> excludedNS, List<QName> excludedProps) {
        List<Object> selectedProperties;
        if (selectParam.size() == 0 || selectParam.contains("properties")) {
            selectedProperties = new ArrayList(nodeProps.size());
            for (QName propQName : nodeProps.keySet()) {
                if (excludedNS.contains(propQName.getNamespaceURI()) || excludedProps.contains(propQName)) continue;
                selectedProperties.add(propQName);
            }
        } else {
            selectedProperties = this.createQNames(selectParam, excludedProps);
        }
        HashMap<String, Serializable> props = null;
        if (!selectedProperties.isEmpty()) {
            props = new HashMap<String, Serializable>(selectedProperties.size());
            for (QName qName : selectedProperties) {
                Serializable value = nodeProps.get(qName);
                if (value == null) continue;
                if (this.personLookupProperties.contains(qName)) {
                    value = Node.lookupUserInfo((String)((Object)value), mapUserInfo, this.personService);
                }
                if (value != null && value instanceof String && ((String)((Object)value)).isEmpty()) continue;
                props.put(qName.toPrefixString((NamespacePrefixResolver)this.namespaceService), value);
            }
            if (props.isEmpty()) {
                props = null;
            }
        }
        return props;
    }

    @Override
    public List<String> mapFromNodeAspects(Set<QName> nodeAspects, List<String> excludedNS, List<QName> excludedAspects) {
        ArrayList<String> aspectNames = new ArrayList<String>(nodeAspects.size());
        for (QName aspectQName : nodeAspects) {
            if (excludedNS.contains(aspectQName.getNamespaceURI()) || excludedAspects.contains(aspectQName)) continue;
            aspectNames.add(aspectQName.toPrefixString((NamespacePrefixResolver)this.namespaceService));
        }
        if (aspectNames.size() == 0) {
            aspectNames = null;
        }
        return aspectNames;
    }

    @Override
    public CollectionWithPagingInfo<Node> listChildren(final String parentFolderNodeId, Parameters parameters) {
        String path = parameters.getParameter("relativePath");
        NodeRef parentNodeRef = this.validateOrLookupNode(parentFolderNodeId, path);
        final List<String> includeParam = parameters.getInclude();
        QName assocTypeQNameParam = null;
        Query q = parameters.getQuery();
        if (q != null) {
            MapBasedQueryWalker propertyWalker = this.createListChildrenQueryWalker();
            QueryHelper.walk(q, propertyWalker);
            String assocTypeQNameStr = propertyWalker.getProperty("assocType", 8, String.class);
            if (assocTypeQNameStr != null) {
                assocTypeQNameParam = this.getAssocType(assocTypeQNameStr);
            }
        }
        List<Pair<QName, Boolean>> sortProps = this.getListChildrenSortProps(parameters);
        List<FilterProp> filterProps = this.getListChildrenFilterProps(parameters);
        Paging paging = parameters.getPaging();
        PagingRequest pagingRequest = Util.getPagingRequest(paging);
        Pair<Set<QName>, Set<QName>> pair = this.buildSearchTypesAndIgnoreAspects(parameters);
        Set searchTypeQNames = (Set)pair.getFirst();
        Set ignoreAspectQNames = (Set)pair.getSecond();
        Set<QName> assocTypeQNames = this.buildAssocTypes(assocTypeQNameParam);
        PagingResults pagingResults = !(filterProps != null && filterProps.size() != 0 || assocTypeQNames != null && assocTypeQNames.size() != 0 || !this.smartStore.isVirtual(parentNodeRef) && !this.smartStore.canVirtualize(parentNodeRef)) ? this.fileFolderService.list(parentNodeRef, searchTypeQNames, ignoreAspectQNames, sortProps, pagingRequest) : this.fileFolderService.list(parentNodeRef, assocTypeQNames, searchTypeQNames, ignoreAspectQNames, sortProps, filterProps, pagingRequest);
        final HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>(10);
        final List page = pagingResults.getPage();
        AbstractList<Node> nodes = new AbstractList<Node>(){

            @Override
            public Node get(int index) {
                FileInfo fInfo = (FileInfo)page.get(index);
                Node node = NodesImpl.this.getFolderOrDocument(fInfo.getNodeRef(), null, fInfo.getType(), includeParam, mapUserInfo);
                if (node.getPath() != null) {
                    this.calculateRelativePath(parentFolderNodeId, node);
                }
                return node;
            }

            private void calculateRelativePath(String parentFolderNodeId2, Node node) {
                NodeRef rootNodeRef = NodesImpl.this.validateOrLookupNode(parentFolderNodeId2);
                try {
                    List pathInfos = NodesImpl.this.fileFolderService.getNameOnlyPath(rootNodeRef, node.getNodeRef());
                    int sizePathInfos = pathInfos.size();
                    if (sizePathInfos > 1) {
                        pathInfos.remove(sizePathInfos - 1);
                        StringBuilder sb = new StringBuilder(pathInfos.size() * 20);
                        for (String fileInfo : pathInfos) {
                            sb.append("/");
                            sb.append(fileInfo);
                        }
                        node.getPath().setRelativePath(sb.toString());
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }

            @Override
            public int size() {
                return page.size();
            }
        };
        Node sourceEntity = null;
        if (parameters.includeSource()) {
            sourceEntity = this.getFolderOrDocumentFullInfo(parentNodeRef, null, null, null, mapUserInfo);
        }
        return CollectionWithPagingInfo.asPaged(paging, nodes, pagingResults.hasMoreItems(), (Integer)pagingResults.getTotalResultCount().getFirst(), sourceEntity);
    }

    private MapBasedQueryWalker createListChildrenQueryWalker() {
        return new MapBasedQueryWalker(LIST_FOLDER_CHILDREN_EQUALS_QUERY_PROPERTIES, null);
    }

    protected List<FilterProp> getListChildrenFilterProps(Parameters parameters) {
        ArrayList<FilterPropBoolean> filterProps = null;
        Query q = parameters.getQuery();
        if (q != null) {
            MapBasedQueryWalker propertyWalker = this.createListChildrenQueryWalker();
            QueryHelper.walk(q, propertyWalker);
            Boolean isPrimary = propertyWalker.getProperty("isPrimary", 8, Boolean.class);
            if (isPrimary != null) {
                filterProps = new ArrayList<FilterPropBoolean>(1);
                filterProps.add(new FilterPropBoolean(GetChildrenCannedQuery.FILTER_QNAME_NODE_IS_PRIMARY, isPrimary));
            }
        }
        return filterProps;
    }

    protected List<Pair<QName, Boolean>> getListChildrenSortProps(Parameters parameters) {
        List<Pair<QName, Boolean>> sortProps;
        List<SortColumn> sortCols = parameters.getSorting();
        if (sortCols != null && sortCols.size() > 0) {
            sortProps = new ArrayList<Pair<QName, Boolean>>(sortCols.size());
            for (SortColumn sortCol : sortCols) {
                QName propQname = PARAM_SYNONYMS_QNAME.get(sortCol.column);
                if (propQname == null) {
                    propQname = this.createQName(sortCol.column);
                }
                if (propQname == null) continue;
                sortProps.add((Pair<QName, Boolean>)new Pair((Object)propQname, (Object)sortCol.asc));
            }
        } else {
            sortProps = this.getListChildrenSortPropsDefault();
        }
        return sortProps;
    }

    protected List<Pair<QName, Boolean>> getListChildrenSortPropsDefault() {
        ArrayList<Pair<QName, Boolean>> sortProps = new ArrayList<Pair<QName, Boolean>>(Arrays.asList(new Pair((Object)GetChildrenCannedQuery.SORT_QNAME_NODE_IS_FOLDER, (Object)Boolean.FALSE), new Pair((Object)ContentModel.PROP_NAME, (Object)true)));
        return sortProps;
    }

    private Pair<QName, Boolean> parseNodeTypeFilter(String nodeTypeStr) {
        QName filterNodeTypeQName;
        String suffix;
        boolean filterIncludeSubTypes = false;
        int idx = nodeTypeStr.lastIndexOf(32);
        if (idx > 0 && (suffix = nodeTypeStr.substring(idx)).equalsIgnoreCase(" INCLUDESUBTYPES")) {
            filterIncludeSubTypes = true;
            nodeTypeStr = nodeTypeStr.substring(0, idx);
        }
        if (this.dictionaryService.getType(filterNodeTypeQName = this.createQName(nodeTypeStr)) == null) {
            throw new InvalidArgumentException("Unknown filter nodeType: " + nodeTypeStr);
        }
        return new Pair((Object)filterNodeTypeQName, (Object)filterIncludeSubTypes);
    }

    protected Set<QName> buildAssocTypes(QName assocTypeQName) {
        Set<QName> assocTypeQNames = null;
        if (assocTypeQName != null) {
            assocTypeQNames = Collections.singleton(assocTypeQName);
        }
        return assocTypeQNames;
    }

    protected Pair<Set<QName>, Set<QName>> buildSearchTypesAndIgnoreAspects(QName nodeTypeQName, boolean includeSubTypes, Set<QName> ignoreQNameTypes, Boolean includeFiles, Boolean includeFolders) {
        Collection qnames;
        HashSet<QName> searchTypeQNames = new HashSet<QName>(100);
        Set<QName> ignoreAspectQNames = null;
        if (nodeTypeQName != null) {
            if (includeSubTypes) {
                qnames = this.dictionaryService.getSubTypes(nodeTypeQName, true);
                searchTypeQNames.addAll(qnames);
            }
            searchTypeQNames.add(nodeTypeQName);
            if (includeSubTypes) {
                qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_SYSTEM_FOLDER, true);
                searchTypeQNames.removeAll(qnames);
            }
            searchTypeQNames.remove(ContentModel.TYPE_SYSTEM_FOLDER);
        }
        if (includeFiles != null) {
            if (includeFiles.booleanValue()) {
                if (includeSubTypes) {
                    qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_CONTENT, true);
                    searchTypeQNames.addAll(qnames);
                }
                searchTypeQNames.add(ContentModel.TYPE_CONTENT);
            } else {
                qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_CONTENT, true);
                searchTypeQNames.removeAll(qnames);
                searchTypeQNames.remove(ContentModel.TYPE_CONTENT);
            }
        }
        if (includeFolders != null) {
            if (includeFolders.booleanValue()) {
                if (includeSubTypes) {
                    qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_FOLDER, true);
                    searchTypeQNames.addAll(qnames);
                }
                searchTypeQNames.add(ContentModel.TYPE_FOLDER);
                if (includeSubTypes) {
                    qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_SYSTEM_FOLDER, true);
                    searchTypeQNames.removeAll(qnames);
                }
                searchTypeQNames.remove(ContentModel.TYPE_SYSTEM_FOLDER);
            } else {
                qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_FOLDER, true);
                searchTypeQNames.removeAll(qnames);
                searchTypeQNames.remove(ContentModel.TYPE_FOLDER);
            }
        }
        if (ignoreQNameTypes != null) {
            HashSet<QName> ignoreQNamesNotSearchTypes = new HashSet<QName>(ignoreQNameTypes);
            ignoreQNamesNotSearchTypes.removeAll(searchTypeQNames);
            ignoreQNamesNotSearchTypes.remove(ContentModel.TYPE_SYSTEM_FOLDER);
            if (ignoreQNamesNotSearchTypes.size() > 0) {
                ignoreAspectQNames = this.getAspectsToIgnore(ignoreQNamesNotSearchTypes);
            }
            searchTypeQNames.removeAll(ignoreQNameTypes);
        }
        return new Pair(searchTypeQNames, ignoreAspectQNames);
    }

    protected Pair<Set<QName>, Set<QName>> buildSearchTypesAndIgnoreAspects(Parameters parameters) {
        Boolean includeFolders = null;
        Boolean includeFiles = null;
        QName filterNodeTypeQName = null;
        boolean filterIncludeSubTypes = true;
        Query q = parameters.getQuery();
        if (q != null) {
            MapBasedQueryWalker propertyWalker = this.createListChildrenQueryWalker();
            QueryHelper.walk(q, propertyWalker);
            Boolean isFolder = propertyWalker.getProperty("isFolder", 8, Boolean.class);
            Boolean isFile = propertyWalker.getProperty("isFile", 8, Boolean.class);
            if (isFolder != null) {
                includeFolders = isFolder;
            }
            if (isFile != null) {
                includeFiles = isFile;
            }
            if (Boolean.TRUE.equals(includeFiles) && Boolean.TRUE.equals(includeFolders)) {
                throw new InvalidArgumentException("Invalid filter (isFile=true and isFolder=true) - a node cannot be both a file and a folder");
            }
            String nodeTypeStr = propertyWalker.getProperty("nodeType", 8, String.class);
            if (nodeTypeStr != null && !nodeTypeStr.isEmpty()) {
                if (isFile != null || isFolder != null) {
                    throw new InvalidArgumentException("Invalid filter - nodeType and isFile/isFolder are mutually exclusive");
                }
                Pair<QName, Boolean> pair = this.parseNodeTypeFilter(nodeTypeStr);
                filterNodeTypeQName = (QName)pair.getFirst();
                filterIncludeSubTypes = (Boolean)pair.getSecond();
            }
        }
        if (filterNodeTypeQName == null) {
            if (includeFiles == null && includeFolders == null) {
                filterNodeTypeQName = ContentModel.TYPE_CMOBJECT;
            } else if (includeFiles != null && includeFolders != null) {
                if (!includeFiles.booleanValue() && !includeFolders.booleanValue()) {
                    filterNodeTypeQName = ContentModel.TYPE_CMOBJECT;
                }
            } else if (includeFiles != null && !includeFiles.booleanValue()) {
                filterNodeTypeQName = ContentModel.TYPE_CMOBJECT;
            } else if (includeFolders != null && !includeFolders.booleanValue()) {
                filterNodeTypeQName = ContentModel.TYPE_CMOBJECT;
            }
        }
        return this.buildSearchTypesAndIgnoreAspects(filterNodeTypeQName, filterIncludeSubTypes, this.ignoreQNames, includeFiles, includeFolders);
    }

    private Set<QName> getAspectsToIgnore(Set<QName> ignoreQNames) {
        HashSet<QName> ignoreQNameAspects = new HashSet<QName>(ignoreQNames.size());
        for (QName qname : ignoreQNames) {
            if (this.dictionaryService.getAspect(qname) == null) continue;
            ignoreQNameAspects.add(qname);
        }
        return ignoreQNameAspects;
    }

    @Override
    public void deleteNode(String nodeId, Parameters parameters) {
        NodeRef nodeRef = this.validateOrLookupNode(nodeId);
        if (this.isSpecialNode(nodeRef, this.getNodeType(nodeRef))) {
            throw new PermissionDeniedException("Cannot delete: " + nodeId);
        }
        boolean permanentDelete = Boolean.valueOf(parameters.getParameter("permanent"));
        if (permanentDelete) {
            boolean isAdmin = this.authorityService.hasAdminAuthority();
            if (!isAdmin) {
                String owner = this.ownableService.getOwner(nodeRef);
                if (!AuthenticationUtil.getRunAsUser().equals(owner)) {
                    throw new PermissionDeniedException("Non-owner/non-admin cannot permanently delete: " + nodeId);
                }
            }
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TEMPORARY, null);
        }
        ActivityInfo activityInfo = this.getActivityInfo(this.getParentNodeRef(nodeRef), nodeRef);
        this.postActivity(Activity_Type.DELETED, activityInfo, true);
        this.fileFolderService.delete(nodeRef);
    }

    @Override
    public Node createNode(String parentFolderNodeId, Node nodeInfo, Parameters parameters) {
        String versioningEnabledStringValue;
        NodeRef existingNode;
        if (nodeInfo.getNodeRef() != null) {
            throw new InvalidArgumentException("Unexpected id when trying to create a new node: " + nodeInfo.getNodeRef().getId());
        }
        this.validateAspects(nodeInfo.getAspectNames(), EXCLUDED_NS, EXCLUDED_ASPECTS);
        this.validateProperties(nodeInfo.getProperties(), EXCLUDED_NS, Arrays.asList(new QName[0]));
        NodeRef parentNodeRef = this.validateOrLookupNode(parentFolderNodeId);
        String nodeName = nodeInfo.getName();
        if (nodeName == null || nodeName.isEmpty()) {
            throw new InvalidArgumentException("Node name is expected: " + parentNodeRef.getId());
        }
        String nodeType = nodeInfo.getNodeType();
        if (nodeType == null || nodeType.isEmpty()) {
            throw new InvalidArgumentException("Node type is expected: " + parentNodeRef.getId() + "," + nodeName);
        }
        QName nodeTypeQName = this.createQName(nodeType);
        boolean isContent = this.isSubClass(nodeTypeQName, ContentModel.TYPE_CONTENT);
        if (!isContent) {
            this.validateCmObject(nodeTypeQName);
        }
        HashMap<QName, Serializable> props = new HashMap(1);
        if (nodeInfo.getProperties() != null) {
            props = this.mapToNodeProperties(nodeInfo.getProperties());
        }
        String relativePath = nodeInfo.getRelativePath();
        parentNodeRef = this.getOrCreatePath(parentNodeRef, relativePath);
        boolean autoRename = Boolean.valueOf(parameters.getParameter("autoRename"));
        if (autoRename && (isContent || this.isSubClass(nodeTypeQName, ContentModel.TYPE_FOLDER)) && (existingNode = this.nodeService.getChildByName(parentNodeRef, ContentModel.ASSOC_CONTAINS, nodeName)) != null) {
            nodeName = this.findUniqueName(parentNodeRef, nodeName);
        }
        QName assocTypeQName = ContentModel.ASSOC_CONTAINS;
        if (nodeInfo.getAssociation() != null && nodeInfo.getAssociation().getAssocType() != null) {
            assocTypeQName = this.getAssocType(nodeInfo.getAssociation().getAssocType());
        }
        Boolean versionMajor = null;
        String str = parameters.getParameter("majorVersion");
        if (str != null) {
            versionMajor = Boolean.valueOf(str);
        }
        if (null != (versioningEnabledStringValue = parameters.getParameter("versioningEnabled"))) {
            boolean versioningEnabled = Boolean.parseBoolean(versioningEnabledStringValue);
            versionMajor = versioningEnabled ? Boolean.valueOf(null != versionMajor ? versionMajor : true) : null;
        }
        String versionComment = parameters.getParameter("comment");
        NodeRef nodeRef = isContent ? this.createNewFile(parentNodeRef, nodeName, nodeTypeQName, null, props, assocTypeQName, parameters, versionMajor, versionComment) : this.createNodeImpl(parentNodeRef, nodeName, nodeTypeQName, props, assocTypeQName);
        this.addCustomAspects(nodeRef, nodeInfo.getAspectNames(), EXCLUDED_ASPECTS);
        this.processNodePermissions(nodeRef, nodeInfo);
        if (nodeInfo.getTargets() != null) {
            this.addTargets(nodeRef.getId(), nodeInfo.getTargets());
        }
        if (nodeInfo.getSecondaryChildren() != null) {
            this.addChildren(nodeRef.getId(), nodeInfo.getSecondaryChildren());
        }
        Node newNode = this.getFolderOrDocument(nodeRef.getId(), parameters);
        return newNode;
    }

    @Override
    public void addCustomAspects(NodeRef nodeRef, List<String> aspectNames, List<QName> excludedAspects) {
        if (aspectNames == null) {
            return;
        }
        Set<QName> aspectQNames = this.mapToNodeAspects(aspectNames);
        for (QName aspectQName : aspectQNames) {
            if (excludedAspects.contains(aspectQName) || aspectQName.equals((Object)ContentModel.ASPECT_AUDITABLE)) continue;
            this.nodeService.addAspect(nodeRef, aspectQName, null);
        }
    }

    private NodeRef getOrCreatePath(NodeRef parentNodeRef, String relativePath) {
        List<String> pathElements;
        if (relativePath != null && !(pathElements = this.getPathElements(relativePath)).isEmpty()) {
            parentNodeRef = this.makeFolders(parentNodeRef, pathElements);
        }
        return parentNodeRef;
    }

    @Override
    public List<AssocChild> addChildren(String parentNodeId, List<AssocChild> entities) {
        NodeRef parentNodeRef = this.validateNode(parentNodeId);
        ArrayList<AssocChild> result = new ArrayList<AssocChild>(entities.size());
        for (AssocChild assoc : entities) {
            String childId = assoc.getChildId();
            if (childId == null) {
                throw new InvalidArgumentException("Missing childId");
            }
            QName assocTypeQName = this.getAssocType(assoc.getAssocType());
            try {
                NodeRef childNodeRef = this.validateNode(childId);
                String nodeName = (String)((Object)this.nodeService.getProperty(childNodeRef, ContentModel.PROP_NAME));
                QName assocChildQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)nodeName));
                this.nodeService.addChild(parentNodeRef, childNodeRef, assocTypeQName, assocChildQName);
            }
            catch (AssociationExistsException aee) {
                throw new ConstraintViolatedException(aee.getMessage());
            }
            catch (DuplicateChildNodeNameException dcne) {
                throw new ConstraintViolatedException(dcne.getMessage());
            }
            result.add(assoc);
        }
        return result;
    }

    @Override
    public List<AssocTarget> addTargets(String sourceNodeId, List<AssocTarget> entities) {
        ArrayList<AssocTarget> result = new ArrayList<AssocTarget>(entities.size());
        NodeRef srcNodeRef = this.validateNode(sourceNodeId);
        for (AssocTarget assoc : entities) {
            String targetNodeId = assoc.getTargetId();
            if (targetNodeId == null) {
                throw new InvalidArgumentException("Missing targetId");
            }
            String assocTypeStr = assoc.getAssocType();
            QName assocTypeQName = this.getAssocType(assocTypeStr);
            try {
                NodeRef tgtNodeRef = this.validateNode(targetNodeId);
                this.nodeService.createAssociation(srcNodeRef, tgtNodeRef, assocTypeQName);
            }
            catch (AssociationExistsException aee) {
                throw new ConstraintViolatedException("Node association '" + assocTypeStr + "' already exists from " + sourceNodeId + " to " + targetNodeId);
            }
            catch (IllegalArgumentException iae) {
                throw new InvalidArgumentException(sourceNodeId + "," + assocTypeStr + "," + targetNodeId);
            }
            result.add(assoc);
        }
        return result;
    }

    @Override
    public QName getAssocType(String assocTypeQNameStr) {
        return this.getAssocType(assocTypeQNameStr, true);
    }

    @Override
    public QName getAssocType(String assocTypeQNameStr, boolean mandatory) {
        QName assocType = null;
        if (assocTypeQNameStr != null && !assocTypeQNameStr.isEmpty()) {
            assocType = this.createQName(assocTypeQNameStr);
            if (this.dictionaryService.getAssociation(assocType) == null) {
                throw new InvalidArgumentException("Unknown assocType: " + assocTypeQNameStr);
            }
            if (EXCLUDED_NS.contains(assocType.getNamespaceURI())) {
                throw new InvalidArgumentException("Invalid assocType: " + assocTypeQNameStr);
            }
        }
        if (mandatory && assocType == null) {
            throw new InvalidArgumentException("Missing assocType");
        }
        return assocType;
    }

    private NodeRef createNodeImpl(NodeRef parentNodeRef, String nodeName, QName nodeTypeQName, Map<QName, Serializable> props, QName assocTypeQName) {
        NodeRef newNode = null;
        if (props == null) {
            props = new HashMap<QName, Serializable>(1);
        }
        props.put(ContentModel.PROP_NAME, (Serializable)((Object)nodeName));
        this.validatePropValues(props);
        QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)nodeName));
        try {
            newNode = this.nodeService.createNode(parentNodeRef, assocTypeQName, assocQName, nodeTypeQName, props).getChildRef();
        }
        catch (DuplicateChildNodeNameException dcne) {
            throw new ConstraintViolatedException(dcne.getMessage());
        }
        ActivityInfo activityInfo = this.getActivityInfo(parentNodeRef, newNode);
        this.postActivity(Activity_Type.ADDED, activityInfo, false);
        return newNode;
    }

    protected void postActivity(Activity_Type activity_type, ActivityInfo activityInfo, boolean aSync) {
        if (activityInfo == null) {
            return;
        }
        String activityType = NodesImpl.determineActivityType(activity_type, activityInfo.getFileInfo().isFolder());
        if (activityType != null) {
            if (aSync) {
                ActivitiesTransactionListener txListener = new ActivitiesTransactionListener(activityType, activityInfo, TenantUtil.getCurrentDomain(), "restapi", Activities.RESTAPI_CLIENT, this.poster, this.retryingTransactionHelper);
                AlfrescoTransactionSupport.bindListener((TransactionListener)txListener);
            } else {
                this.poster.postFileFolderActivity(activityType, null, TenantUtil.getCurrentDomain(), activityInfo.getSiteId(), activityInfo.getParentNodeRef(), activityInfo.getNodeRef(), activityInfo.getFileName(), "restapi", Activities.RESTAPI_CLIENT, activityInfo.getFileInfo());
            }
        }
    }

    protected ActivityInfo getActivityInfo(NodeRef parentNodeRef, final NodeRef nodeRef) {
        String siteId;
        SiteInfo siteInfo = (SiteInfo)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<SiteInfo>(){

            public SiteInfo doWork() throws Exception {
                return NodesImpl.this.siteService.getSite(nodeRef);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        String string = siteId = siteInfo != null ? siteInfo.getShortName() : null;
        if (siteId != null && !siteId.equals("")) {
            FileInfo fileInfo = this.fileFolderService.getFileInfo(nodeRef);
            if (fileInfo != null) {
                boolean isContent = this.isSubClass(fileInfo.getType(), ContentModel.TYPE_CONTENT);
                if (fileInfo.isFolder() || isContent) {
                    return new ActivityInfo(null, parentNodeRef, siteId, fileInfo);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Non-site activity, so ignored " + String.valueOf(nodeRef)));
        }
        return null;
    }

    protected static String determineActivityType(Activity_Type activity_type, boolean isFolder) {
        switch (activity_type) {
            case DELETED: {
                return isFolder ? "org.alfresco.documentlibrary.folder-deleted" : "org.alfresco.documentlibrary.file-deleted";
            }
            case ADDED: {
                return isFolder ? "org.alfresco.documentlibrary.folder-added" : "org.alfresco.documentlibrary.file-added";
            }
            case UPDATED: {
                if (isFolder) break;
                return "org.alfresco.documentlibrary.file-updated";
            }
            case DOWNLOADED: {
                if (isFolder) break;
                return "org.alfresco.documentlibrary.file-downloaded";
            }
        }
        return null;
    }

    private void validateCmObject(QName nodeTypeQName) {
        if (!this.isSubClass(nodeTypeQName, ContentModel.TYPE_CMOBJECT)) {
            throw new InvalidArgumentException("Invalid type: " + String.valueOf(nodeTypeQName) + " - expected (sub-)type of cm:cmobject");
        }
        if (this.isSubClass(nodeTypeQName, ContentModel.TYPE_SYSTEM_FOLDER)) {
            throw new InvalidArgumentException("Invalid type: " + String.valueOf(nodeTypeQName) + " - cannot be (sub-)type of cm:systemfolder");
        }
    }

    private void validatePropValues(Map<QName, Serializable> props) {
        String newOwner = (String)((Object)props.get(ContentModel.PROP_OWNER));
        if (newOwner != null && !this.personService.personExists(newOwner)) {
            throw new InvalidArgumentException("Unknown owner: " + newOwner);
        }
    }

    protected boolean isSpecialNode(NodeRef nodeRef, QName type) {
        List ddAssocs;
        if (nodeRef.equals((Object)this.repositoryHelper.getCompanyHome())) {
            return true;
        }
        if (type.equals((Object)SiteModel.TYPE_SITES) || type.equals((Object)SiteModel.TYPE_SITE)) {
            return true;
        }
        String tenantDomain = TenantUtil.getCurrentDomain();
        NodeRef ddNodeRef = this.ddCache.get(tenantDomain);
        if (ddNodeRef == null && (ddAssocs = this.nodeService.getChildAssocs(this.repositoryHelper.getCompanyHome(), (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"dictionary"))).size() == 1) {
            ddNodeRef = ((ChildAssociationRef)ddAssocs.get(0)).getChildRef();
            this.ddCache.put(tenantDomain, ddNodeRef);
        }
        return nodeRef.equals((Object)ddNodeRef);
    }

    private boolean isLocked(NodeRef nodeRef, Set<QName> aspects) {
        boolean locked = false;
        if (aspects != null && aspects.contains(ContentModel.ASPECT_LOCKABLE) || this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
            locked = this.lockService.isLocked(nodeRef);
        }
        return locked;
    }

    @Override
    public Node updateNode(final String nodeId, final Node nodeInfo, final Parameters parameters) {
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef nodeRef = NodesImpl.this.updateNodeImpl(nodeId, nodeInfo, parameters);
                ActivityInfo activityInfo = NodesImpl.this.getActivityInfo(NodesImpl.this.getParentNodeRef(nodeRef), nodeRef);
                NodesImpl.this.postActivity(Activity_Type.UPDATED, activityInfo, false);
                return null;
            }
        }, false, true);
        return (Node)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Node>(){

            public Node execute() throws Throwable {
                return NodesImpl.this.getFolderOrDocument(nodeId, parameters);
            }
        }, false, false);
    }

    protected NodeRef updateNodeImpl(String nodeId, Node nodeInfo, Parameters parameters) {
        NodeRef parentNodeRef;
        String nodeType;
        String name;
        this.validateAspects(nodeInfo.getAspectNames(), EXCLUDED_NS, EXCLUDED_ASPECTS);
        this.validateProperties(nodeInfo.getProperties(), EXCLUDED_NS, Arrays.asList(new QName[0]));
        NodeRef nodeRef = this.validateOrLookupNode(nodeId);
        QName nodeTypeQName = this.getNodeType(nodeRef);
        this.validateCmObject(nodeTypeQName);
        Map<Object, Object> props = new HashMap(0);
        if (nodeInfo.getProperties() != null) {
            props = this.mapToNodeProperties(nodeInfo.getProperties());
        }
        if ((name = nodeInfo.getName()) != null && !name.isEmpty()) {
            props.put(ContentModel.PROP_NAME, name);
        }
        if ((nodeType = nodeInfo.getNodeType()) != null && !nodeType.isEmpty()) {
            QName destNodeTypeQName = this.createQName(nodeType);
            if (!destNodeTypeQName.equals((Object)nodeTypeQName) && this.isSubClass(destNodeTypeQName, nodeTypeQName) && !this.isSubClass(destNodeTypeQName, ContentModel.TYPE_SYSTEM_FOLDER)) {
                this.nodeService.setType(nodeRef, destNodeTypeQName);
            } else if (!destNodeTypeQName.equals((Object)nodeTypeQName)) {
                throw new InvalidArgumentException("Failed to change (specialise) node type - from " + String.valueOf(nodeTypeQName) + " to " + String.valueOf(destNodeTypeQName));
            }
        }
        if ((parentNodeRef = nodeInfo.getParentId()) != null) {
            NodeRef currentParentNodeRef = this.getParentNodeRef(nodeRef);
            if (currentParentNodeRef == null) {
                throw new PermissionDeniedException();
            }
            if (!currentParentNodeRef.equals((Object)parentNodeRef)) {
                throw new InvalidArgumentException("Cannot update parentId of " + nodeId + " via PUT /nodes/{nodeId}. Please use explicit POST /nodes/{nodeId}/move operation instead");
            }
        }
        List<String> aspectNames = nodeInfo.getAspectNames();
        this.updateCustomAspects(nodeRef, aspectNames, EXCLUDED_ASPECTS);
        if (props.size() > 0) {
            this.validatePropValues(props);
            try {
                this.handleNodeRename(props, nodeRef);
                this.nodeService.addProperties(nodeRef, props);
            }
            catch (DuplicateChildNodeNameException dcne) {
                throw new ConstraintViolatedException(dcne.getMessage());
            }
        }
        this.processNodePermissions(nodeRef, nodeInfo);
        return nodeRef;
    }

    private void handleNodeRename(Map<QName, Serializable> props, NodeRef nodeRef) {
        Serializable nameProp = props.get(ContentModel.PROP_NAME);
        this.handleNodeRename(nameProp, nodeRef);
    }

    private void handleNodeRename(Serializable nameProp, NodeRef nodeRef) {
        String newName;
        String currentName;
        if (nameProp != null && !(currentName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME))).equals(newName = (String)((Object)nameProp))) {
            this.rename(nodeRef, newName);
        }
    }

    protected void processNodePermissions(NodeRef nodeRef, Node nodeInfo) {
        NodePermissions nodePerms = nodeInfo.getPermissions();
        if (nodePerms != null) {
            if (nodePerms.getInherited() != null && nodePerms.getInherited().size() > 0) {
                throw new InvalidArgumentException("Cannot set *inherited* permissions on this node");
            }
            if (nodePerms.getIsInheritanceEnabled() != null) {
                this.setSiteManagerPermission(nodeRef, nodePerms);
                if (nodePerms.getIsInheritanceEnabled().booleanValue() != this.permissionService.getInheritParentPermissions(nodeRef)) {
                    this.permissionService.setInheritParentPermissions(nodeRef, nodePerms.getIsInheritanceEnabled().booleanValue());
                }
            }
            if (nodePerms.getLocallySet() != null) {
                HashSet<AccessPermission> directPerms = new HashSet<AccessPermission>(5);
                for (AccessPermission accessPerm : this.permissionService.getAllSetPermissions(nodeRef)) {
                    if (!accessPerm.isSetDirectly()) continue;
                    directPerms.add(accessPerm);
                }
                if (this.hasDuplicatePermissions(nodePerms.getLocallySet())) {
                    throw new InvalidArgumentException("Duplicate node permissions, there is more than one permission with the same authority and name!");
                }
                for (NodePermissions.NodePermission nodePerm : nodePerms.getLocallySet()) {
                    String permName = nodePerm.getName();
                    String authorityId = nodePerm.getAuthorityId();
                    AccessStatus accessStatus = AccessStatus.ALLOWED;
                    if (nodePerm.getAccessStatus() != null) {
                        accessStatus = AccessStatus.valueOf((String)nodePerm.getAccessStatus());
                    }
                    if (authorityId == null || authorityId.isEmpty()) {
                        throw new InvalidArgumentException("Authority Id is expected.");
                    }
                    if (permName == null || permName.isEmpty()) {
                        throw new InvalidArgumentException("Permission name is expected.");
                    }
                    if (!authorityId.equals("GROUP_EVERYONE") && !this.authorityService.authorityExists(authorityId)) {
                        throw new InvalidArgumentException("Cannot set permissions on this node - unknown authority: " + authorityId);
                    }
                    AccessPermission existing = null;
                    boolean addPerm = true;
                    boolean updatePerm = false;
                    for (AccessPermission accessPerm : directPerms) {
                        if (!accessPerm.getAuthority().equals(authorityId) || !accessPerm.getPermission().equals(permName)) continue;
                        existing = accessPerm;
                        addPerm = false;
                        if (accessPerm.getAccessStatus() == accessStatus) break;
                        updatePerm = true;
                        break;
                    }
                    if (existing != null) {
                        directPerms.remove(existing);
                    }
                    if (!addPerm && !updatePerm) continue;
                    try {
                        this.permissionService.setPermission(nodeRef, authorityId, permName, accessStatus == AccessStatus.ALLOWED);
                    }
                    catch (UnsupportedOperationException e) {
                        throw new InvalidArgumentException("Cannot set permissions on this node - unknown access level: " + permName);
                    }
                }
                for (AccessPermission accessPerm : directPerms) {
                    this.permissionService.deletePermission(nodeRef, accessPerm.getAuthority(), accessPerm.getPermission());
                }
            }
        }
    }

    @Override
    public Node moveOrCopyNode(String sourceNodeId, String targetParentId, String name, Parameters parameters, boolean isCopy) {
        if (sourceNodeId == null || sourceNodeId.isEmpty()) {
            throw new InvalidArgumentException("Missing sourceNodeId");
        }
        if (targetParentId == null || targetParentId.isEmpty()) {
            throw new InvalidArgumentException("Missing targetParentId");
        }
        NodeRef parentNodeRef = this.validateOrLookupNode(targetParentId);
        NodeRef sourceNodeRef = this.validateOrLookupNode(sourceNodeId);
        FileInfo fi = this.moveOrCopyImpl(sourceNodeRef, parentNodeRef, name, isCopy);
        return this.getFolderOrDocument(fi.getNodeRef().getId(), parameters);
    }

    @Override
    public void updateCustomAspects(NodeRef nodeRef, List<String> aspectNames, List<QName> excludedAspects) {
        if (aspectNames != null) {
            Set<QName> aspectQNames = this.mapToNodeAspects(aspectNames);
            Set existingAspects = this.nodeService.getAspects(nodeRef);
            HashSet<QName> aspectsToAdd = new HashSet<QName>(3);
            HashSet<QName> aspectsToRemove = new HashSet<QName>(3);
            boolean hasRules = this.ruleService.hasRules(nodeRef);
            for (QName aspectQName : aspectQNames) {
                if (EXCLUDED_NS.contains(aspectQName.getNamespaceURI()) || excludedAspects.contains(aspectQName) || aspectQName.equals((Object)ContentModel.ASPECT_AUDITABLE) || existingAspects.contains(aspectQName)) continue;
                aspectsToAdd.add(aspectQName);
            }
            for (QName existingAspect : existingAspects) {
                if (EXCLUDED_NS.contains(existingAspect.getNamespaceURI()) || excludedAspects.contains(existingAspect) || existingAspect.equals((Object)ContentModel.ASPECT_AUDITABLE) || existingAspect.equals((Object)RuleModel.ASPECT_RULES) && hasRules || aspectQNames.contains(existingAspect)) continue;
                aspectsToRemove.add(existingAspect);
            }
            for (QName aQName : aspectsToRemove) {
                String qSharedId;
                if (aQName.equals((Object)QuickShareModel.ASPECT_QSHARE) && (qSharedId = (String)((Object)this.nodeService.getProperty(nodeRef, QuickShareModel.PROP_QSHARE_SHAREDID))) != null) {
                    this.quickShareLinks.delete(qSharedId, null);
                }
                this.nodeService.removeAspect(nodeRef, aQName);
            }
            for (QName aQName : aspectsToAdd) {
                if (aQName.equals((Object)QuickShareModel.ASPECT_QSHARE)) {
                    QuickShareLink qs = new QuickShareLink();
                    qs.setNodeId(nodeRef.getId());
                    this.quickShareLinks.create(Collections.singletonList(qs), null);
                }
                this.nodeService.addAspect(nodeRef, aQName, null);
            }
        }
    }

    private void rename(NodeRef nodeRef, String name) {
        try {
            this.fileFolderService.rename(nodeRef, name);
        }
        catch (FileNotFoundException fnfe) {
            throw new EntityNotFoundException(nodeRef.getId());
        }
        catch (FileExistsException fee) {
            throw new ConstraintViolatedException("Name already exists in target parent: " + name);
        }
    }

    protected FileInfo moveOrCopyImpl(NodeRef nodeRef, NodeRef parentNodeRef, String name, boolean isCopy) {
        String targetParentId = parentNodeRef.getId();
        try {
            if (isCopy) {
                FileInfo newFileInfo = this.fileFolderService.copy(nodeRef, parentNodeRef, name);
                if (newFileInfo.getNodeRef().equals((Object)nodeRef)) {
                    throw new FileExistsException(nodeRef, "");
                }
                return newFileInfo;
            }
            if (!nodeRef.equals((Object)parentNodeRef) && this.isSpecialNode(nodeRef, this.getNodeType(nodeRef))) {
                throw new PermissionDeniedException("Cannot move: " + nodeRef.getId());
            }
            return this.fileFolderService.move(nodeRef, parentNodeRef, name);
        }
        catch (InvalidNodeRefException inre) {
            throw new EntityNotFoundException(targetParentId);
        }
        catch (FileNotFoundException fnfe) {
            throw new EntityNotFoundException(targetParentId);
        }
        catch (FileExistsException fee) {
            throw new ConstraintViolatedException("Name already exists in target parent: " + name);
        }
        catch (FileFolderServiceImpl.InvalidTypeException ite) {
            throw new InvalidArgumentException("Invalid type of target parent: " + targetParentId);
        }
    }

    @Override
    public BinaryResource getContent(String fileNodeId, Parameters parameters, boolean recordActivity) {
        NodeRef nodeRef = this.validateNode(fileNodeId);
        return this.getContent(nodeRef, parameters, recordActivity);
    }

    @Override
    public BinaryResource getContent(NodeRef nodeRef, Parameters parameters, boolean recordActivity) {
        String attachFileName;
        Boolean a;
        if (!this.nodeMatches(nodeRef, Collections.singleton(ContentModel.TYPE_CONTENT), null, false)) {
            throw new InvalidArgumentException("NodeId of content is expected: " + nodeRef.getId());
        }
        Map nodeProps = this.nodeService.getProperties(nodeRef);
        ContentData cd = (ContentData)nodeProps.get(ContentModel.PROP_CONTENT);
        String name = (String)nodeProps.get(ContentModel.PROP_NAME);
        ContentInfoImpl ci = null;
        String mimeType = null;
        if (cd != null) {
            mimeType = cd.getMimetype();
            ci = new ContentInfoImpl(mimeType, cd.getEncoding(), cd.getSize(), cd.getLocale());
        }
        boolean attach = true;
        String attachment = parameters.getParameter("attachment");
        if (attachment != null && !(a = Boolean.valueOf(attachment)).booleanValue()) {
            if (this.nonAttachContentTypes.contains(mimeType)) {
                attach = false;
            } else {
                logger.warn((Object)("Ignored attachment=false for " + nodeRef.getId() + " since " + mimeType + " is not in the whitelist for non-attach content types"));
            }
        }
        String string = attachFileName = attach ? name : null;
        if (recordActivity) {
            ActivityInfo activityInfo = this.getActivityInfo(this.getParentNodeRef(nodeRef), nodeRef);
            this.postActivity(Activity_Type.DOWNLOADED, activityInfo, true);
        }
        return new NodeBinaryResource(nodeRef, ContentModel.PROP_CONTENT, ci, attachFileName);
    }

    @Override
    public Node updateContent(String fileNodeId, BasicContentInfo contentInfo, InputStream stream, Parameters parameters) {
        if (contentInfo.getMimeType().toLowerCase().startsWith("multipart")) {
            throw new UnsupportedMediaTypeException("Cannot update using " + contentInfo.getMimeType());
        }
        NodeRef nodeRef = this.validateNode(fileNodeId);
        if (!this.nodeMatches(nodeRef, Collections.singleton(ContentModel.TYPE_CONTENT), null, false)) {
            throw new InvalidArgumentException("NodeId of content is expected: " + nodeRef.getId());
        }
        Boolean versionMajor = null;
        String str = parameters.getParameter("majorVersion");
        if (str != null) {
            versionMajor = Boolean.valueOf(str);
        }
        String versionComment = parameters.getParameter("comment");
        String fileName = parameters.getParameter("name");
        if (fileName != null) {
            this.handleNodeRename((Serializable)((Object)fileName), nodeRef);
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)fileName));
        } else {
            fileName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
        }
        return this.updateExistingFile(null, nodeRef, fileName, contentInfo, stream, parameters, versionMajor, versionComment);
    }

    private void setSiteManagerPermission(NodeRef nodeRef, NodePermissions nodePerms) {
        if (nodeRef != null && nodePerms != null) {
            try {
                SiteInfo containingSite;
                if (nodePerms.getIsInheritanceEnabled() != null && !nodePerms.getIsInheritanceEnabled().booleanValue() && (containingSite = this.siteService.getSite(nodeRef)) != null) {
                    String thisSiteGroupPrefix = this.siteService.getSiteGroup(containingSite.getShortName());
                    String siteManagerAuthority = thisSiteGroupPrefix + "_SiteManager";
                    AuthenticationUtil.runAsSystem(() -> {
                        this.permissionService.setPermission(nodeRef, siteManagerAuthority, "SiteManager", true);
                        return null;
                    });
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error setting site manager permission on " + String.valueOf(nodeRef)), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node updateExistingFile(NodeRef parentNodeRef, NodeRef nodeRef, String fileName, BasicContentInfo contentInfo, InputStream stream, Parameters parameters, Boolean versionMajor, String versionComment) {
        boolean isVersioned = this.versionService.isVersioned(nodeRef);
        this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
        try {
            this.writeContent(nodeRef, fileName, stream, true);
            if (isVersioned || versionMajor != null || versionComment != null) {
                VersionType versionType = null;
                versionType = versionMajor != null ? (versionMajor != false ? VersionType.MAJOR : VersionType.MINOR) : (!isVersioned || this.nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL) == null ? VersionType.MAJOR : VersionType.MINOR);
                this.createVersion(nodeRef, isVersioned, versionType, versionComment);
            }
            ActivityInfo activityInfo = this.getActivityInfo(parentNodeRef, nodeRef);
            this.postActivity(Activity_Type.UPDATED, activityInfo, false);
            this.extractMetadata(nodeRef);
        }
        finally {
            this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
        }
        return this.getFolderOrDocumentFullInfo(nodeRef, null, null, parameters);
    }

    private void writeContent(NodeRef nodeRef, String fileName, InputStream stream, boolean guessEncoding) {
        try {
            ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
            String mimeType = this.mimetypeService.guessMimetype(fileName);
            if (mimeType != null && !mimeType.equals("application/octet-stream")) {
                writer.setMimetype(mimeType);
            } else {
                writer.guessMimetype(fileName);
            }
            InputStream is = null;
            if (guessEncoding) {
                is = new BufferedInputStream(stream);
                is.mark(1024);
                writer.setEncoding(this.guessEncoding(is, mimeType, false));
                try {
                    is.reset();
                }
                catch (IOException ioe) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("Failed to reset stream after trying to guess encoding: " + ioe.getMessage()));
                    }
                }
            } else {
                is = stream;
            }
            writer.putContent(is);
        }
        catch (ContentQuotaException cqe) {
            throw new InsufficientStorageException();
        }
        catch (ContentLimitViolationException clv) {
            throw new RequestEntityTooLargeException(clv.getMessage());
        }
        catch (ContentIOException cioe) {
            if (cioe.getCause() instanceof NodeLockedException) {
                throw (NodeLockedException)cioe.getCause();
            }
            throw cioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String guessEncoding(InputStream in, String mimeType, boolean close) {
        String encoding = "UTF-8";
        try {
            if (in != null) {
                Charset charset = this.mimetypeService.getContentCharsetFinder().getCharset(in, mimeType);
                encoding = charset.name();
            }
        }
        finally {
            block10: {
                try {
                    if (close && in != null) {
                        in.close();
                    }
                }
                catch (IOException ioe) {
                    if (!logger.isWarnEnabled()) break block10;
                    logger.warn((Object)("Failed to close stream after trying to guess encoding: " + ioe.getMessage()));
                }
            }
        }
        return encoding;
    }

    protected void createVersion(NodeRef nodeRef, boolean isVersioned, VersionType versionType, String reason) {
        if (!isVersioned) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        }
        HashMap<String, Object> versionProperties = new HashMap<String, Object>(2);
        versionProperties.put("versionType", versionType);
        if (reason != null) {
            versionProperties.put("description", reason);
        }
        this.versionService.createVersion(nodeRef, versionProperties);
    }

    @Override
    public Node upload(String parentFolderNodeId, FormData formData, Parameters parameters) {
        if (formData == null || !formData.getIsMultiPart()) {
            throw new InvalidArgumentException("The request content-type is not multipart: " + parentFolderNodeId);
        }
        NodeRef parentNodeRef = this.validateOrLookupNode(parentFolderNodeId);
        if (!this.nodeMatches(parentNodeRef, Collections.singleton(ContentModel.TYPE_FOLDER), null, false)) {
            throw new InvalidArgumentException("NodeId of folder is expected: " + parentNodeRef.getId());
        }
        String fileName = null;
        Content content = null;
        boolean autoRename = false;
        QName nodeTypeQName = ContentModel.TYPE_CONTENT;
        boolean overwrite = false;
        Boolean versionMajor = null;
        String versionComment = null;
        String relativePath = null;
        String renditionNames = null;
        boolean versioningEnabled = true;
        HashMap<String, Object> qnameStrProps = new HashMap<String, Object>();
        Map<QName, Serializable> properties = null;
        Map formDataParameters = formData.getParameters();
        block26: for (FormData.FormField field : formData.getFields()) {
            switch (field.getName().toLowerCase()) {
                case "name": {
                    String str = this.getStringOrNull(field.getValue());
                    if (str == null || str.isEmpty()) continue block26;
                    fileName = str;
                    continue block26;
                }
                case "filedata": {
                    if (!field.getIsFile()) continue block26;
                    fileName = fileName != null ? fileName : field.getFilename();
                    content = field.getContent();
                    continue block26;
                }
                case "autorename": {
                    autoRename = Boolean.valueOf(field.getValue());
                    continue block26;
                }
                case "nodetype": {
                    nodeTypeQName = this.createQName(this.getStringOrNull(field.getValue()));
                    if (this.isSubClass(nodeTypeQName, ContentModel.TYPE_CONTENT)) continue block26;
                    throw new InvalidArgumentException("Can only upload type of cm:content: " + String.valueOf(nodeTypeQName));
                }
                case "overwrite": {
                    overwrite = Boolean.valueOf(field.getValue());
                    continue block26;
                }
                case "majorversion": {
                    versionMajor = Boolean.valueOf(field.getValue());
                    continue block26;
                }
                case "comment": {
                    versionComment = this.getStringOrNull(field.getValue());
                    continue block26;
                }
                case "relativepath": {
                    relativePath = this.getStringOrNull(field.getValue());
                    continue block26;
                }
                case "renditions": {
                    renditionNames = this.getStringOrNull(field.getValue());
                    continue block26;
                }
                case "versioningenabled": {
                    String versioningEnabledStringValue = this.getStringOrNull(field.getValue());
                    if (null == versioningEnabledStringValue) continue block26;
                    versioningEnabled = !versioningEnabledStringValue.equalsIgnoreCase("false");
                    continue block26;
                }
                default: {
                    String propName = field.getName();
                    if (propName.indexOf(58) <= -1 || qnameStrProps.containsKey(propName)) continue block26;
                    String[] fieldValue = (String[])formDataParameters.get(propName);
                    if (fieldValue.length > 1) {
                        qnameStrProps.put(propName, Arrays.asList(fieldValue));
                        continue block26;
                    }
                    qnameStrProps.put(propName, fieldValue[0]);
                }
            }
        }
        if (fileName == null || fileName.isEmpty() || content == null) {
            throw new InvalidArgumentException("Required parameters are missing");
        }
        if (autoRename && overwrite) {
            throw new InvalidArgumentException("Both 'overwrite' and 'autoRename' should not be true when uploading a file");
        }
        parentNodeRef = this.getOrCreatePath(parentNodeRef, relativePath);
        QName assocTypeQName = ContentModel.ASSOC_CONTAINS;
        Set<String> renditions = NodesImpl.getRequestedRenditions(renditionNames);
        this.validateProperties(qnameStrProps, EXCLUDED_NS, Arrays.asList(new QName[0]));
        try {
            NodeRef existingFile;
            if (qnameStrProps.size() > 0) {
                properties = this.mapToNodeProperties(qnameStrProps);
            }
            if ((existingFile = this.nodeService.getChildByName(parentNodeRef, assocTypeQName, fileName)) != null) {
                if (autoRename) {
                    fileName = this.findUniqueName(parentNodeRef, fileName);
                } else {
                    if (overwrite && this.nodeService.hasAspect(existingFile, ContentModel.ASPECT_VERSIONABLE)) {
                        ContentInfoImpl contentInfo = new ContentInfoImpl(content.getMimetype(), content.getEncoding(), -1L, null);
                        return this.updateExistingFile(parentNodeRef, existingFile, fileName, contentInfo, content.getInputStream(), parameters, versionMajor, versionComment);
                    }
                    throw new ConstraintViolatedException(fileName + " already exists.");
                }
            }
            if (versionMajor == null) {
                versionMajor = true;
            }
            versionMajor = versioningEnabled ? versionMajor : null;
            NodeRef nodeRef = this.createNewFile(parentNodeRef, fileName, nodeTypeQName, content, properties, assocTypeQName, parameters, versionMajor, versionComment);
            Node fileNode = this.getFolderOrDocumentFullInfo(nodeRef, parentNodeRef, nodeTypeQName, parameters);
            this.checkRenditionNames(renditions);
            this.requestRenditions(renditions, fileNode);
            return fileNode;
        }
        catch (AccessDeniedException ade) {
            throw new PermissionDeniedException(ade.getMessage());
        }
    }

    private NodeRef createNewFile(NodeRef parentNodeRef, String fileName, QName nodeType, Content content, Map<QName, Serializable> props, QName assocTypeQName, Parameters params, Boolean versionMajor, String versionComment) {
        NodeRef nodeRef = this.createNodeImpl(parentNodeRef, fileName, nodeType, props, assocTypeQName);
        if (content == null) {
            this.writeContent(nodeRef, fileName, new ByteArrayInputStream("".getBytes()), false);
        } else {
            this.writeContent(nodeRef, fileName, content.getInputStream(), true);
        }
        if (versionMajor != null || versionComment != null) {
            VersionType versionType = VersionType.MAJOR;
            if (versionMajor != null && !versionMajor.booleanValue()) {
                versionType = VersionType.MINOR;
            }
            this.createVersion(nodeRef, false, versionType, versionComment);
            this.extractMetadata(nodeRef);
        }
        return nodeRef;
    }

    private String getStringOrNull(String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return value.equalsIgnoreCase("null") ? null : value;
        }
        return null;
    }

    private void checkRenditionNames(Set<String> renditionNames) {
        if (renditionNames != null) {
            if (!this.renditionService2.isEnabled()) {
                throw new DisabledServiceException("Thumbnail generation has been disabled.");
            }
            RenditionDefinitionRegistry2 renditionDefinitionRegistry2 = this.renditionService2.getRenditionDefinitionRegistry2();
            for (String renditionName : renditionNames) {
                RenditionDefinition2 renditionDefinition = renditionDefinitionRegistry2.getRenditionDefinition(renditionName);
                if (renditionDefinition != null) continue;
                throw new NotFoundException(renditionName + " is not registered.");
            }
        }
    }

    static Set<String> getRequestedRenditions(String renditionsParam) {
        if (renditionsParam == null) {
            return null;
        }
        String[] renditionNames = renditionsParam.split(",");
        LinkedHashSet<String> renditions = new LinkedHashSet<String>(renditionNames.length);
        for (String name : renditionNames) {
            if ((name = name.trim()).isEmpty()) continue;
            renditions.add(name.trim());
        }
        return renditions;
    }

    private void requestRenditions(Set<String> renditionNames, Node fileNode) {
        if (renditionNames != null) {
            NodeRef sourceNodeRef = fileNode.getNodeRef();
            String mimeType = fileNode.getContent().getMimeType();
            long size = fileNode.getContent().getSizeInBytes();
            RenditionDefinitionRegistry2 renditionDefinitionRegistry2 = this.renditionService2.getRenditionDefinitionRegistry2();
            Set availableRenditions = renditionDefinitionRegistry2.getRenditionNamesFrom(mimeType, size);
            for (String renditionName : renditionNames) {
                try {
                    if (!availableRenditions.contains(renditionName)) {
                        throw new InvalidArgumentException("Unable to create thumbnail '" + renditionName + "' for " + mimeType + " as no transformer is currently available.");
                    }
                    this.renditionService2.render(sourceNodeRef, renditionName);
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Asynchronous request to create a rendition upon upload failed: " + ex.getMessage()));
                }
            }
        }
    }

    private void extractMetadata(NodeRef nodeRef) {
        String actionName = "extract-metadata";
        ActionDefinition actionDef = this.actionService.getActionDefinition("extract-metadata");
        if (actionDef != null) {
            Action action = this.actionService.createAction("extract-metadata");
            this.actionService.executeAction(action, nodeRef);
        }
    }

    private String findUniqueName(NodeRef parentNodeRef, String fileName) {
        String tmpFilename;
        NodeRef existingFile;
        int counter = 1;
        do {
            int dotIndex;
            tmpFilename = (dotIndex = fileName.lastIndexOf(46)) == 0 ? counter + fileName : (dotIndex > 0 ? fileName.substring(0, dotIndex) + "-" + counter + fileName.substring(dotIndex) : fileName + "-" + counter);
            existingFile = this.nodeService.getChildByName(parentNodeRef, ContentModel.ASSOC_CONTAINS, tmpFilename);
            ++counter;
        } while (existingFile != null);
        return tmpFilename;
    }

    @Override
    public QName createQName(String qnameStr) {
        try {
            QName qname = qnameStr.indexOf(123) != -1 ? QName.createQName((String)qnameStr) : QName.createQName((String)qnameStr, (NamespacePrefixResolver)this.namespaceService);
            return qname;
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            if (msg == null) {
                msg = "";
            }
            throw new InvalidArgumentException(qnameStr + " isn't a valid QName. " + msg);
        }
    }

    protected List<QName> createQNames(List<String> qnameStrList, List<QName> excludedProps) {
        String PREFIX = "properties/";
        ArrayList<QName> result = new ArrayList<QName>(qnameStrList.size());
        for (String str : qnameStrList) {
            QName name;
            if (str.startsWith(PREFIX)) {
                str = str.substring(PREFIX.length());
            }
            if (excludedProps.contains(name = this.createQName(str))) continue;
            result.add(name);
        }
        return result;
    }

    @Override
    public Node lock(String nodeId, LockInfo lockInfo, Parameters parameters) {
        NodeRef nodeRef = this.validateOrLookupNode(nodeId);
        if (this.isSpecialNode(nodeRef, this.getNodeType(nodeRef))) {
            throw new PermissionDeniedException("Current user doesn't have permission to lock node " + nodeId);
        }
        if (!this.nodeMatches(nodeRef, Collections.singleton(ContentModel.TYPE_CONTENT), null, false)) {
            throw new InvalidArgumentException("Node of type cm:content or a subtype is expected: " + nodeId);
        }
        LockInfo validatedLockInfo = this.validateLockInformation(lockInfo);
        this.lockService.lock(nodeRef, validatedLockInfo.getMappedType(), validatedLockInfo.getTimeToExpire().intValue(), validatedLockInfo.getLifetime());
        return this.getFolderOrDocument(nodeId, parameters);
    }

    private LockInfo validateLockInformation(LockInfo lockInfo) {
        if (lockInfo.getType() == null) {
            lockInfo.setType(LockInfo.LockType2.ALLOW_OWNER_CHANGES.name());
        }
        if (lockInfo.getLifetime() == null) {
            lockInfo.setLifetime(Lifetime.PERSISTENT.name());
        }
        if (lockInfo.getTimeToExpire() == null) {
            lockInfo.setTimeToExpire(0);
        }
        return lockInfo;
    }

    @Override
    public Node unlock(String nodeId, Parameters parameters) {
        NodeRef nodeRef = this.validateOrLookupNode(nodeId);
        if (this.isSpecialNode(nodeRef, this.getNodeType(nodeRef))) {
            throw new PermissionDeniedException("Current user doesn't have permission to unlock node " + nodeId);
        }
        if (!this.lockService.isLocked(nodeRef)) {
            throw new IntegrityException("Can't unlock node " + nodeId + " because it isn't locked", null);
        }
        this.lockService.unlock(nodeRef);
        return this.getFolderOrDocument(nodeId, parameters);
    }

    @Override
    public DirectAccessUrl requestContentDirectUrl(NodeRef nodeRef, boolean attachment, Long validFor, String fileName) {
        DirectAccessUrl directAccessUrl = this.contentService.requestContentDirectUrl(nodeRef, ContentModel.PROP_CONTENT, attachment, validFor, fileName);
        if (directAccessUrl == null) {
            throw new DisabledServiceException("Direct access url isn't available.");
        }
        return directAccessUrl;
    }

    private boolean hasDuplicatePermissions(List<NodePermissions.NodePermission> locallySetPermissions) {
        boolean duplicate = false;
        if (locallySetPermissions != null) {
            HashSet<NodePermissions.NodePermission> temp = new HashSet<NodePermissions.NodePermission>(locallySetPermissions.size());
            for (NodePermissions.NodePermission permission : locallySetPermissions) {
                temp.add(permission);
            }
            duplicate = locallySetPermissions.size() != temp.size();
        }
        return duplicate;
    }

    private boolean isFavorite(NodeRef node) {
        PreferenceService preferenceService = (PreferenceService)this.sr.getService(ServiceRegistry.PREFERENCE_SERVICE);
        String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
        Map preferences = preferenceService.getPreferences(currentUserName);
        for (Serializable nodesFavorites : preferences.values()) {
            if (!(nodesFavorites instanceof String)) continue;
            StringTokenizer st = new StringTokenizer((String)((Object)nodesFavorites), ",");
            while (st.hasMoreTokens()) {
                NodeRef nodeRef;
                String nodeRefStr = st.nextToken();
                if (!NodeRef.isNodeRef((String)(nodeRefStr = nodeRefStr.trim())) || !(nodeRef = new NodeRef(nodeRefStr)).equals((Object)node)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void validateAspects(List<String> aspectNames, List<String> excludedNS, List<QName> excludedAspects) {
        if (aspectNames != null && excludedNS != null && excludedAspects != null) {
            Set<QName> aspects = this.mapToNodeAspects(aspectNames);
            aspects.forEach(aspect -> {
                if (excludedNS != null && excludedNS.contains(aspect.getNamespaceURI())) {
                    throw new IllegalArgumentException("NameSpace cannot be used by API: " + aspect.toPrefixString());
                }
                if (excludedAspects != null && excludedAspects.contains(aspect)) {
                    throw new IllegalArgumentException("Cannot be used by API: " + aspect.toPrefixString());
                }
            });
        }
    }

    @Override
    public void validateProperties(Map<String, Object> properties, List<String> excludedNS, List<QName> excludedProperties) {
        if (properties != null) {
            Map<QName, Serializable> nodeProps = this.mapToNodeProperties(properties);
            nodeProps.keySet().forEach(property -> {
                if (excludedNS != null && excludedNS.contains(property.getNamespaceURI())) {
                    throw new IllegalArgumentException("NameSpace cannot be used by API: " + property.toPrefixString());
                }
                if (excludedProperties != null && excludedProperties.contains(property) || AuditablePropertiesEntity.getAuditablePropertyQNames().contains(property)) {
                    throw new IllegalArgumentException("Cannot be used by API: " + property.toPrefixString());
                }
            });
        }
    }

    protected NodeService getNodeService() {
        return this.nodeService;
    }

    protected DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    protected FileFolderService getFileFolderService() {
        return this.fileFolderService;
    }

    protected NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    protected PermissionService getPermissionService() {
        return this.permissionService;
    }

    protected MimetypeService getMimetypeService() {
        return this.mimetypeService;
    }

    protected ContentService getContentService() {
        return this.contentService;
    }

    protected ActionService getActionService() {
        return this.actionService;
    }

    protected VersionService getVersionService() {
        return this.versionService;
    }

    protected PersonService getPersonService() {
        return this.personService;
    }

    protected OwnableService getOwnableService() {
        return this.ownableService;
    }

    protected AuthorityService getAuthorityService() {
        return this.authorityService;
    }

    @Deprecated
    protected ThumbnailService getThumbnailService() {
        return this.thumbnailService;
    }

    protected SiteService getSiteService() {
        return this.siteService;
    }

    protected ActivityPoster getPoster() {
        return this.poster;
    }

    protected RetryingTransactionHelper getRetryingTransactionHelper() {
        return this.retryingTransactionHelper;
    }

    protected LockService getLockService() {
        return this.lockService;
    }

    protected VirtualStore getSmartStore() {
        return this.smartStore;
    }

    protected QuickShareLinks getQuickShareLinks() {
        return this.quickShareLinks;
    }

    protected Repository getRepositoryHelper() {
        return this.repositoryHelper;
    }

    static {
        HashMap<String, QName> aMap = new HashMap<String, QName>(9);
        aMap.put("isFolder", GetChildrenCannedQuery.SORT_QNAME_NODE_IS_FOLDER);
        aMap.put("name", ContentModel.PROP_NAME);
        aMap.put("createdAt", ContentModel.PROP_CREATED);
        aMap.put("modifiedAt", ContentModel.PROP_MODIFIED);
        aMap.put("createdByUser", ContentModel.PROP_CREATOR);
        aMap.put("modifiedByUser", ContentModel.PROP_MODIFIER);
        aMap.put("mimeType", GetChildrenCannedQuery.SORT_QNAME_CONTENT_MIMETYPE);
        aMap.put("sizeInBytes", GetChildrenCannedQuery.SORT_QNAME_CONTENT_SIZE);
        aMap.put("nodeType", GetChildrenCannedQuery.SORT_QNAME_NODE_TYPE);
        PARAM_SYNONYMS_QNAME = Collections.unmodifiableMap(aMap);
        LIST_FOLDER_CHILDREN_EQUALS_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("isFolder", "isFile", "nodeType", "isPrimary", "assocType"));
    }

    private static enum Type {
        DOCUMENT,
        FOLDER;

    }

    private static enum Activity_Type {
        ADDED,
        UPDATED,
        DELETED,
        DOWNLOADED;

    }
}

