/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.validator.actions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.model.ContentModel;
import org.alfresco.rest.api.Actions;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.actions.ActionValidator;
import org.alfresco.rest.api.model.ActionDefinition;
import org.alfresco.rest.api.model.rules.Action;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.apache.commons.collections.MapUtils;

public class ActionNodeParameterValidator
implements ActionValidator {
    static final Map<String, List<String>> REQUIRE_READ_PERMISSION_PARAMS = Map.of("link-category", List.of("category-value"));
    static final String NO_PROPER_PERMISSIONS_FOR_NODE = "No proper permissions for node: ";
    static final String NOT_A_CATEGORY = "Node is not a category ";
    static final String NOT_A_FOLDER = "Node is not a folder ";
    private final Actions actions;
    private final NamespaceService namespaceService;
    private final Nodes nodes;
    private final PermissionService permissionService;

    public ActionNodeParameterValidator(Actions actions, NamespaceService namespaceService, Nodes nodes, PermissionService permissionService) {
        this.actions = actions;
        this.namespaceService = namespaceService;
        this.nodes = nodes;
        this.permissionService = permissionService;
    }

    @Override
    public void validate(Action action) {
        ActionDefinition actionDefinition = this.actions.getRuleActionDefinitionById(action.getActionDefinitionId());
        List<ActionDefinition.ParameterDefinition> nodeRefParams = actionDefinition.getParameterDefinitions().stream().filter(pd -> DataTypeDefinition.NODE_REF.toPrefixString((NamespacePrefixResolver)this.namespaceService).equals(pd.getType())).collect(Collectors.toList());
        this.validateNodes(nodeRefParams, action);
    }

    @Override
    public List<String> getActionDefinitionIds() {
        return List.of("copy", "move", "check-out", "import", "link-category", "simple-workflow", "transform", "transform-image");
    }

    @Override
    public int getPriority() {
        return -2147483647;
    }

    private void validateNodes(List<ActionDefinition.ParameterDefinition> nodeRefParamDefinitions, Action action) {
        if (MapUtils.isNotEmpty(action.getParams())) {
            nodeRefParamDefinitions.stream().filter(pd -> action.getParams().containsKey(pd.getName())).forEach(p -> {
                String nodeId = Objects.toString(action.getParams().get(p.getName()), "");
                NodeRef nodeRef = this.nodes.validateNode(nodeId);
                this.validatePermission(action.getActionDefinitionId(), p.getName(), nodeRef);
                this.validateType(action.getActionDefinitionId(), nodeRef);
            });
        }
    }

    private void validatePermission(String actionDefinitionId, String paramName, NodeRef nodeRef) {
        block6: {
            block5: {
                if (this.permissionService.hasReadPermission(nodeRef) != AccessStatus.ALLOWED) {
                    throw new EntityNotFoundException(nodeRef.getId());
                }
                if (!REQUIRE_READ_PERMISSION_PARAMS.containsKey(actionDefinitionId)) break block5;
                if (!REQUIRE_READ_PERMISSION_PARAMS.get(actionDefinitionId).stream().noneMatch(paramName::equals)) break block6;
            }
            if (this.permissionService.hasPermission(nodeRef, "Write") != AccessStatus.ALLOWED) {
                throw new PermissionDeniedException(NO_PROPER_PERMISSIONS_FOR_NODE + nodeRef.getId());
            }
        }
    }

    private void validateType(String actionDefinitionId, NodeRef nodeRef) {
        if (!"link-category".equals(actionDefinitionId)) {
            if (!this.nodes.nodeMatches(nodeRef, Set.of(ContentModel.TYPE_FOLDER), Collections.emptySet())) {
                throw new InvalidArgumentException(NOT_A_FOLDER + nodeRef.getId());
            }
        } else if (!this.nodes.nodeMatches(nodeRef, Set.of(ContentModel.TYPE_CATEGORY), Collections.emptySet())) {
            throw new InvalidArgumentException(NOT_A_CATEGORY + nodeRef.getId());
        }
    }
}

