/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.util.ArrayList;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class Preference
implements Serializable,
ExpectedComparison,
Comparable<Preference> {
    private static final long serialVersionUID = -4187479305268687836L;
    private String id;
    private String value;

    public Preference(String id, String value) {
        this.id = id;
        this.value = value;
    }

    public String getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "Preference [id=" + this.id + ", value=" + this.value + "]";
    }

    public static Preference parsePreference(JSONObject jsonObject) {
        String id = (String)jsonObject.get((Object)"id");
        String value = jsonObject.get((Object)"value").toString();
        Preference preference = new Preference(id, value);
        return preference;
    }

    public static PublicApiClient.ListResponse<Preference> parsePreferences(JSONObject jsonObject) {
        ArrayList<Preference> preferences = new ArrayList<Preference>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            preferences.add(Preference.parsePreference(entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        PublicApiClient.ListResponse<Preference> resp = new PublicApiClient.ListResponse<Preference>(paging, preferences);
        return resp;
    }

    public JSONObject toJSON() {
        JSONObject entry = new JSONObject();
        entry.put((Object)"id", (Object)this.getId());
        entry.put((Object)"value", (Object)this.getValue());
        return entry;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Preference other = (Preference)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((boolean)(o instanceof Preference));
        Preference other = (Preference)o;
        AssertUtil.assertEquals("id", this.id, other.getId());
        AssertUtil.assertEquals("value", this.value, other.getValue());
    }

    @Override
    public int compareTo(Preference o) {
        return this.id.compareTo(o.getId());
    }
}

