/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tests.metadata;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.ResourceDictionary;
import org.alfresco.rest.framework.core.ResourceDictionaryBuilder;
import org.alfresco.rest.framework.core.ResourceLookupDictionary;
import org.alfresco.rest.framework.core.ResourceWithMetadata;
import org.alfresco.rest.framework.metadata.ResourceMetaDataWriter;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:test-rest-context.xml"})
public class WriterTests {
    @Autowired
    ResourceLookupDictionary locator;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="defaultMetaWriter")
    private ResourceMetaDataWriter defaultMetaWriter;
    private static Api api = Api.valueOf((String)"alfrescomock", (String)"private", (String)"1");

    @Before
    public void setUp() throws Exception {
        Map entityResourceBeans = this.applicationContext.getBeansWithAnnotation(EntityResource.class);
        Map relationResourceBeans = this.applicationContext.getBeansWithAnnotation(RelationshipResource.class);
        this.locator.setDictionary(ResourceDictionaryBuilder.build(entityResourceBeans.values(), relationResourceBeans.values()));
    }

    @Test
    public void testWriters() throws IOException {
        ResourceDictionary resourceDic = this.locator.getDictionary();
        Map apiResources = (Map)resourceDic.getAllResources().get(api);
        String writtenOut = this.testWriter(this.defaultMetaWriter, (ResourceWithMetadata)apiResources.get("/sheep"), apiResources);
        Assert.assertTrue((boolean)writtenOut.startsWith("{\"list\":{\"pagination\":{\"count\":5"));
    }

    private String testWriter(ResourceMetaDataWriter defaultWriter, ResourceWithMetadata resourceWithMetadata, Map<String, ResourceWithMetadata> apiResources) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        defaultWriter.writeMetaData((OutputStream)out, apiResources.get("/sheep"), apiResources);
        String outResult = out.toString();
        System.out.println(outResult);
        return outResult;
    }
}

