/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.audit;

import org.alfresco.rest.api.Audit;
import org.alfresco.rest.api.audit.AuditApplicationsEntityResource;
import org.alfresco.rest.api.model.AuditEntry;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="audit-entries", entityResource=AuditApplicationsEntityResource.class, title="Audit Application Entries")
public class AuditApplicationsAuditEntriesRelation
implements RelationshipResourceAction.Read<AuditEntry>,
RelationshipResourceAction.ReadById<AuditEntry>,
RelationshipResourceAction.Delete,
RelationshipResourceAction.DeleteSet,
InitializingBean {
    private Audit audit;

    public void setAudit(Audit audit) {
        this.audit = audit;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"audit", (Object)this.audit);
    }

    @Override
    @WebApiDescription(title="Returns audit entries for audit app id")
    public CollectionWithPagingInfo<AuditEntry> readAll(String auditAppId, Parameters parameters) {
        return this.audit.listAuditEntries(auditAppId, parameters);
    }

    @Override
    @WebApiDescription(title="Return audit entry id for audit app id")
    public AuditEntry readById(String auditAppId, String auditEntryId, Parameters parameters) throws RelationshipResourceNotFoundException {
        return this.audit.getAuditEntry(auditAppId, Long.valueOf(auditEntryId), parameters);
    }

    @Override
    @WebApiDescription(title="Delete audit entry id for audit app id")
    public void delete(String auditAppId, String auditEntryId, Parameters parameters) throws RelationshipResourceNotFoundException {
        this.audit.deleteAuditEntry(auditAppId, Long.valueOf(auditEntryId), parameters);
    }

    @Override
    @WebApiDescription(title="Delete collection/set of audit entries for audit app id - based on params")
    public void deleteSet(String auditAppId, Parameters parameters) throws RelationshipResourceNotFoundException {
        this.audit.deleteAuditEntries(auditAppId, parameters);
    }
}

