/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import org.alfresco.rest.api.Audit;
import org.alfresco.rest.api.model.AuditEntry;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="audit-entries", entityResource=NodesEntityResource.class, title="Audit Entries")
public class NodeAuditEntriesRelation
implements RelationshipResourceAction.Read<AuditEntry>,
InitializingBean {
    private Audit audit;

    public void setAudit(Audit audit) {
        this.audit = audit;
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"audit", (Object)this.audit);
    }

    @Override
    @WebApiDescription(title="Returns audit entries for node id")
    public CollectionWithPagingInfo<AuditEntry> readAll(String nodeId, Parameters parameters) {
        return this.audit.listAuditEntriesByNodeId(nodeId, parameters);
    }
}

