/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.transfer;

import jakarta.servlet.http.HttpServletRequest;
import org.alfresco.repo.web.scripts.transfer.CommandProcessor;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.jakarta.JakartaServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WrappingWebScriptRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;

public class PostContentCommandProcessor
implements CommandProcessor {
    private TransferReceiver receiver;
    private static final String MSG_CAUGHT_UNEXPECTED_EXCEPTION = "transfer_service.receiver.caught_unexpected_exception";
    private static Log logger = LogFactory.getLog(PostContentCommandProcessor.class);

    public void setReceiver(TransferReceiver receiver) {
        this.receiver = receiver;
    }

    @Override
    public int process(WebScriptRequest req, WebScriptResponse resp) {
        logger.debug((Object)"post content start");
        WebScriptServletRequest webScriptServletRequest = null;
        Object current = req;
        do {
            if (current instanceof WebScriptServletRequest) {
                webScriptServletRequest = (WebScriptServletRequest)current;
                current = null;
                continue;
            }
            current = current instanceof WrappingWebScriptRequest ? ((WrappingWebScriptRequest)req).getNext() : null;
        } while (current != null);
        if (webScriptServletRequest == null) {
            resp.setStatus(400);
            return 400;
        }
        HttpServletRequest servletRequest = webScriptServletRequest.getHttpServletRequest();
        String transferId = servletRequest.getParameter("transferId");
        if (transferId == null || !JakartaServletFileUpload.isMultipartContent((HttpServletRequest)servletRequest)) {
            resp.setStatus(400);
            return 400;
        }
        try {
            JakartaServletFileUpload upload = new JakartaServletFileUpload();
            FileItemInputIterator iter = upload.getItemIterator(servletRequest);
            while (iter.hasNext()) {
                FileItemInput item = iter.next();
                String name = item.getFieldName();
                if (item.isFormField()) continue;
                logger.debug((Object)("got content Mime Part : " + name));
                this.receiver.saveContent(transferId, item.getName(), item.getInputStream());
            }
            logger.debug((Object)"success");
            resp.setStatus(200);
        }
        catch (Exception ex) {
            logger.debug((Object)"exception caught", (Throwable)ex);
            if (transferId != null) {
                logger.debug((Object)"ending transfer", (Throwable)ex);
                this.receiver.end(transferId);
            }
            if (ex instanceof TransferException) {
                throw (TransferException)((Object)ex);
            }
            throw new TransferException(MSG_CAUGHT_UNEXPECTED_EXCEPTION, (Throwable)ex);
        }
        resp.setStatus(200);
        return 200;
    }
}

