/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tests.core;

import org.alfresco.repo.forms.FormNotFoundException;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.search.QueryParserException;
import org.alfresco.rest.framework.core.exceptions.ApiException;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.rest.framework.core.exceptions.DeletedResourceException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.ErrorResponse;
import org.alfresco.rest.framework.core.exceptions.InsufficientStorageException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.rest.framework.core.exceptions.StaleEntityException;
import org.alfresco.rest.framework.core.exceptions.UnsupportedResourceOperationException;
import org.alfresco.rest.framework.resource.parameters.where.InvalidQueryException;
import org.alfresco.rest.framework.tools.ApiAssistant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:test-rest-context.xml"})
public class ExceptionResolverTests {
    @Autowired
    ApiAssistant assistant;

    @Test
    public void testWebscriptException() {
        ErrorResponse response = this.assistant.resolveException((Exception)((Object)new WebScriptException(null)));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)500L, (long)response.getStatusCode());
        response = this.assistant.resolveException((Exception)((Object)new WebScriptException(401, "Authentication failed for Web Script ")));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
    }

    @Test
    public void testMatchException() {
        ErrorResponse response = this.assistant.resolveException((Exception)new ApiException(null));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)500L, (long)response.getStatusCode());
        response = this.assistant.resolveException((Exception)new InvalidArgumentException(null));
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        response = this.assistant.resolveException((Exception)new InvalidQueryException(null));
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        response = this.assistant.resolveException((Exception)new NotFoundException(null));
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        response = this.assistant.resolveException((Exception)new EntityNotFoundException(null));
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        response = this.assistant.resolveException((Exception)new RelationshipResourceNotFoundException(null, null));
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        response = this.assistant.resolveException((Exception)new PermissionDeniedException(null));
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        response = this.assistant.resolveException((Exception)new UnsupportedResourceOperationException(null));
        Assert.assertEquals((long)405L, (long)response.getStatusCode());
        response = this.assistant.resolveException((Exception)new DeletedResourceException(null));
        Assert.assertEquals((long)405L, (long)response.getStatusCode());
        response = this.assistant.resolveException((Exception)new ConstraintViolatedException(null));
        Assert.assertEquals((long)409L, (long)response.getStatusCode());
        response = this.assistant.resolveException((Exception)new StaleEntityException(null));
        Assert.assertEquals((long)409L, (long)response.getStatusCode());
        response = this.assistant.resolveException((Exception)new FormNotFoundException(null));
        Assert.assertEquals((long)500L, (long)response.getStatusCode());
        response = this.assistant.resolveException((Exception)new InsufficientStorageException(null));
        Assert.assertEquals((long)507L, (long)response.getStatusCode());
        response = this.assistant.resolveException((Exception)new IntegrityException(null));
        Assert.assertEquals((long)422L, (long)response.getStatusCode());
    }

    @Test
    public void testQueryParserException() {
        ErrorResponse response = this.assistant.resolveException((Exception)new QueryParserException("Endpoint not found", 404));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((String)"Expected status code to be passed through from query parser.", (long)404L, (long)response.getStatusCode());
    }
}

