/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.resource.parameters.where;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.alfresco.rest.framework.resource.parameters.where.BasicQueryWalker;
import org.alfresco.rest.framework.resource.parameters.where.InvalidQueryException;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.WhereProperty;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang3.StringUtils;

public abstract class QueryHelper {
    private static final String SINGLE_QUOTE = "'";

    public static void walk(Query query, WalkerCallback callback) {
        CommonTree tree = query.getTree();
        if (tree != null) {
            LinkedList<CommonTree> stack = new LinkedList<CommonTree>();
            stack.push(tree);
            QueryHelper.callbackTree((Tree)tree, callback, false);
        }
    }

    protected static void callbackTree(Tree tree, WalkerCallback callback, boolean negated) {
        if (tree != null) {
            switch (tree.getType()) {
                case 9: {
                    if (23 != tree.getChild(0).getType()) break;
                    callback.exists(tree.getChild(0).getText(), negated);
                    return;
                }
                case 20: {
                    if (23 != tree.getChild(0).getType()) break;
                    callback.matches(tree.getChild(0).getText(), QueryHelper.stripQuotes(tree.getChild(1).getText()), negated);
                    return;
                }
                case 16: {
                    if (23 != tree.getChild(0).getType()) break;
                    List<Tree> children = QueryHelper.getChildren(tree);
                    String[] inVals = new String[children.size() - 1];
                    for (int i = 1; i < children.size(); ++i) {
                        inVals[i - 1] = QueryHelper.stripQuotes(children.get(i).getText());
                    }
                    callback.in(tree.getChild(0).getText(), negated, inVals);
                    return;
                }
                case 5: {
                    if (23 != tree.getChild(0).getType()) break;
                    callback.between(tree.getChild(0).getText(), QueryHelper.stripQuotes(tree.getChild(1).getText()), QueryHelper.stripQuotes(tree.getChild(2).getText()), negated);
                    return;
                }
                case 8: 
                case 10: 
                case 11: 
                case 18: 
                case 19: {
                    if (23 != tree.getChild(0).getType() || 24 != tree.getChild(1).getType()) break;
                    callback.comparison(tree.getType(), tree.getChild(0).getText(), QueryHelper.stripQuotes(tree.getChild(1).getText()), negated);
                    return;
                }
                case 21: {
                    QueryHelper.callbackTree(tree.getChild(0), callback, true);
                    return;
                }
                case 22: {
                    callback.or();
                    List<Tree> children = QueryHelper.getChildren(tree);
                    for (Tree child : children) {
                        QueryHelper.callbackTree(child, callback, negated);
                    }
                    return;
                }
                case 4: {
                    callback.and();
                    List<Tree> childrenOfAnd = QueryHelper.getChildren(tree);
                    for (Tree child : childrenOfAnd) {
                        QueryHelper.callbackTree(child, callback, negated);
                    }
                    return;
                }
            }
            QueryHelper.callbackTree(tree.getChild(0), callback, negated);
        }
    }

    public static List<Tree> getChildren(Tree tree) {
        if (tree != null && tree.getChildCount() > 0) {
            ArrayList<Tree> children = new ArrayList<Tree>(tree.getChildCount());
            for (int i = 0; i < tree.getChildCount(); ++i) {
                Tree child = tree.getChild(i);
                children.add(child);
            }
            return children;
        }
        return Collections.emptyList();
    }

    public static String stripQuotes(String toBeStripped) {
        if (StringUtils.isNotEmpty((CharSequence)toBeStripped) && toBeStripped.startsWith(SINGLE_QUOTE) && toBeStripped.endsWith(SINGLE_QUOTE)) {
            return toBeStripped.substring(1, toBeStripped.length() - 1);
        }
        return toBeStripped;
    }

    public static QueryResolver.WalkerSpecifier resolve(Query query) {
        return new QueryResolver.WalkerSpecifier(query);
    }

    public static interface WalkerCallback {
        public static final InvalidQueryException UNSUPPORTED = new InvalidQueryException((Object)"Unsupported Predicate");

        default public void exists(String propertyName, boolean negated) {
            throw UNSUPPORTED;
        }

        default public void between(String propertyName, String firstValue, String secondValue, boolean negated) {
            throw UNSUPPORTED;
        }

        default public void comparison(int type, String propertyName, String propertyValue, boolean negated) {
            throw UNSUPPORTED;
        }

        default public void in(String property, boolean negated, String ... propertyValues) {
            throw UNSUPPORTED;
        }

        default public void matches(String property, String propertyValue, boolean negated) {
            throw UNSUPPORTED;
        }

        default public void and() {
            throw UNSUPPORTED;
        }

        default public void or() {
            throw UNSUPPORTED;
        }

        default public Collection<String> getProperty(String propertyName, int type, boolean negated) {
            throw UNSUPPORTED;
        }
    }

    public static abstract class QueryResolver<S extends QueryResolver<?>> {
        private final Query query;
        protected WalkerCallback queryWalker;
        protected Function<Collection<String>, BasicQueryWalker> orQueryWalkerSupplier;
        protected boolean clausesNegatable = true;
        protected boolean validateLeniently = false;

        protected abstract S self();

        public QueryResolver(Query query) {
            this.query = query;
        }

        public Collection<String> getProperty(String propertyName, int clauseType, boolean negated) {
            this.processQuery(propertyName);
            return this.queryWalker.getProperty(propertyName, clauseType, negated);
        }

        protected void processQuery(String ... propertyNames) {
            if (this.queryWalker == null) {
                this.queryWalker = this.orQueryWalkerSupplier != null ? (WalkerCallback)this.orQueryWalkerSupplier.apply(Set.of(propertyNames)) : new BasicQueryWalker(propertyNames);
            }
            if (this.queryWalker instanceof BasicQueryWalker) {
                ((BasicQueryWalker)this.queryWalker).setClausesNegatable(this.clausesNegatable);
                ((BasicQueryWalker)this.queryWalker).setValidateStrictly(!this.validateLeniently);
            }
            QueryHelper.walk(this.query, this.queryWalker);
        }

        public static class WalkerSpecifier
        extends DefaultWalkerOperations<WalkerSpecifier> {
            public WalkerSpecifier(Query query) {
                super(query);
            }

            @Override
            protected WalkerSpecifier self() {
                return this;
            }

            public DefaultWalkerOperations<? extends DefaultWalkerOperations<?>> usingOrOperator() {
                this.orQueryWalkerSupplier = propertyNames -> new BasicQueryWalker((Collection)propertyNames){

                    @Override
                    public void or() {
                    }

                    @Override
                    public void and() {
                        throw UNSUPPORTED;
                    }
                };
                return this;
            }

            public <T extends BasicQueryWalker> DefaultWalkerOperations<? extends DefaultWalkerOperations<?>> usingWalker(T queryWalker) {
                this.queryWalker = queryWalker;
                return this;
            }

            public <T extends WalkerCallback> QueryResolver<? extends QueryResolver<?>> usingWalker(T queryWalker) {
                this.queryWalker = queryWalker;
                return this;
            }
        }

        public static class DefaultWalkerOperations<R extends DefaultWalkerOperations<?>>
        extends QueryResolver<R> {
            public DefaultWalkerOperations(Query query) {
                super(query);
            }

            @Override
            protected R self() {
                return (R)this;
            }

            public R leniently() {
                this.validateLeniently = true;
                return (R)this.self();
            }

            public R withoutNegations() {
                this.clausesNegatable = false;
                return (R)this.self();
            }

            public WhereProperty getProperty(String propertyName) {
                this.processQuery(propertyName);
                return ((BasicQueryWalker)this.queryWalker).getProperty(propertyName);
            }

            public List<WhereProperty> getProperties(String ... propertyNames) {
                this.processQuery(propertyNames);
                return ((BasicQueryWalker)this.queryWalker).getProperties(propertyNames);
            }

            public Map<String, WhereProperty> getPropertiesAsMap(String ... propertyNames) {
                this.processQuery(propertyNames);
                return ((BasicQueryWalker)this.queryWalker).getPropertiesAsMap(propertyNames);
            }
        }
    }

    public static class WalkerCallbackAdapter
    implements WalkerCallback {
    }
}

