/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.HashMap;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.tests.AbstractBaseApiTest;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.data.SiteGroup;
import org.alfresco.rest.api.tests.client.data.SiteMember;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSiteGroups
extends AbstractBaseApiTest {
    protected AuthorityService authorityService;
    private String groupName = null;
    private PublicApiClient.Paging paging = this.getPaging(0, 10);
    private PublicApiClient.ListResponse<SiteMember> siteMembers = null;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.authorityService = (AuthorityService)this.applicationContext.getBean("AuthorityService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCrudSiteGroups() throws Exception {
        PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
        try {
            this.groupName = this.createAuthorityContext(user1);
            this.setRequestContext(networkOne.getId(), "admin", "admin");
            RepoService.TestSite site = (RepoService.TestSite)TenantUtil.runAsUserTenant(() -> networkOne.createSite(SiteVisibility.PRIVATE), (String)"admin", (String)networkOne.getId());
            SiteGroup response = sitesProxy.addGroup(site.getSiteId(), new SiteGroup(this.groupName, SiteRole.SiteCollaborator.name()));
            Assert.assertEquals((Object)response.getGroup().getId(), (Object)this.groupName);
            Assert.assertEquals((Object)response.getRole(), (Object)SiteRole.SiteCollaborator.name());
            response = sitesProxy.getGroup(site.getSiteId(), this.groupName);
            Assert.assertEquals((Object)response.getGroup().getId(), (Object)this.groupName);
            Assert.assertEquals((Object)response.getRole(), (Object)SiteRole.SiteCollaborator.name());
            this.siteMembers = sitesProxy.getSiteMembers(site.getSiteId(), this.createParams(this.paging, null));
            Assert.assertEquals((long)this.siteMembers.getList().size(), (long)3L);
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("where", "(isMemberOfGroup=false)");
            this.siteMembers = sitesProxy.getSiteMembers(site.getSiteId(), this.createParams(this.paging, params));
            Assert.assertFalse((boolean)this.siteMembers.getList().get(0).isMemberOfGroup());
            Assert.assertEquals((long)this.siteMembers.getList().size(), (long)1L);
            params = new HashMap(1);
            params.put("where", "(isMemberOfGroup=true)");
            this.siteMembers = sitesProxy.getSiteMembers(site.getSiteId(), this.createParams(this.paging, params));
            Assert.assertEquals((long)this.siteMembers.getList().size(), (long)3L);
            PublicApiClient.ListResponse<SiteGroup> groups = sitesProxy.getGroups(site.getSiteId(), this.createParams(this.paging, null));
            Assert.assertEquals((long)groups.getList().size(), (long)1L);
            Assert.assertEquals((Object)groups.getList().get(0).getRole(), (Object)SiteRole.SiteCollaborator.name());
            response = sitesProxy.updateGroup(site.getSiteId(), new SiteGroup(this.groupName, SiteRole.SiteContributor.name()));
            groups = sitesProxy.getGroups(site.getSiteId(), this.createParams(this.paging, null));
            Assert.assertEquals((long)groups.getList().size(), (long)1L);
            Assert.assertEquals((Object)groups.getList().get(0).getRole(), (Object)SiteRole.SiteContributor.name());
            sitesProxy.deleteGroup(site.getSiteId(), response.getId());
            groups = sitesProxy.getGroups(site.getSiteId(), this.createParams(this.paging, null));
            Assert.assertEquals((long)groups.getList().size(), (long)0L);
            this.siteMembers = sitesProxy.getSiteMembers(site.getSiteId(), this.createParams(this.paging, null));
            Assert.assertEquals((long)this.siteMembers.getList().size(), (long)1L);
        }
        finally {
            this.clearAuthorityContext(this.groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAddGroup() throws Exception {
        PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
        try {
            this.groupName = this.createAuthorityContext(user1);
            this.setRequestContext(networkOne.getId(), "admin", "admin");
            RepoService.TestSite site = (RepoService.TestSite)TenantUtil.runAsUserTenant(() -> networkOne.createSite(SiteVisibility.PRIVATE), (String)"admin", (String)networkOne.getId());
            try {
                sitesProxy.addGroup(site.getSiteId(), new SiteGroup(GUID.generate(), SiteRole.SiteCollaborator.name()));
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
            SiteGroup response = sitesProxy.addGroup(site.getSiteId(), new SiteGroup(this.groupName, SiteRole.SiteCollaborator.name()));
            Assert.assertEquals((Object)response.getGroup().getId(), (Object)this.groupName);
            Assert.assertEquals((Object)response.getRole(), (Object)SiteRole.SiteCollaborator.name());
            try {
                sitesProxy.addGroup(site.getSiteId(), new SiteGroup(this.groupName, SiteRole.SiteCollaborator.name()));
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)409L, (long)e.getHttpResponse().getStatusCode());
            }
            this.siteMembers = sitesProxy.getSiteMembers(site.getSiteId(), this.createParams(this.paging, null));
            Assert.assertEquals((long)this.siteMembers.getList().size(), (long)3L);
            PublicApiClient.ListResponse<SiteGroup> groups = sitesProxy.getGroups(site.getSiteId(), this.createParams(this.paging, null));
            Assert.assertEquals((long)groups.getList().size(), (long)1L);
            Assert.assertEquals((Object)groups.getList().get(0).getRole(), (Object)SiteRole.SiteCollaborator.name());
        }
        finally {
            this.clearAuthorityContext(this.groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldUpdateGroup() throws Exception {
        PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
        try {
            this.groupName = this.createAuthorityContext(user1);
            this.setRequestContext(networkOne.getId(), "admin", "admin");
            RepoService.TestSite site = (RepoService.TestSite)TenantUtil.runAsUserTenant(() -> networkOne.createSite(SiteVisibility.PRIVATE), (String)"admin", (String)networkOne.getId());
            try {
                sitesProxy.updateGroup(site.getSiteId(), new SiteGroup(GUID.generate(), SiteRole.SiteCollaborator.name()));
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
            }
            SiteGroup response = sitesProxy.addGroup(site.getSiteId(), new SiteGroup(this.groupName, SiteRole.SiteCollaborator.name()));
            Assert.assertEquals((Object)response.getGroup().getId(), (Object)this.groupName);
            Assert.assertEquals((Object)response.getRole(), (Object)SiteRole.SiteCollaborator.name());
            response = sitesProxy.updateGroup(site.getSiteId(), new SiteGroup(this.groupName, SiteRole.SiteContributor.name()));
            Assert.assertEquals((Object)response.getGroup().getId(), (Object)this.groupName);
            Assert.assertEquals((Object)response.getRole(), (Object)SiteRole.SiteContributor.name());
            this.siteMembers = sitesProxy.getSiteMembers(site.getSiteId(), this.createParams(this.paging, null));
            Assert.assertEquals((long)this.siteMembers.getList().size(), (long)3L);
            Assert.assertEquals((Object)this.siteMembers.getList().get(1).getRole(), (Object)SiteRole.SiteContributor.name());
            Assert.assertEquals((Object)this.siteMembers.getList().get(2).getRole(), (Object)SiteRole.SiteContributor.name());
        }
        finally {
            this.clearAuthorityContext(this.groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDeleteGroup() throws Exception {
        PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
        try {
            this.groupName = this.createAuthorityContext(user1);
            this.setRequestContext(networkOne.getId(), "admin", "admin");
            RepoService.TestSite site = (RepoService.TestSite)TenantUtil.runAsUserTenant(() -> networkOne.createSite(SiteVisibility.PRIVATE), (String)"admin", (String)networkOne.getId());
            try {
                sitesProxy.updateGroup(site.getSiteId(), new SiteGroup(GUID.generate(), SiteRole.SiteCollaborator.name()));
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
            }
            SiteGroup response = sitesProxy.addGroup(site.getSiteId(), new SiteGroup(this.groupName, SiteRole.SiteCollaborator.name()));
            Assert.assertEquals((Object)response.getGroup().getId(), (Object)this.groupName);
            Assert.assertEquals((Object)response.getRole(), (Object)SiteRole.SiteCollaborator.name());
            this.siteMembers = sitesProxy.getSiteMembers(site.getSiteId(), this.createParams(this.paging, null));
            Assert.assertEquals((long)this.siteMembers.getList().size(), (long)3L);
            sitesProxy.deleteGroup(site.getSiteId(), response.getId());
            this.siteMembers = sitesProxy.getSiteMembers(site.getSiteId(), this.createParams(this.paging, null));
            Assert.assertEquals((long)this.siteMembers.getList().size(), (long)1L);
        }
        finally {
            this.clearAuthorityContext(this.groupName);
        }
    }

    private String createAuthorityContext(String userName) throws PublicApiException {
        Object groupName = "Test_GroupA" + GUID.generate();
        AuthenticationUtil.setRunAsUser((String)userName);
        groupName = this.authorityService.getName(AuthorityType.GROUP, (String)groupName);
        if (!this.authorityService.authorityExists((String)groupName)) {
            AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
            groupName = this.authorityService.createAuthority(AuthorityType.GROUP, (String)groupName);
            this.authorityService.setAuthorityDisplayName((String)groupName, "Test Group A");
        }
        this.authorityService.addAuthority((String)groupName, user1);
        this.authorityService.addAuthority((String)groupName, user2);
        return groupName;
    }

    private void clearAuthorityContext(String groupName) {
        if (groupName != null && this.authorityService.authorityExists(groupName)) {
            AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
            this.authorityService.deleteAuthority(groupName, true);
        }
    }

    @Override
    public String getScope() {
        return "public";
    }
}

